//------------------------------------------------------------
// SIMPLE.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  SIMPLE.CPP is a DOS text based program which is a modifed
//  version of MEMVIEW.CPP.  In this case a data array is downloaded
//  and displayed in hexadecimal format.  Since SIMPLE.CPP contains
//  very little additional features it can be easily modified and
//  used as a convenient starting point for new applications.
//
//  The project file should include the following
//
//    SIMPLE.CPP    This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS text window executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.  This application can
//        coexist with the debugger and other MEMVIEW applications.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
//#ifdef   __BORLAND
#include <bios.h>
//#endif

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "dsk.h"
#include "keydef.h"

ulong DSP_addr;
int speed = 3;
char disp[8192];   // char display buffer

void check_key(void)
{
  int key;
  ulong tmp, eaddress;
  key = bioskey(0) & 0xFF00;
  switch(key)
  {
    case  _Q  : exit(0);             // Quit
    case  _pls: speed+=1; break;     // Slow down screen update rate
    case  _mns: speed-=1; break;     // speed up
    case  _Pup: DSP_addr-=24; break;  // Page window up
    case  _Pdn: DSP_addr+=24; break;  // Page window down
    case  _Up : DSP_addr-= 4; break;  // Scroll up
    case  _Dn : DSP_addr+= 4; break;  // Scroll down

    case  _A  : cprintf("\r\n\nNew address ");
                scanf("%lx",&DSP_addr);
                break;
    default   : break;
  }
  if(speed <  0) speed =  0;
  if(speed > 10) speed = 10;
}
//--------------------------------------
void main(void)
{

  clock_t start, end;
  ulong Host_Mem[32], *ulptr, addr, temp;
  char *c;
  int x, y;
  MSGS err;
  //
  // Check for command line arguments
  //
  Scan_Command_line("SIMPLE.EXE");
  DSP_addr = 0x809800L;
  //
  // Initialize the communications link to the DSK
  //
  for(;;)
  {
    if(Init_Communication(10000) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  //
  // If windows is being run, is set the appropriate flags
  // to use Windows timeslice management interrupts.
  //
  Detect_Windows();
  clrscr();
  for(;;)
  {
    ulptr = Host_Mem;
    //
    // Avoid accidentally reading or writting the
    // interlocked host port interface address
    //
    if((DSP_addr & 0xF00000L) == 0xF00000L)
    { printf("Address conflicts with HPI, pick a new address!\n");
      while(!kbhit());
      clrscr();
    }
    else
      if((err=getmem(DSP_addr,32,Host_Mem)) != NO_ERR)
      { printf("%s\ngetmem() has crashed!\n",Error_Strg(err));
        exit(0);
      }
    if(kbhit()) check_key();
    c = disp;
    addr = DSP_addr;
    c+=sprintf(c,
    "C31DSK MEMORY VIEW UTILITY\r\n"
    "--------------------------\r\n"
    "(Q)uit\r\n"
    "(A)ddress\r\n"
    "PGUP,PGDN,UP,DN - Scroll window\r\n"
    "+/-   adjust screen update: %d \r\n\n",speed);
    for(y=0;y<6;y++)
    { c+=sprintf(c,"0x%08lx > ",addr);
      addr += 4;
      for(x=0;x<4;x++)
        c+=sprintf(c,"%08lx ",*ulptr++);
      c+=sprintf(c,"\r\n");
    }
    _setcursortype(_NOCURSOR);
    gotoxy(1,1);
    cprintf(disp);
    _setcursortype(_NORMALCURSOR);
    Release_TSlice();
    if(speed)
    { start = clock();
      for(;;)
      { end = clock();
        if((end - start) > speed) break;
      }
    }
  }
}

