//------------------------------------------------------------
// MEMVIEW.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  MEMVIEW.CPP is a TEXT window based program which gets data from the
//  DSK and displays it to the PC's screen.  The memory mapped registers
//  are also displayed as well as the addition of a PWM adjustment utility
//  for the two timer values.
//
//  The project file should include the following
//
//    MEMVIEW.CPP   This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS graphics executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.
//
//        However since this application is a DOS graphics executable
//        it must be run full screen.  Compatiblity with other background
//        applications was NOT tested.
//
//        A PIF file can be created to automate setup and execution.
//----------------------------------------------------------------------
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "dsk.h"
#include "keydef.h"

ulong address;              // Address to start display from
int speed = 3;              // Screen update period
int PWM_adjust_enabled =0;  // Dont change timers unless enabled
char disp[8192];            // char display buffer
//
// The DSK's PWM output is selected when the DEMO signal is held high.
// This enables an XOR gate PWM phase detector whose inputs are the two
// timers.  Since the phase accumulation is W1-W2, and the XOR gate is
// a linear detector a triangle wave is produced whose frequency is F1-F2.
// The output of the XOR gate is also inverted to get a push pull drive
// for the bi-color LED.  The result is a r-y-g-y-r-y... color sequence.
// Note however that the red LED is slightly brighter.  This is because
// the red LED's forward voltage drop is less than the green LED's and
// that red LED's are inherently more efficient.  This results in a green
// yellow red time skewed to the red.  To more easily see the yellow color,
// lower the triangle wave to less than 1Hz.
//
// Inputs: PWM_clock: Sets TIM0 output frequency
//         PWM_Fout : Sets TIM1 = TIM0 + PWM_Fout
//         H_ns     : C31 H1 or H3 clock in nS
//
//         PWM_Fout = abs(TIM1 - TIM0)
//
float PWM_Fout = 1.0000;  // Some constants needed for PWM rate calculation
float PWM_clock= 1000.0;  //
float H_ns     = 50e-9;
float Fout     = 1.000;

void set_PWM(float PWM_clock, float PWM_Fout)
{
  ulong  TIM_CNT = 0x000; // TIMx count
  ulong  TIM_HALT= 0x003; // TIMx control - HALT
  ulong  TIM_RUN = 0x3C3; // TIMx control - RUN
  ulong  TIM0_PRD;        // TIM0 period  1/80nS*2048 = 3051.8 Hz
  ulong  TIM1_PRD;        // TIM1 period  1/80nS*2049 = 3050.3 Hz
  // Setup the two timers to PWM drive the bi-coler LED
  TIM0_PRD = .5 + 1.0 / ((PWM_clock           ) * 4.0 * H_ns); // F1
  TIM1_PRD = .5 + 1.0 / ((PWM_clock + PWM_Fout) * 4.0 * H_ns); // F2
  Fout = 1.0/(TIM1_PRD*4.0*H_ns) - 1.0/(TIM0_PRD*4.0*H_ns);
  putmem(0x808020,1,&TIM_HALT); // TIM0 control - HALT
  putmem(0x808024,1,&TIM_CNT ); // TIM0 count
  putmem(0x808028,1,&TIM0_PRD); // TIM0 period
  putmem(0x808020,1,&TIM_RUN ); // TIM0 control - RUN
  putmem(0x808030,1,&TIM_HALT); // TIM1 control - HALT
  putmem(0x808034,1,&TIM_CNT ); // TIM1 count
  putmem(0x808038,1,&TIM1_PRD); // TIM1 period
  putmem(0x808030,1,&TIM_RUN ); // TIM1 control - RUN
}

void check_key(void)
{
  int key;
  ulong tmp, eaddress;
  key = bioskey(0) & 0xFF00;
  switch(key)
  { case  _P  : PWM_adjust_enabled^=1; break;
    case  _Q  : exit(0);                // Quit
    case  _pls: speed+=1; break;        // Slow down screen update rate
    case  _mns: speed-=1; break;        // speed up
    case  _F1 : PWM_Fout *= 0.90000000; break; // Slow down LED pulse rate
    case  _F2 : PWM_Fout *= 1.11111111; break; // speed up
    case  _Pup: address-=24; break;  // Page window up
    case  _Pdn: address+=24; break;  // Page window down
    case  _Up : address-= 4; break;  // Scroll up
    case  _Dn : address+= 4; break;  // Scroll down

    case  _A  : cprintf("\r\n\nNew address ");
                scanf("%lx",&address);
                break;
//
// Add a memory content 'edit' feature here...
//

    case  _E  : clrscr();
                cprintf("\r\n\nEdit Address ");
                scanf("%lx",&eaddress);
                getmem(eaddress,1,&tmp);
                cprintf("\r0x%08lx       \r",&tmp);
                scanf("%lx",&tmp);
                putmem(eaddress,1,&tmp);
                clrscr();
                break;

    default   : break;
  }
  if(speed <  0) speed =  0;
  if(speed > 10) speed = 10;
  if(PWM_Fout < 0.250) PWM_Fout = 0.25;
  if(PWM_Fout > 30.00) PWM_Fout = 30.0;
  if(PWM_adjust_enabled)
    set_PWM(PWM_clock, PWM_Fout);   // Change LED pulse rate
}

void main()
{

  clock_t start, end;
  ulong memblk[32], *ulptr, addr, temp;
  char *c;
  int x, y;
  MSGS err;
  Scan_Command_line("MEMVIEW.EXE");
  address = 0x809800L;
  for(;;)
  { //
    // Changing this line to use the command line loader DSK3LOAD.EXE
    // will substantially decrease the amount of linked code.
    // Basicly this one line requires the DSK file utilities,
    // which requires the symbols utilities which requires...
    //
    if(Init_Communication(10000) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  Detect_Windows();
  clrscr();
  for(;;)
  {
    ulptr = memblk;
    if((address & 0xF00000L) == 0xF00000L)
    { printf("Address conflicts with HPI, pick a new address!\n");
      while(!kbhit());
      clrscr();
    }
    else
      if((err=getmem(address,32,memblk)) != NO_ERR)
      { printf("%s\nGetmem() has crashed!\n",Error_Strg(err));
        exit(0);
      }
    if(kbhit()) check_key();
    c = disp;
    addr = address;
    c+=sprintf(c,
    "C31DSK MEMORY VIEW UTILITY\r\n"
    "--------------------------\r\n"
    "(Q)uit\r\n"
    "(A)ddress\r\n"
    "PGUP,PGDN,UP,DN - Scroll window\r\n"
    "+/-   adjust screen update: %d \r\n"
    "F1,F2 adjust PWM sawtooth : %f Hz  ",speed,Fout);
    if(PWM_adjust_enabled) c+=sprintf(c,"ENABLED (P toggles enable)\r\n\n");
    else                   c+=sprintf(c,"DISABLED (P toggles enable)\r\n\n");

    for(y=0;y<6;y++)
    { c+=sprintf(c,"0x%08lx > ",addr);
      addr += 4;
      for(x=0;x<4;x++)
        c+=sprintf(c,"%08lx ",*ulptr++);
      c+=sprintf(c,"\r\n");
    }
    c+=sprintf(c,"\r\n");

                          c+=sprintf(c,"DMA ");
getmem(0x808000,1,&temp); c+=sprintf(c," GLBL %08lx"     ,temp);
getmem(0x808004,1,&temp); c+=sprintf(c,"  SRCE %08lx"    ,temp);
getmem(0x808006,1,&temp); c+=sprintf(c,"  DEST %08lx"    ,temp);
getmem(0x808008,1,&temp); c+=sprintf(c,"  TCNT %08lx\r\n",temp);

                          c+=sprintf(c,"TIM0");
getmem(0x808020,1,&temp); c+=sprintf(c," GLBL %08lx"     ,temp);
getmem(0x808024,1,&temp); c+=sprintf(c,"  CNTR %08lx"    ,temp);
getmem(0x808028,1,&temp); c+=sprintf(c,"  PRD  %08lx\r\n",temp);

                          c+=sprintf(c,"TIM1");
getmem(0x808030,1,&temp); c+=sprintf(c," GLBL %08lx"     ,temp);
getmem(0x808034,1,&temp); c+=sprintf(c,"  CNTR %08lx"    ,temp);
getmem(0x808038,1,&temp); c+=sprintf(c,"  PRD  %08lx\r\n",temp);

                          c+=sprintf(c,"SERP");
getmem(0x808040,1,&temp); c+=sprintf(c," GLBL %08lx"     ,temp);
getmem(0x808042,1,&temp); c+=sprintf(c,"  XCTL %08lx"    ,temp);
getmem(0x808043,1,&temp); c+=sprintf(c,"  RCTL %08lx\r\n",temp);
getmem(0x808044,1,&temp); c+=sprintf(c,"     TCTL %08lx" ,temp);
getmem(0x808045,1,&temp); c+=sprintf(c,"  TCNT %08lx"    ,temp);
getmem(0x808046,1,&temp); c+=sprintf(c,"  TPRD %08lx\r\n",temp);
getmem(0x808048,1,&temp); c+=sprintf(c,"     XMIT %08lx" ,temp);
getmem(0x80804C,1,&temp); c+=sprintf(c,"  RECV %08lx\r\n",temp);

getmem(0x808064,1,&temp); c+=sprintf(c,"PBUS CNTL %08lx" ,temp);

    _setcursortype(_NOCURSOR);
    gotoxy(1,1);
    cprintf(disp);
    _setcursortype(_NORMALCURSOR);
    Release_TSlice();
    if(speed)
    { start = clock();
      for(;;)
      { end = clock();
        //Release_TSlice(); // Added 3/10/97
        //delay(1);
        if((end - start) > speed) break;
      }
    }
  }
}

