;****************************************************************
; MANDEL.ASM for TMS320C31 DSP STARTERS KIT
; Keith Larson
; (C) Copyright 1994,1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; NOTE: A shareware 640x480x256 BGI SVGA graphics driver was
;	used to develop this application.  It is NOT distributed
;	the DSK software.  You must obtain this driver from the
;	original author.  Read README. for details.
;
; This code was taken from the MANDEL40.C application included
; with the TMS320C4X M4X communications and debug system.
;
; Features:
;   - Fast 10 cycle, all register, inner loop execution
;   - Fast loop exit using a load of 0x0 to the repeat end
;     register.  This trick preserves the loop count and also
;     provides a fast exit since the application would never
;     execute code at address zero to trigger the repeat block.
;   - Fast detection of convergence to zero for black areas
;     This feature is only enabled if the last pixel was black
;   - Installation of a user defined function via the JSPARE
;     jump vector in the kernels jump vector table
;   - Added LED RED/GREEN functions and imbedded them into the
;     the application to indicate user function start/end
;     By stepping through the host side code a simple go, no-go
;     debugging of the application can be observed
;
; Note: A Multiple C4x system provides a xN speed improvement
;       and also provides better numeric resolution because of
;       the better ALU contained in the C4x
;****************************************************************
	 .include "C3XMMRS.ASM"
         .start   "MANDEL" ,0x809802
         .sect    "MANDEL"
         .start   "PIXDATA",0x809900
         ;-----------------------------------------------------;
         ; Install the XSPARE vector to point to this function ;
         ;-----------------------------------------------------;
PDATA	 .word	  PIXDATA      ;
man3XA   .word    man3X        ; Address of XSPARE function
USER_RET .word	  0	       ;
         ;---------------------
GREEN    ldi      2,R0         ; Turn the LED green
         sti      R0,@T0_ctrl  ;
         sti      R0,@T1_ctrl  ;
         rets                  ;
         ;---------------------
RED      ldi      6,R0         ; Turn the LED red
         sti      R0,@T0_ctrl  ;
         ldi      2,R0         ;
         sti      R0,@T1_ctrl  ;
         rets                  ;
         ;---------------------
         .entry   main         ;
main     ldp      @U_stack     ;
         ldi      @U_stack,SP  ;

	 ldi	  @JSPARE,R0
	 sti	  R0,@USER_RET
         ldi      @man3XA,R0   ;
         sti      R0,@JSPARE   ;
Loop     or       4,IE         ; Wait for host interrupt
         idle                  ;
       ; call     GREEN        ;
       ; call     RED          ;
         b        Loop         ;
;========================================================
; man3X is executed as an extended user defined function
;========================================================
man3X:   ldi      0,IE
         call     GREEN        ;
         call     XRECV        ; X Upper left coordinates
         sti      R0,@Xseed    ;
         sti      R0,@Xcurs    ;
         ldf      @Xcurs,R0    ;
         sti      R0,@XcursM   ;
         call     XRECV        ; Y
         sti      R0,@Ycurs    ;
         ldf      @Ycurs,R0    ;
         sti      R0,@YcursM   ;
         ;---------------------
         call     XRECV        ; X numeric offset between pixels
         sti      R0,@Xoffs    ;
         call     XRECV        ; Y
         sti      R0,@Yoffs    ;
         ;---------------------
         call     XRECV        ; X pixel box dimension
         sti      R0,@Xloop    ;
         sti      R0,@Xloop1   ;
         call     XRECV        ; Y
         sti      R0,@Yloop    ;
         ;---------------------
         call     XRECV        ; Maxiter per pixel
         sti      R0,@Maxiter  ;
         ;---------------------
         ldi      @PDATA,AR0   ;
         ;---------------------
         ldi      0,R0
         sti      R0,@last

NxtPix   ldi      3,RC
         rptb     NxtPix2
         ldf      @Xcurs,R0    ; Update (float40) Xcurs+=Xoffs
         ldi      @XcursM,R0   ;
         addf     @Xoffs,R0    ;
         stf      R0,@Xcurs    ;
         sti      R0,@XcursM
         call     PxTest       ; Call pixel test routine until complete
NxtPix2  push     R0

         ldi      3,RC
         rptb     LP
         pop      R1
         lsh      8,R0
LP       or       R1,R0
         sti      R0,*AR0++    ; save four pixels

         ldi      @Xloop,R0    ; End X loop?
         subi     4,R0         ;
         sti      R0,@Xloop    ;
         bgt      NxtPix       ;

         ldi      @Xloop1,R0   ; Refresh X loop counter
         sti      R0,@Xloop    ;

         ldi      0,R0
         sti      R0,@last

         ldf      @Xseed,R0    ; Init Xcurs
         stf      R0,@Xcurs    ;
         sti      R0,@XcursM   ;

         ldf      @Ycurs,R0    ; Update Ycurs+=Yoffs
         ldi      @YcursM,R0
         addf     @Yoffs,R0    ;
         stf      R0,@Ycurs    ;
         sti      R0,@YcursM   ;

         ldi      @Yloop,R0    ; End Y loop?
         subi     1,R0         ;
         sti      R0,@Yloop    ;
         bgt      NxtPix       ;
	 ;---------------------;
         call     RED          ;
	 ldi	  @USER_RET,R0 ; return back to command mode
	 b	  R0	       ;
;------------------------------
Xseed    .float  -1.50         ;
Xcurs    .float  -1.50         ;
Ycurs    .float   1.20         ;
Xoffs    .float   0.01         ;
Yoffs    .float   0.01         ;
Xloop    .word    640          ;
Yloop    .word    1            ;
Maxiter  .word    1024         ;
last     .word    1            ;
twk1     .set     31.90        ;
twk2     .set     0.010        ;
XcursM   .word    0
YcursM   .word    0
Xloop1   .word    1
;------------------------------
PxTest  ; ldi      @last,R0     ; Fast 'ramp' to test comm+video draw rate
        ; addi     1,R0         ;
        ; and      0xFF,R0
        ; sti      R0,@last     ;
        ; rets                  ;

         push     ST           ; Save block loop control regsiters
         push     RC           ;
         push     RE           ;
         push     RS           ;
         ldf      @Xcurs,R1    ; R1=Rseed
         ldi      @XcursM,R1
         ldf      @Ycurs,R2    ; R2=Iseed
         ldi      @YcursM,R2
         ldf      0,R3         ; R3=R       R5=R^2
         ldf      0,R4         ; R4=I       R6=I^2
         ldi      @Maxiter,R0  ;
         ldf      1.0,R7       ;
         ldi      @Maxiter,RC  ;

         ldp      @last        ; If last color was black use
         nop                   ;
         ldi      @last,R5     ; guessing routine
         bnz      norm         ;

         ldf      1.0,R7

guess    rptb     gblock       ;
         ;----------------     do Mandelbrodt test
         MPYF3    R3,R3,R5     ; Xsqr = Xr * Xr;
         MPYF3    R4,R4,R6     ; Ysqr = Yi * Yi;
         MPYF     2.0,R3       ; Y = 2.0 * Xr * Yr + Yseed;
         MPYF     R3,R4        ;
         ADDF     R2,R4        ;
         SUBF3    R6,R5,R3     ; X = Xsqr - Ysqr + Xseed;
         ADDF     R1,R3        ;
         ADDF3    R6,R5,R5     ; if(Xsqr+Ysqr)>4.0 break;

         cmpf     0.0,R5       ;
         ldfz     1.0,R5       ;
         mpyf     R5,R7        ;

         mpyf     twk1,R7      ;
         cmpf     twk2,R7      ;
         bltd     M_exit       ;
         ldilt    0,RC         ;

         mpyf     0.125,R7     ;
         cmpf     4.0,R5       ;
gblock   ldige    0,RE         ; Fast loop exit, with RC intact
         b        M_exit       ;

norm     rptb     block        ;
         ;---------------------
         MPYF3    R3,R3,R5     ; R^2 = R*R;
         MPYF3    R4,R4,R6     ; I^2 = I*I;
         MPYF     2.0,R3       ; I   = 2.0*R*I + Iseed;
         MPYF     R3,R4        ;
         ADDF     R2,R4        ;
         SUBF3    R6,R5,R3     ; R = R^2 - I^2 + Rseed;
         ADDF     R1,R3        ;
         ADDF3    R6,R5,R5     ; if((R^2+I^2) > 4.0) break;
         cmpf     4.0,R5       ;
block:   ldige    0,RE         ; Fast loop exit, with RC intact
M_exit   subi     RC,R0        ; get loop count
         and      0xff,R0      ; return color (mod 256)
         sti      R0,@last
         pop      RS           ; Save block loop control regsiters
         pop      RE           ;
         pop      RC           ;
         pop      ST           ;
         rets                  ;
;------------------------------
XRECV    ldi      @JR_HOST,R0  ;
         callu    R0           ;
         rets                  ;
;========================================
U_stack  .word    $
         .end




