//------------------------------------------------------------
// LOADPROM.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  SIMPLE.CPP is a DOS text based program which is a modifed
//  version of MEMVIEW.CPP.  In this case a data array is downloaded
//  and displayed in hexadecimal format.  Since SIMPLE.CPP contains
//  very little additional features it can be easily modified and
//  used as a convenient starting point for new applications.
//
//  The project file should include the following
//
//    LOADPROM.CPP  This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS text window executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.  This application can
//        coexist with the debugger and other MEMVIEW applications.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
#include <bios.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "dsk.h"
#include "keydef.h"

#define CLR_1 LIGHTGRAY  /* Normal  text color */
#define CLR_2    WHITE   /* Hilight text color */

ulong Address;
ulong DumpAddr;
int mS_per_write = 3;
char file_to_load[80]; // Name of file to be loaded
//-----------------------------------------
MSGS write_byte(ulong addr, ulong t)
{
  MSGS err;
  ulong l;
  int x;
  t &= 0xFF;
  putmem(addr,1,&t); delay(mS_per_write);
  for(x=0; x<100; x++)
  {
    err = getmem(addr,1,&l);
    if((l&0xFF)==t) break;
    delay(1);
  }
  if(t!=l) err= VERIFY_ERR;
  return err;
}
//-----------------------------------------
MSGS put_EEPROM(ulong addr, ulong val)
{
  MSGS err;
  if((err = write_byte(addr+0,val>> 0))!=NO_ERR) return err;
  if((err = write_byte(addr+1,val>> 8))!=NO_ERR) return err;
  if((err = write_byte(addr+2,val>>16))!=NO_ERR) return err;
  if((err = write_byte(addr+3,val>>24))!=NO_ERR) return err;
  return err;
}

MSGS copy_hex_to_DSK(char *filename)
{
  #define slen  120
  ulong addr;
  FILE *hex_file;
  MSGS err = NO_ERR;
  char strg[slen];
  char *p;
  ulong l;
  int x;
  //----------------------------------------------------------
  // Append .HEX to file... always *.HEX no others are allowed!
  //----------------------------------------------------------
  if((p=strstr(filename,"."))!=NULL) strcpy(p,".HEX");
  else  strcat(filename,".HEX");
  //----------------------------------------------------------
  // Open hex output file to be used for fast loads
  //----------------------------------------------------------
  if((hex_file = fopen(filename,"rb"))==NULL)
  {
    fclose(hex_file);
    clrscr();
    return FATAL_OPEN;
  }
  //-------------------------------------------------------------------
  // From a bootable imamage a file can be simply loaded to an EEPROM
  // if the EEPROM is properly configured to accept data writes
  // The proper address and timing is all that is required
  //-------------------------------------------------------------------
  fgets(strg,slen,hex_file);
  if((p=strstr(strg,"\r"))!=NULL) *p=0;
  if((p=strstr(strg,"\n"))!=NULL) *p=0;
  if(strstr(strg,"FILE2HEX")==0)
  { fclose(hex_file);
    return OPEN_ERR;  // A better error return MSG would be nice
  }
  addr = Address;
  for(x=0;x<10000;x++) // 10K words is realistic upper limit for DSK
  {
    if(fgets(strg,slen,hex_file)==NULL) break;
    l = strtoul(strg,&p,0);
    //err = xmit_long(l);
    err = put_EEPROM(addr,l);
    if(err!=NO_ERR) break;
    addr+=4;
  }
  fclose(hex_file);
  return err;
}
//----------------------------------------
void check_key(void)
{
  FILE *hex_file;
  int key;
  MSGS err;
  ulong tmp;
  ulong OldAddress;
  ulong OldDumpAddr;
  char *p;
  OldAddress = Address ;
  OldDumpAddr= DumpAddr;
  key = bioskey(0) & 0xFF00;
  switch(key)
  {
    case  _Q  : exit(0);                  // Quit
    case  _pls: mS_per_write+=1; break;   // Slow down screen update rate
    case  _mns: mS_per_write-=1; break;   // mS_per_write up
    case  _Up : DumpAddr-=4; break;
    case  _Dn : DumpAddr+=4; break;
    case  _Pup: DumpAddr-=32; break;
    case  _Pdn: DumpAddr+=32; break;
    case  _F  : cprintf("New filename : ");
                scanf("%s",file_to_load);
                //-----------------------------------
                // Append .HEX to file... *.HEX only!
                //-----------------------------------
                if((p=strstr(file_to_load,"."))!=NULL) strcpy(p,".HEX");
                else  strcat(file_to_load,".HEX");
                clrscr();
                if((hex_file = fopen(file_to_load,"rb"))==NULL)
                {
                  printf("%s does not exist",file_to_load);
                  while(!kbhit());
                }
                fclose(hex_file);
                clrscr();
                break;
    case  _P  : printf("HEX->EEPROM Write in progress, please wait");
                err = copy_hex_to_DSK(file_to_load);
                if(err!=NO_ERR)
                {
                textcolor(CLR_2);  // Hilight the error
                cprintf("  --> %s",Error_Strg(err));
                textcolor(CLR_1);
                getch();
                }
                clrscr();
                break;       // Program the EEPROM (Download the HEX file)
    case  _A  : cprintf("New address 0x%08lx",Address);
                gotoxy(wherex()-8,wherey());
                scanf("%lx",&tmp);
                Address = tmp;
                DumpAddr = Address;
                clrscr();
    default   : break;
  }
  // Avoid accidental read or write of the host port interface address
  //
  if(
         (((Address + 0) & 0xF00000L) == 0xF00000L)
      || (((DumpAddr+ 0) & 0xF00000L) == 0xF00000L)
      || (((Address +32) & 0xF00000L) == 0xF00000L)
      || (((DumpAddr+32) & 0xF00000L) == 0xF00000L)
    )
  {
    printf("Address conflicts with HPI, pick a new address!");
    Address = OldAddress ;   // Likely conflict was a foldover
    DumpAddr= OldDumpAddr;
    while(!kbhit());
    clrscr();
  }

  if(mS_per_write <  0) mS_per_write =  0;
  if(mS_per_write > 10) mS_per_write = 10;
}
//----------------------------------------
void main(void)
{
  ulong *ulptr, addr;
  ulong memblk[32];
  ulong ReconVal;
  ulong tmp;
  int x, y;
  MSGS err;
  //
  // Check for command line arguments
  //
  Scan_Command_line("SIMPLE.EXE");
  //
  // Initialize the communications link to the DSK
  //
  for(;;)
  {
    Address = 0x809800L;
    DumpAddr = Address;
    for(;;)
    {
      if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    //
    // If windows is being run, is set the appropriate flags
    // to use Windows timeslice management interrupts.
    //
    Detect_Windows();
    strcpy(file_to_load,"NOFILE.HEX");
    textbackground(BLACK);
    clrscr();
    //
    // Set the TMS320C31 wait bus control wait state generator to use
    // the maximum number of wait states to be compatible with as
    // slow an EEPROM as possible
    //
    getmem(0x808060L,1,&tmp); // Expansion control for C30 users
    tmp = tmp | 0xF8;         // Max WS
    putmem(0x808060L,1,&tmp);
    getmem(0x808064L,1,&tmp);
    tmp = tmp | 0xF8;
    putmem(0x808064L,1,&tmp);
    for(;;)
    {
      //
      // Avoid accidentally reading or writting the
      // interlocked host port interface address
      //
      if((err=getmem(DumpAddr,32,memblk)) != NO_ERR)
      { textcolor(CLR_2);  // Hilight the error
        cprintf("%s..  getmem() has crashed!",Error_Strg(err));
        getch();
        textcolor(CLR_1);
        break; // exit(0);
      }
      ulptr = memblk;
      addr = DumpAddr;
      gotoxy(1,1);
      textcolor(CLR_1);
      cprintf(
      "C31DSK EEPROM PROGRAMER             (C source is in \\DSK3APPS)\r\n"
      "--------------------------------------------------------------\r\n");
      textcolor(CLR_1); cprintf("+/- mS per write rate       = ");
      textcolor(CLR_2); cprintf("%d \r\n",mS_per_write);
      textcolor(CLR_1); cprintf("(F)filename (must be *.hex) = ");
      textcolor(CLR_2); cprintf("%s\r\n",file_to_load);
      textcolor(CLR_1); cprintf("(A)ddress of EEPROM         = ");
      textcolor(CLR_2); cprintf("%08lx\r\n",Address);
      textcolor(CLR_1);
      cprintf(
      "(P)rogram the EEPROM\r\n"
      "(Q)uit LOADPROM\r\n"

      "up/dn/pgup/pgdn to scroll memory window\r\n"
      "--------------------------------------------------------------\r\n"
      "Memory dump of first 32 words of write destination\r\n"
      "--------------------------------------------------------------\r\n");
      for(y=0;y<8;y++)
      {
        cprintf("0x%08lx > ",addr);
        addr += 4;
        ReconVal  =   ((memblk[(y*4)+0] & 0xFF) <<  0);
        ReconVal |=   ((memblk[(y*4)+1] & 0xFF) <<  8);
        ReconVal |=   ((memblk[(y*4)+2] & 0xFF) << 16);
        ReconVal |=   ((memblk[(y*4)+3] & 0xFF) << 24);
        for(x=0;x<4;x++)
        {
          textcolor(CLR_1);cprintf("%06lx" ,(      *ulptr >>8));
          textcolor(CLR_2);cprintf("%02lx ",(0xFF& *ulptr++  ));
        }
        textcolor(CLR_1); cprintf(" -> ");
        textcolor(CLR_2); cprintf("%08lx\r\n",ReconVal);
        textcolor(CLR_1);
      }
      cprintf("\r\n"
      "Note: Small programs can be test written to on-chip RAM where\r\n"
      "      you can see each byte unpacked into 32 bit memory\r\n\r\nCMD>");
      _setcursortype(_NORMALCURSOR);
      if(kbhit()) check_key();
      else        delay(20);  // 50 updates per second max
      _setcursortype(_NOCURSOR);
    }
  }
}

