;---------------------------------------------------------------------
; INTERP.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;---------------------------------------------------------------------
; This example shows how to perform a table lookup and linear first
;order interpolation on the C31 DSK.  The function is arc-cosine.
;
;  If the function has an input range of R, first calculate an address
;whose range is modulo 2^N bits using floating point arithmetic.  Then
;use the fix and subf instructions to calculate the fractional, or
;intercept, and non-fractional, or base point, components.
;
;  By using a 2^N table size a logical AND of 2^N-1 with the modulo 2^N
;input can be readily reduced to fit within the table bounds.
;
;  If the function is well behaved the number of effective bits produced
;by the interpolator is approximately 2X those used for a raw lookup.
;In other words, comparing a simple 8 bit lookup, or 256 point table,
;the accuracy improves to nearly 16 bits.
;---------------------------------------------------------

         .start  "TEST",0x809802 ; Where to assemble
         .sect   "TEST"          ;
         .entry  BEGIN           ; Begin at MAIN
;--------------------------------
BEGIN    ldp     @stack          ; Init the data page and stack
         ldi     @stack,SP       ;
MAIN     LDF     @INPUT,R0       ; Call with argument in F0
         CALL    ACOS            ;
         STF     R0,@OUTPUT      ;
         LDF     @INPUT,R0       ; Store result
         ADDF    0.1,R0          ; Increment argument
         STF     R0,@INPUT       ;
         B       MAIN            ;
;--------------------------------
INPUT    .float  0               ;
OUTPUT   .float  0               ;
;--------------------------------
; ACOS Input is in F0
;--------------------------------
ACOS     push    R1              ; Save registers
         push    R2              ;
         pushf   R1              ;
         pushf   R2              ;
         MPYF    @SCALE,R0       ; F0= scale input to 0.000-0.999
         cmpf    0.0,R0          ; Check the range of the input...
         ldfle   @MIN,R0         ; 0.0 < input < 1.000
         ble     DONE            ;
         cmpf    1.0,R0          ;
         ldfge   @MAX,R0         ;
         bge     DONE            ;
         MPYF    TBLSIZE,R0      ;     rescale to N*(0-TBLSIZE) modulo OK
         FIX     R0,AR0          ; AR0= mod(TBLSIZE) integer
         FLOAT   AR0,R1          ; F1 = whole part of address (as float)
         SUBF    R1,R0           ; F0 = 0.0-0.9, fractional part of address
         AND     TBLSIZE-1,AR0   ; AR0= 0-TBLSIZE-1, whole part of address
         ADDI    @TBLLOC,AR0     ; Calc 1 st address of lookup
         LDF     *AR0,R1         ; F1=1 st value. (quite here if accurate)
Interp   SUBF3   R1,*+AR0(1),R2  ; F2=difference of 1st & 2nd point (slope)
         MPYF    R2,R0           ; F0=partial of slope
         ADDF    R1,R0           ; F0=final result (1st point + partial)
DONE     popf    R2              ;
         popf    R1              ;
         pop     R2              ;
         pop     R1              ;
         RETS                    ;
;------------------------------
TBLSIZE  .set    64.0            ; N locations in lookup table
SCALE    .float  1               ; Input range is 0-0.999
TBLLOC   .word   TABLE           ; Start address of table
MIN      .float  acos(0.0)       ;
MAX      .float  acos(1.0)       ;
;--------------------------------
         .start  "TABLE",0x809900;
         .sect   "TABLE"         ;
         .loop   TBLSIZE         ; Calculate the table (this is NON-COFF)
F        .sdef  ($-TABLE)/TBLSIZE; NOTE: The fraction is defined outside
         .float  acos(F)         ;       of the loop because of an expression
         .endloop                ;       analyzer problem in acos().
;--------------------------------
stack    .word   stack           ; Put stack at end of data
         .end                    ;


