;------------------------------------------------------------------
; IDRIVE.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This application will drive the data pins in opposition to any
; pullup or pulldown that is connected to the data bus.  The I/V
; curve can then be easily plotted.
;-------------------------------------------------------------------------
          .include "C3XMMRS.ASM"
          .start   "TEXT",0x809802      ;
          .sect    "TEXT"               ;
          .entry                        ;
Extern    .set     0x80A000             ;
          ldp      Extern               ; Setup DP and stack
          ldi      @stack,SP            ;
          ldi      @p_buscon,R0         ; Set max WS for p_buscon
          or       0x7<<5,R0            ;
          sti      R0,@p_buscon         ;
Loop      ldi      @Extern,R0           ; Invert data (pullups?) on ext bus
          not      R0,R0                ;
          sti      R0,@Extern           ; Drive bus
          rpts     60                   ; Let the drivers cool down
          nop                           ;
          b        Loop                 ; Do it again
stack     .word    stack

