//------------------------------------------------------------
// FFT_XXX.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  FFT_XXX.CPP is a DOS graphics based program which is a modifed
//  version of DSK_OSC.CPP.  In this case the data array is converted
//  to the frequency domain before it is sent to the PC for display.
//
//  +--------------------------------------------------------------+
//  | PLEASE NOTE: THIS APPLICATION USES EGA GRAPHICS              |
//  |                                                              |
//  | YOU MUST EITHER CREATE AND LINK IN EGAVGA.OBJ AND ALSO USE   |
//  | REGISTER THE DRIVER IN YOUR CODE WITH registerbgidriver();   |
//  | -OR-                                                         |
//  | EGAVGA.BGI MUST BE IN THE CURRENT DIRECTORY                  |
//  |                                                              |
//  | -ALSO-                                                       |
//  | THE LINKER OPTIONS NEED TO BE SET TO LINK IN GRAPHICS.LIB    |
//  +--------------------------------------------------------------+
//
//  The project file (link list) should include the following
//
//    FFT_XXX.CPP   This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//  * EGAVGA.OBJ    EGA and VGA graphics driver
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS graphics executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.
//
//        However since this application is a DOS graphics executable
//        it must be run full screen.  Compatiblity with other background
//        applications was NOT tested.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <graphics.h>
#include <bios.h>
#include <math.h>
#include "DSK.H"
#include "DSK_COFF.H"
#include "C3XMMRS.H"
#include "keydef.h"

ulong   MSG_BOX  =  0x809800L;
ulong   A_BOX    =  0x809800L;
ulong   B_BOX    =  0x809800L;
ulong   C_BOX    =  0x809800L;
ulong   LOAD_BOX =  0x809800L;
ulong   MASK     =  0x809800L;
ulong   SAMPLES  =  0x809800L;
ulong   DATABLOCK = 0x809800L;

#define MaxSamples 512         // FFT size is 256
int     Samples   =  256;
int     StepSize  =    2;
int     graph_en  =    1;
//
// DSP cycle time H1/H3 clock rate
//
//float  THx=50.000e-9;  // 40MHz
float  THx=40.000e-9;  // 50MHz
//float  THx=33.333e-9;  // 60MHz
//float  THx=25.000e-9;  // 80MHz

#define graph_vwport() mysetviewport( 50,  0, 563, 340,   1)
#define menu_vwport()  mysetviewport(334,  0, 639, 340,   1)
//#fine graph_vwport()   setviewport( 50,  0, 563, 340,   1)
//#fine menu_vwport()    setviewport(334,  0, 639, 340,   1)
#define A_REG  ((TA <<9)+(RA <<2)+0) // A divisors.. set SCF rate
#define AP_REG ((TAP<<9)+(RAP<<2)+1) // TA RA prime registers (not used)
#define B_REG  ((TB <<9)+(RB <<2)+2) // B divisors


typedef enum messages
{
  STOP =1,
  START=2
}message;

char  DSK_APP[]    ="FFTXXX.DSK";
char  DSK_EXE_APP[]="FFT_XXX.EXE";
long  TLVL_V;
ulong T0_prdv=0x00000001L;
ulong ZERO   =0x00000000L;
ulong MASKVAL=0xFFFF0000L;

float Hz_per_div = 0.0;
float Fsr=1000.0, Fsx=1000.0;
int   TA =  10;     // DAC divisors
int   TB =  14;     //
int   RA =  10;     // ADC divisors
int   RB =  14;     //
int   TAP=   1;     // TA' and RA' are not used in this application
int   RAP=   1;     //
int C_REG=0x03;     // AIC control register bits

int  oldbuf[MaxSamples];
char buf_0 [MaxSamples];                      // Keep past data history for
char buf_1 [MaxSamples];                      // time averaging of signals
char buf_2 [MaxSamples];
char buf_3 [MaxSamples];
char buf_4 [MaxSamples];
char buf_5 [MaxSamples];
char buf_6 [MaxSamples];
char buf_7 [MaxSamples];
char buf_8 [MaxSamples];

float Ftyp=0, Fmax=0, Fmin=0;
char  strg[32];
int   maxy=0,maxx=0;
double Fx,f0=0,f1=0,f2=0,f3=0,f4=0,f5=0,f6=0;
char  *p;

char  buf_pk_t[MaxSamples];
int   buf_y_pk[MaxSamples];
int   avg_on = 0;
void  init_graphics(void);
int   check_key (void);
void  binsprintf(char *s,int val);
//----------------------------------------------------
//
//----------------------------------------------------
void myouttextxy(int x,int y,char *s)
{
  int xc,yc;
  if(graph_en) outtextxy(x,y,s);
  else
  {
    xc = 1+(80*(x  ))/640;
    yc = 1+(25*(y  ))/250;
    if(yc< 1) yc =  1; if(yc>25) yc = 25;
    if(xc< 1) xc =  1; if(xc>60) xc = 60;
    gotoxy(xc,yc);
    printf("%s",s);
  }
}
void mysetwritemode(int mode)
{
  if(graph_en) setwritemode(mode);
}

void mysetviewport(int x1,int y1, int x2, int y2, int clip)
{
  if(graph_en) setviewport(x1,y1,x2,y2,clip);
}
void myclearviewport(void)
{
  if(graph_en) clearviewport();
}
void  mysetcolor(int c)
{
  if(graph_en) setcolor(c);
}

//----------------------------------------------------
// draw_peak()
//----------------------------------------------------
#define pw 1   // controls peak indicator draw width
void draw_peak(void)
{
  int  x, xx=0, y, *y_pk;
  char *pk_t, *ptr0, *tmp0;
  if(!graph_en) return;
  pk_t = buf_pk_t;
  tmp0 = buf_0;
  y_pk = buf_y_pk;
  ptr0 = tmp0;                       // Set buffer pointers
  setcolor(LIGHTRED);
  for(x=0;x<Samples/2;x++)
  {
    xx+=StepSize;
    y = 128 - *ptr0++;               // present Y to display
    *pk_t += 1;                      // Inc times peak has been displayed
    if((*pk_t > 8) || (y < *y_pk))   // If vmag>last redraw new peak
    {
      line(xx-pw,*y_pk,xx+pw,*y_pk  ); // undraw old horizontal peak
    //line(xx   ,*y_pk,xx   ,*y_pk-4); // vertical version (not as interesting)
      if(y <= *y_pk)                 // if vmag>last freshen peak hold
      {
        *y_pk = y;
        *pk_t = 0;
      }
      else
      {
        if(y>=254) *y_pk=254;         // No peak if array is zero
        if(y > (*y_pk+6)) *y_pk += 6; // Fast peak decay for rapid change
        else              *y_pk += 1; // slow decay
      }
      line(xx-pw,*y_pk,xx+pw, *y_pk  );  // draw new horizontal peak
   // line(xx   ,*y_pk,xx   , *y_pk-4);  // vertical
    }
    y_pk++;
    pk_t++;
  }
}
//--------------------------------------------------------
// draw_vect() draws the vertical display bars for each
// frequency bin.  To make the display much faster only
// the part which changes is drawn using an XOR function.
//--------------------------------------------------------
void draw_vect()
{
  int  x, y, *old,xx=0;
  char *ptr0, *tmp0;
  if(graph_en)
  {
    tmp0 = buf_0;
    ptr0 = tmp0;                          // Set buffer pointers
    setcolor(WHITE);
    old = oldbuf;
    setwritemode(1);                      // Set line draw to XOR mode
    for(x=0;x<Samples/2;x++)
    {
      xx+=StepSize;
      y = 128 - *ptr0++;                  // present Y to display
  //  if(y == old_y) do nothing
      if(y  > *old) line(xx,*old+1,xx,y  );
      if(y  < *old) line(xx,*old  ,xx,y+1);
      *old++ = y;
    }
    setfillstyle(SOLID_FILL, BLACK);
    bar(0,261,256,268);
  }
  if(graph_en==0)
  {
    sprintf(strg,"Fmin=%7.6f khz",(float)     Fmin); myouttextxy(1,100,strg);
    sprintf(strg,"Ftyp=%7.6f khz",(float)     Ftyp); myouttextxy(1,110,strg);
    sprintf(strg,"Fmax=%7.6f khz",(float)     Fmax); myouttextxy(1,120,strg);
    sprintf(strg,"F__ =%7.6f khz",(float)Fmax-Fmin); myouttextxy(1,130,strg);
  }
  else
  {
    if(maxx<Samples/4)
    {sprintf(strg,"^ %7.6f",Ftyp);myouttextxy(maxx   ,261,strg);}
    else
    {sprintf(strg,"%7.6f ^",Ftyp);
    myouttextxy(maxx-((strlen(strg)-1)*8),261,strg);}
  }                                 // 8=pixel width/char
}                                   // N chars printed to left of ^

void printmsg(int x, int frq)
{
//  if(sound_en) sound(frq);
  if(frq==0) return;
  if(!graph_en) return;
  if(!x) sprintf(strg,"Going up!");
  else   sprintf(strg,"Going down!");
  if(maxx < 256)  myouttextxy(maxx+150,261,strg);
  else            myouttextxy(maxx-150,261,strg);
}
/*
void mysound(float f,float Ftyp)
{
   if  (f > 1.05*Ftyp) {printmsg(0,3000);}
   else
   {
     if(f < Ftyp/1.05) {printmsg(1,2000);}
     else  nosound();
   }
}
*/

void Zero(void)
{
  int  x;
  char *ptr0;
  char *pk_t;
//int  *y_pk;
  ptr0 = buf_0;
//y_pk = buf_y_pk;
  pk_t = buf_pk_t;
  for(x=0;x<Samples/2;x++)
  {
    *pk_t++ =    9;
//  *y_pk++ = -127;
    *ptr0++ = -128;                  // present Y to display
  }
//for(x=0;x<64;x++)
//  draw_peak();
}

//---------------------------------------------------------------
// main()  After checking for any command line arguments main
// enters an outer 'forever loop' where the DSK communications
// channel is initialized, followed by loading the code and
// then initializing the graphics mode.  A second 'inner forever
// loop' is then entered where the application interacts with the
// host.  When a failure occurs inside the inner forever loop that
// loop is broken (see break; commands), causing the application
// to re-execute the outer loop, which causes the channel to be
// re-initialized followed by a code load and graphics initialize.
// This method allows the DSK to be disconnected and reconnected
// without the application bombing out to the command line.
//----------------------------------------------------------------
void main(void)
{
  int New_Params = 1, reset_flag = 0;
  ulong START_MSG=START, aic,TEMP;
  MSGS err;
  double sum;
  char *ptr1, *ptr2, *ptr3, *ptr4;
  char *ptr5, *ptr6, *ptr7, *ptr8, *ptr0;
  char *tmp1, *tmp2, *tmp3, *tmp4;
  char *tmp5, *tmp6, *tmp7, *tmp8, *tmp0;
  int x;
  clrscr();
  Scan_Command_line(DSK_EXE_APP);
  clrscr();
  //***********************************************//
  // The outer loop initializes the DSK on entry   //
  // or if the application fails                   //
  //***********************************************//
  for(;;)
  { for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    HALT_CPU(); // Halt previously running apps code
    if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    if((err=Load_File(DSK_APP,SLOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    // Load location information for updatable variables
    // from the loaded DSP applications symbol table
    //
    x  = ref_value("MASK"      ,(long *) &MASK     );
    x  = ref_value("MSG_BOX"   ,(long *) &MSG_BOX  );
    x  = ref_value("LOAD"      ,(long *) &LOAD_BOX );
    x  = ref_value("A_REG"     ,(long *) &A_BOX    );
    x  = ref_value("B_REG"     ,(long *) &B_BOX    );
    x  = ref_value("C_REG"     ,(long *) &C_BOX    );
    x  = ref_value("SIZE"      ,(long *) &SAMPLES  );
    x  = ref_value("DATA_ARRAY",(long *) &DATABLOCK);
    //
    // Load size parameter from application running on DSK
    //
    getmem(SAMPLES,1,&TEMP);
    Samples = TEMP;
    if(Samples>MaxSamples)Samples=MaxSamples;
    //
    RUN_CPU();
    init_graphics();
    //
    // Init buff ptrs, Temps are rotated
    //
    tmp0 = buf_0;
    tmp1 = buf_1; tmp2 = buf_2; tmp3 = buf_3; tmp4 = buf_4;
    tmp5 = buf_5; tmp6 = buf_6; tmp7 = buf_7; tmp8 = buf_8;
    ptr0 = tmp0;
    for(x=0;x<Samples;x++)                   // Clear all buffersq
    {
      buf_1[x] = 0; buf_2[x] = 0; buf_3[x] = 0; buf_4[x] = 0;
      buf_5[x] = 0; buf_6[x] = 0; buf_7[x] = 0; buf_8[x] = 0;

      buf_0[x]    = 0;
      buf_y_pk[x] = 255;
      buf_pk_t[x] = 8;
      oldbuf[x]   = 255;
    }

    StepSize = 512/Samples;
    check_key();
    draw_vect(); //
    draw_peak(); // Draw peaks and vector displays using XOR write
    //***********************************************************//
    // The inner loop is repeated until a keyboard hit exits the //
    // application or the application reports an error and needs //
    // to be reinitialized                                       //
    //***********************************************************//
    //for(int loop=0;loop<1000;loop++) // 1K loop benchmark for entire app
    for(;;)
    {
      // The inner loop draws the display using an XOR line draw
      // to overdraw existing vectors
      StepSize = 512/Samples;
      //--------------------------------------------------------
      // Average the data over up to 8 frames
      //
      ptr0 = tmp0;                                   // Set buffer pointers
      ptr1 = tmp1; ptr2 = tmp2; ptr3 = tmp3; ptr4 = tmp4;
      ptr5 = tmp5; ptr6 = tmp6; ptr7 = tmp7; ptr8 = tmp8;
      for(x=0;x<Samples;x+=StepSize)
      { switch(avg_on)
        { case  1: *ptr0=(*ptr1+*ptr2)             >> 1; break; // avg 2
          case  2: *ptr0=(*ptr1+*ptr2+*ptr3+*ptr4) >> 2; break; // avg 4
          case  3: *ptr0=(*ptr1+*ptr2+*ptr3+*ptr4+              // avg 8
                          *ptr5+*ptr6+*ptr7+*ptr8) >> 3; break;
          default: *ptr0= *ptr1;                         break; // avg 1
        }
        ptr0++;
        ptr1++; ptr2++; ptr3++; ptr4++;               // next data
        ptr5++; ptr6++; ptr7++; ptr8++;
      }
      draw_vect();
      draw_peak();
      // To prevent getmem timeouts an artificial strobe is used to
      // signal to the DSK that a host request is in progress
      HPI_STRB(0);            // Drive HPSTB (INT2) low and wait
      reset_flag = 0;
      for(;;)                 // for DSK to stop with full buffer
      { if(kbhit())
        {
          reset_flag = check_key();
          New_Params=1;
        }
        if(HPI_ACK())break;  // Note: break last to ensure keytrap!
        delay(1);
      }
      if(reset_flag) break;

      ptr1 = tmp8;                    // Rotate the buffer pointers
      tmp8 = tmp7; tmp7 = tmp6; tmp6 = tmp5; tmp5 = tmp4;
      tmp4 = tmp3; tmp3 = tmp2; tmp2 = tmp1; tmp1 = ptr1;
      //
      // If a key was pressed, update the AIC setup
      if(New_Params)
      {
    //  Samples = 256;
        TEMP = Samples;
        if(putmem(SAMPLES , 1,&TEMP   )!=NO_ERR) break;
        if(putmem(MASK,     1,&MASKVAL)!=NO_ERR) break;
        if(putmem(T0_prd  , 1,&T0_prdv)!=NO_ERR) break;
        if(putmem(T0_count, 1,   &ZERO)!=NO_ERR) break;
        if(putmem(T1_prd  , 1,&T0_prdv)!=NO_ERR) break;
        if(putmem(T1_count, 1,   &ZERO)!=NO_ERR) break;
        if(TB>TA)
        {
          aic = A_REG; if(putmem(A_BOX,1,&aic)!=NO_ERR) break;
          aic = B_REG; if(putmem(B_BOX,1,&aic)!=NO_ERR) break;
        }
        else
        {
          aic = B_REG; if(putmem(A_BOX,1,&aic)!=NO_ERR) break;
          aic = A_REG; if(putmem(B_BOX,1,&aic)!=NO_ERR) break;
        }
        aic = C_REG; if(putmem(C_BOX,1,&aic)!=NO_ERR) break;
        if(putmem(LOAD_BOX,1,&aic)!=NO_ERR) break; // Any nonzero reinits AIC
      }
      New_Params = 0;
      if(getmem(DATABLOCK,Samples/8,(ulong *)ptr1)!=NO_ERR) break;//128 char

      //
      // After finding the peak, go back and get the full precision data
      //
      Fsx     = 1/(2*TA*TB*(2*THx * T0_prdv));
      if(C_REG & 0x20) Fsr = Fsx;
      else             Fsr = 1/(2*RA*RB*(2*THx * T0_prdv));
      //
      ptr1 = tmp0+2;
      maxy = *ptr1;
      maxx = 0;
      for(x=3;x<Samples-3;x++)
      { if(*ptr1>maxy)
        { maxy = *ptr1;
          maxx = x;
        }
        ptr1++;
      }
      x = maxx;
      maxx*=StepSize;  // two pixels/bin
      maxx-=2;         // half pixel width of '^' symbol
      //
      /*
      getmem(DATABLOCK+Samples+x-3,1,&TEMP); f0 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x-2,1,&TEMP); f1 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x-1,1,&TEMP); f2 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x  ,1,&TEMP); f3 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x+1,1,&TEMP); f4 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x+2,1,&TEMP); f5 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+Samples+x+3,1,&TEMP); f6 = TMS_IEEE(TEMP);
      */
  //  #define MaxSamples 512
      getmem(DATABLOCK+MaxSamples+x-3,1,&TEMP); f0 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x-2,1,&TEMP); f1 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x-1,1,&TEMP); f2 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x  ,1,&TEMP); f3 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x+1,1,&TEMP); f4 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x+2,1,&TEMP); f5 = TMS_IEEE(TEMP);
      getmem(DATABLOCK+MaxSamples+x+3,1,&TEMP); f6 = TMS_IEEE(TEMP);

      sum = f0+f1+f2+f3+f4+f5+f6;
      if(sum==0) Fx = 0;
      else
      {
      //  if(Samples==256)
      //    x-=1;
        Fx = f0*(x-3)
           +f1*(x-2)
           +f2*(x-1)
           +f3*(x  )
           +f4*(x+1)
           +f5*(x+2)
           +f6*(x+3);

        Fx/= sum;
        Fx = ((Fx * Fsr)/(float)(Samples))*1e-3;
        #define Smear 4.0
        Ftyp = (Ftyp*(Smear-1.0) + Fx)/Smear;
        if(Fx>Fmax) Fmax = Fx;
        if(Fx<Fmin) Fmin = Fx;
        Fmax = Ftyp + ((Fmax - Fx) * 0.95);
        Fmin = Ftyp + ((Fmin - Fx) * 0.95);
      }

      putmem(MSG_BOX,1,&START_MSG); // Restart
    }
    closegraph();  // Shutdown graphics before re-initializing
    printf("%s: %s\n",DSK_APP, Error_Strg(err));
    printf("Communications are being reinitialized");
    delay(1000);
    DSK_reset();
  }
}
//----------------------------------------------------------------
// clip() is used to clip the upper and lower bounds of a number
//----------------------------------------------------------------
long inline clip(long x, int min, int max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}
//----------------------------------------------------------------
// check_key() is used to associate keystrokes with actions
//----------------------------------------------------------------
int check_key(void)
{
  int  key=0;
  int  Yt=0;
  int  C1;
  char buf[80];
  static int old_key=0; // accelerate action if same key is hit again
  static int accel  =1;
  if(kbhit()) key = bioskey(0) & 0xFF00;
  if(old_key==key) accel = accel + 1;
  else             accel = accel / 4;
  accel = clip(accel,1,200); old_key = key;
  if(key)
  {
    switch(key)
    {
      case _Ins: T0_prdv -=accel; break;
      case _Del: T0_prdv +=accel; break;
      case _R  : return 1;  // Return reset (break) flag
      //
      // _M adjusts a mantissa mask which can be used to
      // analyze the effects of numeric precision
      //
      case _M  : MASKVAL = MASKVAL << 1;
                 if(MASKVAL==0) MASKVAL = 0xFFFF0000L;
                 break;

      case _Q  :closegraph();
                _setcursortype(_NORMALCURSOR);
                exit(0);
                break;
      case _F1 : TA++; break;
      case _F2 : TA--; break;
      case _F3 : TB++; break;
      case _F4 : TB--; break;
      case _F5 : RA++; break;
      case _F6 : RA--; break;
      case _F7 : RB++; break;
      case _F8 : RB--; break;

      case _G  : graph_en^=1;
                 if(graph_en)
                 {
                   init_graphics(); // re-init graphics mode
                   for(int x=0;x<Samples/2;x++)  // Clear all buffers
                   {
                     buf_1[x] = 0; buf_2[x] = 0;
                     buf_3[x] = 0; buf_4[x] = 0;
                     buf_5[x] = 0; buf_6[x] = 0;
                     buf_7[x] = 0; buf_8[x] = 0;

                     buf_0[x]    = 0;
                     buf_y_pk[x] = 255;
                     buf_pk_t[x] = 8;
                     oldbuf[x]   = 255;
                   }
                   draw_vect(); //
                   draw_peak(); // Draw peaks and vector displays using XOR write
                 }
                 else
                 {
                   closegraph();    // go back to EGA/VGA text mode
                 }
                 break;


      case _F9 : Zero();
                 draw_vect();
                 draw_peak();
                 Samples = 256;
                 StepSize = 512/Samples;
                 break;
      case _F10: Zero();
                 draw_vect();
                 draw_peak();
                 Samples = 512;
                 StepSize = 512/Samples;
                 break;

      case _1  : C_REG = C_REG ^ 0x80; break; // bit 7
      case _2  : C_REG = C_REG ^ 0x40; break; // bit 6
      case _3  : C_REG = C_REG ^ 0x20; break; // bit 5
      case _4  : C_REG = C_REG ^ 0x10; break; // bit 4
      case _5  : C_REG = C_REG ^ 0x08; break; // bit 3
      case _6  : C_REG = C_REG ^ 0x04; break; // bit 2
      case _A  :
                 switch(avg_on)
                 {
                   case  1: avg_on=2; break;
                   case  2: avg_on=3; break;
                   case  3: avg_on=4; break;
                   default: avg_on=1; break;
                 }
                 break;

      default : return 0;
    }
    TA         = clip(TA        ,     3,         31);
    TB         = clip(TB        ,    12,         63);
    RA         = clip(RA        ,     3,         31);
    RB         = clip(RB        ,    12,         63);
    T0_prdv = clip(T0_prdv,     1,         64);
  }
  mysetwritemode(0);                      // turn off XOR write
  menu_vwport();                       // Write to window in bright blue
  myclearviewport();
  mysetcolor(11);
  Yt=1;
  C1=1;
  myouttextxy(C1,Yt    , "Q       quit"  );
  myouttextxy(C1,Yt+=10, "R       reset" ); switch(avg_on)
  { case  1: sprintf(buf,"A       avg  => 2 frames");break;
    case  2: sprintf(buf,"A       avg  => 4 frames");break;
    case  3: sprintf(buf,"A       avg  => 8 frames");break;
    default: sprintf(buf,"A       avg  => 1 frame");break;
  }
  myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,"Ins/Del TIM0 => Tprd=%02ld",T0_prdv);
  myouttextxy(C1,Yt+=10,buf);
  Yt+=10;
  sprintf(buf,"F1/F2 TA+/-   TA=%02d",TA); myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,"F3/F4 TB+/-   TB=%02d",TB); myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,"F5/F6 RA+/-   RA=%02d",RA); myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,"F7/F8 RB+/-   RB=%02d",RB); myouttextxy(C1,Yt+=10,buf);
//sprintf(buf,"              Fdac=%7.2f",Fsx);myouttextxy(C1,Yt+=10,buf);
//sprintf(buf,"              Fadc=%7.2f",Fsr);myouttextxy(C1,Yt+=10,buf);
  Yt+=10;
  if(graph_en==0)
  {
    C1 = 300;
    Yt =   0;
  }

 sprintf(buf,"AIC CTRL:  ");binsprintf(buf+10,C_REG);myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"          ||||||"                   ); myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"  use num |||||+---6   BP filter"   ); myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"  keys to |||+-----5   Loopback"    ); myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"  toggle  ||+------4   AIN/AUXIN"   ); myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"  bits    |+-------3   Asynch/synch"); myouttextxy(C1,Yt+=10,buf);
 sprintf(buf,"          +--------1,2 gain bits"   ); myouttextxy(C1,Yt+=10,buf);
  Yt+=10;
  switch(C_REG&0xC0)
  { case 0x00:  myouttextxy(C1,Yt+=10,"+0dB      6.0 Vmax"); break;
    case 0x40:  myouttextxy(C1,Yt+=10,"+6dB      3.0 Vmax"); break;
    case 0x80:  myouttextxy(C1,Yt+=10,"+12dB     1.5 Vmax"); break;
    case 0xC0:  myouttextxy(C1,Yt+=10,"+0dB      6.0 Vmax"); break;
  }
  if(C_REG&0x20)myouttextxy(C1,Yt+=10,"Synch     Fadc==Fdac");
  else          myouttextxy(C1,Yt+=10,"Asynch    Fadc!=Fdac");
  if(C_REG&0x10)myouttextxy(C1,Yt+=10,"AUXIN     ENABLE");
  else          myouttextxy(C1,Yt+=10,"AIN       ENABLE");
  if(C_REG&0x08)myouttextxy(C1,Yt+=10,"loopback  ENABLE");
  else          myouttextxy(C1,Yt+=10,"loopback  DISABLE");
  if(C_REG&0x04)myouttextxy(C1,Yt+=10,"BP filter ENABLE");
  else          myouttextxy(C1,Yt+=10,"BP filter DISABLE");
  Yt+=10;
  sprintf(buf,"[M]ant Mask=%08lx (precision)",MASKVAL);
  myouttextxy(C1,Yt+=10,buf);
  //
  //
  graph_vwport();
  Fsx     = 1/(2*TA*TB*(2*THx * T0_prdv));
  if(C_REG & 0x20) Fsr = Fsx;
  else             Fsr = 1/(2*RA*RB*(2*THx * T0_prdv));
  Hz_per_div = (520.0/512.0)*Fsr/(2.0*10);
  //
  //
  if(graph_en)
  {
    setfillstyle(SOLID_FILL, BLACK);
    bar(0,269,260,310);
  }
  Yt +=20;
  if(graph_en==0)
  {
    C1 =   0;
    Yt = 150;
  }
  sprintf(buf,  "Hz/div=%7.2f",Hz_per_div); myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,  "  Fdac=%7.2f",       Fsx); myouttextxy(C1,Yt+=10,buf);
  if(C_REG&0x20)  sprintf(buf,"  Fadc=Fdac");
  else            sprintf(buf,"  Fadc=%7.2f",Fsr);
  myouttextxy(C1,Yt+=10,buf);
  sprintf(buf,
  "The 5 key enables a sawtooth loopback signal for self analysis");
  myouttextxy(C1,Yt+=20,buf);
  sprintf(buf,
  "Use the G key to toggle between text/graphics modes");
  myouttextxy(C1,Yt+=20,buf);
  return 0;
}
//----------------------------------------------------------------
// Intialize graphics mode, draw reticle, and add labels
//----------------------------------------------------------------
void init_graphics(void)
{
  int gdriver = EGA, gmode = EGAHI, errorcode, Y, X;
// register EGAVGA_driver which is the name of the driver in EGAVGA.OBJ
// EGAVGA.OBJ is created from EGAVGA.BGI using the BGIOBJ.EXE utility
// and is linked by either the link list or project file
// NOTE: This section of code can be ommitted if EGAVGA.BGI is
//       located in the applications startup directory
  if(!graph_en) return;
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)  // report any registration errors
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");  getch();  exit(1);
  }
  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:"); getch(); exit(1);
  }
  myclearviewport(); graph_vwport(); mysetcolor(GREEN);
  #define Xd 260
  #define xd 26
  for(Y=0;Y<=Xd;Y+=xd) line(0,Y,Xd,  Y);  // draw reticle
  for(X=0;X<=Xd;X+=xd) line(X,0, X, Xd);

  Y = 2; X = 2;
  myouttextxy(X,Y    ,"+20"); myouttextxy(X,Y+=26,"+10");
  myouttextxy(X,Y+=26," +0"); myouttextxy(X,Y+=26,"-10");
  myouttextxy(X,Y+=26,"-20"); myouttextxy(X,Y+=26,"-30");
  myouttextxy(X,Y+=26,"-40"); myouttextxy(X,Y+=26,"-50");
  myouttextxy(X,Y+=26,"-60"); myouttextxy(X,Y+=26,"-70");
  mysetwritemode(1);                        // display lines are XOR drawn
  mysetcolor(15);                           // light gray
}
//----------------------------------------------------------------
// bunsprintf() prints an integer values 1,0 bit pattern to a
// string pointer which can then be printed to the display device
//----------------------------------------------------------------
void binsprintf(char *s,int val)
{
  char *p;
  unsigned int t;
  p = s;
  t = 0x80;  // scan 8 bits
  for(;t>0;t=t>>1)
  {
    if(val & t) *p++ = '1';
    else        *p++ = '0';
  }
  *p=0;
}
