//------------------------------------------------------
// Bare bones 256 FFT
//------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <graphics.h>
#include "DSK.H"
#include "DSK_COFF.H"
//------------------------------------------------------


#define Samples 256         // FFT size is 256
char  DSK_APP[]    ="FFT256.DSK";
char  DSK_EXE_APP[]="FFT_256.EXE";
#define MSG_BOX   0x809C00L
/*
#define Samples 512         // FFT size is 256
char  DSK_APP[]    ="FFT512.DSK";
char  DSK_EXE_APP[]="FFT_512.EXE";
#define MSG_BOX   0x809E00L
*/
#define DATABLOCK (0x809800L + Samples)

typedef enum messages
{
  STOP =1,
  START=2
}message;
int  oldbuf[512];
char buf_0 [512];                      // Keep past data history for
void  init_graphics(void);
//------------------------------------------------------
// draw_vect() draws the vertical display bars for each
// frequency bin.  To make the display much faster only
// the part which changes is drawn using an XOR function
//------------------------------------------------------
void draw_vect()
{
  int  x, y;
  int  *old;
  char *ptr0;
  char *tmp0;
  tmp0 = buf_0;
  ptr0 = tmp0;                          // Set buffer pointers
  setcolor(WHITE);
  old = oldbuf;
  setwritemode(1);                      // Set line draw to XOR mode
  for(x=0;x<Samples;x+=2)
  {
    y = 128 - *ptr0++;                  // present Y to display
//  if(y == old_y) do nothing
    if(y  > *old) line(x,*old+1,x,y  );
    if(y  < *old) line(x,*old  ,x,y+1);
    *old++ = y;
  }
  setfillstyle(SOLID_FILL, BLACK);
}
//----------------------------------------------------------------
void main(void)
{
  int  reset_flag = 0;
  ulong MSG=START;
  MSGS err;
  int x;
  Scan_Command_line(DSK_EXE_APP);
  //***********************************************//
  for(;;)
  { if(Init_Communication(10000) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  HALT_CPU(); // Halt previously running apps code
  if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
  { printf("%s %s\n",DSK_APP,Error_Strg(err));
    exit(0);
  }
  RUN_CPU();
  init_graphics();
  //
  //
  for(x=0;x<256;x++)                   // Clear new/old buffers
  {
    oldbuf[x]= 255;
    buf_0[x] = 0;
  }
  draw_vect();
  //***********************************************************//
  for(;;)
  {
    draw_vect();
    // To prevent getmem timeouts an artificial strobe is used to
    // signal to the DSK that a host request is in progress
    HPI_STRB(0);            // Drive HPSTB (INT2) low and wait
    reset_flag = 0;
    for(;;)                 // for DSK to stop with full buffer
    {
      if(kbhit()) reset_flag = 1;
      if(HPI_ACK())break;  // Note: break last to ensure keytrap!
      delay(1);
    }
    if(reset_flag) break;
    if(getmem(DATABLOCK,Samples/8,(ulong *)buf_0)!=NO_ERR) break;
    putmem(MSG_BOX,1,&MSG);
  }
  closegraph();  // Shutdown graphics before re-initializing
}
//----------------------------------------------------------------
// init_graphics() initializes the host display for graphics
// output and then draws the lines and text for the display graph
//----------------------------------------------------------------
void init_graphics(void)
{
  int gdriver = EGA;
  int gmode = EGAHI;
  int errorcode;
  int Y;
  int X;
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)  // report any registration errors
  {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    exit(1); // terminate with an error code
  }
  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    exit(1);
  }
  clearviewport();
  setcolor(GREEN);
  for(Y=0;Y<=260;Y+=26) line(0,Y,260,Y);  // draw reticle
  for(X=0;X<=260;X+=26) line(X,0,X,260);  //
  setwritemode(1);                        // display lines are XOR drawn
  setcolor(15);                           // light gray
}

