//------------------------------------------------------------
// DSK_HLL.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  DSK_HLL.CPP is a modifed version of REGVIEW.CPP, a DOS text based
//  application.  DSK_HLL continually downloads the CPU program
//  counter (in context array) and then uses that value to cross
//  reference to a given SOURCE.C file.  DSK_HLL is intended
//  to be run concurrently with the DSK3D debugger.
//
//  Special Note: DSK_HLL expects to always be able to gain access
//                to the DSK target.  If the DSK fails to respond
//                the application will fail.
//
//  The project file should include the following
//
//    DSK_HLL.CPP   This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window routines
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - None
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.  The CPP extensions are simply a default.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS text window executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.  This application can
//        coexist with the debugger and other MEMVIEW applications.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
// Version 1.12 update
//
// The code protection scheme that was used as during UPDATE_CPU was
// Changed from "asm cli, asm sti" code protection to using the global
// variable 'No_MTask'.  If set, this variable disables all calls to
// the timeslice managment routines.  If multitasking is already turned
// off, and this variable is set, whatever code that follows, including
// code that might turn multitasking back on, is disabled.  Use STI/CLI
// with EXTREME caution!
//--------------------------------------------------------------
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dsk.h"
#include "keydef.h"
#include "dsk_coff.h"
#include "symbols.h"

char DSK_APP[80];
int speed = 3;
char HLLfunction[20];
FILE *csrcfile;
int first_line = 0, last_line = 0, debug_line;

MSGS HLL_SRCE_LINE(void);
MSGS Display_Source(void);
//---------------------------------------------------
// Get the name of the file loaded into DSK3D debugger
// Note: this information is saved in dasmfile.fil
//---------------------------------------------------
void get_file_name(void)
{
  char *p;
  MSGS err;
  csrcfile = fopen("dasmfile.fil ","rt");
  if(csrcfile==NULL)
  {
    printf("No file is presently being debugged");
    exit(0);
  }
  fgets(DSK_APP,20,csrcfile);
  strupr(DSK_APP);
  if((p=strstr(DSK_APP,".OUT"))!=NULL)
  {
    strcpy(p,".out");
    fclose(csrcfile);
    if((err=Load_File(DSK_APP,SLOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
  }
  else
  {
    printf("\r\n Cannot debug non-COFF files");
    exit(0);
  }
}
//--------------------------------------------------
// Check any pending keytraps and perform actions
//--------------------------------------------------
void check_key(void)
{
  int key;
  key = bioskey(0) & 0xFF00;
  switch(key)
  {
    case  _Q  : exit(0);                // Quit
    case  _R  : get_file_name(); break;
    case  _pls: speed+=1; break;        // Slow down screen update rate
    case  _mns: speed-=1; break;        // speed up
    default   : break;
  }
  if(speed <  0) speed =  0;
  if(speed > 10) speed = 10;
}
//------------------------------------------------------------------
// UPDATE_CPU() performs a DSK halt if the DSK is not already halted
// and then copies a portion of the DSK's register context area
// to local host memory.  The DSK this then restarted if it was found
// in a running state.
//-------------------------------------------------------------------
MSGS UPDATE_CPU(void)
{
// If a XHALT command is issued while the DSK is halted, the current
// context (debugger mode) will be saved instead of the runtime
// context.  If a XRUN were then issued the resulting restore operation
// would corrupt the registers.
//
// A method of detecting a halt condition is provided in the C3X.ASM
// communications and debug kernel.  This method involves polling the
// FREERUN memory location at the end of the register context save structure.
//
//   FREERUN==0 -> DSK is currently stopped... DO NOT HALT_CPU
//   FREERUN!=0 -> DSK is currently running    HALT_CPU/RUN_CPU updates regs
//
  int t, T;
  ulong CMD, FREE;
  MSGS err;
  disable_Mtask();

  T = No_MTask;
  No_MTask=1;
  for(;;)
  {
    err = getmem(CTXT_PTR+FREERUN,1,&FREE);// If keyhit getmem incomplete
    if(err == KEY_HIT) {No_MTask=T; check_key();}
    else break;
  }
  //
  // If the DSK is already halted, the context is valid so simply return.
  //
  if(FREE==0) {No_MTask=T; enable_Mtask(); return NO_ERR;}
  //
  // If the DSK is freerunning, the Registers need to be updated
  // before returning.  The update is performed by a HALT_CPU/RUN_CPU
  //
  CMD = XHALT;                   // Write command
  disable_Mtask();
  if((err=xmit_long(CMD))!=NO_ERR)
  { No_MTask=T; enable_Mtask(); return RECV_ERR; }
  for(t=500;t>0;t--)     // Allow 500 mS for slow apps to respond
  { if(HPI_ACK()) break;
    delay(1);
  }
  err = recv_long(&CMD);
//No_MTask = T;
  if(t==0) { /*enable_Mtask();*/ return RECV_ERR; }
  CMD = XRUNF;                // Write command
  err = xmit_long(CMD);
  delay(10);  // Allow time for context restore
  No_MTask = T;
  enable_Mtask();
  return err;
}

//--------------------------------------------------------
// HLL_SRCE_LINE returns the C source line number and sets
// the filename to the file associated with the function.
//--------------------------------------------------------
MSGS HLL_SRCE_LINE(void)
{
  int x, line;
  ulong addr;
  //
  // Search the cross reference table for a match,
  // remembering the name of each function associated
  //
  addr = CTXT[PC];
  line = 0;
  debug_line = 0;
    //-------------------------------
    line = HLL[lastHLL].xref.HLL_line;
    for(x=0;x<lastHLL;x++)
    {
      if(HLL[x].xref.HLL_line == 0)
      {
        strncpy(HLLfunction,SYM[(int)HLL[x].xref.DSP_addr].sptr,20);
        if((addr>= HLL[x+1].xref.DSP_addr)&& (addr < HLL[x+2].xref.DSP_addr))
        {
          line = HLL[x+1].xref.HLL_line;
          break;
        }
      }
      if((HLL[x+2].xref.DSP_addr)!=0)
      if((HLL[x+1].xref.HLL_line == 0) && (addr < HLL[x+2].xref.DSP_addr))
      {
        line = HLL[x].xref.HLL_line - 1;
        break;
      }
      if((HLL[x+1].xref.DSP_addr)!=0)
      if((addr >= HLL[x].xref.DSP_addr) && (addr < HLL[x+1].xref.DSP_addr))
      {
        line = HLL[x].xref.HLL_line - 1;
        break;
      }
      line = HLL[lastHLL].xref.HLL_line;
    }
    if(x==lastHLL)
      line = HLL[lastHLL].xref.HLL_line-1;
  debug_line = line;
  return NO_ERR;
}
//==========================================================
// Recalculate the displays upper/lower line limits
//==========================================================
void Disp_Limits(void)
{
  if(debug_line < first_line)
    first_line = debug_line;
  if(debug_line > (last_line - 4))
  {
    last_line = last_line - ((last_line-4) - debug_line);
    first_line = last_line - 22;
  }
}
//==========================================================
// Display the source file using the line information
//==========================================================
char filename[20];
MSGS Display_Source(void)
{
  FILE *csrcfile;
  struct text_info ti;
  char buf[120];
  char *p;
  int xx;
  clrscr();
  if(first_line < 1) first_line = 1;
  last_line = first_line + 22;
  //--------------------------------------------------------------
  // Search the symbol table for the function name prepended to
  // the filename with a ':' seperator
  //--------------------------------------------------------------
  strcat(HLLfunction,":");
  for(xx=0;xx<last_ref;xx++)
    if((p=strstr(SYM[xx].sptr,HLLfunction))!=NULL)
    {
      p=strstr(SYM[xx].sptr,":");
      break;
    }
    if(xx==last_ref)
    {
      cprintf(">> No HLL cross reference found for current PC <<");
      strcpy(filename,"No File");
      return NO_ERR;
   // return NO_REF;
    }
  strncpy(filename,p+1,19);
  //-------------------------------------------------------------
  // Open the source file
  if((csrcfile = fopen(filename,"rt")) == NULL)
  { fcloseall();
    return OPEN_ERR;
  }
  //-------------------------------------------------------------
  for(xx=1;xx<=last_line;xx++)
  {
    if(fgets(buf,119, csrcfile)==NULL) break;
    tabstrip(buf,8);   // Tabs do not cprintf() to the screen nicely
    if(xx==debug_line)
    {
      gettextinfo(&ti);
      textbackground(BLUE);
      cprintf(">> %s\r",buf);
      textattr(ti.attribute);
    }
    else
      if(xx >= first_line)
        cprintf("   %s\r",buf);
  }
  fcloseall();
  return NO_ERR;
}
//==========================================================
// main begins
//==========================================================
void main()
{
//  clock_t start, end;
  int old_line;
  MSGS err;
  static char whirly[]="-";
  char *p;

  /*-------------------------------------------------------------*/
  /* The following line is used to insert app specific command   */
  /* line options into the help string before being printed. The */
  /* help string itself has enough WS chars to allow this.       */
  /*-------------------------------------------------------------*/
  Edit_Help_Msg("DSK_HLL.EXE","",
  "  USE: Start DSK3D, load your .OUT file then start DSK_HLL, or\r\n"
  "  use the 'R' key to have DSK_HLL recheck the DSK3D filename\r\n"
  "  The DSK3D saved loaded filenames in DASMFILE.FIL\r\n"
  "\r\n"
  );
  //
  // Check for standard command line arguments
  //
  Scan_Command_line("DSK_HLL.EXE");
  //
  // Initialize the communications link to the DSK
  //
  for(;;)
  {
    if(Init_Communication(10000) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  //-----------------------------------------------------
  // If windows is being run, is set the appropriate flags
  // to use Windows timeslice management interrupts.
  //-----------------------------------------------------
  Detect_Windows();
  clrscr();
  get_file_name();       // Get file name in the debugger
  textbackground(BLACK );
  textcolor     (YELLOW);
  for(;;)
  {
    if(kbhit()) check_key(); // If a key is hit, check it
    //-----------------------------------------------
    // Get the DSK register values and put them
    // into the local context storage array CTXT[]
    //-----------------------------------------------
    UPDATE_CPU();  // HALT/RUN update of register context
    if((err=getmem(CTXT_PTR+PC,1,&CTXT[PC])) != NO_ERR)
    { printf("%s\ngetmem() has crashed!\n",Error_Strg(err));
      exit(0);
    }
    //-----------------------------------------------------
    // Get the C source line that cross references with
    // the PC of the DSK and display the source (if any)
    //-----------------------------------------------------
    debug_line = 0;
    if(HLL_SRCE_LINE()!=NO_ERR) break;    // Find HLL line for PC value
    if(debug_line != old_line)            // If no change dont re-display
    { Disp_Limits();                      // calculate display limits
      if(Display_Source()!=NO_ERR) break; // display the source file
    }
    gotoxy(1,24);                         // Print other information
    printf("------------------------\n"
           "PC:%08lx -> %s  line:%d  %s  speed:%d",
               CTXT[PC],filename, debug_line,whirly,speed);
    switch(whirly[0])
    {
      case  '|': whirly[0] =  '/'; break;
      case  '/': whirly[0] =  '-'; break;
      case  '-': whirly[0] = '\\'; break;
      default:
      case '\\': whirly[0] =  '|'; break;
    }
    old_line = debug_line;
    //
    // Release the timeslice to other multi-task applications
    // NOTE: dont release the timeslice more than neccessary as this
    // can cause the application to lose all of its local time allotment
    // Placing Release_TSlice() inside the loop can cause the application
    // to freeze and not update...
    //
    /*
    Release_TSlice();
    //
    // Wait the appropriate interval for the screen update rate
    //
    start = clock();
    for(;;)
    {
      if(speed==0) break;
      Release_TSlice();
      if(kbhit()) break;
      end = clock();
      if((end - start) > speed) break;
    }
    */
    Release_TSlice();   // Release TimeSlice
    for(int i=0;i<speed;i++)
    {
//    Release_TSlice();   // Release TimeSlice
      if(kbhit()) break;
      delay(10);
    }
  }
  // If a failure occurs, there is no outer re-initialization
  // loop.  Therfor this is the exit code for the application
  // if a failure occurs.
  fcloseall();
  printf("Abnormal application exit");
  exit(0);
}

