//------------------------------------------------------------
// DSK_BMRK.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  DSK_BMRK.CPP is a DOS text based program which is used to benchmark
//  the DSK's connection to a printer port.  The reported data includes
//  IO read/write timing as well as actual DSK word transfer rates in
//  various operational modes.
//
//  The project file should include the following
//
//    DSK_BMRK.CPP    This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.TXT source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS text window executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.  This application can
//        coexist with the debugger and other MEMVIEW applications.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "dsk.h"
#include "keydef.h"
//--------------------------------------
void main(void)
{
  float elapsed_time;
  float words_xfrd;
  clock_t start, end;
  ulong testdata[2000];
  int x, y;
//int xx;
  long l;
//long xxx=0;
  //
  // Check for command line arguments
  //
  Scan_Command_line("DSK_BMRK.EXE");
  //
  // Initialize the communications link to the DSK
  //
  for(;;)
  {
    if(Init_Communication(10000) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  //
  // If windows is being run, is set the appropriate flags
  // to use Windows timeslice management interrupts.
  //
  Detect_Windows();
  clrscr();
  if(WSHIFT==-8)  printf("DSK interface is in byte mode\n\n");
  else            printf("DSK interface is in nibble mode\n\n");
#define LENGTH 100
#define TICKS    2
  while(clock()==clock());
  printf("Testing DSK getmem speed\n"
         "------------------------\n");
  start = clock();    // Restart and do benchmark
  for(y=1;y<10000;y++)  // Run for 10 sec maximum
  {
    getmem(0x0,LENGTH,testdata);
    end = clock();  // Dont call too often, or will corrupt benchmark
    if((end-start) > TICKS*CLK_TCK) break;
  }
  words_xfrd = (float)LENGTH * y;
  elapsed_time = (end-start)/CLK_TCK;
  l = words_xfrd/elapsed_time;
  printf("%f words xfrd\n%f seconds elapsed\n",words_xfrd,elapsed_time);
  printf("%ld 32 bit DSK reads/second, %d word blocks\n",l,(int)LENGTH);
  printf("%ld bytes/second\n\n",l*4);
  printf("Testing DSK putmem speed\n"
         "------------------------\n");
  while(clock()==clock());
  start = clock();    // Restart and do benchmark
  for(y=1;y<10000;y++)  // Run for 10 sec maximum
  {
    putmem(0x0,LENGTH,testdata);
    end = clock();  // Dont call too often, or will corrupt benchmark
    if((end-start) > TICKS*CLK_TCK) break;
  }
  words_xfrd = (float)LENGTH * y;
  elapsed_time = (end-start)/CLK_TCK;
  l = words_xfrd/elapsed_time;
  printf("%f words xfrd\n%f seconds elapsed\n",words_xfrd,elapsed_time);
  printf("%ld 32 bit DSK writes/second, %d word blocks\n",l,(int)LENGTH);
  printf("%ld bytes/second\n\n",l*4);
  //
  // Test IO access times (This section kills the DSK kernel)
  //
  printf("Host Printer Port speed\n"
         "-----------------------\n");
  #define K1 1000
  while(clock()==clock());
  start = clock();    // Restart and do benchmark
  for(y=0;y<10000;y++)  // Run for 10 sec maximum
  { for(x=0;x< K1;x++) // Apx 2 mS / loop at 2uS per IO access
      instat;
    end = clock();  // Dont call too often, or will corrupt benchmark
    if((end-start) > TICKS * CLK_TCK) break;
  }
  words_xfrd = (float)K1 * y;
  elapsed_time = (end-start)/CLK_TCK;
  l = words_xfrd/elapsed_time;
  printf("%ld PP reads/second (bytes/sec)\n",l);
  //---------------------------------------------------
  while(clock()==clock());
  start = clock();    // Restart and do benchmark
  for(y=0;y<10000;y++)  // Run for 10 sec maximum
  { for(x=0;x<K1;x++) // Apx 2 mS / loop at 2uS per IO access
      outctrl(RESET_LO);
    end = clock();  // Dont call too often, or will corrupt benchmark
    if((end-start) > CLK_TCK) break;
  }
  words_xfrd = (float)K1 * y;
  elapsed_time = (end-start)/CLK_TCK;
  l = words_xfrd/elapsed_time;
  printf("%ld PP writes/second (bytes/sec)\n",l);
  //---------------------------------------------------
  while(clock()==clock());
  start = clock();    // Restart and do benchmark
  for(y=0;y<10000;y++)  // Run for 10 sec maximum
  { for(x=0;x<K1;x++) // Apx 2 mS / loop at 2uS per IO access
    { instat;
      outctrl(RESET_LO);
    }
    end = clock();  // Dont call too often, or will corrupt benchmark
    if((end-start) > CLK_TCK) break;
  }
  words_xfrd = (float)K1 * y;
  elapsed_time = (end-start)/CLK_TCK;
  l = words_xfrd/elapsed_time;
  printf("%ld PP read&writes/second (bytes/sec)\n",l);
  //---------------------------------------------------
  getch();
}

