;------------------------------------------------------------------
; DSKWAV.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or liabilities.
; See the disclaimer document for details
;
; This application is written to run with the DOS executable DSK_WAV.EXE
; Information that pertains to the operation of the C31 assembly file and
; host interface is in the file DSK3WAV.DOC
;-------------------------------------------------------------------------
          .include "C3XMMRS.ASM"        ; C3x memory mapped registers
;---------------------------------------
          .start  "DMADATA",0X809800    ; 1024 byte DMA play buffer
          .sect   "DMADATA"             ; DMA<->HOST send/recv packet buffer
           ;----------------------------
          .start  "WAVDATA",DMADATA+1024; put buffers in on-chip RAM0
          .sect   "WAVDATA"             ;
;---------------------------------------
          .loop    256                  ; The unpacked DMA data from the host
          .word    0                    ; is zero filled to avoid hearing
          .endloop                      ; the previous buffer on startup
WAVDATAEND                              ;
;---------------------------------------
DMABUF1   .word  DMABUF1A               ; DMA receive buffer for Commands
DMABUF1A  .word  0,0,0,0                ; Receive is 4 bytes/long
          .word  1,1,1,1                ;
          .word  2,2,2,2                ;
          .word  3,3,3,3                ;
          .word  4,4,4,4                ;
          .word  5,5,5,5                ;
          .word  6,6,6,6                ;
          .word  7,7,7,7                ;
;---------------------------------------
COMMAND   .word  CMDBUF                 ; unpacked 32 bit commands
CMDBUF    .word  0,1,2,3,4,5,6,7        ;
;=================================================
Buf_End   .word  WAVDATAEND          ; Location of WAV buffers
Buf_Bgn   .word  WAVDATA             ;
Buf_IOA   .word  WAVDATA             ;
S0_gctrlv .word  0x0E970300          ; Serial port setup, XINT/RINT enabled
S0_xctrlv .word  0x00000111          ;
S0_rctrlv .word  0x00000111          ;
Dest      .word  DMADATA             ; Write to internal
HILO      .word  0                   ; Toggles HI or LO packed data playback
M16       .word  -16                 ; HI->LO Shift by 16 bits
AICDONE   .word  0                   ; Flag to indicate AIC play buffer empty
HPA       .word  0x00F00000          ; Host port address (addr is 24 bits)
TA        .set   4                   ; AIC default setup values
TB        .set   35                  ;
RA        .set   4                   ;
RB        .set   35                  ;
A_REG     .word  (TA<<9)+(RA<<2)+0   ;
B_REG     .word  (TB<<9)+(RB<<2)+2   ;
WLENG     .word  1028                ;
TIM0_w    .word  2                   ;
Dtype     .word  32                  ;
REINIT    .word  0                   ;
SUBCMD    .word  1                   ;
KernelSw  .set   0x809FAA            ; Address to enter kernel switch
;==========================================================================
; Main routine
;==========================================================================
main      ldi    0x30,IE         ; Service XINT/RINT
          or     0x2000,ST       ; Note: the AIC is never shut down
          andn   4,IF            ;
          andn   4,IF            ;
          tstb   4,IF            ; wait for INT2 to go active
          bz     main            ;
          ldi    1       ,R0     ; Receive a command from the host
          ldi    @HPA    ,R1     ; DMA read from
          ldi    @DMABUF1,R2     ; DMA write to
          ldi    @COMMAND,R3     ; Unpack destination
          ldi    0       ,R4     ; Unpack right away
          call   RecvDMA         ;
          ;-----------------------
          ldi    @CMDBUF,R0      ;
          cmpi   9,R0            ; If XUSER, branch straight to WAV
          bne    KernelCMD       ;
;---------------------------------
WAV_UCMD  ldi    7       ,R0     ; Recv WAVE sub parameters
          ldi    @HPA    ,R1     ; DMA read from
          ldi    @DMABUF1,R2     ; DMA write to
          ldi    @COMMAND,R3     ; Unpack destination
          ldi    0       ,R4     ; Unpack right away
          call   RecvDMA         ;
          ;----------------------
          ldi    @COMMAND,AR0    ;
          ldi    *+AR0(0),R0     ; Copy received params to proper fields
          sti    R0,@SUBCMD      ;
          ldi    *+AR0(1),R0     ;
          sti    R0,@WLENG       ;
          addi   @Buf_Bgn,R0     ;
          sti    R0,@Buf_End     ;
          ldi    *+AR0(2),R0     ;
          sti    R0,@A_REG       ;
          ldi    *+AR0(3),R0     ;
          sti    R0,@B_REG       ;
          ldi    *+AR0(4),R0     ;
          sti    R0,@TIM0_w      ;
          ldi    *+AR0(5),R0     ;
          sti    R0,@Dtype       ;
          ldi    *+AR0(6),R0     ;
          sti    R0,@REINIT      ;
          ;----------------------
          ldi    @REINIT,R0      ; If the REINIT flag is set, restart
          bz     BypsInit        ; the timer and AIC with new parameters
          ldi    0,R0            ; supplied from the host
          sti    R0,@REINIT      ;
          call   Init_TIM0       ;
          call   AIC_INIT        ;
          ldi    @S0_rdata,R0    ; Unfreeze underrun RINT
          ;----------------------
BypsInit  ldi    @SUBCMD,R0      ; Is sub-command RECORD=1 or PLAY!=1
          bz     SNDWAV          ;
          ;----------------------
RCVWAV    ldi    0x30,IE         ; Service both RINT/XINT for WAVE player
          ldi    @WLENG  ,R0     ; Recv WAVE packet
          ldi    @HPA    ,R1     ; DMA read from
          ldi    @Dest   ,R2     ; DMA write to
          ldi    @Buf_Bgn,R3     ; Unpack destination
          ldi    1       ,R4     ; Do NOT unpack right away
          call   RecvDMA         ;
          b      main            ; Stay in loop
          ;----------------------
SNDWAV    ldi    0x30,IE         ; Service both RINT/XINT for WAVE player
          ldi    @WLENG  ,R0     ; Recv WAVE packet
          ldi    @Dest   ,R1     ; DMA read from
          ldi    @HPA    ,R2     ; DMA write to
          ldi    @Buf_Bgn,R3     ; Pack source
          ldi    1       ,R4     ; Do NOT unpack right away
          call   SendDMA
        ; b      RCVWAV
          b      main            ; Stay in loop
;-------------------------------------------------------------------------
; The WAVE player is not set up to handle kernel commands.  If a kernel
; command is received, push the registers as if the command was received
; via the normal C3x comm kernel, and then branch to the beginning of the
; kernels command switch.  This patch allows this application to run
; concurrently with other DSK applications, so long as a timeout does not
; occur.
;
; NOTE: Be careful regarding the switch jump address.  This value was
; simply taken from the C3X.DSK file.  If the kernel changes, this value
; may need to be changed.
;-------------------------------------------------------------------------
KernelCMD ldi     @FakeC3x,R7    ; Kernel is an ISR, need a return address
          push    R7             ; >>> IE... DID NOT GET HERE BY INT2! <<<
          push    ST             ; Push ISR variables that are used in
          push    DP             ; kernel command switch.  After the
          push    R0             ; command completes, executing from
          push    IR1            ; the kernels program space, the kernel
          push    AR0            ; will try to restore these registers
          push    AR1            ;
          ldi    @CMDBUF,R0      ;
          ldi    R0,AR1          ;
          b      KernelSw        ; Command was a kernel command
Fake      ldi    @S0_rdata,R0
          ldi    0,R0
          sti    R0,@S0_xdata
          b      main            ;
FakeC3x  .word   Fake            ; Return from kernel is to 'Fake'
;------------------------------------------------------------------------
; Receives bytes from host, and then unpacks them into 32 bit words.
;
;   DMA_srce = HPA
;   RecvLeng = R0   length (longs)
;   DMA_srce = R1   DMA read from
;   DMA_dest = R2   DMA write to
;   Func_dest= R3   unpack destination
;   Play_Lock= R4   1 =wait for AIC play buf to complete before unpack
;------------------------------------------------------------------------
RecvDMA   push   R0           ;
          ldi    @DMA_xfr,R0  ; Wait for previous DMA to complete
          bnz    $-1          ;
          ldi    0,R0         ; Zero the DMA control... no false starts
          sti    R0,@DMA_ctrl ;
          pop    R0           ;
          mpyi   4,R0         ; Receive is 4 bytes/long
          sti    R0,@DMA_xfr  ; Set DMA counter
          sti    R1,@DMA_srce ;
          sti    R2,@DMA_dest ;
          ldi    0x453,R1     ;
          sti    R1,@DMA_ctrl ; Start the DMA
          ;-------------------
          ldi    @DMA_xfr,R1  ; Wait for DMA to complete, nothing to do
          bnz    $-1          ;  except ISR, or wait to finish block
          ldi    R4,R4        ; Wait for AIC play buf before unpack?
          bz     UnpackDMA    ;
          ldi    @AICDONE,R4  ; Wait for AIC play buf to complete
          bz     $-1          ;
          ldi    0,R4         ;
          sti    R4,@AICDONE  ;
;------------------------------------------------------------------------
; Unpack DMA takes an array of bytes, and packs them into an array of longs
;   Length (bytes)= R0
;   Read address  = R2 where to read byte values
;   Dest address  = R3 where to write 32 bit values
;------------------------------------------------------------------------
UnpackDMA ldi    R2,AR0       ;
          ldi    R3,AR1       ;
          lsh    -2,R0        ;
          ldi    R0,RC        ; Unpack each 4 byte DMA buffer -> 32 bit
          subi   1,RC         ; RPTB is RC+1 loops
          rptb   Unpack32     ;
          ldi    *AR0++,R0    ;
          and    0xFF,R0      ;
          ldi    *AR0++,R1    ;
          and    0xFF,R1      ;
          lsh    8 ,R1        ;
          or     R1,R0        ;
          ldi    *AR0++,R1    ;
          and    0xFF,R1      ;
          lsh    16,R1        ;
          or     R1,R0        ;
          ldi    *AR0++,R1    ;
          and    0xFF,R1      ;
          lsh    24,R1        ;
          or     R1,R0        ;
Unpack32  sti    R0,*AR1++    ;
          rets                ;
;------------------------------------------------------------------------
; Sends bytes or nibbles to the host.  The data being sent is unpacked
; from the AIC receive buffer.
;
;   DMA_srce = HPA
;   RecvLeng = R0   length (longs)     = 256
;   DMA_srce = R1   DMA read from      = 0x809800
;   DMA_dest = R2   DMA write to       = HPA
;   Func_dest= R3   unpack destination = Buf_Bgn (ADC data)
;   Play_Lock= R4   1 =wait for AIC play buf to complete before unpack
;------------------------------------------------------------------------
SendDMA   ldi    R4,R4        ; Wait for ADC buf to fill before transfer?
          bz     p2           ;
          ldi    @AICDONE,R4  ; Wait for AIC play buf to fill
          bz     $-1          ;
p2        ldi    0,R4         ; Check off as done
          sti    R4,@AICDONE  ;
          ;-------------------
          ldi    @DMA_xfr,R4  ; Wait for previous DMA to complete
          bnz    $-1          ;     (should be complete)
          ldi    0,R4         ; Zero the DMA control... no false starts
          sti    R4,@DMA_ctrl ;
          ;-------------------
          ldi    R3,AR0       ; Pack the output data array
          ldi    R1,AR1       ;
          ldi    R0,RC        ;
          subi   1,RC         ;
          ;-------------------
          ldi    @0x809FFF,R4 ; Determine current host port mode
          cmpi   -8,R4        ;
          beq    Pack8        ;
          ;-------------------
Pack4     rptb   Pack4end     ;
          ldi    *AR0++,R4    ;
          sti    R4,*+AR1(0)  ; Store LSB first
          lsh    -4,R4        ;
          sti    R4,*+AR1(1)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(2)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(3)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(4)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(5)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(6)  ;
          lsh    -4,R4        ;
          sti    R4,*+AR1(7)  ;
Pack4end  nop    *AR1++(8)    ;
          mpyi   8,R0         ; Transmit is 8 nibles/long in PP=NIBL mode
          b      PackDone     ;
          ;-------------------
Pack8     rptb   Pack8end     ;
          ldi    *AR0++,R4    ;
          sti    R4,*+AR1(0)  ; Store LSB first
          lsh    -8,R4        ;
          sti    R4,*+AR1(1)  ;
          lsh    -8,R4        ;
          sti    R4,*+AR1(2)  ;
          lsh    -8,R4        ;
          sti    R4,*+AR1(3)  ;
Pack8end  nop    *AR1++(4)    ;
          mpyi   4,R0         ; Transmit is 4 bytes/long in PP=BYTE mode
          ;-------------------
PackDone  ldi    0,R4
          sti    R4,@DMA_ctrl  
          sti    R0,@DMA_xfr  ; Set DMA counter
          sti    R1,@DMA_srce ;
          sti    R2,@DMA_dest ;
          ldi    0x453,R1     ;
          sti    R1,@DMA_ctrl ; Start the DMA
          rets                ;
;------------------------------------------------------------------------
; PackDMA packs ADC values into bytes/nibles according to the PP mode
;   Length (bytes)= R0
;   Read address  = R2 where to read byte values
;   Dest address  = R3 where to write 32 bit values
;------------------------------------------------------------------------

;-----------------------------------------------------------------------
; AIC_INIT initializes the AIC using values received from the host
;-----------------------------------------------------------------------
AIC_INIT  push   R0              ;
          LDI    0x10,IE         ; Enable XINT interrupt
          andn   0x34,IF         ;
          ;---------------------
AIC_reset ldi    0,R0            ;
          sti    R0,@S0_xdata    ;
          RPTS   0x020           ;
          LDI    2,IOF           ; XF0=0 resets AIC
          rpts   0x20            ;
          LDI    6,IOF           ; XF0=1 runs AIC
          sti    R0,@S0_xdata    ;
          ;----------------------
          ldi    3,R0            ; Pgm the AIC control register (C_REG)
          call   prog_AIC        ;
          ldi    0xfffc  ,R0     ; Pgm the AIC A/B divisers to be real slow
          call   prog_AIC        ;   This allows very small divisors to be
          ldi    0xfffc|2,R0     ;   loaded into the AIC
          call   prog_AIC        ;
          ldi    @B_REG,R0       ; Bump up Fs to the final rate
          call   prog_AIC        ; (smallest divisor should be last)
          ldi    @A_REG,R0       ;
          call   prog_AIC        ;
          ;----------------------
          pop    R0              ;
          rets                   ;
;--------------------------------
prog_AIC  push   R1              ; Programs the value of R0 into the AIC
          push   IE              ;
          ldi    0x10,IE         ;
          andn   0x30,IF         ;
          ldi    3,R1            ; Request 2 ndy XMIT
          sti    R1,@S0_xdata    ;
          idle                   ;
          sti    R0,@S0_xdata    ; Send R0 value
          idle                   ;
          pop    IE              ;
          pop    R1              ;
          rets                   ;
;---------------------------------------------------------------------
; Init_TIM0 initializes the Timer 0 which is used for the AIC MCLK
;---------------------------------------------------------------------
Init_TIM0 ldp    T0_ctrl         ; Use kernel data page and stack
          ldi    0,R0            ; Halt TIM0
          sti    R0,@T0_ctrl     ;
          sti    R0,@T0_count    ; Set count to 0
          ldi    @TIM0_w,R0      ; Set period to TIM0_w
          sti    R0,@T0_prd      ;
          ldi    0x2C1,R0        ; Restart timer
          sti    R0,@T0_ctrl     ;
          rets                   ;
;---------------------------------------------------------------------
; AIC receive and transmit interrupt routines
; NOTE: This ISR toggles between the upper and lower 16 bits of the
;       packed AIC buffer.
;---------------------------------------------------------------------
RINT      push   ST              ; Save what will be used
          push   R0              ;
          push   R1              ;
          push   AR0             ;
          push   IR0             ;
          ldi    @Buf_IOA,AR0    ; Get last used address
          ldi    @HILO,R1        ; determine shift amount -16, 0, -16
          xor    @M16,R1         ;
          sti    R1,@HILO        ; keep till next RINT/XINT
          ldi    R1,IR0          ; determine if HI/LO
          lsh    -4,IR0          ;
          and    1,IR0           ; Increment only if HI int is being accessed

          ldi    @SUBCMD,R0      ; If the sub-command is play
          bz     RECORD          ;

PLAY      ldi    *AR0,R0         ;
          lsh    R1,R0           ;
          andn   3,R0            ;
          sti    R0,@S0_xdata    ; Send value to DAC
          ldi    @S0_rdata,R0    ; read ADC to prevent underrun
          b      RINT2

RECORD    ldi    @S0_rdata,R0    ; read ADC
          sti    R0,@S0_xdata    ; Loop back value to DAC

          and    @MASK,R0        ; Using old sample...
          ldi    @S0_rdata,R0    ; The DRR shifts old samples to the top,
          sti    R0,*AR0         ; so there is no need to save and pack!

RINT2     nop    *AR0++(IR0)     ; Increment the AIC pointer
          cmpi   @Buf_End,AR0    ;
          blt    ADCOK           ;
          ldi    1,R0            ; Set a software flag to let the CPU know
          sti    R0,@AICDONE     ; that the buffer is empty and that the
          ldi    @Buf_Bgn,AR0    ; next DMA block can be unpacked
ADCOK     sti    AR0,@Buf_IOA    ;
          pop    IR0             ; Restore what was used
          pop    AR0             ;
          pop    R1              ;
          pop    R0              ;
          pop    ST              ;
XINT      reti                   ; XINT only needs a simple return
MASK      .word   0xFFFF
;=========================================================================
; The ST_STUB (start stub) code is used only once for initialization.
; The memory it uses can be safely reused by overwritting this section
; by assembling it into the stack or volatile data storage.
;=========================================================================
ADVNCD   .set   0                 ; For the advanced user, the stack can be
         .if    ADVNCD            ; placed here for RAM recovery.
stack    .word  stack             ; ST_STUB can also be placed in unitialized
         .start "ADVANCED",DMADATA; DMA or AIC buffers.  If placed in the
         .sect  "ADVANCED"        ; the AIC buffer, this code block will be
         .endif                   ; played until overwritten
;-------------------------------------------------------------------------
         .entry  ST_STUB          ; <<<< START HERE <<<<<
          ;----------------------
ST_STUB   ldp    @stack           ; Set up a runtime stack
          ldi    @stack,SP        ;
          call   Init_TIM0        ; Initialize the timer with default
          ldi    @S0_xctrlv,R0    ; Initialize the serial port
          sti    R0,@S0_xctrl     ; transmit control
          ldi    @S0_rctrlv,R0    ;
          sti    R0,@S0_rctrl     ; receive control
          ldi    0,R0             ;
          sti    R0,@S0_xdata     ; DXR data value
          ldi    @S0_gctrlv,R0    ; Setup serial port
          sti    R0,@S0_gctrl     ; global control
          call   AIC_INIT         ; Initialize the AIC
          ldi    0x30,IE          ; Service both RINT/XINT
          ldi    @S0_rdata,R0     ;
          b      main             ;
;--------------------------------------------------------------------------
         .if    ADVNCD=0          ; Another favorite place to put the stack
stack    .word  stack             ; is immediately after the program section
         .endif                   ;
;====================================================================
; Install the XINT/RINT ISR handler directly into
; the vector RAM location it will be used in
;====================================================================
         .start "SP0VECTS",0x809FC5
         .sect  "SP0VECTS"
          B     XINT              ; XINT0
          B     RINT              ; RINT0
