;---------------------------------------------------------------
; DSKPWM.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; DSKPWM.ASM is used with the host application DSK_PWM.EXE to
; modify the two timer values in a precise and controlled manner.
; For setting triangle wave PWM outputs the host can set the
; values using putmem() functions.  However when precisely controlled
; DC PWM outputs are desired both timers must be started with very
; little time difference.  This file provides that function.
;---------------------------------------------------------------
         .include "C3XMMRS.ASM"
;==================================================
          .start  "CODE",0x809C00  ; Start of RAM1
          .sect   "CODE"           ;
;==================================================
LOAD      .word  1                 ; 0x809C00 set to 1 to reload AIC
T0_PRDV   .word  0x2000            ; 0x809C01
T0_CNTV   .word  0x1000            ; 0x809C02
T1_PRDV   .word  0x2000            ; 0x809C03
T1_CNTV   .word  0x0000            ; 0x809C04
;-------------------------------
          .entry   Start
Start     ldp   T0_ctrl         ; Use kernel data page and stack
          ldi   @stack,SP
          call  TIM_INIT
main      ldi   0x4,IE          ;
        ; idle                  ; Wait for next ADC sample
          ;- - - - - - - - - - -
          ldi   @LOAD,R2        ; If signalled by host, reinitialize AIC
          bz    main            ;
          call  TIM_INIT        ; setup timers
          call  TIM_INIT        ;
          ldi   0,R2            ; reset the LOAD flag
          sti   R2,@LOAD        ;
          b     main            ; close loop
;==================================================================
TIM_INIT  ldi   0,R0            ; Halt TIM0 & TIM1
          sti   R0,@T0_ctrl     ;
          sti   R0,@T1_ctrl     ;

          ldi   @T0_PRDV,R0     ; Set period
          sti   R0,@T0_prd      ;
          ldi   @T1_PRDV,R0     ;
          sti   R0,@T1_prd      ;

          ldi   0x3C3,R0        ; Restart both timers THIS ZEROS THE PRDS
          sti   R0,@T0_ctrl     ;
          sti   R0,@T1_ctrl     ;

          ldi   @T0_CNTV,R0     ; Set counts (if not, offset will occur!)
          sti   R0,@T0_count    ;
          ldi   @T1_CNTV,R0     ;
          sti   R0,@T1_count    ;

          rets                  ;
;-------------------------------
         nop
         nop
stack    .word  $+1
