//------------------------------------------------------------
// DSK3LOAD.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  DSK3LOAD.CPP is a DOS text window based program which can be used to
//  either load or bootload a file into the DSK.  If a file is to be loaded
//  it is assumed that if a valid kernel is not already loaded, the DSK
//  will be reset, bootloaded with the C3X.DSK kernel and then loaded.
//
//  If a bootload is desired the DSK is reset followed by a direct bootload
//  of the application into DSK memory.
//
//  NOTE: The internal DSK bootloader program (ROM space of TMS320C31)
//        uses the first two locations of internal RAM for a small
//        stack.  Your application cannot load code into these locations
//        until after the bootloader is complete.
//
//  The project file should include the following
//
//    DSK3LOAD.CPP   This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window drivers
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS text window executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.
//
//------------------------------------------------------------
#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "dsk.h"
#include "errormsg.h"
#include "dsk_coff.h"
#include "keydef.h"

ulong address;
//
// DSK3LOAD is a utility for loading programs into the C3x DSK
//   Useage is as follows
//
//   DSK3LOAD filename [BOOT]
//                      |
//                      +--- Bootload directly into memory
//                           If not specified the kernel is used
//                           to load the file.
//
void main()
{
  int i;
  char *p;
  char FileName[120];
  TASK task=LOAD;// An enumerated int that will define the LOAD/BOOT task
  char *msg;     // A pointer to any error message if it should occur
  MSGS err;      // An enumerated message for looking up messages
  clrscr();
  /*-------------------------------------------------------------*/
  /* The following line is used to insert DSK3D specific command */
  /* line options into the help string before being printed. The */
  /* help string itself has enough WS chars to allow this.       */
  /*-------------------------------------------------------------*/
  Edit_Help_Msg("DSK3LOAD","file [boot][FILE2HEX][NOLOAD]",
//"  Use to Load or Bootload DSK or *.OUT files\r\n"
  "  boot              Bootload 'file'\r\n"
  "  FILE2HEX          Convert file.* to file.HEX\r\n"
  "  NOLOAD            Only do conversion\r\n");
  //
  // Check the command line for standard options, LPT1, LPT2 etc...
  //
  Scan_Command_line("DSK3LOAD");
  if(_argc<=1)
  {
    printf("You must specify a file to load\n");
    exit(0);
  }
  //
  // You can use multiple DSK applications within Windows 3.1 and 95
  // by using the Windows timeslice managment interrupts.  This essentialy
  // protects the DSK's communications link by preventing a multitask swap.
  // To enable this the presence of Windows needs to be detected.
  //
  //   If Windows is not detected or forced to a 'Not Detected' state
  // from the command line argument WIN=0, the DSK's communications
  // link will be unprotected.
  //
  Detect_Windows();
  //------------------------------------------------------
  // Check command line for BOOTLOAD and FILE2HEX convert
  //------------------------------------------------------
  //   Added alias commands: 'DSK2COFF' and 'DSK2HEX'
  strcpy(FileName,_argv[1]);
  for(i=2; i<_argc;i++)
  {
    strupr(_argv[i]);
    if(  strstr(_argv[i],"FILE2HEX")
       ||strstr(_argv[i],"DSK2HEX" )
       ||strstr(_argv[i],"2HEX"    )
       ||strstr(_argv[i],"COFF2HEX"))
    {
      err = Load_File(FileName,FILE2HEX);
      if(err!=NO_ERR)
      {
        printf("\n>>>> FILE2HEX conversion error for %s",FileName);
        exit(0);
      }
      if((p=strstr(FileName,"."))!=NULL) strcpy(       p,".HEX");
      else                               strcat(FileName,".HEX");
      break;
    }
    if(  strstr(_argv[i],"DSK2COFF" )
       ||strstr(_argv[i],"2COFF"    )
       ||strstr(_argv[i],"FILE2COFF"))
    {                                  // File does not exist yet?
      err = Load_File(FileName,SLOAD); // GPF fault in WIN95
      if(err!=NO_ERR) printf("%s:%s\n",Error_Strg(err),FileName);
      err = Load_File(FileName,DSK2COFF);
      if(err!=NO_ERR)
      {
        printf("\n>>>> DSK2COFF conversion error for %s",FileName);
        exit(0);
      }
      if((p=strstr(FileName,"."))!=NULL) strcpy(       p,".OUT");
      else                               strcat(FileName,".OUT");
      break;
    }

  }
  for(i=2; i<_argc;i++)
  {
    strupr(_argv[i]);
    if(strstr(_argv[i],"NOLOAD"))
    {
      printf("\n>>>> NOLOAD %s",FileName);
      exit(0);
    }
  }
  for(i=2; i<_argc;i++)
  {
    strupr(_argv[i]);
    if(strstr(_argv[i],"BOOT")) {task = BOOT; break;}
    else                         task = LOAD;
  }
  //--------------------------------------------------------
  // This outer loop runs forever until the task is complete
  // or the user has hit a key to terminate the loader
  //
  for(;;)
  {
    clrscr();
    //
    // If the task is to LOAD be sure that the communications
    // channel has beeb initialized BEFORE loading the file.
    // A maximum of 10000 tries is assumed to be enough before
    // falling out of the Init_Communication sub loop.
    //
    if(task == LOAD)
      Init_Communication(10000);
    if(kbhit())
    {
      printf("User exit of DSK3LOAD before task complete");
      exit(0);
    }
    clrscr();
    if(task==BOOT) printf("BOOTLOADING '%s'\n",FileName);
    else           printf("LOADING '%s'\n",FileName);
    //
    // Perform the LOAD or BOOTLOAD task, then print a message if succesful
    //

    if(task==LOAD) HALT_CPU(); // Put C31 into spin0 mode

    if((err=Load_File(FileName,task))==NO_ERR)
    {
      clrscr();
      if(task==BOOT) printf("FILE '%s' BOOTLOADED WITH NO ERROR",FileName);
      else           printf("FILE '%s' LOADED WITH NO ERROR",FileName);
      if(task==LOAD) RUN_CPU();
      exit(0);                   // Task complete so exit...
    }
    else
    {
      //
      // Print the appropriate error message if an error occurs
      //
      msg = Error_Strg(err);
      printf("\r\n%s",msg);
      exit(0);
    }
  }
}

