//------------------------------------------------------------
// DSK3A.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  DSK3A.CPP is a DOS text window based program which will
//  assemble DSK formatted source files into DSK files
//
//  The project file should include the following files in a directory
//  tree similar to the one shown below.
//
//                  (root)
//
//  C:\---\DSK3SRC--+--\DSK3--+-- \DSK3A  (not used for DSK3D)
//                  |         +-- \DSK3D
//                  |         +-- \COMMON
//                  |         +-- \COMMON2
//                  |         +-- \DSK3APPS
//                  |
//                  +-- Verxxx
//                  +-- Veryyy
//                      etc...
//
//  Files in root directory
//  -----------------------
//    DSK3A.PRJ     Borland project file
//    DSK3A.DSK     Borland desktop file
//    *.obj         Compiler object output
//
//  Files in DSK3A directory
//  ------------------------
//    DSK3A.CPP     3X DSK Assembler main routine
//
//  Files in COMMON2 directory
//  --------------------------
//    ARGSPLIT.CPP  Functions to split arguments up for analysis
//    ASCIINUM.CPP  Universal number type recognizer
//    ASMC40.CPP    Assembler routines
//    ASSM_FUN.CPP  Functions for recognizing assembly constructs
//    DASMC40.CPP   Disassembler routines
//    EXP_ANAL.CPP  Expression analyzer and function recognizer
//    FAKETARG.CPP  Contains a few 'fake' target functions to satisfy link
//    MATHERR.CPP   Math error trap routines
//    OPCODES1.CPP  Text strings and structures used for assy/dasm
//    OPCODES2.CPP  Main array of assembler menmonics and codes
//    SIM3XNUL.CPP  Null functions for SIM3X.CPP
//
//  Files in COMMON directory
//  -------------------------
//    ERRORMSG.CPP  Messages used for most function returns
//    RAND386.CPP   Fast 32 bit random number generator
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TMSFLOAT.CPP  TMSFLOAT - IEEE floating point conversion functions
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - MEDIUM       (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        DSK3A is a self contained DOS text application
//
//  DSK3A Assembler core revision history
//  -------------------------------------
//  1.00  02/01/96  Keith Larson - Release version
//  1.01  05/15/96  Keith Larson
//  1.02  06/15/96  Keith Larson
//  1.03  07/10/96  Keith Larson
//  1.04  07/20/96  Keith Larson
//  1.10  08/05/96  Keith Larson
//  1.11  08/05/96  Keith Larson - Increase stack space
//--------------------------------------------------------------------
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "assm_fun.h"
#include "symbols.h"
#include "errormsg.h"
#include "argsplit.h"
#include "opcodes.h"
#include "dsk.h"
#include "TMSFLOAT.H"

#include "DISCLAIM.H" // You must remove the comment in DISCLAIM.H to compile
#ifndef __DISCLAIM
========================================================================
 NOTE: By removing this statement or the comment inside DISCLAIM.H which
 blocks the definition of __DISCLAIM you are hereby recognizing that you
 have read and will abide by the disclaimer statement and guidelines of
 useage which are outlined in the file DISCLAIM.H

 Please note that the contents of DISCLAIM.H include statements specific
 to the DSK assembler and debugger that are not covered in the standard
 disclaimer.
========================================================================
#endif
void exit_DSK3A(int);
unsigned long rand386(unsigned long A);
void  help_menu(void);
void  dasm_assm(void);
int   DSK3D = 0;          // Enables register recognition for debugger
int   warn_limit = 4;
int   err_limit  = 4;
char  uquiet=1;
char  quiet=1;
ulong ENTRY=0x0L;
char  *ASMEXT=".asm";
char  PAUSE_AT_END=0;
#define lname 80          // max length for filename
//---------------------------------------------------------------
// lprintf() writes string outputs to both the DSK output file
// and conditionaly the console if the global 'quiet' veriable
// is not turned on
//---------------------------------------------------------------
void lprintf(char *strg1)
{
  //fprintf(dsk_file,"%s",strg1);
  fprintf(dsk_file,strg1);     // Faster... no %s formatting needed!
  if(quiet == 0)
     printf(strg1); // printf("%s",strg1);.. again faster...
}
//---------------------------------------------------------------
// init_segments() initializes the structure defining segment
// allocation to a default state before assembling a file
//---------------------------------------------------------------
void init_segments(void)
{ int seg;
  OBJ obj;
  for(seg=0;seg<MAX_SEGMENTS;seg++)
  { strncpy(SEG[seg].name,"",16);
    SEG[seg].name[15] = 0;
    SEG[seg].offs=0;
  }
  seg = 0;
  last_segment = 0;
  strcpy(g_file,"setup");
  g_line = 0;
  g_pass = 1;
  assm(" .start  \"Default_sect\",0x809802","",obj);
  assm(" .sect   \"Default_sect\"","",obj);
  if_level = 0;
  if_on = 1;
  err_cnt = 0;
  warn_cnt = 0;
}
//---------------------------------------------------------------------
// if a symbol is neither a label, fixed or float (0,1,2) it is a
// temporary variable which needs to be destroyed between pass 1 & 2
//---------------------------------------------------------------------
void anihilate_xset(void)
{ for(int x=0;x<last_ref;x++)
    if(SYM[x].symt == SYM_DEF)    // was addressable=2 // delate 2nd pass
      SYM[x].sptr = nullstring;
}                 // was 2
//---------------------------------------------------------------------
// seg_overlap() detects segment overlap conditions and is called at
// the end of assembly for reporting segment information.
//---------------------------------------------------------------------
int seg_overlap(int x, int z)
{
  if(x==z) return 0;                             // cannot overlay self
  if(SEG[x].offs - SEG[x].start == 0) return 0;  // Zero length sections
  if(SEG[z].offs - SEG[z].start == 0) return 0;  // cannot overlap
  if(   (SEG[x].start < SEG[z].offs )
     && (SEG[x].offs  > SEG[z].start) ) return 1;

  return 0;
}
//---------------------------------------------------------------------
// VERBOSE() and UQUIET() are used to switch on and off 'quiet' where
// quiet is always set back to the default command line state
//---------------------------------------------------------------------
void VERBOSE(void)
{ uquiet = quiet;
  quiet = 0;
}
void UQUIET(void)
{ quiet = uquiet;
}
//-------------------------------------------------------------------
// main() sets up the global variables which are set by the command
// line arguments and then controls the pass1 pass2 assembly.  Depending
// on the return error levels various actions can be taken.  When
// assembly is complete the symbol table and section information is
// output to the DSK file.
//-------------------------------------------------------------------
void main(void)
{
  time_t dtime;
  char c1,c2;
  int err;
  unsigned int i;
  char *ptr,*eptr;
  char strg[bufsize];
  char xsrce_file[lname];
  char xlist_file[lname];
  OBJ obj;
  C3Xmode = 1; // Turn off C40 assembly
  g_pass = 0;
  if_on = 1;
  current_seg = 0;
  clrscr();
  BuildFastLook();  // 12/10/96
  if(Create_SYM()!=NO_ERR)
  {
    printf("System cannot allocate memory for symbols");
    exit(0);
  }


  #if 0
  /* This is asimple disassembler example         */
  /* Dont forget BuildFastLook() and Create_Sym() */
  /* These tables are needed!                     */
  ENTRY = 0x13FB1234L;
  clrscr();
  Disasm(0x809800L ,ENTRY, strg);
  printf("DASM(%08lx)=> %s\n", ENTRY, strg);
  exit(0);
  #endif


  if(_argc <= 1) help_menu();
  for(i=2;i<_argc;i++)
  {
    strupr(_argv[i]);
    if(     strstr(_argv[i],"?")) {help_menu(); exit(0);}
    if(     strstr(_argv[i],"H")) {help_menu(); exit(0);}
    if((ptr=strstr(_argv[i],"D"))!=NULL) dasm_assm_on  = 1;
    if((ptr=strstr(_argv[i],"Q"))!=NULL) quiet = 1;
    if((ptr=strstr(_argv[i],"X"))!=NULL) Enhanced_Enable = 1;
    if((ptr=strstr(_argv[i],"V"))!=NULL) quiet = 0;
    if((ptr=strstr(_argv[i],"P"))!=NULL) PAUSE_AT_END = 1;
    if((ptr=strstr(_argv[i],"E"))!=NULL)
    {
      // Find first numeric character
      while(*ptr && (isdigit(*ptr)==0)) ptr++;
      err_limit = (int)strtol(ptr,&eptr,0);
//    err_limit = (int)atol(ptr);
    }
    if((ptr=strstr(_argv[i],"W"))!=NULL)
    { while(*ptr && (isdigit(*ptr)==0)) ptr++;
      warn_limit = (int)strtol(ptr,&eptr,0);
    //warn_limit=(int)atol(ptr);
    }
  }
  if( err_limit<  1)  err_limit=  1; // Establish some practical limits...
  if(warn_limit<  1) warn_limit=  1;
  if( err_limit> 32)  err_limit= 32;
  if(warn_limit>128) warn_limit=128;

  uquiet=quiet;
  if(dasm_assm_on)
  { dasm_assm(); // Self diagnostic loop.  Random numbers input to DASM
    exit(0);     // are re-assembled and then compared for differences
  }
  // Create the filenames used by the assembler
  //
  strncpy(xsrce_file,_argv[1],lname);
  if((ptr= strstr(xsrce_file,".")) == NULL) strcat(xsrce_file,ASMEXT);
  strupr(xsrce_file);
  VERBOSE();     // Macro to turn on verbose message
  //
  // Open list file
  strcpy(xlist_file,xsrce_file);
  ptr = strstr(xlist_file,".");
  strcpy(ptr+1,"dsk");
  unlink(xlist_file);
  if((dsk_file = fopen(xlist_file,"wt"))==NULL)
  {
    //
    // There is no file to open
    //
    printf(">>>> FATAL ERROR: >> CAN NOT OPEN %s\r\n",xlist_file);
    exit_DSK3A(1);
//  fcloseall();
//  exit(1);
  }
  //
  // Print banner
  //
  sprintf(strg,
    ">>>> DSK3A C3x DSP Starter Kit Assembler Rev %2.2f\n",DSK3_rev);
  lprintf(strg);
  lprintf(">>>> (c) Copyright 1994-1995 Texas Instruments Incorporated\n");
  time(&dtime);
  sprintf(strg,">>>> %s",ctime(&dtime));
  lprintf(strg);
  sprintf(strg,">>>> File %s\n>>>>\n",xsrce_file);
  lprintf(strg);
  UQUIET();       // go back to user quiet level
  //
  //  Assemble source file, creating object and temporary file
  SYM[0].numt  = NT_NOREF;
  for(int pass=1;pass<3;pass++)
  {
    init_segments();
    if(pass==1)
    {
      assm("pass1 .sdef 1","",obj);
      assm("pass2 .sdef 0","",obj);
    }
    if(pass==2)
    {
      remove_defines();
      assm("pass1 .sdef 0","",obj);
      assm("pass2 .sdef 1","",obj);
    }
    inc_lvl=0;
    err = passx(xsrce_file,pass);
    VERBOSE();     // Macro to turn on verbose message
    sprintf(strg,">>>>\n>>>> PASS %d Complete\n",pass);  lprintf(strg);
    sprintf(strg,">>>> Errors: %d  Warnings: %d\n>>>>\n",err_cnt,warn_cnt);
    lprintf(strg);
    UQUIET();       // go back to user quiet level
    if(err_cnt && (pass==1))
    {
      exit_DSK3A(0);
    //fcloseall();
    //exit(0);
    }
    // anihilate directive control variables created by .xset
    anihilate_xset();
    switch(err)
    {
      case d_end  : break;
      case NO_LINE: break;
      case NO_ERR : break;
      case OPEN_ERR:
      case FATAL:
      default:
      {
        exit_DSK3A(0);
      //fcloseall();
      //exit(0);
      }
    }
  }
  VERBOSE();
  sprintf(strg,">>>> ENTRY 0x%08lx\n",ENTRY); lprintf(strg);
  UQUIET();
  // Generate symbol cross reference table
  lprintf(">>>>\n>>>> Symbol reference table           Type  Addressable\n");
  for(int x=0;x<last_ref;x++)
  {
//  if((*SYM[x].sptr!=0) && (SYM[x].type!=SYM_ANNUL))
    if((*SYM[x].sptr!=0) && (SYM[x].symt!=SYM_FOO))
    {
      switch(SYM[x].numt)
      {
        default        :
        case NT_NOREF  : c1 = '0'; break;
        case NT_INTEGER: c1 = '1'; break;
        case NT_FLOAT  : c1 = '2'; break;
        case NT_SLONG  : c1 = '3'; break;
        case NT_ULONG  : c1 = '4'; break;
        case NT_QFORM  : c1 = '5'; break;
        case  NT_AUTO  : c1 = '6'; break;
      }
      switch(SYM[x].symt)
      {
        case SYM_VAR   : c2= '0'; break;
        case SYM_GLBL  : c2= '1'; break;
        case SYM_DEF   : c2= '2'; break;
        case SYM_LLBL  : c2= '3'; break;
        case SYM_FOO   : c2= '4'; break;
        default        : c2= '?'; break;
      }
      sprintf(strg,">>>> ref %16s 0x%08lx  %c     %c\n",
      SYM[x].sptr,SYM[x].value,c1,c2);
      lprintf(strg);            // Prints 0,1,2,3...
    }
  }
  // Generate SEGment list table
  lprintf
  (">>>>\n>>>>        Output section start       end         length\n");
  for(x=0;x<last_segment;x++)
  {
//#define length SEG[x].offs - SEG[x].start
    SEG[x].length = SEG[x].offs - SEG[x].start;
    sprintf(strg,">>>> sect %16s 0x%08lx  0x%08lx  0x%08lx\n",
                     SEG[x].name,SEG[x].start, SEG[x].offs,SEG[x].length);
    lprintf(strg);
  }
  // Detect and print overlayed segments
  lprintf(">>>>\n");
  quiet = 0;
  for(x=0;x<last_segment;x++)
  { for(int z=x+1;z<last_segment;z++)
    { if(seg_overlap(x,z))
      { sprintf(strg,">>>> over %16s <=overlays=> %s\n",
                          SEG[z].name,SEG[x].name);
        lprintf(strg);
      }
    }
  }
  lprintf(">>>>\n>>>> END DSK\n");
  strcpy(g_strg1,nullstring);
  strcpy(g_strg2,nullstring);
  g_line = 1;
//  if(NON_COFF_MATH_F) {err_cnt--; assm_error_msg(non_coff_math);}
  if(W_GLBL_FLAG)     {err_cnt--; assm_error_msg(W_GLBL,"");}
//
//  The following section is being used to test how to pipe errors and
//  warnings to the Borland C++ IDE
//
//  printf("Borland C++ 4.51 Copyright (c) 1987, 1994 Borland International\n");
//  printf("rand.asm:\n");
//  printf("Warning rand.asm 1: This is a test message\n");
  exit_DSK3A(0);
}
void exit_DSK3A(int i)
{
  fcloseall();
  //
  // Wait for keystroke before exit
  //
  if(PAUSE_AT_END)
  {
    printf("PAUSED: Hit key to exit");
    getch();
  }
  exit(i);
}
//-------------------------------------------------------------------
// passx() sets up and controls the assembly process for the 1st and
// 2nd pass.  This is where each line is read from the input file and
// passed to the assm() function.  Enumerated returns from assm()
// identify things like no_code, directives, code, looping etc...
//-------------------------------------------------------------------
MSGS passx(char *name, char pass)
{
  MSGS err;
  fpos_t loopfilepos,filepos;
  OBJ obj;              // object structure filled in by assembler
  int loop_line,line = 1;         // local file line count
  FILE *stream;         // local file name
  char mstrg[bufsize]; // Message string
  char strg1[bufsize]; // 1st line
  char strg2[bufsize]; // 2nd line
  char dstrg1[bufsize]; // 1st line - packed
  char dstrg2[bufsize]; // 2nd line - packed
  char *buf;            // GP pointer
  char *p;
  char assmlines;
  long opcode; //,old_addr;
  char temp_g_strg1[bufsize];
  char temp_g_strg2[bufsize];
  char temp_g_file [lname];
  char incname[lname];
  int temp_g_line;
  //
  // Open source file
//strncpy(g_file,  name, bufsize);
  if((stream = fopen(name,"rt"))==NULL)
  {
    //
    // If a file cannot be opened at this level, it is at least
    // one level nested.
    //
    VERBOSE();
//  sprintf(strg1,">>>> FATAL ERROR: >> CAN NOT OPEN %s\r\n",name);
    sprintf(EXTMSG,"  Can not open %s >> ",name);
    assm_error_msg(FATAL,EXTMSG);
//  application should exit within assm_error_msg();
    fcloseall();
    exit(0);
/*  err_cnt++;
    lprintf(strg1);
    fcloseall();
    UQUIET();
    return FATAL; */
  }
  strncpy(g_file,  name, bufsize);
  fseek(stream, 0, SEEK_SET);                  // seek to start of file
  // Since parallel opcodes span two lines, the loop is unrolled
  // such that the line being assembled is the previous line
  if((buf=fgets(strg1,bufsize-1, stream)) == NULL)
  {
    fclose(stream);
    return NO_LINE;
  }
  fgetpos(stream,&filepos);
  loop_line = line;
  buf=fgets(strg2,bufsize-1, stream);
  for(line=1;;line++)
  {
    //-----------------------------------------------------------
    // Split up arguments and repack
    //-----------------------------------------------------------
    if((p=strstr(strg1,"\n"))!=NULL) *p=0;  // strip newline character
    if((p=strstr(strg1,"\r"))!=NULL) *p=0;  // strip line return character
    if((p=strstr(strg2,"\n"))!=NULL) *p=0;// strip \n character
    if((p=strstr(strg2,"\r"))!=NULL) *p=0;// strip \r character

    #define TAB_SIZE 8
    tabstrip(strg1,TAB_SIZE);
    tabstrip(strg2,TAB_SIZE);

    strcpy( dstrg1,strg1); strcpy( dstrg2,strg2);
    strcpy(g_strg1,strg1); strcpy(g_strg2,strg2);
//  strcpy(g_file ,  name);
    g_line  = line;
    g_pass  = pass;
    //------------------------------------------------------------
    assmlines = 1;
    err=assm(dstrg1,dstrg2, obj);
    switch(err)
    {
      case d_inc: //err = passx(arg[2].s,g_pass); break;
                  inc_lvl++;
                  if(inc_lvl > 8)
                  {
                    fclose(stream);
                    err_cnt++;
                    assm_error_msg(d_inc2,"");
                    return d_inc2;
                  }
                  while((p=strstr(arg[2].s,"\""))!=NULL) *p = ' ';
                  //
                  // Remove leading/trailing WS during copy...
                  //
                  p = arg[2].s;
                  if(*p==' ') p++;
                  if(p==0) return d_inc;   // No file string == error
                  strncpy(incname,p,lname);
                  while((p=strstr(incname," "))!=NULL) *p = 0;
                  p=incname;
                  //
                  //
                  // Back up global names and strings
                  //
                  strcpy(temp_g_file,g_file);
                  strcpy(temp_g_strg1,g_strg1);
                  strcpy(temp_g_strg2,g_strg2);
                  temp_g_line = g_line;
                  //
                  //
                  if(g_pass == 1)
                  {
                    sprintf(mstrg,">>>> Include Open : %s\n",p);
                    lprintf(mstrg);
                  }
                  //
                  if((err=passx(p,g_pass)) != NO_ERR)
                  {
                    fclose(stream);
                    return err;
                  }
                  if(g_pass == 1)
                  {
                    sprintf(mstrg,">>>> Include Close: %s\n",p);
                    lprintf(mstrg);
                  }
                  //
                  // Restore global names and strings
                  //
                  g_line = temp_g_line;
                  strcpy(g_file,temp_g_file);
                  strcpy(g_strg1,temp_g_strg1);
                  strcpy(g_strg2,temp_g_strg2);
                  inc_lvl--;
                  break;
      case d_loop_start: loopfilepos=filepos;
                         loop_line = line;
                         assmlines = 1;
                         break;
      case d_loop_end  : loop_count--;
                         assmlines = 1;
                         if(loop_count <= 0) break;
                         line = loop_line;
                         fsetpos(stream,&loopfilepos);
                         fgets(strg2,bufsize-1, stream);
                         //
                         // If file ends with .endloop buf will be NULL
                         // To keep program from inadvertantly exiting
                         // buf is set to point to something that should
                         // exist if everything is working properly
                         //
                         buf = strg2;  // 6/1/96
                         //
                         break;

      case NO_CODE:if(pass==1) break;
               if(if_on==0)
                 fprintf(dsk_file,"0x%08lx if_off     %s\n",
                                SEG[current_seg].offs,strg1);
               else
                 fprintf(dsk_file,"0x%08lx nocode     %s\n",
                                SEG[current_seg].offs,strg1);
               break;
      case PAR_NO_ERR: assmlines += 1; line++;
      case NO_ERR:
             if(pass==2)
             {
               opcode = obj_pack(obj);
               fprintf(dsk_file,"0x%08lx 0x%08lx %s\n",
                       SEG[current_seg].offs,opcode,strg1);
               if(assmlines==2)
               {
                 fprintf(dsk_file,"0x%08lx parcode    %s\n",
                                SEG[current_seg].offs,strg2);
               }
             }
             SEG[current_seg].offs+=1;
             break;
      case DIR_NO_ERR: break;  // Listing output and objects are written
                               // by the directive processor in assm()
      case d_end: //  buf = strg2;
                  break;
      default   : // print out specific error message
                  if(strstr(g_strg2,"||")) assmlines = 2;
                  if(assmlines==1)  strcpy(g_strg2,nullstring);
                  err = assm_error_msg(err,"");
                  if(err_cnt   > err_limit) {err=d_end; break;};
                  if(warn_cnt > warn_limit)
                  { err_cnt++;
                    err = d_end;
                  }
                  break;
    }

    if(err==d_end) break;
    if(err_cnt > err_limit) break;
    if(warn_cnt > warn_limit) break;
    fgetpos(stream,&filepos);
    if(assmlines == 1)
    { if(buf==NULL) break;
      strcpy(strg1,strg2);
    }
    else
    {
      if((buf=fgets(strg1,bufsize-1, stream)) == NULL) break;
    }
    buf=fgets(strg2,bufsize-1, stream);
  }
  if(ENTRY==0)  // If zero, .entry was most likely not in the source
  {             // Furthermore, you cannot execute the reset vector!
    assm(" .entry 0x809802 ;Add Default entry ","",obj);
  }

  fclose(stream);
  if((inc_lvl==0) && err_cnt)
    return TOO_MANY_ERR;  // failed nested include return value
  if(err==d_end) return d_end;
  return NO_ERR;
}
//--------------------------------------------------------
// help_menu() displays the DOS command line help string
// if an error or ? occurs on startup
//--------------------------------------------------------
void help_menu(void)
{
  clrscr();
  printf(
  "DSK3A version %2.2f\n"
  "------------------\n"
  "DSK3A FILE[.ASM] [OPTIONS]\n"
  "      ? or /H  Display this help menu\n"
  "      Q        Quiet console update\n"
  "      V        Verbose console update\n"
  "      Wxxx     Warning limit xxx (def=5)\n"
  "      Exxx     Error limit xxx (def=5)\n"
  "      D        DASM(rand)->ASSM(string) selftest loop\n"
  "      X        Enable enhanced indirect opcodes for PG-6 support\n"
  "      P        Pause at end of assembly (hit key to continue)\n"
  "\n"
  "Files created\n"
  "  FILE.DSK      Assembler output - a loadable list file\n",DSK3_rev
  );
exit(0);
}
//---------------------  SELF TEST CODE  ------------------------//
// This function creates random bit patterns which are then      //
// disassembled into a string.  The resulting string is then     //
// assembled into a bit pattern.  If the two dont match, an      //
// error message is generated and the inner loop exits.  To      //
// debug the error, set a breakpoint within the error detection  //
// code, just before the code is retested.                       //
//---------------------------------------------------------------//
extern long Hash_hit;
extern long Hash_miss;
void dasm_assm(void)
{ OBJ obj;
  MSGS err;
  char *ptr;
  char buf1[bufsize], buf2[bufsize], buf3[bufsize];
  long o, words=0, values=0;
  ulong rnd=0;
  long z=0;
  long loops= 256;
  ulong Hexv;
  int line = 0;
  int code;
  rnd=4;
  strcpy(g_file,"No_file");
  g_pass = 2;
  TMS_TEST = 1; // Set to 1 to disable short float zero decode
                // IE.  0x8012 in short float is zero to the CPU
                // but will cause dasm_assm() to fail loopback
  for(code=__ABSF/*__IACK*/;Instr[code].en!=__word;code++)  // Loop through all codes
  {
    // Set the number of loops for the particular opcode
    // as a function of the number of unused bits
    loops = Instr[code].mask ^ 0xFFFFFFFFL;
    if(loops <= 0) loops = 1;
    loops = 20 * log(loops) + 4;  // log base e=2.71828

//  if(Instr[code].en == __TRAP4x) loops = 0;  // Bypass test for TRAP4x

    for(z=0;z<loops;z++)          // 100 was 20
    {
      *buf2=0;
      *buf1 = ' ';
      // DASM a value which has been created from the raw code logicaly
      // OR'ed with a random number in the unused bits
      rnd = rand386(rnd);
      Hexv  = rnd; // | 0xE0; // Forces lots of PG6 enhanced indirect codes

      /* Adding the next three lines causes the search to be narrowed */
      /* down to use only valid upper bits defining valid codes       */
      /* IE this causes the .word hit rate to go down considerably    */
      /*     This does skew valid code density statistics             */
//    Hexv  = Instr[code].mask | Hexv;
//    Hexv ^= Instr[code].mask;
//    Hexv |= Instr[code].pattern;
      //
      // Disassemble the hex value into a string
      //
      values++;
      //
      // If the returned string is not an opcode count it as
      // a word and go on.  Otherwise assemble the string and
      // compare it with the original.  Flag any differences
      //
      Disasm(SEG[current_seg].offs,Hexv, buf1+1);
      if((ptr=strstr(buf1,".word"))==NULL)
      {
        if(quiet==0) cprintf("%s\r\n",buf1);
        if((ptr=strstr(buf1,"||"))!=NULL)
        { *buf2 = ' ';
          strcpy(buf2+1,ptr);
          *ptr++ = 0;
        }
        else strcpy(buf2," ");
        g_line = line++;
        strcpy(g_strg1, buf1);
        err = assm(buf1,buf2,obj);
        o = obj_pack(obj);
//      o|=1;  // Forces an error
        //------------------------------------------------------------
        // If the resulting opcodes do not match, or if the assembler
        // reported an error, use the following section to set a trap
        // and then step into either the DASM or ASSM routines.
        //------------------------------------------------------------
        if((o != Hexv) || ((err!=NO_ERR)&&(err!=PAR_NO_ERR)))
        {
          *buf1 = ' ';
          printf(">>> DASM->ASSM Error Detected\n");
          //
          //
          Disasm(SEG[current_seg].offs,Hexv, buf1+1);
          strcpy(buf3,buf1);
          printf("%08lx DASM(%08lx)=> %s\n", SEG[current_seg].offs,Hexv,buf1);
          if((ptr=strstr(buf1,"||"))!=NULL)
          { *buf2 = ' ';
            strcpy(buf2+1,ptr);
            *ptr++ = 0;
          }
          else strcpy(buf2," ");
          err = assm(buf1,buf2,obj);
          o = obj_pack(obj);

          printf(" --->    ASSM:%s  -> %08lx\n", buf3, o);
          *buf1 = ' ';
          Disasm(SEG[current_seg].offs,o, buf1+1);
          printf(" --->    DASM(%08lx)=> %s\n", o, buf1);
          if(strexact(buf1,buf3))
            printf("DASM before/after match exactly\n");
          printf("%s\n[Q]uit",Error_Strg(err));
          if(toupper(getch())=='Q') exit(0);
        }
      }
      else // count .word values encountered
      {
//      printf("%08lx DASM(%08lx)=> %s\n",
//              SEG[current_seg].offs,Hexv,buf1);
        words++;
        if((words & 0x3ff)==0)
          cprintf("%ld   Set Verbose mode on command line\r\n",words);
      }
      if(kbhit())  break; //if(toupper(getch())=='Q') break;
      SEG[current_seg].offs++;
    }
    if(kbhit()) if(toupper(getch())=='Q') break;
  }
  cprintf("Finished!\r\n");
  cprintf("%ld codes     %ld words    %ld total\r\n",
           values-words, words, values);
  cprintf("Hash_hit=%ld  Hash_miss=%ld\r\n", Hash_hit, Hash_miss);
  exit(0);
}


