//------------------------------------------------------------
// C3A.CPP                         C3x command line assembler
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// Use:
//           C:\mydir\c3a  0x809800  mpyf3 *AR0,R0,R1|| addf3 R0,R1,R2
//                     |       |     |<----------------------------->|
//    The program -----+       |         |
//    Address to assemble at --+         |
//    Opcode or directive to assemble ---+
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//
//  Files in root directory
//  -----------------------
//    DSK3A.PRJ     Borland project file
//    DSK3A.DSK     Borland desktop file
//    *.obj         Compiler object output
//
//  Files in DSK3A directory
//  ------------------------
//    DSK3A.CPP     3X DSK Assembler main routine
//
//  Files in COMMON2 directory
//  --------------------------
//    ARGSPLIT.CPP  Functions to split arguments up for analysis
//    ASCIINUM.CPP  Universal number type recognizer
//    ASMC40.CPP    Assembler routines
//    ASSM_FUN.CPP  Functions for recognizing assembly constructs
//    DASMC40.CPP   Disassembler routines
//    EXP_ANAL.CPP  Expression analyzer and function recognizer
//    FAKETARG.CPP  Contains a few 'fake' target functions to satisfy link
//    MATHERR.CPP   Math error trap routines
//    OPCODES1.CPP  Text strings and structures used for assy/dasm
//    OPCODES2.CPP  Main array of assembler menmonics and codes
//    SIM3XNUL.CPP  Null functions for SIM3X.CPP
//
//  Files in COMMON directory
//  -------------------------
//    ERRORMSG.CPP  Messages used for most function returns
//    RAND386.CPP   Fast 32 bit random number generator
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TMSFLOAT.CPP  TMSFLOAT - IEEE floating point conversion functions
//--------------------------------------------------------------------
#include <conio.h>
#include <stdlib.h>
#include "opcodes.h"
#include "dsk.h"
#include "exp_anal.h"
int   DSK3D      = 0;   // Enables register recognition for debugger
int   warn_limit = 4;
int   err_limit  = 4;
char  uquiet     = 0;
char  quiet      = 0;
ulong ENTRY      = 0;
//-------------------------------------------------------------------
// main() sets up the global variables which are set by the command
// line arguments and then controls the pass1 pass2 assembly.  Depending
// on the return error levels various actions can be taken.  When
// assembly is complete the symbol table and section information is
// output to the DSK file.
//---------------------------------------------------------------
MSGS PatchAsm(char *strg)
{
  char buf1[120];
  char buf2[120];
  char *ptr;
  ulong o;
  MSGS err;
  OBJ obj;
  //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  *buf1 = ' ';
//  strcpy(strg," mpyf r2,r0");
  strcpy(buf1+1,strg);
  if((ptr=strstr(buf1,"||"))!=NULL)
  {
     *buf2 = ' ';
     strcpy(buf2+1,ptr);
     *ptr++ = 0;
  }
  else strcpy(buf2," ");
  strcpy(g_strg1, buf1);
  err = assm(buf1,buf2,obj);
  o = obj_pack(obj);
  printf("%s => %08lx\n",strg,o);
  if((err!=NO_ERR)&&(err!=PAR_NO_ERR)) return err;
  Disasm(SEG[current_seg].offs,o, buf1+1);
  printf("%08lx => %s\n",o,buf1);
  return NO_ERR;
}
//---------------------------------------------------------------
//void main(*_argc, **_argv)  // Unix world
void main(void)               // Borland/Dos world
{
  int x;
  MSGS err;
  NUM_TYPE NTYPE;
  ulong ul;
  char strg[120];
  C3Xmode = 1; // Turn off C40 assembly
  g_pass  = 2;
  if_on   = 1;
  current_seg = 0;
  TMS_TEST = 1; // Set to 1 to disable short float zero decode
  Enhanced_Enable = 0;
  //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  clrscr();
  BuildFastLook();
  if(Create_SYM()!=NO_ERR)
  {
    printf("System cannot allocate memory for symbols");
    exit(0);
  }
  clrscr();
  //-------------------
  /*
  ENTRY = 0x13FB1234L;
  Disasm(0x809800L ,ENTRY, strg);
  printf("DASM(%08lx)=> %s\n\n\n", ENTRY, strg);
  */
  //-------------------
  SEG[current_seg].offs = 0x809803L;
  if(_argc<3)
  {
    printf("    Use:  C:\MYDIR\C3A  <address> <asm expression>\n");
    printf("Example:  C:\MYDIR\C3A  0x809800  mpyf r1,r2\n");
    exit(0);
  }
  *strg=0;
  for(x=1;x<_argc;x++)
  {
    strcat(strg," ");
    strcat(strg,_argv[x]);
  }
//NUM_TYPE expressionz(char *ptr, ulong *lval, NUM_TYPE numtype);
  NTYPE = expressionz(_argv[1], &ul, NT_INTEGER);
  switch(NTYPE)
  {
    case NT_INTEGER: break;
    case NT_NOREF  : printf(">>> Error: %s\n",strg);
                     printf(">>> Error: Invalid address expression\n");
                     printf(">>> Error: No symbol match found\n");
                     getch();
                     exit(0);
    default        : printf(">>> Error: %s\n",strg);
                     printf(">>> Error: Invalid address expression\n");
                     printf(">>> Error: Could not convert to long int\n");
                     getch();
                     exit(0);
  }
  SEG[current_seg].offs = ul;
  printf("Assembling \"%s\"\n",strg);
  *strg=0;
  for(x=2;x<_argc;x++)
  {
    strcat(strg," ");
    strcat(strg,_argv[x]);
  }
  if((err=PatchAsm(strg))!=NO_ERR)
  {
    printf(">>> Error: %s\n", strg           );
    printf(">>>        %s\n", Error_Strg(err));
  }
  getch();
}
