//---------------------------------------------------------
// VIDEO.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include "svga256.h"
#include "video.h"

#define VIDEO 0x10

void set_bw(void)
{ int x,y;
  for(x=0; x< 256;x+=4)
  {
    y = x>>2;
    set_color_reg(x  ,y  ,y  ,y  ); // Base
    set_color_reg(x+1,y+1,y  ,y  ); // +1 green
    set_color_reg(x+2,y  ,y+1,y  ); // +1 blue
    set_color_reg(x+3,y  ,y  ,y+1); // +1 red
  }
}
void set_ibw(void)
{ int x,y;
  for(x=0; x< 256;x+=4)
  {
    y = 63 - (x>>2);
    set_color_reg(x  ,y  ,y  ,y  ); // Base
    set_color_reg(x+1,y+1,y  ,y  ); // +1 green
    set_color_reg(x+2,y  ,y+1,y  ); // +1 blue
    set_color_reg(x+3,y  ,y  ,y+1); // +1 red
  }
}

int huge DetectVGA256()
{
  return 2;
}
// detects EGA or VGA cards
int huge DetectEGA(void)
{
   int driver, mode, sugmode = 0;
   detectgraph(&driver, &mode);
   if ((driver == EGA) || (driver == VGA))
      return sugmode;  // return suggested video mode number
   else
      return grError;  // return an error code
}

void set_color_reg(int reg, int green, int blue, int red)
{
  union REGS regs;
  if(red   > 63) red   = 63;
  if(green > 63) green = 63;
  if(blue  > 63) blue  = 63;
  regs.h.ah = 0x10;    // Subfunction 10, set color register
  regs.h.al = 0x10;    //
  regs.x.bx = reg;     // color register
  regs.h.ch = green;   // green
  regs.h.cl = red;     // blue
  regs.h.dh = blue;    // red
  int86(VIDEO, &regs, &regs);
}

void init_video(void)
{
  int Gd = DETECT, Gm, err;
  if(access("svga256.bgi",0)==0)
  { printf(" Installing Svga256\n");
    installuserdriver("Svga256",DetectVGA256);
  }
  else
  { clrscr();
    printf(
    "This application requires an SVGA 640x480x256 color BGI driver.\n"
    "The driver used to develop this application (SVGA256.BGI) is a\n"
    "shareware graphics driver available from Jordon Hargraphix Software.\n"
    "The latest version can be downloaded from America On Line (AOL)\n"
    "at the following FTP site.  Note that the last two numbers are the\n"
    "revision of the drivers and therefor may differ.\n"
    "\n"
    "   ftp://mirrors.aol.com/pub/simtelnet/msdos/borland/svgabg55.zip\n"
    "\n"
    "   SVGABG55.ZIP - Super VGA/Tweaked VGA BGI drivers\n"
    "                  Jordon Hargraphix Software\n"
    "\n"
    "NOTE: Shareware code which periodically needs updating or requires\n"
    "      a license agreement is NOT kept on the TI BBS or Internet FTP\n"
    "      site for download.  TI will not provide this for you.  You will\n"
    "      need to download these files for yourself\n"
    );
    exit(1);
  }
  initgraph(&Gd,&Gm,"");
  err = graphresult();
  if (err != grOk)    // an error occurred
  { printf("Graphics error: %s\n", grapherrormsg(err));
    exit(1);          // Application exits
  }
}
