/*=======================================================================
  LOOP_C.C
  Keith Larson
  TMS320 DSP Applications
  (C) Copyright 1996,1997,1998
  Texas Instruments Incorporated

  This is unsupported freeware with no implied warranties or
  liabilities.  See the C3x DSK disclaimer document for details
 ========================================================================*/
#include "C3MMR.H"
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
#define  TIM0_prd  2             /* AIC reference clock is TIM0          */
#define  TA        6             /* DAC setup                            */
#define  TB        25            /*                                      */
#define  RA        10            /* ADC setup                            */
#define  RB        15            /*                                      */
/*===================================================================
  The application code begins here, beginning with constants that
  are used in various routines.
 ====================================================================*/
#define  A_REG   ((TA<<9)+(RA<<2)+0) /* Packed AIC register values       */
#define  B_REG   ((TB<<9)+(RB<<2)+2) /*                                  */
#define  C_REG   0x3                 /*                                  */
/*efine  S0gctrl 00E970300h */       /* Sport, noninverted clkx/clkr     */
#define  S0gctrl 0x0E973300          /* Sport,    inverted clkx/clkr     */
#define  S0xctrl 0x00000111          /*                                  */
#define  S0rctrl 0x00000111          /*                                  */
#define  bigval  000010000h          /* Used in overflow mode saturation */
/*===================================================================
  The main loop consists of waiting for a new ADC sample.
  When an receive interrupt occurs, the new data is loaded into the
  data delay line buffer, followed by the SFFT and output routines.
  Four dummy writes to the external bus have been added in the main
  loop to allow real time benchmarking of the three functions using
  and oscilloscope to monitor the address bus LSB's
 ====================================================================*/
void ST_STUB (void);
float Input   (void);
void  Output  (float);
void  prog_AIC(int );
void  AIC_INIT(void);
/********************************************************/
void main(void)
{
   float f;
   ST_STUB();
   asm("  ldi   0E4h,IE     ");  /*   Enable XINT/RINT/INT2             */
   asm("  idle              ");  /*   Wait for Receive Interrupt        */
   f = (float)*S0_rdata;         /* The first interrupt occurs shortly  */
   *S0_xdata = 0;                /* after AIC init is complete, which   */
                                 /* will not leave enough time for SFFT */
   for(;;)
   {
     asm("  idle    ");          /*   Wait for Receive Interrupt        */
     f = Input();                /*   Put ADC sample in delay buffer    */
     Output(f);                  /*   Output result                     */
   }
}
/*===================================================================
  The ADC data is read and buffered here
 ====================================================================*/
float Input(void)
{
  int   x;
  float f;
  x = *S0_rdata;     /*get ADC data                         */
  x = x >> 16;       /* Sign extend previous sample in MSBs */
  f = x;             /* Convert the ADC data to float       */
  return f;
}
/*===================================================================
  The output section is written for both Spectrum analyzer output
  as well as REAL/IMAG filter sum outputs
 ====================================================================*/
void Output(float f)
{
  int x;
  x = f;
  x &= 0xFFFC;
  *S0_xdata = x;
}
/*===================================================================
  The startup stub is used during initialization only and can be
  overwritten by the stack or data after initialization is complete.
  Note: A DSK or RTOS communications kernel may also use the stack.
  In this case be sure to not put the stack here during debug.
 ====================================================================*/
void ST_STUB(void)
{
   *T0_ctrl = 0;         /* Halt TIM0           */
   *T0_count= 0;         /* Set counts to 0     */
   *T0_prd  = TIM0_prd;  /* Set period          */
   *T0_ctrl = 0x2C1;     /* Restart both timers */
   /* - - - - - - - - - - - - - - - - - - - - - */
   *S0_xctrl = S0xctrl;  /* transmit control    */
   *S0_rctrl = S0rctrl;  /* receive  control    */
   *S0_xdata =       0;  /* DXR data value      */
   *S0_gctrl = S0gctrl;  /* global control      */
    AIC_INIT();
}
/*================================================
  This function initializes the AIC
 ================================================*/
void AIC_INIT(void)
{
  asm("  andn  034h,IF  ");
  asm("  ldi   004h,IE  ");  /* Enable only INT2 */
  *S0_xdata = 0;
  asm(" rpts  0040h     ");
  asm(" ldi   2,IOF     ");  /* XF0=0 resets AIC */
  asm(" ldi   6,IOF     ");  /* XF0=1 runs AIC   */
  asm(" rpts  040h      ");
  asm(" nop             ");
  asm("  andn  034h,IF  ");
  asm("  ldi   014h,IE  ");  /* Enable only XINT interrupt */
  /*- - - - - - - - - - - -*/
  prog_AIC(C_REG   );      /* program control register */
  prog_AIC(0xFFFC  );      /* Program the AIC to be real slow */
  prog_AIC(0xFFFC|2);      /* Program the AIC to be real slow */
  prog_AIC(B_REG   );      /* Bump up the Fs to final rate    */
  prog_AIC(A_REG   );      /* smaller divisors sent first     */
  asm("  or  080h,ST");    /* Use the overflow mode for fast saturate */
}
/*===================================================================
  prog_AIC is used to transmit new timing configurations to the AIC.
  If you single step this routine, the AIC timing will be corrupted
  causing AIC programming to fail.
  STEP OVER THIS ROUTINE USING THE F10 FUNCTION STEP
 ====================================================================*/
void prog_AIC(int xmit2)
{
  int x;
  *S0_xdata =     0; asm(" idle "); /* Pre transmit a safe value       */
  *S0_xdata =     3; asm(" idle "); /* Request 2ndy xmit               */
  *S0_xdata = xmit2; asm(" idle "); /* Send register porgram value     */
  *S0_xdata =     0; asm(" idle "); /* Leave with a safe value         */
  x = *S0_rdata;                    /* Fix rcvr underrun by dummy read */
}
/*===================================================================
  Install the XINT/RINT ISR branch vectors
 ====================================================================*/
  asm(" .sect  \"BRTBL\"");  /* secondary branch table */
  asm(" reti            ");  /* XINT0                  */
  asm(" reti            ");  /* RINT0                  */
  asm(" .text           ");
/*===================================================================
  Recreate the C31 vector table in the bootrom if using an EVM
 ====================================================================*/
  asm(" .sect  \"VECTS\"   "); /* secondary branch table  */
  asm(" .word  0000045h    ");  /* Reset                  */
  asm(" .word  0809FC1h    ");  /* INT0                   */
  asm(" .word  0809FC2h    ");  /* INT1                   */
  asm(" .word  0809FC3h    ");  /* INT2  (Debug Host int) */
  asm(" .word  0809FC4h    ");  /* INT3                   */
  asm(" .word  0809FC5h    ");  /* XINT0                  */
  asm(" .word  0809FC6h    ");  /* RINT0                  */
  asm(" .word  0809FC7h    ");  /* XINT1 (Debug SSTEP)    */
  asm(" .word  0809FC8h    ");  /* RINT1                  */
  asm(" .word  0809FC9h    ");  /* TINT0                  */
  asm(" .word  0809FCAh    ");  /* TINT1                  */
  asm(" .word  0809FCBh    ");  /* DMA                    */
  asm(" .text               ");
/*===================================================================*/
