/* BiQuad.C
   Posted to internet news group COMP.DSP by 

   Pete Hewitt
   pete.hewitt@g*cm.com
*/

#define num_filters 1
#define num_coefficients 10
#define num_biquads 2
#define len_delay_line 3

/* note delay line must be preserved between calls */
static float delay_line[num_biquads][len_delay_line];

/* probably most efficient to declare filter outside biquad routine */
static float filter[num_filters*num_coefficients] = 
                        {-0.957581,
                         +1.957153,
                         +0.469238,
                         -0.979675,
                         +0.510620,
                         -0.955383,
                         +1.951416,
                         +0.480103,
                         -0.986755,
                         +0.510620};

float biquad(input_sample)
{
        float input_sample;
        float output_sample;
        float *filter_ptr = &filter[0];
        float filtered_signal[num_sources];
        int i;    

        for (i = 0; i<num_biquads;i++)
        {
                float *delay_ptr = &delay_line[i][0];
                dtemp = 
                *filter_ptr++ * *delay_ptr++ +
                *filter_ptr++ * *delay_ptr-- +
                input_sample;
                output_sample = 
                *filter_ptr++ * *delay_ptr++ +
                *filter_ptr++ * *delay_ptr-- +
                *filter_ptr++ * dtemp;
                input_sample = output_sample;
                *delay_ptr++ = *delay_ptr;              
                *delay_ptr = dtemp;             
        }
            return (output_sample);
}


