/*=======================================================================
  Running Average

  Keith Larson
  TMS320 DSP Applications
  (C) Copyright 1996,1997,1998
  Texas Instruments Incorporated
 ========================================================================*/
#include "C3MMR.H"
#define  S0gctrl 0x0E973300          /* Sport,    inverted clkx/clkr     */
#define  S0xctrl 0x00000111          /*                                  */
#define  S0rctrl 0x00000111          /*                                  */
#define  TA_   8
#define  TB_  60
#define  RA_   8
#define  RB_  60
#define  MAXCNT  30000
long     TA = TA_;
long     TB = TB_;
long     RA = RA_;
long     RB = RB_;
/*==================================================================*/
void ST_STUB   (void   );
float Input    (void   );
void  Output   (float  );
void  prog_AIC (int    );
void  AIC_INIT (void   );
/*************************************************/
volatile long A_LOC   = ((TA_<<9)+(RA_<<2)+0);
volatile long B_LOC   = ((TB_<<9)+(RB_<<2)+2);
volatile long C_LOC   = 3;
volatile long T_LOC   = 2;
/*************************************************/
volatile int xdata    = 0;
volatile int free_run = 0;
volatile int RRDY     = 0;
/*************************************************************/
#define LENGTH 4
void main(void)
{
   float f,fin;
   float sum;
   float BUF[LENGTH];
   int n;
   n = 0;
   sum = 0;
   for(n=0;n<LENGTH;n++) BUF[n] = 0;

   ST_STUB();
   for(;;)
   {
     *T0_ctrl = 0;
     *T0_count= 0;
     *T0_prd  = T_LOC;
     *T0_ctrl = 0x2C1;
     free_run = 0;
     AIC_INIT();
     free_run = 1;
     asm("  ldi   0F4h,IE     ");
     asm("  andn  00Fh,IF     ");
     f = Input();
     *S0_xdata = xdata;
     asm(" OR 02000h,ST  ");
     for(;;)
     {
       asm(" STI R0,@080A000h ");
       RRDY = 0;
       while(RRDY==0);
       f  = Input();

       sum = sum + f - BUF[n];
       BUF[n] = f;
       n++;
       if(n>=LENGTH) n = 0;

       Output(sum/LENGTH);
       asm(" STI R0,@080AFFFh");
     }
   }
}
/*===================================================================
  The ADC data is read and buffered here
 ====================================================================*/
float Input(void)
{
  int   x;
  float f;
  x = *S0_rdata;     /*get ADC data                         */
  x = x >> 16;       /* Sign extend previous sample in MSBs */
  f = x;             /* Convert the ADC data to float       */
  return f;
}
/*===================================================================
  The output section is written for both Spectrum analyzer output
  as well as REAL/IMAG filter sum outputs
 ====================================================================*/
void Output(float f)
{
  long x;
  if(f>  32767) f =  32767;
  if(f< -32768) f = -32768;
  x = f;
  x &= 0xFFFC;
  xdata = x;
}
/*===================================================================
  The startup stub is used during initialization only and can be
  overwritten by the stack or data after initialization is complete.
  Note: A DSK or RTOS communications kernel may also use the stack.
  In this case be sure to not put the stack here during debug.
 ====================================================================*/
void ST_STUB(void)
{
   *T0_ctrl = 0;         /* Halt TIM0           */
   *T0_count= 0;         /* Set counts to 0     */
   *T0_prd  = T_LOC;     /* Set period          */
   *T0_ctrl = 0x2C1;     /* Restart both timers */
   /* - - - - - - - - - - - - - - - - - - - - - */
   *S0_xctrl = S0xctrl;  /* transmit control    */
   *S0_rctrl = S0rctrl;  /* receive  control    */
   *S0_xdata =       0;  /* DXR data value      */
   *S0_gctrl = S0gctrl;  /* global control      */
  /*AIC_INIT();*/
}
/*===============================================================
  This function initializes the AIC and would be supplied by the
  board manufacturer.
 ================================================================*/
void AIC_INIT(void)
{
  /* *dma_ctrl =        0;  */
  asm("  andn  034h,IF  ");
  asm("  ldi   004h,IE  ");  /* Enable only INT2 */
  *S0_xdata = 0;
  asm(" rpts  0040h     ");
  asm(" ldi   2,IOF     ");  /* XF0=0 resets AIC */
  asm(" ldi   6,IOF     ");  /* XF0=1 runs AIC   */
  asm(" rpts  040h      ");
  asm(" nop             ");
  asm(" andn  034h,IF   ");
  asm(" ldi   014h,IE   ");  /* Enable only XINT interrupt */
  /*- - - - - - - - - - - -*/
  prog_AIC(C_LOC   );      /* program control register */
  prog_AIC(0xFFFC  );      /* Program the AIC to be real slow */
  prog_AIC(0xFFFC|2);      /* Program the AIC to be real slow */
  prog_AIC(B_LOC   );      /* Bump up the F s to final rate    */
  prog_AIC(A_LOC   );      /* smaller divisors sent first     */
  asm("  or  080h,ST");    /* Use the overflow mode for fast saturate */
}
/*===================================================================
  This called by AIC_INIT()

  prog_AIC is used to transmit new timing configurations to the AIC.
  If you single step this routine, the AIC timing will be corrupted
  causing AIC programming to fail.
  STEP OVER THIS ROUTINE USING THE F10 FUNCTION STEP
 ====================================================================*/
void prog_AIC(int xmit2)
{
  int x;
  *S0_xdata =     0; asm(" idle "); /* Pre transmit a safe value       */
  *S0_xdata =     3; asm(" idle "); /* Request 2ndy xmit               */
  *S0_xdata = xmit2; asm(" idle "); /* Send register porgram value     */
  *S0_xdata =     0; asm(" idle "); /* Leave with a safe value         */
  x = *S0_rdata;                    /* Fix rcvr underrun by dummy read */
}

/*-------------------------------------------------------------------
  Send the output value posted by Output to the serial port xmit
  -------------------------------------------------------------------*/
void c_int05(void)
{
  if(free_run)
    *S0_xdata = xdata;
}
/*-------------------------------------------------------------------
  Set a flag to let the Input() routine know that a value is ready
  -------------------------------------------------------------------*/
void c_int06(void)
{
  RRDY = 1;
}
/*===================================================================
  Install the XINT/RINT ISR branch vectors
 ====================================================================*/
  asm(" .sect  \"BRTBL\" ; secondary branch table ");
  asm(" b   _c_int05        ; XINT0                  ");
  asm(" b   _c_int06        ; RINT0                  ");
  asm(" .text               ; secondary branch table ");
/*===================================================================
  Recreate the C31 vector table in the bootrom if using an EVM
 ====================================================================*/
  asm(" .sect  \"VECTS\""); /* secondary branch table  */
  asm(" .word  0000045h    ");  /* Reset                  */
  asm(" .word  0809FC1h    ");  /* INT0                   */
  asm(" .word  0809FC2h    ");  /* INT1                   */
  asm(" .word  0809FC3h    ");  /* INT2  (Debug Host int) */
  asm(" .word  0809FC4h    ");  /* INT3                   */
  asm(" .word  0809FC5h    ");  /* XINT0                  */
  asm(" .word  0809FC6h    ");  /* RINT0                  */
  asm(" .word  0809FC7h    ");  /* XINT1 (Debug SSTEP)    */
  asm(" .word  0809FC8h    ");  /* RINT1                  */
  asm(" .word  0809FC9h    ");  /* TINT0                  */
  asm(" .word  0809FCAh    ");  /* TINT1                  */
  asm(" .word  0809FCBh    ");  /* DMA                    */
  asm(" .text               ");
/*===================================================================*/
