//------------------------------------------------------------
// OPCODES1.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
#include "assm_fun.h"

RegTbl C30Reg[] =
{
 {"R0" ,  0},
 {"R1" ,  1},
 {"R2" ,  2},
 {"R3" ,  3},
 {"R4" ,  4},
 {"R5" ,  5},
 {"R6" ,  6},
 {"R7" ,  7},
 {"AR0",  8},
 {"AR1",  9},
 {"AR2", 10},
 {"AR3", 11},
 {"AR4", 12},
 {"AR5", 13},
 {"AR6", 14},
 {"AR7", 15},
 {"DP" , 16},
 {"IR0", 17},
 {"IR1", 18},
 {"BK" , 19},
 {"SP" , 20},
 {"ST" , 21},
 {"IE" , 22},
 {"IF" , 23},
 {"IOF", 24},
 {"RS" , 25},
 {"RE" , 26},
 {"RC" , 27},

 {"R8" ,-28}, // These do not exist for C3x, R8-R11 for C4x
 {"R9" ,-29},
 {"R10",-30},
 {"R11",-31},

 {"IVTP",-32},
 {"TVTP",-33},
 {"DIE",-22},
 {"IIE",-23},
 {"IIF",-24},

 {"F8" ,-28}, // Floating point alias for R8-11
 {"F9" ,-29},
 {"F10",-30},
 {"F11",-31},

 {"F0" ,  0}, // Alias' for R0-R7
 {"F1" ,  1},
 {"F2" ,  2},
 {"F3" ,  3},
 {"F4" ,  4},
 {"F5" ,  5},
 {"F6" ,  6},
 {"F7" ,  7},
 {"FP" , 11}, // Alias for AR3
 {"ERR", -1}  // Last entry terminated with -1
};

//--------------------------------------------------------
// Indirect modifier strings
//--------------------------------------------------------
char *Mod[] =
{                           //  code
  "*+AR%.1d(%d)",           // 00000   2 args
  "*-AR%.1d(%d)",           // 00001   2 args
  "*++AR%.1d(%d)",          // 00010   2 args
  "*--AR%.1d(%d)",          // 00011   2 args
  "*AR%.1d++(%d)",          // 00100   2 args
  "*AR%.1d--(%d)",          // 00101   2 args
  "*AR%.1d++(%d)%",         // 00110   2 args
  "*AR%.1d--(%d)%",         // 00111   2 args

  "*+AR%.1d(IR0)",          // 01000
  "*-AR%.1d(IR0)",          // 01001
  "*++AR%.1d(IR0)",         // 01010
  "*--AR%.1d(IR0)",         // 01011
  "*AR%.1d++(IR0)",         // 01100
  "*AR%.1d--(IR0)",         // 01101
  "*AR%.1d++(IR0)%",        // 01110
  "*AR%.1d--(IR0)%",        // 01111

  "*+AR%.1d(IR1)",          // 10000
  "*-AR%.1d(IR1)",          // 10001
  "*++AR%.1d(IR1)",         // 10010
  "*--AR%.1d(IR1)",         // 10011
  "*AR%.1d++(IR1)",         // 10100
  "*AR%.1d--(IR1)",         // 10101
  "*AR%.1d++(IR1)%",        // 10110
  "*AR%.1d--(IR1)%",        // 10111

  "*AR%.1d",                // 11000
  "*AR%.1d++(IR0)B",        // 11001
  "%d",                     // 11010 * Error cases *
  "%d",                     // 11011
  "%d",                     // 11100
  "%d",                     // 11101
  "%d",                     // 11110
  "%d",                     // 11111
};
char *Cond_tab[] =
{
  "U"   , "LO"  , "LS" , "HI"  , "NC"  ,
  "Z"   , "NZ"  , "N"  , "LE"  , "GT"  ,
  "NN"  , ""    , "NV" , "V"   , "NUF" ,
  "UF"  , "NLV" , "LV" , "NLUF", "LUF" ,
  "ZUF"
};

