//---------------------------------------------------------
// OPCODES.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
#ifndef __OPCODES
#define __OPCODES
#include "typedefs.h"
#include "assm_fun.h"
#include "sim3x.h"
extern char dasm_assm_on;
extern char C3Xmode     ;

typedef MSGS (*AFUNC)(int en_opcode, OBJ &obj, char* operands);
typedef int  (*DFUNC)(int , ulong, char * );
//typedef int  (*SFUNC)(pipeline *pipe, state *st, ulong code);

int DForm0 ( int , ulong, char *);
int DForm1 ( int , ulong, char *);
int DForm3 ( int , ulong, char *);
int DForm4 ( int , ulong, char *);
int DForm5 ( int , ulong, char *);
int DForm5b( int , ulong, char *);
int DForm7 ( int , ulong, char *);
int DForm9 ( int , ulong, char *);
int DFormA ( int , ulong, char *);
int DFormB ( int , ulong, char *);
//
MSGS AForm0 ( int N, OBJ &obj, char *op);
MSGS AForm1 ( int N, OBJ &obj, char *op);
MSGS AForm3 ( int N, OBJ &obj, char *op);
MSGS AForm4 ( int N, OBJ &obj, char *op);
MSGS AForm5 ( int N, OBJ &obj, char *op);
MSGS AForm7 ( int N, OBJ &obj, char *op);
MSGS AForm9 ( int N, OBJ &obj, char *op);
MSGS AFormA ( int N, OBJ &obj, char *op);
MSGS AFormB ( int N, OBJ &obj, char *op);

typedef struct
{
  int en;
  char *instr;             // instruction ABSF ABSI etc ...
  ulong mask;
  ulong pattern;           // opcode for the op_length given
  AFUNC  aform;             // assembler  functions
  DFUNC  dform;             // disassembly functions
  SFUNC  sform;
} INSTR_TABLE;

enum opcodes
{
 __ABSF=1      , __ADDF        , __CMPF        , __FLOAT       ,
 __LDE         , __LDF         , __LDFI        , __LDM         ,
 __MPYF        , __NEGF        , __POPF        , __PUSHF       ,
 __RND         , __SUBF        , __SUBRF       , __NORM        ,
 __ABSI        , __ADDC        , __ADDI        , __AND         ,
 __ANDN        , __ASH         , __CMPI        , __FIX         ,
 __LDP         , __LDI         , __LDII        , __LSH         ,
 __MPYI        , __NEGB        , __NEGI        , __NOP         ,
 __NOT         , __POP         , __PUSH        , __OR          ,
 __ROL         , __ROLC        , __ROR         , __RORC        ,
 __RPTS        , __STF         , __STFI        ,
 __STI         ,
 __STIK        ,
 __STII        , __SIGI        , __SUBB        , __SUBC        ,
 __SUBI        , __SUBRB       , __SUBRI       , __TSTB        ,
 __XOR         , __IACK        ,

 __MPYF3_ADDF3 , __MPYF3_SUBF3 , __MPYI3_ADDI3 , __MPYI3_SUBI3 ,
 __STF_STF     , __STI_STI     , __LDF_LDF     , __LDI_LDI     ,
 __ABSF_STF    , __ABSI_STI    ,
 __ADDF3_STF   , __ADDI3_STI   , __AND3_STI    , __ASH3_STI    ,
 __FIX_STI     , __FLOAT_STF   , __LDF_STF     , __LDI_STI     ,
 __LSH3_STI    , __MPYF3_STF   , __MPYI3_STI   , __NEGF_STF    ,
 __NEGI_STI    , __NOT_STI     , __OR3_STI     , __SUBF3_STF   ,
 __SUBI3_STI   , __XOR3_STI    ,

 __ADDC3       , __ADDI3       , __AND3        , __ANDN3       ,
 __ASH3        , __CMPI3       , __LSH3        , __MPYI3       ,
 __OR3         , __SUBB3       , __SUBI3       , __TSTB3       ,
 __XOR3        , __MPYSHI3     , __MPYUHI3     ,
 __ADDF3       , __CMPF3       , __MPYF3       , __SUBF3       ,
 __DBc         , __DBDc        ,
 __Bc          , __BDc         , __LDIc        , __LDFc        ,
 __CALLc       , __RETIc       , __RETSc       ,
 __CALL        ,
 __TRAP        , __TRAP4x      ,

 __IDLE        ,
 __IDLE2       ,
 __LOPOWER     ,
 __MAXSPEED    ,
 __SWI         ,
 __BR          , __BRD         ,
 __RPTB        ,

/*
 __STIK
 __LB0         , __LB1         , __LB2         , __LB3         ,
 __LBU0        , __LBU1        , __LBU2        , __LBU3        ,
*/
 __LDA,
/*
 __LDEP        , __LDHI        , __LDPE        ,
 __LDPK        , __LH0         , __LH1         , __LHU0        ,
 __LHU1        ,
 __LWL0        , __LWL1        , __LWL2        , __LWL3        ,
 __LWR0        , __LWR1        , __LWR2        , __LWR3        ,
 */
 __FRIEEE      ,
 /*
 __MB0         , __MB1         , __MB2         , __MB3         ,
 __MH0         , __MH1         ,
 __MPYSHI      , __MPYUHI      , __RCPF        , __RSQRF       ,
 */
 __TOIEEE      ,
 /*
 __LDF_B       , __LDI_B       ,
 __FRIEEE_STF  , __TOIEEE_STF  ,

 __ADDC3_B     , __ADDI3_B     , __AND3_B      , __ANDN3_B     ,
 __ASH3_B      , __CMPI3_B     , __LSH3_B      , __MPYI3_B     ,
 __OR3_B       , __SUBB3_B     , __SUBI3_B     , __TSTB3_B     ,
 __XOR3_B      , __MPYSHI3_B   , __MPYUHI3_B   , __ADDF3_B     ,
 __CMPF3_B     , __MPYF3_B     , __SUBF3_B     ,

 __B_A         , __BAT_        , __BAF_        , __DB_A        ,
 __DB_B        , //__LAJ_A       ,
 __LATc        , __RETID       ,
 __RETI        , __RETS        ,
 __LAJ_B       ,
 __RPTBD_A     , __RPTBD_B     , __RPTB_B      ,
*/
  __word
};
extern INSTR_TABLE Instr[];
#endif
