//---------------------------------------------------------------
// EXP_ANAL.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//
//   The parser / expression analyzer this file has been derived from
//   the reference material listed below.  Features added include
//   a number format analyzer covering additional number formats,
//   strings, constant chars, Symbol tables, fixed/float types,
//   transcendental, logical, relational and assembler relative addressing
//
//   Title:     C: The Complete Reference
//   Author:    Herbert Schildt
//   Publisher: Osborne McGraw-Hill
//              ISBN 0-07-881538-X
//
#include "dsk.h"
#include "typedefs.h"
#include "symbols.h"
extern int    l_saturation; // 0=no, +1=pos, -1 neg saturate
extern int    f_saturation;
NUM_TYPE DLLEXTEND_EX expressionz(char *ptr, ulong *lval, NUM_TYPE numtype);
int isreg2(char *ptr);
//========================================================================
// Input:
//   char *ptr   - String pointer to the expression to be analyzed
//   ulong *lval - Pointer to 32 bit storage location.  Returned
//                 lval can be char, int, long or float
//   int numtype - NUMTYPE
//
// Return: Returns an enumerated NUMTYPE value
//
// NUMTYPES:
//      0=NO_REF   Used for return of non-converted expression
//      1=INTEGER  Integer is desired return type
//      2=FLOAT    Float is desired return type
//      3=AUT0     Expression determines return type
//
//========================================================================

