#ifndef __TYPEDEFS
#define __TYPEDEFS
//--------------------------------------------
// TYPEDEFS.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//--------------------------------------------
typedef unsigned short ushort;
typedef unsigned char  uchar;
typedef unsigned int   uint;
typedef unsigned long  ulong;
/*
typedef int16    short;  // Some Unix machines
typedef int32    int;
typedef int64    int;
*/
/*---------------------------------------------------------------
  In 32 bit OS machines far and huge do not exist.  The #define
  undefines these types for non DOS or windows apps
  ---------------------------------------------------------------*/
#if  __HUGE__ || __LARGE__ || __COMPACT__ || __MEDIUM__ || __SMALL__
#else
  #define far       // Windows, Linux, Unix do not use far and huge
  #define huge      //
#endif
//=======================================================================
// Set WINDOWS_LINK_ALL if the entire host side driver API is to be linked
// directly into the application
//=======================================================================
#define WINDOWS_LINK_ALL   0
//=======================================================================
// MicroSoft Visual C++ Studio Version
// The 'dllimport' and 'dllexport' arguments to __declspec are
// conditionaly selected using the _DLL keyword
//=======================================================================
#ifdef  _WIN32 | __WIN32__  // Windows detect for MSVC
  #define __DSKWINAPP  1    // Defined for windows compile
  #include <windows.h>
  #include <stdio.h>
  #if WINDOWS_LINK_ALL
      // Extensions defined as null if linking into one EXE
      #define DLLEXTEND_EX
      #define DLLEXTEND_IM
      #define DLLEXTEND_FN
  #else
    #ifdef _DLL
      #define DLLEXTEND_EX  __declspec(dllexport)   // Functions and data in
      #define DLLEXTEND_IM
      #define DLLEXTEND_FN
    #else
      #define DLLEXTEND_EX __declspec(dllimport)
      #define DLLEXTEND_IM __declspec(dllimport)    // Data in 32 bit exe
      #define DLLEXTEND_FN                          // Functions in 32 bit exe
    #endif
  #endif
#else
//#endif
  //=======================================================================
  // Borland import export is far simpler, using the same definitions
  //=======================================================================
//#ifdef   __BORLANDC__  // Borland C version number is unique to Borland
  #pragma argsused
  #ifdef _Windows                          // Windows detect for Borland
    #define __DSKWINAPP  1                 // Defined for windows compile
    #include <windows.h>
    #include <stdio.h>
    #if WINDOWS_LINK_ALL
      // Extensions defined as null if linking into one EXE
      #define DLLEXTEND_EX
      #define DLLEXTEND_IM
      #define DLLEXTEND_FN
    #else
      #define DLLEXTEND_EX FAR PASCAL _export
      #define DLLEXTEND_IM FAR PASCAL _export
      #define DLLEXTEND_FN FAR PASCAL _export
    #endif
  #else
    // Extensions are defined "null" for DOS applications
    #define DLLEXTEND_EX
    #define DLLEXTEND_IM
    #define DLLEXTEND_FN
  #endif
#endif
#endif




