//------------------------------------------------------------
// SYMBOLS.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
// SYMBOLS.CPP creates and manages the symbol table arrays
//------------------------------------------------------------
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <alloc.h>  // alloc.h not included in MSVC
#include <stdlib.h>
//#include "typedefs.h"
#include "dsk.h"
#include "symbols.h"
#include "typedefs.h"
#if __DSKWINAPP
#include <windows.h>
#endif
                // MSVC overload
float DSK3_rev  = (float)DSK3_ver; // DSK3 version stamp available to all apps

// XREF_TABLE SYM[MAX_SYMBOLS];
int MAX_SYMBOLS = 2;       // Max alloced size of SYM table
XREF_TABLE SYM_START[2];   // Small SYM array satisfies start of old code
XREF_TABLE *SYM = SYM_START;

int sym_str_tbl_sz = 100;
char symbols2[132];         // small start up array of symbol strings
char *symbols;

//char symbols[sym_str_tbl_sz]; // large array of symbol strings
char *symbol_ptr = symbols2;    // Ptr to string table
char *post_boot_symbols=symbols;// Ptr to string table after bootup
int  post_boot_sym=0;           // Symbol table offset
int  last_ref=0;                // Last symbol entry
int  last_segment=1;            //
int  current_seg = 1;           // Init value keeps exp_anal happy
segments SEG[MAX_SEGMENTS];

SYM_TYPE DLLEXTEND_EX SymbolType(int offs)
{
  return((SYM_TYPE)SYM[offs].numt);  // Int, Float types
}
NUM_TYPE DLLEXTEND_EX SymbolNumType(int offs)
{
  return((NUM_TYPE)SYM[offs].numt);  // Int, Float types
}

//
// Ver 1.23
// The SYM array is now malloc'd into existance on DSK startup.
//
char BUILD_SYM=1;
MSGS Create_SYM(void)
{

  MAX_SYMBOLS    =  2000;  // These variables set the size of the
  sym_str_tbl_sz = 20000;  // SYM table entries and string allocation

// This is a reminder to set SYMBOLS to 3000/30000
/*
#if __DSKWINAPP
#else
  if(MAX_SYMBOLS != 3000)
  {
    sprintf(EXTMSG,"\nDont forget to set MAX_SYMBOLS back to 3000");
    return EXT_MSG_ERR;
  }
#endif
*/
  if(BUILD_SYM)
  {
    SYM     = (XREF_TABLE *) malloc(MAX_SYMBOLS*sizeof(XREF_TABLE));
    symbols = (char *)       malloc(sym_str_tbl_sz);
    post_boot_symbols=symbols;// Ptr to string table after bootup
    symbol_ptr = symbols;     // Ptr to string table
  }
  BUILD_SYM = 0;
  if((SYM==NULL)||(symbols==NULL))
  {
#if __DSKWINAPP
	MessageBox(NULL,
		"System cannot allocate memory for symbol table",
		"Out of memory",MB_OK);
	return SYS_ERR;
#else
    printf("System cannot allocate memory for symbol table");
    exit(0);
	return SYS_ERR;
#endif   
  }
  return NO_ERR;
}
//-------------------------------------------------------
// symb_defined() returns a non zero offset+1 into the
// the symbol table if a symbol is defined
//-------------------------------------------------------
int symb_defined(char *ptr)
{
  for(int x=0;x<last_ref;x++)
  {
    if(strexact(ptr, SYM[x].sptr))
      return x+1;  // Can now use to redefine a symbol
  }
  return 0;
}
//==================================================================
// ref_add() adds a symbol at *ptr to the symbol list. The symbol
// list is an array of values and attributes along with a pointer
// to the symbol string stored in the symbol string array 'symbols'.
//==================================================================
MSGS xref_add(char *ptr, ulong value, NUM_TYPE type, SYM_TYPE addressable)
{
  int x;
  for(x=0;x<last_ref;x++)
  {
    if(strexact(ptr, SYM[x].sptr))
    return MULT_REF;
  }
  if(symbol_ptr==NULL) return FATAL_SYM1;
  if(last_ref   >= (MAX_SYMBOLS - 1))                return FATAL_SYM1;
  if(symbol_ptr >  (symbols + sym_str_tbl_sz - 32))  return FATAL_SYM2;
  SYM[last_ref].sptr = symbol_ptr;   // add symbol to ref table
  symbol_ptr += sprintf(symbol_ptr, ptr);
  *symbol_ptr++ = 0;
  SYM[last_ref].value  = value;
  SYM[last_ref].numt   = (char)type;
  SYM[last_ref].symt   = (char)addressable;
  SYM[last_ref+1].numt = NT_NOREF;
  last_ref++;
  return NO_ERR;
}
//==========================================================
// ref_mod only changes the value of a symbol.  None of the
// attributes are changed... use carefully as this can
// cause float and integer types to become confused.
//==========================================================
MSGS ref_mod(char *ptr, ulong value)
{
  int x;
  for(x=0;x<last_ref;x++)
  {
    if(strexact(ptr, SYM[x].sptr)) break;
  }
  if(x>=last_ref) return NO_REF;
  SYM[x].value = value;
//SYM[x].type  = 1;
//SYM[x].a     = 0;
  return NO_ERR;
}
//==========================================================
// Modifies the value and all attribytes of a symbol
//==========================================================
MSGS xref_mod2(char *ptr, ulong value,NUM_TYPE type, SYM_TYPE addressable)
{
  int x;
  for(x=0;x<last_ref;x++)
  {
    if(strexact(ptr, SYM[x].sptr)) break;
  }
  if(x>=last_ref) return NO_REF;
  SYM[x].value = value;
  SYM[x].numt  = (char)type;
  SYM[x].symt  = (char)addressable;
  return NO_ERR;
}
//==================================================================
// Returns the symbol table offset for a symbol, or -1 if not found
//==================================================================
int DLLEXTEND_EX ref_offs(char *ptr)
{
  int x;
  for(x=0;x<last_ref;x++)
  {
    if(strexact(ptr, SYM[x].sptr)) break;
  }
  if(x>=last_ref) return -1;
  return x;
}
//==================================================================
// Removes .define symbols from the table by setting the string to ""
//==================================================================
void remove_defines(void)
{
  int x;
  for(x=0;x<last_ref;x++)
  {
  //if(SYM[x].numt==SYM_DEF)
    if(SYM[x].symt==SYM_DEF)
      strcpy(SYM[x].sptr,"");
  }
}
//----------------------------------------------------------
// sets *value to the value of a defined symbol.  Returns
// the type on success or NO_REF if the symbol was not found
//----------------------------------------------------------
NUM_TYPE DLLEXTEND_EX ref_value(char *ptr, long *value)
{ int x;
  ptr = argstart(ptr);              // This line is different
  for(x=0;x<last_ref;x++)
  { if(strexact(SYM[x].sptr, ptr))
    {
      *value = SYM[x].value;
  //  if(SYM[x].a) return INTEGER;
  //  if(SYM[x].numt == SYM_ANNUL)
  //    return NT_NOREF;  // If label... even needed?
     if(SYM[x].symt ==SYM_GLBL) return NT_INTEGER; // If label... needed?
     return (NUM_TYPE) SYM[x].numt;              // SYM_LBL was 1
    }
  }
  return NT_NOREF;
}
//===============================================================
// get_label searches for a 32 bit value match to addr and if
// found, writes the associated string to the char pointer *label
// leading_ws is used to insert leading white space characters.
//
// Also the addressable field SYM[].a is used as a
// filter to only use addresable items
//===============================================================
int DLLEXTEND_EX get_label(char *label,ulong addr, int leading_ws)
{
  char *p;
  for(int j=0; j<last_ref/*MAX_SYMBOLS*/; j++)
  {
//  if(*SYM[j].sptr == 0) break;
    if ( (unsigned long) SYM[j].value == addr)
    {
      if ( SYM[j].symt == SYM_GLBL)   // Type is LABEL  SYM_LBL was 1
      {
        //----------------------------------------------------
        // First version simply aborts if a ":" delimiter is
        // found in the symbol.  The ":" indicates that the
        // symbol name is composed of the symbol plus the
        // name of the file it was defined in.  However for
        // example .text appears in the symbol table many times
        // and can be confusing..
        //
        // The second version chops off the file name, making
        // the symbol shorter, but at the risk of appearing to
        // be aliased into many locations.
        //
        // The third version simply copies the entire symbol
        //----------------------------------------------------
        // 1st version
        /*
        if(strstr(SYM[j].sptr,":")==NULL)
        {
          for(;leading_ws>0;leading_ws--) *label++=' '; // insert desired WS
          sprintf(label,"%.12s",SYM[j].sptr);
          return 1;
        }
        */

        // 2nd version
        for(;leading_ws>0;leading_ws--) *label++=' '; // insert desired WS
        sprintf(label,"%.12s",SYM[j].sptr);
        if((p=strstr(label,":"))!=NULL) *p=0;
        return 1;
        /*
        // 3rd version
        for(;leading_ws>0;leading_ws--) *label++=' '; // insert desired WS
        sprintf(label,"%.12s",SYM[j].sptr);
        return 1;
        */
      }
    }
  }
  *label = 0;
  return 0;
}
//-----------------------------------------------------------------
// argstart() is used by the various parsers to find the beginning
// of string, stripping off the leading WS, TAB and other special
// characters.  Argstart also recognizes other special characters
// to the assembler such as the colon ':' and semi-colon ';'
//-----------------------------------------------------------------
char *argstart(char *ptr)
{ for(int x=0;x<120;x++)
  { switch(*ptr)
    { case  ' ':
      case  ':':
      case  ',':
      case '\t': ptr++; break;
      case '\n':
      case '\r':
      case  ';': *ptr=0; return ptr;
      default  : return ptr;
    }
  }
  *ptr = 0; return ptr;
}
//-----------------------------------------------------------
// argend() finds the last character in a string which is not
// a WS or invalid symbol character.  The string is then terminated
// and a pointer to the end is returned.
//-----------------------------------------------------------
char *argend(char *ptr,char EnColn)
{
  int parrend_count = 0;
  for(int x=0;x<120;x++)
  { switch(*ptr)
    {
      case  ',': if(parrend_count == 0) return ptr;
                 else ptr++; break;
      case  ' ':
      case '\t':
      case  ';':
      case '\n':
      case '\r':
      case   0 : return ptr;
      case  '(': parrend_count++; ptr++; break;
      case  ')': parrend_count--; ptr++; break;
      case  ':': if(EnColn==0) return ptr;
      default  : ptr++; break;
    }
  }
  *ptr = 0; return ptr;
}

//=================================================================
// tabstrip() removes tab characters assuming tabs every Nth char
// This function also assumes that the string can be expanded in
// place.  IOW there should unused string space following the string.
//=================================================================
void tabstrip(char *buf,int N)
{
  int x, cnt;
  char tmp[120];
  char *t = tmp, *p=buf;
  cnt = N;
  for(x=0;x<80;x++) // strip a maximum of 80 chars
  {
    switch(*p)
    {
      case    0: break;  // Line termination
      case '\t': for(;cnt>0;cnt--)
                   *t++ = ' ';
                 p++;
                 break;
      default: *t++ = *p++; cnt--; break;
    }
    *t = 0;
    if(*p==0) break;
    if(cnt<=0) cnt = N;
  }
  strcpy(buf,tmp);
}
