//---------------------------------------------------------
// OBJECT.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1996, 1997, 1998
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
#include <conio.h>
#include <io.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dsk.h"
#if      __DSKWINAPP // MSVC
#else
#include <bios.h>    // Borland and DOS apps
#endif

char *KernelName = "C3X.DSK      ";
char *KernelSrce = "C3X.ASM      ";
int   test_flag       = 0;
int   No_MTask        = 0;
int   WINDOWS         = 1; // Enable test for Windows TimeSlice managment
int   BW_force        =-1; // Do not use set_buswidth unless indicated
int   Windows_Detected= 0;
int   DSK3D           = 1; // 1 enables register recognition in expr analyze
int   TARGET  =   C31_DSK;
ulong SIZELOC;             // printer port readback mode information here
ulong VECTLOC;             // Location of vector table
ulong DASMBGN;             // Startup DASM location
ulong STEPLOC;             // SSTEP here for _dT constant
ulong SP_DFLT;             // Stack default location for file reload
/*----------------------------------------------------------------*/
#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif
#if __WIN32__ | _WIN32          // Borland Win 32 or MSVC Win32
#else
void interrupt ( *ivctr)(__CPPARGS);
#endif

/*----------------------------------------------------------------*/
/* This included file inserts a properly formatted help screen    */
/* message which has been formatted as a C style string           */
/*                                                                */
/* To save time, a conversion utility TXT2SRC.EXE was written to  */
/* convert plain text to properly formatted C, making updating or */
/* spell checking much easier than hand editing                   */
/*                                                                */
/* Borlands a program transfer utility is also useful, creating   */
/* auto-dependancies for easier to project management             */
/******************************************************************/
char huge  Help_Msg[]=
  #include "HARDWARE.CPP"
/*----------------------------------------------------------------*/
/* Multi-tasking cooperation between Windows 'DOS box'            */
/* applications is accomplished by protecting the communications  */
/* messages from a task switch in the operating system.  This     */
/* is also known as protecting a piece of 'critical code'.        */
/* When an application issues a command to transfer a block of    */
/* data, the packet is preceeded by a 'lock' and then followed    */
/* by an 'unlock' of the multi-task operation.  For Windows       */
/* operation, Windows can be detected and then controlled from    */
/* the extended INT 0x2F operating system functions.              */
/*                                                                */
/* NOTE: Graphics applications can coexist with other applications*/
/*       beginning with WIN95.  However the graphics emulation    */
/*       is extrememely slow.  Text emulation in a DOS box is     */
/*       also not particularily fast.                             */
/*----------------------------------------------------------------*/
#if _WIN32
#define Asm __asm  // MSVC
#else
#define Asm asm    // Borland
#endif

MSGS Detect_Windows(void)
{
#if _WIN32 | __WIN32__ //| __DLL__ // MSVC or Borland Windows 32 compile
//  Windows_Detected = 1;
//  No_MTask = 0;
//  return ENBL_WIN;
	return NO_ERR;
#else
  int VM_ID;
  Create_SYM();
  Windows_Detected = 0;
  if(No_MTask) return NO_ERR; // User turn off for all Windows support
  //
  // Should try to determine if the extended 0x2F vectors are
  // present before making a function call to them.  However,
  // getvect(0x??) somehow corrupts the VM_ID detect process.
  // The vector being detected does not need to be 0x2F to cause
  // this corruption.
  //
/*asm   push ax
  asm   push bx
  asm   mov  bx,VM_ID
  asm   mov  ax,0x1684              // Get Device Entry point address
  asm   int  0x2f                   // multiplex interupt
  asm   mov  word ptr[ivc tr  ],di   // di:es holds entry point address
  asm   mov  word ptr[ivc tr+2],es   //
  asm   pop  bx
  asm   pop  ax*/
/*ivc tr = getvect(0x0);*/
/*if(ivc tr == NULL)
  {
    Windows_Detected = 0;
    No_MTask = 1;
    return DSBL_WIN;
  }*/
  Asm  push ax       
  Asm  push bx       
  Asm  mov  ax,0x1683      // Get current virtual machine ID
  Asm  int  0x2f           // multiplex interupt
  Asm  mov  VM_ID,bx       // bx = Virtual Machine ID
  Asm  pop  bx       
  Asm  pop  ax
  //
  ivctr = getvect(0x2F);
  if((VM_ID < 2)||(ivctr==NULL)||(WINDOWS==0))  // VM_ID = -?,0,1
  {
    Windows_Detected = 0;
    No_MTask = 1;
    return DSBL_WIN;
  }
  Windows_Detected = 1;
  No_MTask = 0;
  return ENBL_WIN;
#endif
}
void DLLEXTEND_EX Release_TSlice(void)
{
//#if __WIN32__ //| __DLL__
//return;
//#else
  if(No_MTask) return;
  if(Windows_Detected)
  {
    Asm  mov ax,0x1682   // End time critical code
    Asm  int 0x2f        //
    Asm  mov ax,0x1680   // Release time slice
    Asm  int 0x2f        //
  }
//#endif
}
void DLLEXTEND_EX disable_Mtask(void)
{
  // If the printer port is capable of reading back the data sent
  // to it, then the last used control word should be queriable.  If
  // true, then this might be useable as a method of detecting if
  // the channel can be cooperatively accessed.
//#if __WIN32__ //| __DLL__
//return;
//#else
  if(No_MTask) return;
  if(Windows_Detected)
  {
    Asm  mov ax,0x1681   // Start time critical code
    Asm  int 0x2f
  }
//#endif
}

void DLLEXTEND_EX enable_Mtask(void)
{
//#if __WIN32__ //| __DLL__
//return;
//#else
  if(No_MTask) return;
  if(Windows_Detected)
  {
    Asm  mov ax,0x1682  // End time critical code
    Asm  int 0x2f
  }
//#endif
}
#define TESTLOC VECTLOC+7 // The test location is RINT1, which should
                          // not be in use by the kernel or apps
//---------------------------------------------------------------
// Init_Communication() checks the current LPT connection for a
// currently active DSK kernel.  If active, the existing kernel
// is used.  If not, the DSK kernel is bootloaded into the device.
// To invalidate an existing kernel, issue a DSK_reset()
//---------------------------------------------------------------
MSGS DLLEXTEND_EX Init_Communication(int loops)
{
  char PATH[100];
  #if __DSKWINAPP
  #else
  char *p1,*p2,*p;
  #endif
  int i;
  MSGS err;
  ulong temp, orig;
  ulong testval = 0x00320C31L;
  Detect_Windows( );
  Create_SYM    ( ); // Create the symbol table SYM
  Symbol_Clear  (0); // Init all symbol table ptrs as if reset
  enable_Mtask  ( ); // Enable multitask BEFORE disable (TSLICE is given up)
  //----------------------------------------------------------------
  // Look in the current directory first for the comm kernel.  If
  // not found, use the application startup path
  switch(TARGET)
  { case C32_DSK: strcpy(KernelName,"C32.DSK");
                  strcpy(KernelSrce,"C32.ASM");
                  break;
    case C30_EVM: strcpy(KernelName,"C3XEVM.DSK");
                  strcpy(KernelSrce,"C3XEVM.ASM");
                  break;
  }
  strcpy(PATH,KernelName);     // Check current dir (no path prepend)
  if(access(PATH,0)!=0)   // If file does not exist, check start path
  {
    // C3X.DSK is not in current directory, so look in the startup path
    //
    #if __DSKWINAPP
    sprintf(EXTMSG,"C3X.DSK (DSK communications kernel) needs to be"
    "in the current directory");
    return EXT_MSG_ERR;
    #else
    strcpy(PATH,_argv[0]); // get the startup path environment
    p = EXTMSG;
    p+=sprintf(p,"Application startup path = %s\n\n",PATH);
    // chop off "appname" which follows last \ slash
    p1 = PATH;
    for(;;)
    { p2 = p1;
      p1 = strstr(p1,"\\");
      if(p1==NULL) break;
      p1++;
    }
    *p2=0;
    strcat(PATH,KernelName);
    p+=sprintf(p,"Kernel search path = %s\n\n",PATH);
    if(access(PATH,0)!=0)  // If file exists exit
    {
      p+=sprintf(p,
      "%s was not found in the current directory or startup path\n"
      "To create this file re-assemble %s (.ASM) using DSK3A assembler\n"
      "\nC:\DSKTOOLS\\DSK3A %s\n",KernelName,KernelSrce,KernelSrce);

      clrscr();
      printf(EXTMSG);
      //exit(0);
      return EXT_MSG_ERR;
    }
    #endif
  }
  if((err=Load_File(PATH,SLOAD))!=NO_ERR) return err;
  //
  // Load default locations from kernel symbol table
  //
  // SIZELOC printer port readback mode information here
  // VECTLOC Location of vector table
  // DASMBGN Startup DASM location
  // STEPLOC SSTEP here for _dT constant
  // SP_DFLT Stack default location for file reload
  //
  // Each symbol should be defined, else use default C31 setup
  // An error is detected by sumcheck of INTEGER value N times
  i  = ref_value("SIZELOC",(long *) &SIZELOC); 
  i += ref_value("VECTLOC",(long *) &VECTLOC); 
  i += ref_value("DASMBGN",(long *) &DASMBGN); 
  i += ref_value("STEPLOC",(long *) &STEPLOC); 
  i += ref_value("SP_DFLT",(long *) &SP_DFLT); 
  if(i != (NT_INTEGER*5))
  {
    SIZELOC = 0x809FFEL; // printer port readback mode information here
    VECTLOC = 0x809FC1L; // Location of vector table
    DASMBGN = 0x809800L; // Startup DASM location
    STEPLOC = 0x809FC3L; // SSTEP here for _dT constant.  This is a branch
                         // to the INT2 host routine within the secondary
                         // branch table of the C31 while in bootloader mode
    SP_DFLT = 0x809EFFL; // Stack default location for file reload
  }
  if(TARGET==C30_EVM)
  {
    getmem(0,1,&temp);
    if(temp!=0x809FC0L)
       if((err=InitEVM())!=NO_ERR) return err;
 //   RUN_CPU();
    HALT_CPU();
  }
  else
  {
    for(;loops>0;loops--)
    { // Testing bus size readback
      //
      get_buswidth();             // Query target for current bus mode
      getmem(TESTLOC,1,&orig   ); // If communications fails the port is
      putmem(TESTLOC,1,&testval); // reset to the default conditions
      getmem(TESTLOC,1,&temp   );
      if(putmem(TESTLOC,1,&orig) == NO_ERR)
        if(temp == testval)
          if(set_buswidth() == NO_ERR) break;
      //
      // If read/write fails, try bootloading
      err=Load_File(PATH,BOOT); // BOOT also loads symbols
      switch(err)
      {
        case EXT_MSG_ERR:
        case EXT_MSG_OK: enable_Mtask();
                         #if    __DSKWINAPP
                         return err;      // Windows app displays EXTMSG errors
                         #else
                         clrscr();        // Display EXTMSG message
                         cprintf(EXTMSG); // Note loss of text attribute info
                         break;           // in version 1.21 since display
                         #endif           // is now one level higher
        case NO_ERR: break;
        default    : return err;
      }
      //
      // After succesful boot, C31 is executing spin loop
      // and needs to be halted to set the registers.  Otherwise
      // a run or other command can corrupt the kernel
      //
      HALT_CPU();
      if(err==EXT_MSG_OK) break;
//    if(err==NO_ERR    ) break;

//    if(kbhit()) if(toupper(getch()) == 'Q') exit(0);
      #if __DSKWINAPP
      //
      // Put windows equivlent code here
      //
      #else
      if(test_flag) // Cycle through the three port addresses
      {
        switch(port)
        {
          case 0x378: port = 0x278; break;
          case 0x278: port = 0x3BC; break;
          case 0x3BC:
          default:    port = 0x378; break;
        }
      }
      if(kbhit())
      { switch(toupper(getch()))
        {
         // case 'Q': exit(0);
          case '1': ports(0x378); break;
          case '2': ports(0x278); break;
          case '3': ports(0x3BC); break;
          case 'H': View_Manual("DSK3APP.EXE"); break;
          case 'Q':
          default: fcloseall();
                   //gotoxy(1,25);
                   exit(0);
        }
      }
      #endif
    }
    if(loops==0) return TIMEOUT;
  }
  //
  // Determine the kernel timing by singlestepping a known opcode at
  // a known location and measuring delta T (dT).  In this case, the
  // BRANCH opcode in the INT2 branch of the secondary interupt table
  //
  // If the kernel is already running, halt the processor, get the
  // step timing information and then restart it.
  //
  if((err=GET_DEBUG_CTXT())!=NO_ERR)  return err;
  #define FREE temp
  if((err=getmem(CTXT_PTR+FREERUN,1,&FREE))!=NO_ERR)  return err;
  if(FREE) HALT_CPU();
//RUN_CPU();            // Set the registers
//HALT_CPU();
//ref_mod("PC",DASMBGN);
  if((err=getmem(CTXT_PTR,CTXTSIZE,&CTXT[0])) != NO_ERR) return err;
  if((err=SSTEP_NOP())!=NO_ERR)  return err;

  if(FREE) RUN_CPU();

  //HALT_CPU(); //1.24

  //
  // Load the symbols
  //
  if((err=Load_File(PATH,SLOAD))!=NO_ERR) return err;
  //
  // Add referencable symbols for the CPU registers
  //
  // VAR_ADD was 0
  xref_add("R0" ,0,NT_INTEGER,SYM_VAR); xref_add("R1" ,0,NT_INTEGER,SYM_VAR);
  xref_add("R2" ,0,NT_INTEGER,SYM_VAR); xref_add("R3" ,0,NT_INTEGER,SYM_VAR);
  xref_add("R4" ,0,NT_INTEGER,SYM_VAR); xref_add("R5" ,0,NT_INTEGER,SYM_VAR);
  xref_add("R6" ,0,NT_INTEGER,SYM_VAR); xref_add("R7" ,0,NT_INTEGER,SYM_VAR);
  xref_add("F0" ,0,NT_FLOAT  ,SYM_VAR); xref_add("F1" ,0,NT_FLOAT  ,SYM_VAR);
  xref_add("F2" ,0,NT_FLOAT  ,SYM_VAR); xref_add("F3" ,0,NT_FLOAT  ,SYM_VAR);
  xref_add("F4" ,0,NT_FLOAT  ,SYM_VAR); xref_add("F5" ,0,NT_FLOAT  ,SYM_VAR);
  xref_add("F6" ,0,NT_FLOAT  ,SYM_VAR); xref_add("F7" ,0,NT_FLOAT  ,SYM_VAR);
  xref_add("AR0",0,NT_INTEGER,SYM_VAR); xref_add("AR1",0,NT_INTEGER,SYM_VAR);
  xref_add("AR2",0,NT_INTEGER,SYM_VAR); xref_add("AR3",0,NT_INTEGER,SYM_VAR);
  xref_add("AR4",0,NT_INTEGER,SYM_VAR); xref_add("AR5",0,NT_INTEGER,SYM_VAR);
  xref_add("AR6",0,NT_INTEGER,SYM_VAR); xref_add("AR7",0,NT_INTEGER,SYM_VAR);
  xref_add("DP" ,0,NT_INTEGER,SYM_VAR); xref_add("IR0",0,NT_INTEGER,SYM_VAR);
  xref_add("IR1",0,NT_INTEGER,SYM_VAR); xref_add("BK" ,0,NT_INTEGER,SYM_VAR);
  xref_add("SP" ,0,NT_INTEGER,SYM_VAR); xref_add("ST" ,0,NT_INTEGER,SYM_VAR);
  xref_add("IE" ,0,NT_INTEGER,SYM_VAR); xref_add("IF" ,0,NT_INTEGER,SYM_VAR);
  xref_add("IOF",0,NT_INTEGER,SYM_VAR);
  xref_add("RS" ,0,NT_INTEGER,SYM_VAR); xref_add("RE" ,0,NT_INTEGER,SYM_VAR);
  xref_add("RC" ,0,NT_INTEGER,SYM_VAR); xref_add("PC" ,0,NT_INTEGER,SYM_VAR);
  xref_add(">> End of Kernel<<",0,NT_INTEGER,SYM_VAR);
  post_boot_sym     = last_ref;
  post_boot_symbols = symbol_ptr;
//ref_mod("PC",DASMBGN);
  err = GET_DEBUG_CTXT();
  return err;
}
//------------------------------------------
// ports() converts the port, status, ctrl
// values from the base port value.
//------------------------------------------
extern uint EVMbase;
#if __WIN32__
#else
#define WORD int
#endif
int DLLEXTEND_EX ports(int base)
{
  /*
  if(TARGET==C30_EVM)
  {
    base = EVMbase;
  }
  */
  port   = (WORD)(base+0);
  status = (WORD)(base+1);
  ctrl   = (WORD)(base+2);
  switch(port)
  {
    case 0x378: return 1;
    case 0x278: return 2;
    case 0x3BC: return 3;
    default   : return 99;
  }
}
//--------------------------------------------------------------------
// Scan_Command_Line() looks for standard DSK command line arguments
// which are common to all C3X DSK apps and sets the appropriate global
// variables.  If help is requested the standard help message is
// displayed followed by an exit
//---------------------------------------------------------------------
MSGS Scan_Command_line(char *app_name)
{
  #if  __DSKWINAPP
  sprintf(EXTMSG,"DOS help messaging for %s is not available",app_name);
  return EXT_MSG_ERR;
  #else
  char *p;
  char MSG[80], *eptr;
  char reset_flag = 0;
  /*-------------------------------------------------------------*/
  /* Edit_Help_Msg() inserts application specific command line   */
  /* options into the help string before being printed.          */
  /*-------------------------------------------------------------*/
  if(Create_SYM()!=NO_ERR)
  {
    printf("System cannot allocate memory for symbol table");
    exit(0);
  }
  Edit_Help_Msg(app_name,"","\r\n");
  for(int i=1; i<_argc;i++)
  {
    p = _argv[i];
    if(*p=='-' ) p++;  // '-' ignore if preceeds argument
    if(*p=='/' ) p++;  // '/'
    if(*p=='\\') p++;  // '\'
    strcpy(MSG,p);
    strupr(MSG);
    if(strexact(MSG,"R"      )) reset_flag=1;
    if(strexact(MSG,"RESET"  )) reset_flag=1;
    if(strexact(MSG,"WIN=0"  )) WINDOWS  = 0;
    if(strexact(MSG,"WIN=1"  )) WINDOWS  = 1;
    if(strexact(MSG,"AUTO"   )) BW_force = 0;
    if(strexact(MSG,"BW=8"   )) BW_force = 8;
    if(strexact(MSG,"BW=4"   )) BW_force = 4;
    if(strexact(MSG,"BYTE"   )) BW_force = 8;
    if(strexact(MSG,"NIBBLE" )) BW_force = 4;
    if(strexact(MSG,"MTASK=0")) No_MTask = 1;
    if(strexact(MSG,"NOMTASK")) No_MTask = 1;
    if(strexact(MSG,"LO_PWR" )) LO_PWR   = 1;
    if(strstr  (MSG,"T="     )) timeout = (int) atol(&MSG[2]);
    if(strstr  (MSG,"WS="     )) WSTATE = strtol(&MSG[3],&eptr,0);
    if(strstr  (MSG,"IOSTRB=" )) IOSTRB = strtol(&MSG[7],&eptr,0);
    if(strstr  (MSG,"STRB0="  )) STRB0  = strtol(&MSG[6],&eptr,0);
    if(strstr  (MSG,"STRB1="  )) STRB1  = strtol(&MSG[6],&eptr,0);
    if(strstr  (MSG,"PBUSCON=")) STRB0  = strtol(&MSG[8],&eptr,0);
    if(strstr  (MSG,"P_BUSCON=")) STRB0  = strtol(&MSG[9],&eptr,0);
    if(strexact(MSG,"LPT=1"  )) port=0x378;
    if(strexact(MSG,"LPT=2"  )) port=0x278;
    if(strexact(MSG,"LPT=3"  )) port=0x3BC;
    if(strexact(MSG,"LPT1"   )) port=0x378;
    if(strexact(MSG,"LPT2"   )) port=0x278;
    if(strexact(MSG,"LPT3"   )) port=0x3BC;
    if(strexact(MSG,"C32"    )) TARGET=C32_DSK;
    if(strexact(MSG,"FAST"   )) FAST_FLAG=1;
    //
    // Dont use strexact for the following port assignment.  The
    // likelihood of someone specifying a substring containing
    // 'port=' unless it was intended is minimal.
    // IE 'DSK3LOAD port' is no longer mistaken for port assign
    //
    if(strstr  (MSG,"PORT="  ))
    {
      port = (int)strtol(MSG+5,&eptr,0);
      EVMbase = port;
    }
    if(strexact(MSG,"TEST" )) test_flag = 1;
    if(strstr(MSG,"?") || strexact(MSG,"HELP"))
    {
      View_Manual(app_name);
      exit(0);
    }
    if(strexact(MSG,"EVM"))
    {
      TARGET=C30_EVM;
    }
    if(MSG[0]=='K')    // User defined kernel?
    {
      if(MSG[1]=='=')  // More delimiters?
      {
     // if(strstr(MSG,".DSK")!=NULL)
        {
          strcpy(KernelName,&MSG[2]);
          strcpy(KernelSrce,&MSG[2]);
          p = strstr(KernelSrce,".");
          strcpy(p,".ASM");
        }
      }
    }
  }
  if(TARGET!=C30_EVM)
  {
    switch(port)                     // Use the ports() function within a
    {                                // switch to make sure port address is
      case 0x278:                    // a valid PP
      case 0x378:
      case 0x3BC: break;
      default: port = 0x378;
    }
  }
  if(WSTATE > 7) WSTATE=7; // Put limits on internal WS
  if(WSTATE < 1) WSTATE=0;
  if((TARGET==C31_DSK)||(TARGET==C30_EVM))
  {
    STRB0 = (STRB0 & 0xFF1FL) | (WSTATE << 5);
  }
  ports(port);
  if(reset_flag)  Pulse_Init();    // reset the DSK
  return NO_ERR;
  #endif
}

