#ifndef __DSK
#define __DSK
//---------------------------------------------------------
// DSK.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1996, 1997 1998
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
// Software version stamp for all apps goes here
//---------------------------------------------------------
#define  DSK3_ver	1.25
//---------------------------------------------------------
#include <string.h>
#include <dos.h>
#include "typedefs.h"
#include "errormsg.h"
#include "c3xmmrs.h"
#include "keydef.h"
#include "dsk_coff.h"
#include "symbols.h"
#include "tmsfloat.h"
//
// 'static' functions can be defined within a header, keeping the
// compiler from generating multiple copies using the same function
// name.  Inline, causes the function to be expanded like a macro
// for maximum speed.  Note that in this case the function is very
// small and that a call to strexact would use as much code as
// the inlining.
//
//int strexact(char *p1,char *p2);

static inline int strexact(char *p1,char *p2)
{
  return (  strstr(p1,p2) && strstr(p2,p1)  );
}

enum TARGET_TYPE{C31_DSK, C32_DSK, C30_EVM};

extern              int        TARGET;
extern              int     FAST_FLAG;
extern              ulong     SIZELOC; // printer port readback mode information here
extern              ulong     VECTLOC; // Location of vector table
extern              ulong     DASMBGN; // Startup DASM location
extern              ulong     STEPLOC; // SSTEP here for _dT constant
extern              ulong     SP_DFLT; // Default stack location for file reloading
extern              int   cpu_running;
//#define MAX_WAIT 100000L    //  3-10-97 bumped up for wav file buffer
extern long MAX_WAIT; // 100000L
//
// Prototypes and declarations for TARGET.CPP
//
// The DSK jump table is located at 0x809FF4 in DSP memory
// When an enumerated command is sent to the DSP the number
// value is used as an offset to lookup the address of the
// command to execute.  Since a table offset is used this
// also makes a convenient place to patch in the host routines
// with applications.  For expansion purposes a spare is also
// provided which the user can define.
//
#define XWRIT     1
#define XREAD     2
#define XCTXT     3
#define XRUNF     4
#define XSSTEP    5
#define XHALT     6
#define XW_HOST   7  /* Not really a host based command      */
#define XR_HOST   8  /* Not really a host based command      */
#define XSPARE    9  /* Need to add your own vector for this */

void mydelay(int);
MSGS DLLEXTEND_EX fputmem (ulong addr, ulong length, float *data);
MSGS DLLEXTEND_EX fgetmem (ulong addr, ulong length, float *data);
MSGS DLLEXTEND_EX putmem  (ulong addr, ulong length, ulong *data);
MSGS DLLEXTEND_EX getmem  (ulong addr, ulong length, ulong *data);
MSGS DLLEXTEND_EX SSTEP_CPU     (void);
MSGS DLLEXTEND_EX RUN_CPU       (void);
MSGS DLLEXTEND_EX HALT_CPU      (void);
MSGS DLLEXTEND_EX GET_DEBUG_CTXT(void);
MSGS DLLEXTEND_EX SSTEP_NOP     (void);
extern int swap_en;
extern ulong dT_Test_NOP;
//---------------------------------------------------------
// Prototypes and declarations for DRIVER.CPP
//---------------------------------------------------------
#if __WIN32__
void outportb(WORD port, unsigned char value);
void outport(WORD port, WORD value);
unsigned char inportb(WORD port);
WORD inport(WORD port);
#endif
#if __WIN32__
extern WORD      port   ;
extern WORD      status ;
extern WORD      ctrl   ;
#else
extern uint      port   ;
extern uint      status ;
extern uint      ctrl   ;
#endif
extern long      WSHIFT ;
extern ulong     WSCOUNT;
extern int       timeout;
extern int       test_flag ;
extern char huge Help_Msg[];
extern char      LO_PWR;
//----------------------------------------------------
int   DLLEXTEND_EX  Get_No_MTask    (void);
void  DLLEXTEND_EX  Set_No_MTask    (int x);
long  DLLEXTEND_EX  Get_MAX_WAIT   (void);
void  DLLEXTEND_EX  Set_MAX_WAIT   (long x);
void   DLLEXTEND_EX Set_PC_Appli   (ulong);
ulong  DLLEXTEND_EX Get_PC_Appli   (void);
int    DLLEXTEND_EX get_cpu_running(void);
void   DLLEXTEND_EX Set_Windows_Detected(int);
void   DLLEXTEND_EX Set_BW_force   (int);
void   DLLEXTEND_EX set_cpu_running(int);
int    DLLEXTEND_EX get_cpu_running(void);
ulong  DLLEXTEND_EX CTXTPTR        (void); // Win32 cannot directly access data
ulong  DLLEXTEND_EX SPDFLT         (void); // in a DLL so a function is used
void   DLLEXTEND_EX WriteCTXT      (int offs,ulong val);
ulong  DLLEXTEND_EX ReadCTXT       (int offs);
//----------------------------------------------------
void   DLLEXTEND_EX HPI_STRB(int val);
char   DLLEXTEND_EX HPI_ACK(void);
MSGS   DLLEXTEND_EX InitEVM(void);
MSGS   DLLEXTEND_EX DSK_reset(void);
MSGS   DLLEXTEND_EX Interlock(void);
MSGS   DLLEXTEND_EX recv_long(ulong *);
MSGS   DLLEXTEND_EX xmit_byte(char);
MSGS   DLLEXTEND_EX xmit_long(ulong);
void   DLLEXTEND_EX Pulse_Init(void);
//-----------------------------------------------------
// C31 DSK interface and parallel printer port signal definitions
// Bit definitions at printer control port (write)
//    B7      B6     B5    B4     B3        B2         B1        B0
// +--------------------+--------------+----------+---------+---------+
// |  DIR |   x  |  DIR |  INT |/SLCTIN|   INIT   |/AUTOFEED| /STROBE |
// +--------------------+--------------+----------+---------+---------+
//                                        RESET                 HPSTB
//                   W     R/W     W      R/W          W         R/W
//
// Bit definitions at printer status port (read)
//    B7         B6         B5          B4        B3     B2    B1   B0
// +----------+----------+-----------+----------+---------------------+
// | /BUSY    |  ACK     |  PAPER    |  SELECT  |ERROR| ACK |  x |  x |
// +----------+----------+-----------+----------+---------------------+
//  <------------------ D0 - D3 ---------------> HPACK
extern int _DIR;        // NOTE: Some laptops use these bits for shutdown!
#if __WIN32__
#define PPSTRB_LO (unsigned char)0x5
#define PPSTRB_HI (unsigned char)0x4
#define RESET_LO  (unsigned char)0x0    /* RESET is lo, PSTRB hi */
#define RESET_HI  (unsigned char)0x4    /* RESET is hi, PSTRB hi */
#else
#define PPSTRB_LO 0x5
#define PPSTRB_HI 0x4
#define RESET_LO  0x0    /* RESET is lo, PSTRB hi */
#define RESET_HI  0x4    /* RESET is hi, PSTRB hi */
#endif

#if _WIN32
#define Asm __asm  // MSVC style
#else
#define Asm asm    // Borland style
#endif

#if _WIN32  // MSVC

#define inword(p)          _inpw(p)
#define inctrl             _inp(ctrl)
#define instat             _inp(status)
#define inbyte             _inp(port)
#define innible           ((_inp(status) >> 4) ^ 0x8)
#define outctrl(val)       _outp(ctrl,val)
#define outbyte(val)       _outp(port,val)
#define outword(p,v)       _outpw(p,v)

#else // Borland DOS and Win 16

#define outctrl(val)   outportb(ctrl,val)
#define instat         inportb(status)
#define inbyte         inportb(port)
#define innible        ((inportb(status) >> 4) ^ 0x8)
#define outbyte(val)   outportb(port,val)
#define outword(p,v)   outport(p,v)
#define inword(p)      inport(p)
#define inctrl         inportb(ctrl)

#endif
//
// The following enumeration matches the context save structure used
// in the communications kernel.  By downloading the context save area
// to PC memory (int the array CTXT[]) programs can have access to the
// DSP's registers.   By then modifying and reloading these values
// the user can modify the runtime parameters.
//
typedef enum { R0F, R1F, R2F, R3F, R4F, R5F, R6F, R7F, // R8i-11i  0- 7
               R0 , R1 , R2 , R3 , R4 , R5 , R6 , R7 , // R8F-11F  8-15
               AR0, AR1, AR2, AR3, AR4, AR5, AR6, AR7, //         16-23
               DP , IR0, IR1, BK , SP , ST , IE , IF , //         24-31
               IOF, RS ,  RE,  RC, PC , FREERUN, T1DIF, CNTXT //  32-39
             } TMS_REGS;

#define CTXTSIZE 40
extern ulong CTXT[];    // DSP register context save array
extern ulong CTXT_PTR;  // DSP Address of where array is located
//
// Prototypes and declarations for OBJECT.CPP
//
extern int   WINDOWS ;
extern int   timeout ;
extern int   Windows_Detected;
extern int   DSK3D;    // Global flag for low level code

extern int   No_MTask;
extern ulong PC_Appli;
extern int   BW_force;

int  DLLEXTEND_EX ports          (int base);
void DLLEXTEND_EX enable_Mtask   (void);
void DLLEXTEND_EX disable_Mtask  (void);
void DLLEXTEND_EX Release_TSlice (void);
MSGS Detect_Windows   (void);
MSGS Scan_Command_line(char *app_name);
MSGS Display_manual   (char     *name);
MSGS View_Manual      (char     *name);
//
// Edit the hardware manual to have the name of the app and options
void Edit_Help_Msg(char *app_name, char *sw1, char *desc);
MSGS DLLEXTEND_EX Init_Communication(int loops);
MSGS DLLEXTEND_EX get_buswidth  (void);
MSGS DLLEXTEND_EX set_buswidth  (void);
MSGS Disp_Menu(char *banner, char huge *msg,int,int,int,int);

#define FRAME2 "ɻȼ" /* Double bar frame  */
#define FRAME1 "ڿٳ" /* Single bar frame  */
#define FRAME0 "      " /* Plain text window */

extern float DSK3_rev; // Global version variable available to all apps

#endif
