//---------------------------------------------------------------
// C3XMMRS.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//----------------------------------------------------------------
#ifndef __C3XMMRS
#define __C3XMMRS
//
//MMR address locations for the TMS320C30 and TMS320C31
//
#define DMA_ctrl   0x808000L /* DMA cntl                  */
#define DMA_srce   0x808004L /* DMA srce address          */
#define DMA_dest   0x808006L /* DMA dest address          */
#define DMA_xfr    0x808008L /* DMA xfer counter          */
#define T0_ctrl    0x808020L /* TIM0 gl control           */
#define T0_count   0x808024L /* TIM0 count                */
#define T0_prd     0x808028L /* TIM0 prd                  */
#define T1_ctrl    0x808030L /* TIM1 gl control           */
#define T1_count   0x808034L /* TIM1 count                */
#define T1_prd     0x808038L /* TIM1 prd                  */
#define S0_gctrl   0x808040L /* SP 0 global control       */
#define S0_xctrl   0x808042L /* SP 0 FSX/DX/CLKX port ctl */
#define S0_rctrl   0x808043L /* SP 0 FSR/DR/CLKR port ctl */
#define S0_tctrl   0x808044L /* SP 0 R/X timer control    */
#define S0_tcount  0x808045L /* SP 0 R/X timer counter    */
#define S0_tprd    0x808046L /* SP 0 R/X timer period     */
#define S0_xdata   0x808048L /* SP 0 Data transmit        */
#define S0_rdata   0x80804CL /* SP 0 Data receive         */
#define S1_gctrl   0x808050L /* SP 1 global control       */
#define S1_xctrl   0x808052L /* SP 1 FSX/DX/CLKX port ctl */
#define S1_rctrl   0x808053L /* SP 1 FSR/DR/CLKR port ctl */
#define S1_tctrl   0x808054L /* SP 1 R/X timer control    */
#define S1_tcount  0x808055L /* SP 1 R/X timer counter    */
#define S1_tprd    0x808056L /* SP 1 R/X timer period     */
#define S1_xdata   0x808058L /* SP 1 Data transmit        */
#define S1_rdata   0x80805CL /* SP 1 Data receive         */
#define e_buscon   0x808060L /* Exp bus control           */
#define p_buscon   0x808064L /* Pri bus control           */

#endif
