;---------------------------------------------------------------------
; TMS320C3x DSK COMMUNICATIONS AND DEBUG MONITOR KERNEL
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; Update history
; --------------
; 5/25/96  Added _FREERUN to context save array to indicate if the
;          DSK is currently running code or executing the spin 0 loop.
;          This feature allows applications such as REGVIEW.EXE to
;          better cooperate with the debugger.
;
; 6/27/96  Add Timer 1 store for context save and restore allowing
;          the debugger to calculate a time difference if the period
;          of the timer is set to a large value and is running
;
; 7/14/96  The kernel was modified to include C3XMMRS.ASM rather than
;          only a fragment of the MMR (memory mapped register)
;          definitions being added within the body of the kernel.
;
;          The contents of JSPARE were changed to hold the address
;          of the function SR2.  This gives the user easier access
;          to the common return function 'SR2' used by most DSK
;          commands. See MANDEL.ASM for an example of how to install
;          a user defined function.
;
; 5/12/97  Edited explaination for PRI/SEC vector tables.
;          Added location information to the symbol table that the
;          debugger can use to automatically determine where to
;          find certain variables locations.  This helps in porting
;          between C31/C32 targets.  Also added a C31/C32 select switch
;
; LOCATING THE KERNEL IN MEMORY
; -----------------------------
; For proper operation and maximum use of memory the kernel needs to
; be located in memory such that the last address is just before the
; secondary vector branch table.  Since the assembler only creates
; runtime code the size of the kernel is not known until after
; assembly is complete.  The reported size (bottom of output) of
; "kernel" is then used to offset the section exactly.
;
; COMMUNICATION MONITOR START & DEFAULT STACK
; -------------------------------------------
;   The section of unoccupied free memory just below the kernel is
; used on initialization and later becomes the default stack.  The
; user can then either modify this stack location within their code.
;
; When initialization is complete, the startup stub can be safely
; overwritten since it is no longer needed.  In this case the startup
; stub is placed within the stack.
;
; This section of code also initializes the timers which are used by
; the PAL to create the PWM signal which drives the LED.  The rate
; at which the LED changes color is F0-F1 where F0 and F0 are the two
; timer output frequencies. (See the Users Guide)
;=====================================================================
TARGET_EVM .set  1
TARGET_DSK .set  0
TARGET_C32 .set  0
T0_cut   .set    0
T0cut    .set    0
;-----------------------------------
         .include "C3XMMRS.ASM" ; Target type defined here
PRD0     .set   0x00005000      ; Timer (set for PWM) default rate
PRD1     .set   0x00005020      ;
TSTART   .set   0x000003C3      ; reset and restart value for timers
SIZELOC  .set   WSCOUNT         ; Where HPI readback info is kept
VECTLOC  .set   vectors         ; Vector table location
STEPLOC  .set   spin0           ; OR 0x40,IE is safe 1 cycle code to step
SP_DFLT  .set   stack-1         ; Default stack used for file reloads
         ;----------------------
          .if TARGET_EVM        ;
HP_INT     .set  0x7
 .start  "vectors",0x809FC1     ;
 .start  "kernel",vectors-0xB1  ; offset by kernel length to
 .start  "sstack",0x809F00      ; pack to end of RAM
HP_ADDR  .set   0x804000        ; Location of HPI
DASMBGN  .set   0x809800        ; Default begin for DASM window (CSAVEALL)
         .endif                 ;
         ;----------------------
          .if TARGET_DSK        ;
HP_INT     .set  0x4
 .start  "vectors",0x809FC1     ;
         .if T0cut
 .start  "kernel",vectors-0xBC  ; offset by kernel length to
         .else
 .start  "kernel",vectors-0xB1  ; offset by kernel length to
         .endif
         .if T0cut
 .start  "sstack",0x809EC0      ; pack to end of RAM
         .else
 .start  "sstack",0x809F00      ; pack to end of RAM
         .endif
HP_ADDR  .set   0xF00000        ; Location of HPI
DASMBGN  .set   0x809800        ; Default begin for DASM window (CSAVEALL)
         .endif                 ;
         ;----------------------
         .if TARGET_C32         ;
HP_INT     .set  0x4
 .start  "vectors",0x0          ; Load locations for C32 kernel
 .start  "kernel" ,0x20         ;
 .start  "sstack" ,0x100        ;
HP_ADDR  .set   0xF00000        ; Location of HPI
DASMBGN  .set   0x809810        ; Default begin for DASM window (CSAVEALL)
         .endif                 ;
;===============================================;
;===== START CODE (START STUB) BEGINS HERE =====;
;===============================================;
        .sect   "sstack"        ;
stack:  .word   stack-1         ; default stack location (note pre-inc of SP)
;- - - - - - - - - - - - - - - -
         .entry START           ;
START   ldp     @START          ; Set up stack and other params
        ldi     @stack,SP       ;
        ;=======================  Init T0&T1 for slow PWM modulation
        ldi     PRD0,R0         ; Init periods (note they are different)
        sti     R0,@T0_prd      ;
        ldi     PRD1,R0         ;
        sti     R0,@T1_prd      ;
        ldi     TSTART,R0       ; Start timers (reset and restart)
        sti     R0,@T0_ctrl     ;
        sti     R0,@T1_ctrl     ;
        b       spin0           ;
;========================================================================;
; DEBUGGER COMMANDS                                                      ;
;   The debugger commands are assembled into the lowest available kernel ;
;   memory.  If an application were to overgow this section the debugger ;
;   functions would be corrupted, but the application would continue to  ;
;   run so long as the debugger functions were not used.                 ;
;========================================================================;
; XSTEP/XRUNF                                                            ;
;                                                                        ;
;   These functions restore the CPU registers from the context save area ;
; before returning to the code pointed to by the program counter value.  ;
; The only difference is that XSTEP purposely sets the interrupt flag    ;
; used for single stepping before returning to the users code.           ;
;                                                                        ;
; SINGLE STEPPING                                                        ;
;   The tail end of this function is written such that a pending         ;
; interrupt will not be serviced until one opcode has been fetched from  ;
; the return address and executed (there may be other dummy fetches).    ;
; This 'pending' interrupt then causes the processor to return back to   ;
; the context save routine, effectively singlestepping the CPU.          ;
;                                                                        ;
;========================================================================;
        .sect   "kernel"
XSTEP   or      0x40,IF         ; set  XINT1 (safe INT for C31/C32 debug!)
XRUNF   or      0xC0|HP_INT,IE  ; set EXINT1 (safe INT for C31/C32 debug!)
        ;-----------------------
        sti     IE,@_FREERUN    ; FREERUN !=0 indicates DSK is not HALT'ed
        ;-----------------------
        ldi     @CPUCTXT,AR0    ; Use parallel opcodes for squeeze
        ldi     AR0,AR1         ;
        addi    1,AR1           ;
        ldi     2,IR0           ;
        ;-----------------------
        ldf     *AR0++(IR0),R0  ; load floats (exponents)
    ||  ldf     *AR1++(IR0),R1  ;
        ldf     *AR0++(IR0),R2  ;
    ||  ldf     *AR1++(IR0),R3  ;
        ldf     *AR0++(IR0),R4  ;
    ||  ldf     *AR1++(IR0),R5  ;
        ldf     *AR0++(IR0),R6  ;
    ||  ldf     *AR1++(IR0),R7  ;
        ;- - - - - - - - - - - -
        ldi     *AR0++(IR0),R0  ; load longs (mantissa)
    ||  ldi     *AR1++(IR0),R1  ;
        ldi     *AR0++(IR0),R2  ;
    ||  ldi     *AR1++(IR0),R3  ;
        ldi     *AR0++(IR0),R4  ;
    ||  ldi     *AR1++(IR0),R5  ;
        ldi     *AR0++(IR0),R6  ;
    ||  ldi     *AR1++(IR0),R7  ;
        ;- - - - - - - - - - - -
        ldi      @_AR0,AR0      ; load ARx
        ldi      @_AR1,AR1      ;
        ldi      @_AR2,AR2      ;
        ldi      @_AR3,AR3      ;
        ldi      @_AR4,AR4      ;
        ldi      @_AR5,AR5      ;
        ldi      @_AR6,AR6      ;
        ldi      @_AR7,AR7      ;
        ldi      @_IR0,IR0      ;
        ldi      @_IR1,IR1      ;
        ldi      @_IOF,IOF      ; IO flags
        ldi      @_RS,RS        ; Repeat start
        ldi      @_RE,RE        ; Repeat end
        ldi      @_RC,RC        ; Repeat counter
        ldi      @_BK,BK        ; Block size
        ldi      @_SP,SP        ; get user SP
        ;- - - - - - - - - - - -
        ldi      @T1_count,R5   ; Double T1 value, catch transistions
        addi     @T1_count,R5   ; Effectively gives x2 timer accuracy
        sti      R5,@_dT        ; Store result
        ;- - - - - - - - - - - -
        ldi      @_PC,R5        ; return to PC from TOS return
        andn     HP_INT,IF      ; Clear/Poll INT2 before SSTEP or RUNF
        tstb     HP_INT,IF      ;
        bnz      $-3            ;

        .if    T0_cut           ;;;;;
        ldiu   @TIM0CTRL,R5     ;;;;; restart timer
        sti    R5,@T0_ctrl      ;;;;;
        ldi      @_PC,R5        ;;;;; Temp fix...
        .endif                  ;;;;;

        ldiu     @_ST,ST        ; restore Status
        or       @_IE,IE
        BUD      R5             ;
        or       0x2000,ST      ; turn on INT's
        ldiu     @_R5,R5        ;
        ldiu     @_DP,DP        ; restore DP
;========================================================================;
; XHALT                                                                  ;
;   When called this function restores the temporary use registers used  ;
; for quick returns from the XWRITE/XREAD before falling into a full     ;
; context save, followed by waiting for a new command.                   ;
;========================================================================;
XHALT   pop     AR1             ; restore original registers before save
        pop     AR0             ;
        pop     IR1             ;
        pop     R0              ;
        pop     DP              ;
        pop     ST              ; User PC now at TOS
;========================================================================;
; SSTEP                                                                  ;
;   This section of code is executed after the pending interrupt, which  ;
; was set in XSTEP, has feteched the ISR vector and begun execution.     ;
; This code performs a full CPU context save before going to the spin    ;
; loop to await further commands.                                        ;
;========================================================================;
SSTEP   push    DP              ; temp storage of user DP
        ldp     @_ST            ; DP for kernal
        sti     ST,@_ST         ; store ST
        sti     IR0,@_IR0       ; IR0 used as temp, later for indexed store
        pop     IR0             ; save user DP
        sti     IR0,@_DP        ;
        pop     IR0             ; save user PC
        sti     IR0,@_PC        ;
        sti     SP,@_SP         ; save user SP
        sti     BK,@_BK         ; Block size
        sti     IE,@_IE         ; Internal int enable
        sti     IF,@_IF         ; CPU interrupt flags
        sti     IOF,@_IOF       ; IO flags
        sti     RS,@_RS         ; Repeat start
        sti     RE,@_RE         ; Repeat end
        sti     RC,@_RC         ; Repeat counter
     ;  sti     IR0,@_IR0       ; Keep everything  <- IR0 Saved previously
        sti     IR1,@_IR1       ;
        ;- - - - - - - - - - - -
        sti     AR0,@_AR0       ; Use parallel opcodes for squeeze
        sti     AR1,@_AR1       ;
        ldi     @CPUCTXT,AR0    ;
        ldi     AR0,AR1         ;
        addi    1,AR1           ;
        ldi     2,IR0           ;
        ;- - - - - - - - - - - -
        stf     R0,*AR0++(IR0)  ; Store floats
    ||  stf     R1,*AR1++(IR0)  ;
        stf     R2,*AR0++(IR0)  ;
    ||  stf     R3,*AR1++(IR0)  ;
        stf     R4,*AR0++(IR0)  ;
    ||  stf     R5,*AR1++(IR0)  ;
        stf     R6,*AR0++(IR0)  ;
    ||  stf     R7,*AR1++(IR0)  ;
        ;- - - - - - - - - - - -
        sti     R0,*AR0++(IR0)  ; Store longs
    ||  sti     R1,*AR1++(IR0)  ;
        sti     R2,*AR0++(IR0)  ;
    ||  sti     R3,*AR1++(IR0)  ;
        sti     R4,*AR0++(IR0)  ;
    ||  sti     R5,*AR1++(IR0)  ;
        sti     R6,*AR0++(IR0)  ;
    ||  sti     R7,*AR1++(IR0)  ;
        ;- - - - - - - - - - - -
        sti     AR2,@_AR2       ; AR0 & AR1 Already saved
        sti     AR3,@_AR3       ;
        sti     AR4,@_AR4       ;
        sti     AR5,@_AR5       ;
        sti     AR6,@_AR6       ;
        sti     AR7,@_AR7       ;
        .if T0_cut              ; Since SSTEP can be reached by singlestep,
        call    StopT0          ; (not a command) a stop is needed.
        .endif                  ;
;-------------------------------
        ldi      @T1_count,R0   ; Double T1 value, catch transistions
        addi     @T1_count,R0   ; Effectively gives x2 timer accuracy
        subi     @_dT,R0        ; calculate difference
        sti      R0,@_dT        ; store result
        ;- - - - - - - - - - - -
        ldi     0,R0            ; FREERUN=0 indicates HALT (spin0)
        sti     R0,@_FREERUN    ;
TRAP_AK call    W_HOST          ; Send acknowledge (Zero) to host
     ;  b       spin0           ; <- Branch is removed (spin0 is inline)
;--------------------------------------------------------------------;
; The spin0 code loop is used by the kernel as a known program loop  ;
; when a process is halted.  While in the spin loop, commands can be ;
; processed.  This code loop is primarily used while debugging or    ;
; during startup as a known useable code loop.                       ;
;--------------------------------------------------------------------;
spin0
        .if    T0_cut           ;;;;;
        call   StopT0           ;;;;;
        .endif                  ;;;;;
        ldi     HP_INT,IE       ; Enable HPI interrupts (all others off)
    ;   or      GIE,ST          ; Enable ints, No power save, run full speed
    ;   idle                    ; IDLE saves power but prevent S.P. refresh
        idle2                   ; IDLE2 saves most power and shuts down all
        b       spin0           ; peripherals since all clocks are stopped
;=====================================================================;
; REGISTER CONTEXT STORAGE                                            ;
;  This block of memory holds the register values when a process is   ;
;  stopped.  Essentially the registers displayed in the debugger are  ;
;  the contents of this memory block.                                 ;
;=====================================================================;
_F0             .float  0       ; F0
_F1             .float  0       ; F1
_F2             .float  0       ; F2
_F3             .float  0       ; F3
_F4             .float  0       ; F4
_F5             .float  0       ; F5
_F6             .float  0       ; F6
_F7             .float  0       ; F7
_R0             .word   0       ; R0
_R1             .word   0       ; R1
_R2             .word   0       ; R2
_R3             .word   0       ; R3
_R4             .word   0       ; R4
_R5             .word   0       ; R5
_R6             .word   0       ; R6
_R7             .word   0       ; R7
_AR0            .word   0       ; AR0
_AR1            .word   0       ; AR1
_AR2            .word   0       ; AR2
_AR3            .word   0       ; AR3
_AR4            .word   0       ; AR4
_AR5            .word   0       ; AR5
_AR6            .word   0       ; AR6
_AR7            .word   0       ; AR7
_DP             .word   0       ; Data page
_IR0            .word   0       ; Index register 0
_IR1            .word   0       ; Index register 1
_BK             .word   0       ; Block size
_SP             .word   stack   ; Stack pointer (initial DSK3D value)
_ST             .word   0       ; Status
_IE             .word   0       ; Internal int enable
_IF             .word   0       ; CPU interrupt flags
_IOF            .word   0       ; I/O flags
_RS             .word   0       ; Repeat start
_RE             .word   0       ; Repeat end
_RC             .word   0       ; Repeat counter
_PC             .word   0       ; program counter
_FREERUN        .word   0       ; 1=DSK is free running, 0=DSK is HALT'ed
_dT             .word   0       ; Calculated TIM1 delta between run-halt
CPUCTXT         .word   _F0     ;
;********************************************************************;
; KERNEL COMMANDS                                                    ;
; ---------------                                                    ;
;   These commands are the primary functions required by the kernel  ;
; to perform host based communications.  They have been packed into  ;
; the avalable memory in such a way as to minimize the kernels size. ;
; The non-debugger functions have also been placed after the debugger;
; commands making it easier to simply allow the application to       ;
; 'overwrite' the debugger commands.                                 ;
;********************************************************************;
;====================================================================;
; INTx is the starting point for all host generated commands.        ;
; A host generated command is received when INT2 goes active (driven ;
; low) indicating HPSTB has gone low and that the host would like to ;
; transfer a piece of data or command.                               ;
;====================================================================;
        .if    T0_cut           ;; Stop timer 0
StopT0  ldi    @T0_ctrl,R0      ;; Save user defined T0_ctrl
        cmpi   0x201,R0         ;; No need to re-stop and corrupt TIM0CTRL
        beq    NoStop           ;;
        or     0xC0,R0          ;; Set restart bits
        sti    R0,@TIM0CTRL     ;;
        ldi    0x201,R0         ;; Halt the timer
        sti    R0,@T0_ctrl      ;;
NoStop  rets                    ;;
        .endif                  ;;
;--------------------------------
INTx    push    ST              ; Push ISR variables
        push    DP              ;
        push    R0              ; NOTE: A HALT command pops these
        push    IR1             ;       values followed by a full save
        push    AR0             ;
        push    AR1             ;
        ldp     @JUMP           ; Get address of command from JUMP table

        .if     T0_cut
        call    StopT0
        .endif

     .if TARGET_EVM
        or      HP_INT,IF       ; Set any INTx to get through WAIT4 1x
     .else
        tstb    HP_INT,IF       ; Get here by driving INT2 low
        bz      SR2             ; Make sure INT2 is active
     .endif
        call    R_HOST          ; R0==command
        ldi     R0,AR1          ; Get command function address from table
        addi    @JUMP,AR1       ;
        ldi     *AR1,AR1        ;
        b       AR1             ; execute command
;********************************************************************
; COMN is used by both the XWRIT and XREAD functions to receive the
; block transfer length, address and address increment value.
;********************************************************************
COMN    call    R_HOST          ;
        ldi     R0,AR1          ; data packet length
        call    R_HOST          ;
        ldi     R0,AR0          ; source address
        call    R_HOST          ;
        ldi     R0,IR1          ; source index
        subi    1,AR1           ;
        rets                    ;
;====================================================================;
; The XCTXT command returns the address of the context save area to  ;
; the host.  Subsequently, the host can use this address to 'get'    ;
; and put the CPU registers to modify the exectution of the processor;
;--------------------------------------------------------------------;
XCTXT   ldi     @CPUCTXT,R0     ; Transmit location of context to CPU
        call    W_HOST          ;
    ;   b       SR2             ; B to next address is not needed
;====================================================================;
; SR2 is the short 'common' return sequence used by most commands.   ;
; when executed, the return will send the CPU back to the users code ;
;====================================================================;
SR2     ldi     0x7F00,AR0      ; Dummy non-HPI read releases READY
        ldi     *AR0,AR0        ;
        pop     AR1             ; restore ISR variables
        pop     AR0             ;
        pop     IR1             ;

        .if    T0_cut           ;;;;;
        ldi    @TIM0CTRL,R0     ;;;;; restart timer/sp
        sti    R0,@T0_ctrl      ;;;;;
        .endif                  ;;;;;

        pop     R0              ;
        pop     DP              ;
        pop     ST              ;
        reti                    ; return to original code

        .if T0cut
TIM0CTRL .word    TSTART ; 0x3C3
        .endif
;====================================================================;
; TMS320C31 SECONDARY 'BRANCH' TABLE                                 ;
; ----------------------------------                                 ;
;   When the TMS320C31 receives an interrupt it first fetches an     ;
; address from the primary vector table (located in the bootloader   ;
; ROM).  This 32 bit value is then used as the PC address where the  ;
; new execution begins.                                              ;
;                                                                    ;
;   Since the C31 ROM vector table cannot be relocated or modified,  ;
; the contents of the bootloader ROM are filled with vectors that    ;
; point to a 'secondary' or 'branch' table in the internal RAM       ;
; space beginning at 0x809FC1.  The branch table (in RAM) can then   ;
; be modified to direct execution to the correct ISR routine.        ;
;====================================================================;
HPADDR  .word   HP_ADDR         ;
        .sect   "vectors"
INT0    b       $               ; 0x809FC1  0x001          EVM hcontrol
INT1    b       INTx            ; 0x809FC2  0x002          EVM hwrite16
INT2    b       INTx            ; 0x809FC3  0x004 <- HPI   EVM hread16
INT3    b       $               ; 0x809FC4  0x008
XINT0   b       $               ; 0x809FC5  0x010
RINT0   b       $               ; 0x809FC6  0x020
XINT1   b       SSTEP           ; 0x809FC7  0x040 <- SSTEP
RINT1   b       SSTEP; TRAPFIX  ; 0x809FC8  0x080 <- ETRAP 0x74000008
TINT0   b       $               ; 0x809FC9  0x100
TINT1   b       $               ; 0x809FCA  0x200
DINT    b       $               ; 0x809FCB  0x400
;====================================================================;
; HOST HPI communications routines packed into himem                 ;
;                                                                    ;
;  NOTE: These routines can be called from a high level langauge     ;
;  compiler using the C31s TRAP commands, by directly linking their  ;
;  resolved addresses or by using the jump table.                    ;
;====================================================================;
        .if     TARGET_EVM      ; Comm routines for EVM30
        ;-----------------------
R_HOST  bud     R_HOSTx         ;
W_HOST  push    AR0             ; Used for HPI address
        push    AR1             ; Used for loop counter
        ldi     @HPADDR,AR0     ;
        sti     R0,*+AR0(0)     ; Store lsbs to HPI
        call    WAIT4           ;
        lsh     -16,R0          ; shift to next lsbs
        sti     R0,*+AR0(15)    ; Store lsbs to HPI
        call    WAIT4           ; loop until done
        b       COMNHST         ;
        ;-----------------------
R_HOSTx push    R1              ; temp register
        call    WAIT4           ;
        ldi     *+AR0(0),R0     ; Load byte
        lsh     16,R0           ; shift to upper byte
        call    WAIT4           ;
        ldi     *+AR0(15),R1    ; Load byte
        lsh     16,R1           ;
        lsh     -16,R0          ;
        or      R1,R0           ; or w/result
        pop     R1              ; restore
COMNHST pop     AR1             ; Next 4 opcodes common to W_HOST/R_HOST
        pop     AR0             ;
        rets                    ;
        ;- - - - - - - - - - - -
WAIT4   tstb    HP_INT,IF       ;
        bz      WAIT4           ;
        andn    HP_INT,IF       ;
        rets                    ;
;====================================================================;
; C31 DSK COMM ROUTINES                                              ;
;   W_HOST performs an interlocked Host Port write of the contents   ;
; of R0 to the host using the HPSTB/HPACK protocol.  When called the ;
; host PC should be waiting for this function to send data.          ;
;====================================================================;
;   R_HOST performs an interlocked Host Port read from the printer   ;
; port interface and places the result into R0.                      ;
;====================================================================;
        .else
R_HOST  bud     R_HOSTx         ; BUD reuses next 3 lines of code
W_HOST  push    AR0           ;1; Used for HPI address
        push    AR1           ;2; Used for loop counter
        push    DP            ;3; Might not be on same page
        ldp     HPADDR          ;
        ldi     @HPADDR,AR0     ; Load AR0=HPI address
        ldi     @WSCOUNT,AR1    ;
WH      sti     R0,*AR0++(16)   ; Store lsbs to HPI
        lsh     @WSHIFT,R0      ; shift to next lsbs
        db      AR1,WH          ; loop until done
        b       COMNHST         ;
        ;-----------------------
RSCOUNT .set    3               ; 4 chunks, 8 bits each
RSHIFT  .set    24              ; 32-(32/chunks)
R_HOSTx ldp     HPADDR          ;
        ldi     @HPADDR,AR0     ; Load AR0=HPI address
        push    R1              ; temp register
        ldi     RSCOUNT,AR1     ; recv RSCOUNT+1 chunks (4x8 bits each)
RH      lsh     RSHIFT-32,R0    ; shift result right
        ldi     *AR0++,R1       ; Load byte
        lsh     RSHIFT,R1       ; shift to upper byte
        or      R1,R0           ; or w/result
        db      AR1,RH          ; loop until done
        pop     R1              ; restore
COMNHST pop     DP              ;
        pop     AR1             ; Next 4 opcodes common to W_HOST/R_HOST
        pop     AR0             ;
        rets                    ;
        .endif                  ;
;====================================================================;
;   XWRIT is a host port command designed to transfer a block of     ;
; data from the host to the C31's memory.                            ;
;====================================================================;
XWRIT   call    COMN            ;
XW1     call    R_HOST          ;
        sti     R0,*AR0++(IR1)  ;
        db      AR1,XW1         ;
        b       SR2             ;
;====================================================================;
;   XREAD is a host port command designed to transfer a block of     ;
; data from C31 memory to the host.                                  ;
;====================================================================;
XREAD   call    COMN            ;
XR1     ldi     *AR0++(IR1),R0  ;
        call    W_HOST          ;
        db      AR1,XR1         ;
        b       SR2             ;
;====================================================================;
;   There are a few leftover traps that can be used by appliactions  ;
; The number of TRAPs coincides with the amount of available unused  ;
; memory before the JUMP table is encountered and was adjusted by    ;
; hand by looking at the assembler listing                           ;
;====================================================================;
TRAPS   .loop   0x809FF4-$
        b       $               ;
        .endloop
;====================================================================;
; A JUMP table can also be used to access the DSK3 routines from     ;
; other applications that require host communications.  In this case ;
; the contents of the loaction specified can be used in a register   ;
; call or branch.                                                    ;
;====================================================================;
         .start "JMPTBL",0x809FF4
         .sect  "JMPTBL"
JUMP    .word   JUMP      ;Enum Value ;0x809FF4 Jump table base address
        .word   XWRIT     ; 1         ;0x809FF5 for DSK3 routines
        .word   XREAD     ; 2         ;0x809FF6
        .word   XCTXT     ; 3         ;0x809FF7
        .word   XRUNF     ; 4         ;0x809FF8
        .word   XSTEP     ; 5         ;0x809FF9
        .word   XHALT     ; 6         ;0x809FFA
        .word   W_HOST    ; 7         ;0x809FFB
        .word   R_HOST    ; 8         ;0x809FFC
CHAIN   .word   SR2       ; 9         ;0x809FFD  User defined command
;====================================================================;
; The last two locations of internal memory hold the two parameters  ;
; which define the printer ports bus return width.  Depending on the ;
; values, either 8 bit bi-directional or 4 bit nibble returns can    ;
; be implimented.  These values control the loop count and shift     ;
; value needed to place the correct bits on the proper return buffer ;
; inputs.                                                            ;
;                                                                    ;
; DO NOT OVERWITE THESE VALUES unless you are performing buswidth    ;
; verification or setup.  For more details, see the communications   ;
; initialization routines within the host side code.                 ;
;====================================================================;
        .if TARGET_EVM          ;
WSCOUNT .word   1               ;0x809FFE These locations hold the W_HOST
WSHIFT  .word   -16             ;0x809FFF buswidth parameters (Nibble/Byte)
        .else
WSCOUNT .word   7               ;0x809FFE These locations hold the W_HOST
WSHIFT  .word   -4              ;0x809FFF buswidth parameters (Nibble/Byte)
        .endif
;=====================================================================;
; The following variables are added to the kernel to make it easier   ;
; port to other targets.  For backward compatability, the host side   ;
; code is written such that the default values for a C31 DSK are      ;
; maintained even if these are not included in the kernel             ;
;=====================================================================;
        .if     TARGET_EVM
        .start  "C30EVMVECS",0
        .sect   "C30EVMVECS"
        .word   0x809FC0      ; RESET
        .word   0x809FC1      ; INT0
        .word   0x809FC2      ; INT1
        .word   0x809FC3      ; INT2
        .word   0x809FC4      ; INT3
        .word   0x809FC5      ; XINT0
        .word   0x809FC6      ; RINT0
        .word   0x809FC7      ; XINT1
        .word   0x809FC8      ; RINT1
        .word   0x809FC9      ; TINT0
        .word   0x809FCA      ; TINT1
        .word   0x809FCB      ; DMA
        .word   0x809FCC      ; RESERVED (negative traps)
        .word   0x809FCD      ;
        .word   0x809FCE      ;
        .word   0x809FCF      ;
        .word   0x809FD0      ;
        .word   0x809FD1      ;
        .word   0x809FD2      ;
        .word   0x809FD3      ;
        .word   0x809FD4      ;
        .word   0x809FD5      ;
        .word   0x809FD6      ;
        .word   0x809FD7      ;
        .word   0x809FD8      ;
        .word   0x809FD9      ;
        .word   0x809FDA      ;
        .word   0x809FDB      ;
        .word   0x809FDC      ;
        .word   0x809FDD      ;
        .word   0x809FDE      ;
        .word   0x809FDF      ;
        ;---------------------
        .word   0x809FE0      ; TRAP 0
        .word   0x809FE1      ; TRAP 1
        .word   0x809FE2      ; TRAP 2
        .word   0x809FE3      ; TRAP 3
        .word   0x809FE4      ; TRAP 4
        .word   0x809FE5      ; TRAP 5
        .word   0x809FE6      ; TRAP 6
        .word   0x809FE7      ; TRAP 7
        .word   0x809FE8      ; TRAP 8
        .word   0x809FE9      ; TRAP 9
        .word   0x809FEA      ; TRAP 10
        .word   0x809FEB      ; TRAP 11
        .word   0x809FEC      ; TRAP 12
        .word   0x809FED      ; TRAP 13
        .word   0x809FEE      ; TRAP 14
        .word   0x809FEF      ; TRAP 15
        .word   0x809FF0      ; TRAP 16
        .word   0x809FF1      ; TRAP 17
        .word   0x809FF2      ; TRAP 18
        .word   0x809FF3      ; TRAP 19
        .word   0x809FF4      ; TRAP 20
        .word   0x809FF5      ; TRAP 21
        .word   0x809FF6      ; TRAP 22
        .word   0x809FF7      ; TRAP 23
        .word   0x809FF8      ; TRAP 24
        .word   0x809FF9      ; TRAP 25
        .word   0x809FFA      ; TRAP 26
        .word   0x809FFB      ; TRAP 27
        .word   0x809FFC      ; TRAP 28
        .word   0x809FFD      ; TRAP 29
        .word   0x809FFE      ; TRAP 30
        .word   0x809FFF      ; TRAP 31
        .endif
        .end

