/* File C30MMRS.H */

#ifndef _C30MMRS
#define _C30MMRS

volatile long *dma_ctrl = (volatile long *) 0x808000;  /*  DMA control                      */
volatile long *dma_srce = (volatile long *) 0x808004;  /*  DMA source address               */
volatile long *dma_dest = (volatile long *) 0x808006;  /*  DMA destination address          */
volatile long *dma_xfr  = (volatile long *) 0x808008;  /*  DMA transfer counter             */

volatile long *T0_ctrl  = (volatile long *) 0x808020;  /*  Timer 0 global control           */
volatile long *T0_count = (volatile long *) 0x808024;  /*  Timer 0 counter                  */
volatile long *T0_prd   = (volatile long *) 0x808028;  /*  Timer 0 period                   */
volatile long *T1_ctrl  = (volatile long *) 0x808030;  /*  Timer 1 global control           */
volatile long *T1_count = (volatile long *) 0x808034;  /*  Timer 1 counter                  */
volatile long *T1_prd   = (volatile long *) 0x808038;  /*  Timer 1 period                   */

volatile long *S0_gctrl = (volatile long *) 0x808040;  /*  Serial 0 global control          */
volatile long *S0_xctrl = (volatile long *) 0x808042;  /*  Serial 0 FSX/DX/CLKX port control*/
volatile long *S0_rctrl = (volatile long *) 0x808043;  /*  Serial 0 FSR/DR/CLKR port control*/
volatile long *S0_tctrl = (volatile long *) 0x808044;  /*  Serial 0 R/X timer control       */
volatile long *S0_tcount= (volatile long *) 0x808045;  /*  Serial 0 R/X timer counter       */
volatile long *S0_tprd  = (volatile long *) 0x808046;  /*  Serial 0 R/X timer period        */
volatile long *S0_xdata = (volatile long *) 0x808048;  /*  Serial 0 Data transmit           */
volatile long *S0_rdata = (volatile long *) 0x80804C;  /*  Serial 0 Data receive            */

volatile long *S1_gctrl = (volatile long *) 0x808050;  /*  Serial 1 global control          */
volatile long *S1_xctrl = (volatile long *) 0x808052;  /*  Serial 1 FSX/DX/CLKX port control*/
volatile long *S1_rctrl = (volatile long *) 0x808053;  /*  Serial 1 FSR/DR/CLKR port control*/
volatile long *S1_tctrl = (volatile long *) 0x808054;  /*  Serial 1 R/X timer control       */
volatile long *S1_tcount= (volatile long *) 0x808055;  /*  Serial 1 R/X timer counter       */
volatile long *S1_tprd  = (volatile long *) 0x808056;  /*  Serial 1 R/X timer period        */
volatile long *S1_xdata = (volatile long *) 0x808058;  /*  Serial 1 Data transmit           */
volatile long *S1_rdata = (volatile long *) 0x80805C;  /*  Serial 1 Data receive            */

volatile long *e_buscon = (volatile long *) 0x808060;  /*  Expansion bus control            */
volatile long *p_buscon = (volatile long *) 0x808064;  /*  Primary bus control              */

#endif
