*File name: sldrv201.h                                          *  
*Include file with programming variable declarations            *
*Common to flash and bootcode algorithms                        * 
*                                                               *
*Rev 2.00                                                       *
*Written by: Sam Saba, TI Houston                       9/8/97  *
*****************************************************************
        .mmregs
; Memory variables specific to flash algorithms
***************************************************
BASE    .set    068h             ; Base address for variables
B2_0    .set    BASE+0           ; can be changed to relocate
B2_1    .set    BASE+1           ; variable space in RAM
B2_2    .set    BASE+2
B2_3    .set    BASE+3
B2_4    .set    BASE+4
B2_5    .set    BASE+5
B2_6    .set    BASE+6
nextsect .set   BASE+7
FDEST    .set   BASE+8
B2PA_3  .set    BASE+9          ; Program start address

* Variables for Uart_loader
***************************************************
B2      .set 72h
B2S_0   .set B2+0h              ; Scratch registers
B2S_1   .set B2+1h
B2PA_2  .set B2+2h              ; Program start address
*
B2PL_4  .set B2+4h              ; Program Length
B2PD_5  .set B2+5h              ; Program Code/Data
B2D_6   .set B2+6h              ; Variables
B2D_7   .set B2+7h
B2FM_8  .set B2+8h              ; Flag for start Data move - Data_move
B2FH_9  .set B2+9h              ; Flag for Header receive - Header_done
B2FD_a  .set B2+0ah             ; Flag for data move complete - Data_ready
B2FSH   .set B2+0bh             ; High word check sum
B2FSL   .set B2+0ch             ; Low word check sum

* On-chip I/O registers

PMST      .set    0FFE4h  ;Defines SARAM in PM/DM and MP/MC bit
* SYNC PORT
sdtr	.set    0fff0h
sspcr	.set    0fff1h
sspst   .set    0fff2h
* UART
adtr	.set    0fff4h
aspcr   .set    0fff5h
iosr    .set    0fff6h
brd     .set    0fff7h
