*							  	 
*   TMS320C206/TMS320LC206 Boot Loader Program	,Rev 1.3			 
*   Revision 1.0, 12/18/97
*
*   Revision 1.2, 6/29/98
*
*   Revision 1.3, 11/14/98
*
*   1.1 changes
*   1. Fix 16 bit EPROM load, need pointer for counter
*   2. Fix branching in serial I/O from EQ to TC
*   3. Change original 8 bit boot from using INTR 0 to a BACC instruction
*      and copy boot routine to B0.  This will allow code to be copied to
*      address 0x0h after switching to microprocessor mode.
*   4. Set CNF = program space.
*   5. Add lacl in parallel 16 bit routine to load TEMP
*   6. Change TEMP to TEMP1 for 8 bit parallel I/O.
*
*
*   1.2 Changes
*   1. Change the branch address to 0xFF18 due to incorrect copy.
*   2. Changed address for DMOV on warmboot
*
*   1.3 Changes
*   Fixed the memory pointer problem for EPROM bootloading
*
*   Objective: This bootloader has a total of 9 options and is backward 
*   compatible to the original '203 bootloader.
*
*   Operation:  If the MP/~MC pin is low at reset, the bootloader program 
*               stored in the on-chip ROM will get activated to determine 
*		which method of booting is to be used.
*               First, the program will decide if the C203 style bootloader
*		is to be used by reading the LEVEXT8 bit in the PMST register 
*		which is a direct representation of pin 1 (EXT8).  
*		If not, it will continue to read I/O port zero to determine 
*		which option in the enhanced bootloader to use.
*
*  Refer to c206 bootloader documentation for a complete description of 
*   		bootloader operation.
*
*  Interrupt Vectoring:  Interrupt vectors stored in the on-chip ROM have hard
*			 coded addresses to the on-chip SARAM starting at 
*			 address 8000h in program space.
*
*  Multiple sections booting:  The bootloader allows multiple sections of 
*			       program code to be copied via any of the options
*                              except the old style '203 bootloader.
*                              The first section copied is assumed to be the 
*			       entry point to the program once all section(s) 
*			       have been copied.
*
* Note: B2PA_3 stores the address where execution will begin from, after all
* sections have been loaded 

**** Use C206BOOT.CMD file for linking *****

                .copy "sldrv201.h"         ; Variable and register declaration		
*********************************************************************************
SRC         .set    8000h           ; source address
DEST        .set    60h             ; destination address
DEST1       .set    331h
LENGTH      .set    61h             ; code length
TEMP        .set    62h             ; temporary register
HBYTE       .set    63h             ; temporary storage for upper half of 
				    ; 16-bit word
TEMP1       .set    68h
CODEWORD    .set    64h             ; hold program code word
CODEWORD1   .set    330h            ; hold address for copy for oldboot routine
brs         .set    65h             ; Boot Selection Word
SOURCE      .set    66h
DEST2       .set    67h
b0          .set    0Fh
b1          .set    0Eh
b2          .set    0Dh
b3          .set    0Ch
b4          .set    0Bh
 
*  Interrupt vectors for TMS320C206, TMS320LC206
*
int1_holdv	.set	8000h		; external interrupt vectors
int2_3v         .set    8002h           ;
tintv		.set	8004h		; timer interrupt vector
rintv		.set	801Ah		; receive interrupt vector
xintv		.set	8032h		; transmit interrupt vector
txrxintv        .set  	804Eh       	; UART port interrupt vector
trapv		.set	8050h		; software trap vector
nmiv		.set	8052h		; non-maskable interrupt vector
swi8v		.set	8054h		; software interrupt vectors
swi9v		.set	8056h		; 
swi10v          .set    8058h           ; (Note: If these interrupts are unused
swi11v          .set    805Ah           ; these data memory locations may be
swi12v          .set    805Ch           ; assigned to other purposes.)
swi13v          .set    805Eh           ; Software interrupt vectors
swi14v          .set    8060h           ; |			   |
swi15v          .set    8062h           ; |			   |
swi16v          .set    8064h           ; V			   V
swi20v          .set    8066h           ;
swi21v          .set  	8068h           ;
swi22v          .set  	806Ah           ;
swi23v          .set  	806Ch           ;
swi24v          .set  	806Eh           ;
swi25v          .set  	8070h           ;
swi26v          .set  	8072h           ;
swi27v          .set  	8074h           ;
swi28v          .set  	8076h           ;
swi29v          .set  	8078h           ;
swi30v          .set  	807Ah           ;
swi31v          .set  	807Ch           ;
reserved	.set	807Eh
 
*****************************************************************
       .sect   "vectors"
*****************************************************************
reset   B     boot            	; 0  - power on reset
int1h   B     int1_holdv      	; 1  - external interrupt 1 or HOLD
int23	B     int2_3v		; 2  - external interrupts 2 or 3
tint	B     tintv		; 3  - timer interrupt
rint	B     rintv		; 4  - synchronous serial port receive interrupt
xint	B     xintv		; 5  - synchronous serial port transmit interrupt
txrx    B     txrxintv          ; 6  - asynchronous serial port transmit and
				;      receive interrupt 
res     B       reserved        ; 7  - reserved for emulation
swi8	B	swi8v		; 8  - software interrupt 
swi9	B	swi9v		; 9  - software interrupt 
swi10	B	swi10v		; 10 - software interrupt 
swi11	B	swi11v		; 11 - software interrupt 
swi12	B	swi12v		; 12 - software interrupt 
swi13	B	swi13v		; 13 - software interrupt 
swi14	B	swi14v		; 14 - software interrupt 
swi15	B	swi15v		; 15 - software interrupt 
swi16	B	swi16v		; 16 - software interrupt 
trap	B	trapv		; 17 - software trap 
nmi	B	nmiv		; 18 - non-maskable interrupt 
res1    B       reserved        ; 19 - Reserved
swi20	B	swi20v		; 20 - software interrupt 
swi21	B	swi21v		; 21 - software interrupt 
swi22	B	swi22v		; 22 - software interrupt 
swi23	B	swi23v		; 23 - software interrupt 
swi24	B	swi24v		; 24 - software interrupt 
swi25	B	swi25v		; 25 - software interrupt 
swi26	B	swi26v		; 26 - software interrupt 
swi27	B	swi27v		; 27 - software interrupt 
swi28	B	swi28v		; 28 - software interrupt 
swi29	B	swi29v		; 29 - software interrupt 
swi30	B	swi30v		; 30 - software interrupt 
swi31	B	swi31v		; 31 - software interrupt 

	.sect   "bootload" 
 
*  Initialization

boot    LDP     #0
        SPLK    #2E00H,TEMP     ; ARP = 1, OVM = 1, INTM = 1, DP = 0
	LST	#0,TEMP 	; B0 is in PM
        SPLK    #31FCH,TEMP     ; ARB = 1, CNF = 1, SXM = 0
	LST	#1,TEMP		; XF = 1, PM = 0 , B0-->Prog.memory
       
******************************************************
*  Determine if old or new boot method               *
******************************************************

        IN      TEMP,PMST        ; Read level of EXT8 pin. 
	BIT	TEMP,b3	  	 ; Test LEVEXT8 bit.
        BCND    OLDBOOT,NTC      ; Branch to 8-bit EPROM boot.
				 ; nextsect = 0    FDEST = 1
        splk    #0,nextsect      ; flag for determining if new section exists
        splk    #1,FDEST         ; FLAG to determine address of code entry	

* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*          Read Configuration Byte                      *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	IN	brs,0h		; read I/O port 0	(I/O 0 -->65h)
	LACC	brs,8		; Shifted BRS word --> ACC
	AND	#0FC00h 	; throw away 2 LSBs
	SACL	SOURCE		; save as source address
                                ; b15.....b10 b9 b8 0000 0000 -->SOURCE
        LACL    brs             ; BRS -->ACC
	AND	#3		; if 2 LSBs == 00
	BCND	ser_io,eq	; use serial or parallel I/O or ASP
                                ; At this stage, b1 b0 can be 01,10 or 11
	sub	#2		; if 2 LSBs == 01
        bcnd    PAR08,lt        ;  load from 8-bit memory (EPROM)

				; if 2 LSBs == 10
        bcnd    PAR16,eq        ;  load from 16-bit memory (EPROM)

				; else 2 LSBs == 11

* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*	Warm-boot, simply branch to source address	*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

warmboot
	dmov	SOURCE		; dest <-- src
        splk    #0, GREG
        lacl    DEST2
        BACC

looper  splk 	#0,GREG
	LACL 	B2PA_3          ; load code entry into accumulator
        BACC                    ; branch to address and execute program
        
OLDBOOT  

******* C203 STYLE 8-BIT EPROM BOOT LOADER CODE BEGINS ********

* COPY TO BO MEMORY, SWITCH TO MP MODE, THEN CONTINUE TO BOOT
*
        LAR     AR7,#300h       ;AR7 => B1  (300h)
	MAR	*,AR7		;ARP => AR7
*
* MOVE THE CODE BLOCK
        RPT     #(CODE_END-CODE-1) ; c203 bootloader is copied in B1
        BLPD    #CODE,*+        ; BLOCK move from PM to DM
*                               ; Code is copied in DM from 300h 
        LDP     #6              ; DP --> 300h
        LAR     AR0, #(CODE_END-CODE-1) ; AR0 is the counter
        LAR     AR1, #300h              ; Source address-->AR1
        MAR     *,AR1
        LACL    #0FF00h         ; Destination is FF00h in Prog.memory
        SACL    DEST1

COPY    LACL    *+,AR0          ; c203 bootloader is copied in FF00h
        SACL    CODEWORD1
        LACL    DEST1
        TBLW    CODEWORD1
        ADD     #1
        SACL    DEST1
        BANZ    COPY,AR1
        SPLK    #0FF18h, 0h     ; fix to modify loop return address
        LACL    #0FF24h         ; Write FF18h in FF24h of Prog.memory
        TBLW    300h            ; This is required to patch the "loop"
        MAR     *,AR1           ; address in the original c203 bootloader 
        LDP     #0              ; after relocation to FF00h
        B       0FF00h

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
*	BOOTLOAD FROM 8-BIT MEMORY, MS BYTE IS FIRST	* 
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
*
* change to MP mode from MC mode

CODE
        SPLK    0007h, TEMP     ; set to microprocessor mode
        OUT     TEMP,PMST       ; write to PMST register, SARAM mapped in 
                                ; program and data (SARAM is internal)
*
*  Determine destination address
*
        SPLK    #80h,GREG       ; LOCATIONS 8000-FFFFH are in global data space
        LAR     AR1,#SRC        ; AR1 points to Global address 8000h
        LACC    *+,8            ; Load ACC with high byte and shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+              ; load ACC with low byte of destination
        AND     #0FFH           ; Mask off upper 24 bits.
        OR      HBYTE           ; OR ACC with high byte to form 16 bit 
				; destination address
        SACL    DEST            ; store destination address in PM
        SACL    B2PA_3          ; (71h - Program start address)
*
*  Determine length of code to be transferred
*
        LACC    *+,8            ; Load ACC with high byte and shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+              ; load ACC with low byte of length
        AND     #0FFH           ; Mask off upper 24 bits.
        OR      HBYTE           ; or ACC with hbyte to form 16 bit length
        SACL    LENGTH          ; store length
        LAR     AR0,LENGTH      ; load aro with length to be used for banz
*
*  Transfer code
*
LOOP    LACC    *+,8            ; Load ACC with high byte of code & shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+,AR0
        AND     #0FFH           ;
        OR      HBYTE           ; OR ACC with hbyte to form 16 bit code word
        SACL    CODEWORD
        LACL    DEST
        TBLW    CODEWORD
        ADD     #1
        SACL    DEST
        BANZ    LOOP,AR1        ; determine if end of code is reached
        splk    #0,GREG         ; Remove global memory
        LACL    B2PA_3          ; load code entry into ACCumulator
        BACC                    ; branch to address and execute program
CODE_END
******* C203 STYLE 8-BIT EPROM BOOT LOADER CODE ENDS ********

 
PAR08: ;******************* 8-BIT EPROM BOOT LOADER CODE BEGINS *************

*  Determine destination address
*
	SPLK    #80h,GREG       ; LOCATIONS 8000-FFFFH are in global data space
        LAR     AR5,SOURCE      ; AR1 points to starting address of EPROM in
                                ; global memory space
TOP     MAR     *,AR5
	LACC    *+,8            ; Load ACC with high byte and shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+              ; load ACC with low byte of destination
        AND     #0FFH           ; Mask off upper 24 bits.
        OR      HBYTE           ; OR ACC with high byte to form 16 bit
                                ; destination address --> ACC
        bit     FDEST,15        ; FDEST = 1 in first pass
	bcnd    skip5,ntc
        splk    #0, FDEST       ; FDEST = 0 from second pass
        SACL    B2PA_3          ; Save final destination address to jump to.
skip5   SACL    DEST            ; Store destination address

	bit 	nextsect,15	; check to see if through at least one section
        bcnd    cont1,ntc       ; nextsect = 0 in first pass
	lacl	DEST
	and 	#0FFFFh
	bcnd	looper,eq	; if word is 0000h, booting is done
	splk	#0,nextsect
cont1        
*
*  Determine length of code to be transferred
*
        LACC    *+,8            ; Load ACC with high byte and shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+              ; load ACC with low byte of length
        AND     #0FFH           ; Mask off upper 24 bits.
        OR      HBYTE           ; OR ACC with high byte to form 16 bit length
        SACL    LENGTH          ; store length
        LAR     AR0,LENGTH      ; load AR0 with length to be used for banz
*
*  Transfer code
*
LOOP1   LACC    *+,8            ; Load ACC with high byte of code & shift 8 bits
        SACL    HBYTE           ; store high byte
        LACL    *+,AR0
        AND     #0FFH           
        OR      HBYTE           ; OR ACC with hbyte to form 16 bit code word
        SACL    CODEWORD
        LACL    DEST
        TBLW    CODEWORD
        ADD     #1
        SACL    DEST
        BANZ    LOOP1,AR5       ; determine if end of code is reached

        call B2_init            ; reinitialize for next section
        splk #1, nextsect       ; flag to check for another section
        B	TOP

*** 8-bit EPROM boot loader code ends ***

PAR16: ; *************** 16-bit EPROM BOOT LOADER CODE BEGINS ****************

*  Determine destination address
*
	SPLK    #80h,GREG       ; LOCATIONS 8000-FFFFH are in global data space
        LAR     AR5,SOURCE      ; AR1 points to starting address of EPROM in
                                ; global memory space

TOP1    MAR 	*,AR5
	LACC    *+              ; Load ACC withdestination address
        bit     FDEST,15        ; FDEST = 1 in first pass
	bcnd    skip2,ntc
        splk    #0, FDEST       ; FDEST = 0 from second pass
        SACL    B2PA_3          ; save final destination address to jump to
skip2   SACL    DEST            ; store destination address

        bit     nextsect,15     ; nextsect = 0 in first pass
	bcnd	cont2,ntc
	lacl	DEST
	and 	#0FFFFh
	bcnd	looper,eq
	splk	#0,nextsect
cont2        
*
*  Determine length of code to be transferred
*
        LACC    *+                 ; Load ACC with length of section
        SACL    LENGTH             ; store length
        LAR     AR0,LENGTH         ; load aro with length to be used for banz
*
*  Transfer code
*
LOOP2   LACC    *+, AR0            ; Load ACC with high byte of code 
        SACL    CODEWORD
        LACL    DEST
        TBLW    CODEWORD
        ADD     #1
        SACL    DEST
        BANZ    LOOP2,AR5          ; determine if end of code is reached
        call    B2_init            ; reinitialize for next section
        splk    #1, nextsect       ; flag to check for another section
        B	TOP1

*** 16-bit EPROM boot loader code ends ***

ASP: ; *********** ASYNCH. SERIAL PORT (UART) BOOT LOADER CODE BEGINS **********

* Function: 2xx Serial loader module by polling DR bit     *

* UART initialization with autobaud enable
      
        ldp #0
        splk #0c0a0h,B2S_0      ; reset the UART by writing 0
        out B2S_0, aspcr        ; Enable Auto baud detect & Rcv interrupt
        splk #0e0a0h,B2S_0      ; CAD=1, 1 stop bit 
	out B2S_0,aspcr
        splk #4fffh,B2S_0       ; Clear ADC & BI bits
        out B2S_0,iosr          ; enable auto baud

uart:   in B2S_0,iosr           
        bit B2S_0,7             ; check DR bit to see if any new character
        bcnd uart,ntc           ; is available in the ADTR

	in B2S_0,aspcr
	bit B2S_0,10		; Check CAD =1
	bcnd nrcv,ntc		; If 0 , start receive, autobaud done 
        in B2S_1,iosr           ; load input status from iosr
        bit B2S_1,1             ; check if auto baud bit is set,else return
        bcnd nauto,ntc          ; and wait for Auto baud detect receive
        splk #4000h,B2S_1       ; Auto baud detect done 
        out B2S_1,iosr          ; clear ADC
	splk #0e080h,B2S_1
        out B2S_1, aspcr        ; Disable CAD bit/ auto baud
        in B2S_1,adtr           ; Dummy read to discard "a"
        out B2S_1,adtr          ; Echo back "a"
nauto:  in B2S_1,adtr           ; Dummy read to clear UART rx buffer
        b skip1                  ; Exit and wait for "a"

skip1:  splk #6600h,B2S_0
        out B2S_0,iosr          ; Clear all Interrupt sources
	B uart

nrcv:

*  Begin receiving user code 

        setc CNF                ; map B0 to program space
        call B2_init            ; 
pwait:
        in B2S_0,iosr           ; Load input status from iosr
        bit B2S_0,7             ; bit 8 in the data
        bcnd pwait,ntc          ; IF DR=0 no echo, return
        call pnrcv              ;
        bit B2FM_8,15           ; Wait until Data_move ready flag
        bcnd pwait,ntc
        lacl B2PA_2             ; Load destination address
        tblw B2PD_5             ; Move data to the current destination address
        add #1                  ; Increment destination address+1
        sacl B2PA_2             ; save next destination address
        banz pwait,*-

* check if next section, need to read next 16 bit word, if "0000" then a
* section follows else program branches to address saved in B2PA_3.

        call B2_init            ; reinitialize for next section
        splk #1, nextsect       ; flag to check for another section
        B pwait

pnrcv:
        mar *,ar1               ; Valid UART data, Point to Word index reg.
        bit B2D_6,15            ; Check if bit0 of word index =1,low byte 
        bcnd plbyte,tc          ; received!
        in B2S_1,adtr           ; No, Hi byte received!
        out B2S_1,adtr          ; Echo receive data
        lacc B2S_1,8            ; Align to upper byte
        sacl B2D_7              ; Save aligned word
        mar *+                  ; Increment Word Index 
        sar ar1,B2D_6           ; Store high_byte flag
        splk #0,B2FM_8          ; Reset Data/word move flag as only hi-byte recd!
        b pskip                 ; wait for next byte 
plbyte:
        in B2S_0,adtr           ; Receive second byte/low byte
*        out B2S_0,adtr          ; Echo received data
        lacc B2S_0,0
        and #0ffh               ; Clear high byte
        or B2D_7                ; Add high byte to the word
        sacl B2PD_5             ; store 16-bit word at ar1
        mar *+                  ; 1+
        sar ar1,B2D_6           ; Save the count 

        bit nextsect,15         ; check for next section
        bcnd cont,ntc           ; if not zero, continue, else check for 0
        lacl B2PD_5             ; load first word
	and #0FFFFh
        bcnd looper,eq          ; if 0 done, else
        splk #0,nextsect        ; reset next sect flag for next pass
cont    bit B2FH_9,15           ; Check Header_done flag
        bcnd psmove,tc          ; No, if 2 words received update Data_move flag
        lar ar0,#2
        cmpr 0
        bcnd pword2,ntc          

        bit  FDEST,15           ; test to determine if this is first pass
        bcnd skip,ntc           ; skip if this is 2nd section onward
        splk #0, FDEST          ; if yes reset flag

        sacl B2PA_3             ; Store DESTINATION address to JUMP TO
skip    sacl B2PA_2             ; Save data buffer address
        b pskip                 ;
pword2:
        lar ar0,#4              ; Check if 4 words recvd, update program length
        cmpr 0                  ; Program length register
        bcnd pskip,ntc          ; Else exit
        lar ar2,B2PD_5          ; Yes received!,Load PM length in AR2
        sar ar2, B2PL_4         ; Save program length
        splk #1,B2FH_9          ; Set Header_done flag 
        b pskip
psmove:
        mar *,ar2
        splk #1h,B2FM_8         ; Set UART Data_move ready flag
pskip:
        splk #0020h, ifr        ; Clear interrupt in ifr!
	ret

B2_init:
        lacc #0
        lar ar1,#B2            ; Point B2_RAM start address
        mar *,ar1
        rpt #16
        sacl *+                 ; Clear B2 memory 
        lar ar1,#00h            ; Clear pointers
        lar ar2,#00h            ; 
        lar ar3,#00h
        ret

*** Asynch. serial port (UART) boot loader code ends ***

*********************************************************
*  SERIAL BOOTLOAD (SSP 8/16 bit,UART), PARALLEL I/O    *
*********************************************************
ser_io

	bit 	brs,b4		; test bit 4 of configuration word
        bcnd    ASP,TC          ; If set, branch to UART bootloader

        bit     brs,b3          ; test bit 3 of configuration word
        bcnd    io,tc           ; If set, branch to Parallel I/O bootloader

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*       Bootload from Synchronous serial port  (SSP)      *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

ser
        bit     brs,b2          ; test bit 2 of configuration word
        bcnd    bit8,ntc        ; if 0, then 8-bit mode, else 16-bit mode

*********** 16-BIT SYNCH. SERIAL PORT (SSP) BOOT LOADER CODE BEGINS *********


*           After data load the PC will jump to the Destination   *
*           /Load/Run address.                                    *
                                                          

        setc CNF                ; Block B0 in PM
        ldp #0h                 ; set DP=0
        setc INTM               ; Disable all interrupts
	call	B2_init

        splk #0,nextsect
        splk #1,FDEST           ; FLAG to determine address of code entry

*SSP initialization

sspld:  splk #0c00ah,B2S_0      ; Initialize SSP in Burst mode, in reset
        out B2S_0,sspcr         ; External Clocks, 16 bit word
        splk #0c03ah, B2S_0     ; Interrupt on 1 word in FIFO, Internal FSX
        out B2S_0, sspcr        ; take port out of reset

wait:	in B2S_0,sspcr
        bit B2S_0,3             ; poll RFNE bit to see if data received
        bcnd wait,ntc
        call codrx   
        bit B2FM_8,15           ; Wait until Data_move ready flag
        bcnd wait,ntc
        splk #0,B2FM_8
        lacl B2PA_2             ; Load destination address
        tblw B2PD_5             ; Move data to the current destination address
        add #1                  ; Increment destination address+1
        sacl B2PA_2             ; save next destination address
        banz wait,*-            ; decrement length counter

* check if next section, need to read next 16 bit word, if not "0000" then a
* section follows else program branches to address saved in B2PA_3.

        call B2_init            ; reinitialize for next section
        splk #1, nextsect       ; flag to check for another section
        B wait

* SSP loader code!
codrx:
        in B2S_0,sdtr           ; Read received data/Load Scratch RAM 
        out B2S_0,sdtr          ; Echo received data

        bit nextsect,15         ; check for next section/BIT 0 of nextsect
        bcnd contx,ntc          ; if not zero, continue, else check for 0
        lacl  B2S_0
	and #0FFFFh
        lar  ar7, #9999h
        bcnd looper,eq          ; if 0 done, else
        splk #0,nextsect        ; reset next sect flag for next pass

contx   mar *,ar3               ; Set Word index register as AR3
        mar *+                  ; Increment word index
        lar ar0,#1              ; If word index =1 save Program start address
        cmpr 0
        bcnd pmad,tc
        lar ar0,#2              ; If index =2 save Program length
        cmpr 0                  ; Compare if (AR3)=(AR0). TC=1, if true
        bcnd plen,tc            ; True in second pass
        lacc B2S_0,0            
        sacl B2PD_5,0           ; Store received word 
        splk #1h,B2FM_8         ; Set SSP Data_move ready flag
        b skip7,ar2
pmad:   lacc B2S_0,0            ; Store destination start address in ACC

        bit  FDEST,15           ; test to determine if this is first pass
        bcnd skip6,ntc          ; skip if this is 2nd section onward
        splk #0, FDEST          ; if yes reset flag

        sacl B2PA_3             ; Store DESTINATION address to JUMP TO
skip6   sacl B2PA_2             ; Save data buffer address
        b skip7,ar2             ;      
      
plen:   lar ar2,B2S_0           ; Store Program length at B2PL_4
        sar ar2,B2PL_4
skip7:  
        ret

*** 16-bit Synch. serial port (SSP) boot loader code ends ***

*********** 8-BIT SYNCH. SERIAL PORT (SSP) BOOT LOADER CODE BEGINS *********

bit8

        .title  " Serial loader"  ; Title

        setc CNF                ; Block B0 in PM
        ldp #0h                 ; set DP=0
        setc INTM               ; Disable all interrupts
        call B2_init
        splk #0,nextsect
        splk #1,FDEST           ; FLAG to determine address of code entry

*SSP initialization

sspld1  splk #0c00ah,B2S_0      ; Initialize SSP in Burst mode, in reset
        out B2S_0,sspcr         ; External Clocks, 16 bit word
        splk #0c03ah, B2S_0     ; Interrupt on 1 word in FIFO, external FSX
        out B2S_0, sspcr        ; take port out of reset
	splk #0001h, B2S_0
	out B2S_0,sspst		; 8 bit mode
*        splk #8h,imr           ; Enable SSP RX interrupt only

pwait1:
        in B2S_0,sspcr          ; Load input status from sspcr
        bit B2S_0,3             ; Poll RFNE bit
        bcnd pwait1,ntc         ; IF DR=0 no echo, return
        call pnrcv1             ;
        bit B2FM_8,15           ; Wait until Data_move ready flag
        bcnd pwait1,ntc
        lacl B2PA_2             ; Load destination address
        tblw B2PD_5             ; Move data to the current destination address
        add #1                  ; Increment destination address+1
        sacl B2PA_2             ; save next destination address
        banz pwait1,*-

* check if next section, need to read next 16 bit word, if not "0000" then a
* section follows else program branches to address saved in B2PA_3.

        call B2_init            ; reinitialize for next section
        splk #1, nextsect       ; flag to check for another section
        B pwait1

pnrcv1:
        mar *,ar1               ; Valid  data, Point to Word index reg.
        bit B2D_6,15            ; Check if bit0 of word index =1,low byte 
        bcnd lbyte,tc           ; received!
        in B2S_1,sdtr           ; No, Hi byte received!
        out B2S_1,sdtr          ; Echo receive data
        lacc B2S_1,8            ; Align to upper byte
        sacl B2D_7              ; Save aligned word
        mar *+                  ; Increment Word Index 
        sar ar1,B2D_6           ; Store high_byte flag
        splk #0,B2FM_8          ; Reset Data/word move flag as only hi-byte recd!
        b pskip8                ; wait for next byte
lbyte:
        in B2S_0,sdtr           ; Receive second byte/low byte
*        out B2S_0,sdtr          ; Echo received data
        lacc B2S_0,0
        and #0ffh               ; Clear high byte
        or B2D_7                ; Add high byte to the word
        sacl B2PD_5             ; store 16-bit word at ar1
        mar *+                  ; 1+
        sar ar1,B2D_6           ; Save the count 

        bit nextsect,15         ; check for next section
        bcnd cont9,ntc          ; if not zero, continue, else check for 0
        lacl B2PD_5             ; load first word
	and #0FFFFh
        bcnd looper,eq          ; if 0 done, else
        splk #0,nextsect        ; reset next sect flag for next pass
cont9   bit B2FH_9,15           ; Check Header_done flag
        bcnd psmove0,tc          ; No, if 2 words received update Data_move flag
        lar ar0,#2
        cmpr 0
        bcnd word2,ntc          

        bit  FDEST,15           ; test to determine if this is first pass
        bcnd skipe,ntc          ; skip if this is 2nd section onward
        splk #0, FDEST          ; if yes reset flag

        sacl B2PA_3             ; Store DESTINATION address to JUMP TO
skipe   sacl B2PA_2             ; Save data buffer address
        b pskip8                ;
word2:
        lar ar0,#4              ; Check if 4 words recvd, update program length
        cmpr 0                  ; Program length register
        bcnd pskip8,ntc          ; Else exit
        lar ar2,B2PD_5          ; Yes received!,Load PM length in AR2
        sar ar2, B2PL_4         ; Save program length
        splk #1,B2FH_9          ; Set Header_done flag 
        b pskip8
psmove0:
        mar *,ar2
        splk #1h,B2FM_8         ; Set UART Data_move ready flag
pskip8:
        ret

*** 8-bit Synch. serial port (SSP) boot loader code ends ***


* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*       Bootload from parallel I/O port (port 1) -8/16 bit parallel I/O *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

io
        splk    #0,GREG         ; disable global space
	bit	brs,b2		; test bit #2 of configuration word
	bcnd	pasync08,ntc	; if reset, use 8-bit mode


*********** 16-BIT PARALLEL I/O BOOT LOADER CODE BEGINS *****************

pasync16
	mar     *,ar1
TOP3	call	handshake
        IN 	DEST,1		; read word from port 1 to destination

        LACL    DEST

        bit     FDEST,15
	bcnd    skip3,ntc
	splk	#0, FDEST
        SACL    B2PA_3          ; save final destination address to jump to
skip3   SACL    DEST            ; store destination address

	bit 	nextsect,15
	bcnd	cont3,ntc
	lacl	DEST
	and 	#0FFFFh
	bcnd	looper,eq
	splk	#0,nextsect
cont3        
	call	handshake
        IN      LENGTH,1         ; read word from port 1 to length

        lar     ar1,LENGTH       ; ar1 <-- code length
        lacl    DEST           ; ACC <-- destination address

loop16	call	handshake
        IN      TEMP,1          ; read word from port 1 to temp
	setc	xf		; acknowledge word as soon as it's read
	nop			; delay between xf and write
	nop
        tblw    TEMP            ; write word to destination
	add	#1		; increment destination address
	banz	loop16,*-	; loop if ar1 is not zero
        call    B2_init            ; reinitialize for next section
        splk    #1, nextsect       ; flag to check for another section
        B	TOP3

*** 16-bit Parallel I/O boot loader code ends ***

******** 8-BIT PARALLEL I/O BOOT LOADER CODE BEGINS -  MS byte first *******

pasync08
	mar	*,ar1
TOP4	call	handshake
	IN 	TEMP,1		; read I/O port 1
	lacc	TEMP,8		; read high byte from port
        sacl 	DEST

    	call	handshake
	IN 	TEMP,1
	lacl	TEMP		; read low byte from port
	and	#0ffh		; clear upper byte
        or      DEST            ; combine high and low byte
    
        bit     FDEST,15
	bcnd    skip4,ntc
	splk	#0, FDEST
        SACL    B2PA_3          ; save final destination address to jump to
skip4   SACL    DEST            ; store destination address

	bit 	nextsect,15
	bcnd	cont4,ntc
	lacl	DEST
	and 	#0FFFFh
	bcnd	looper,eq
	splk	#0,nextsect
cont4        
  	call	handshake
	IN	TEMP,1
	lacc	TEMP,8		; read high byte from port
        sacl    LENGTH           ; save high byte

	call	handshake
	IN      TEMP,1
	lacl	TEMP		; read low byte from port
	and	#0ffh		; clear upper byte
        or      LENGTH           ; combine high and low byte
        sacl    LENGTH           ; save code length

	LAR	ar1,LENGTH	; ar1 <-- code length
        lacl    DEST
	sacl	DEST2		; DEST2 <-- destination address

loop08	call	handshake
	IN      TEMP,1
	lacc	TEMP,8		; read high byte from port
        sacl    TEMP1           ; save high byte

	call	handshake
	IN      TEMP,1
	lacl	TEMP		; read low byte from port
	setc	xf		; acknowledge byte as soon as it's read
	and	#0ffh		; clear upper byte
        or      TEMP1           ; combine high and low byte
        sacl    TEMP1           ; save code word

	lacl	DEST2		; DEST2 <-- destination address
        tblw    TEMP1           ; write code word to program memory
	add	#1		; increment destination address
	sacl	DEST2		; save new destination address
	banz	loop08,*-	; loop if ar1 not zero
        call    B2_init            ; reinitialize for next section
        splk    #1, nextsect       ; flag to check for another section
        B	TOP4
       
*** 8-bit Parallel I/O boot loader code ends ***

*	Handshake with BIO signal using XF

handshake
	setc	xf		; acknowledge previous data word
biohigh
	bcnd	biohigh,bio	; wait till host sends request
	clrc	xf		; indicate ready to receive new data
biolow
	retc	bio		; wait till new data ready
	b	biolow
	
	.sect	"alaw"

;**************************************************************************
;
;  	CCITT expansion table
; 	The table is A-law expansion table for ADI-coded samples
;
;**************************************************************************
	.DEF	AEXPTAB
	
AEXPTAB	.WORD    -688
	.WORD    -656
	.WORD    -752
	.WORD    -720
	.WORD    -560
	.WORD    -528
	.WORD    -624
	.WORD    -592
	.WORD    -944
	.WORD    -912
	.WORD    -1008
	.WORD    -976
	.WORD    -816
	.WORD    -784
	.WORD    -880
	.WORD    -848
	.WORD    -344
	.WORD    -328
	.WORD    -376
	.WORD    -360
	.WORD    -280
	.WORD    -264
	.WORD    -312
	.WORD    -296
	.WORD    -472
	.WORD    -456
	.WORD    -504
	.WORD    -488
	.WORD    -408
	.WORD    -392
	.WORD    -440
	.WORD    -424
	.WORD    -2752
	.WORD    -2624
	.WORD    -3008
	.WORD    -2880
	.WORD    -2240
	.WORD    -2112
	.WORD    -2496
	.WORD    -2368
	.WORD    -3776
	.WORD    -3648
	.WORD    -4032
	.WORD    -3904
	.WORD    -3264
	.WORD    -3136
	.WORD    -3520
	.WORD    -3392
	.WORD    -1376
	.WORD    -1312
	.WORD    -1504
	.WORD    -1440
	.WORD    -1120
	.WORD    -1056
	.WORD    -1248
	.WORD    -1184
	.WORD    -1888
	.WORD    -1824
	.WORD    -2016
	.WORD    -1952
	.WORD    -1632
	.WORD    -1568
	.WORD    -1760
	.WORD    -1696
	.WORD    -43
	.WORD    -41
	.WORD    -47
	.WORD    -45
	.WORD    -35
	.WORD    -33
	.WORD    -39
	.WORD    -37
	.WORD    -59
	.WORD    -57
	.WORD    -63
	.WORD    -61
	.WORD    -51
	.WORD    -49
	.WORD    -55
	.WORD    -53
	.WORD    -11
	.WORD    -9
	.WORD    -15
	.WORD    -13
	.WORD    -3
	.WORD    -1
	.WORD    -7
	.WORD    -5
	.WORD    -27
	.WORD    -25
	.WORD    -31
	.WORD    -29
	.WORD    -19
	.WORD    -17
	.WORD    -23
	.WORD    -21
	.WORD    -172
	.WORD    -164
	.WORD    -188
	.WORD    -180
	.WORD    -140
	.WORD    -132
	.WORD    -156
	.WORD    -148
	.WORD    -236
	.WORD    -228
	.WORD    -252
	.WORD    -244
	.WORD    -204
	.WORD    -196
	.WORD    -220
	.WORD    -212
	.WORD    -86
	.WORD    -82
	.WORD    -94
	.WORD    -90
	.WORD    -70
	.WORD    -66
	.WORD    -78
	.WORD    -74
	.WORD    -118
	.WORD    -114
	.WORD    -126
	.WORD    -122
	.WORD    -102
	.WORD    -98
	.WORD    -110
	.WORD    -106
	.WORD    688
	.WORD    656
	.WORD    752
	.WORD    720
	.WORD    560
	.WORD    528
	.WORD    624
	.WORD    592
	.WORD    944
	.WORD    912
	.WORD    1008
	.WORD    976
	.WORD    816
	.WORD    784
	.WORD    880
	.WORD    848
	.WORD    344
	.WORD    328
	.WORD    376
	.WORD    360
	.WORD    280
	.WORD    264
	.WORD    312
	.WORD    296
	.WORD    472
	.WORD    456
	.WORD    504
	.WORD    488
	.WORD    408
	.WORD    392
	.WORD    440
	.WORD    424
	.WORD    2752
	.WORD    2624
	.WORD    3008
	.WORD    2880
	.WORD    2240
	.WORD    2112
	.WORD    2496
	.WORD    2368
	.WORD    3776
	.WORD    3648
	.WORD    4032
	.WORD    3904
	.WORD    3264
	.WORD    3136
	.WORD    3520
	.WORD    3392
	.WORD    1376
	.WORD    1312
	.WORD    1504
	.WORD    1440
	.WORD    1120
	.WORD    1056
	.WORD    1248
	.WORD    1184
	.WORD    1888
	.WORD    1824
	.WORD    2016
	.WORD    1952
	.WORD    1632
	.WORD    1568
	.WORD    1760
	.WORD    1696
	.WORD    43
	.WORD    41
	.WORD    47
	.WORD    45
	.WORD    35
	.WORD    33
	.WORD    39
	.WORD    37
	.WORD    59
	.WORD    57
	.WORD    63
	.WORD    61
	.WORD    51
	.WORD    49
	.WORD    55
	.WORD    53
	.WORD    11
	.WORD    9
	.WORD    15
	.WORD    13
	.WORD    3
	.WORD    1
	.WORD    7
	.WORD    5
	.WORD    27
	.WORD    25
	.WORD    31
	.WORD    29
	.WORD    19
	.WORD    17
	.WORD    23
	.WORD    21
	.WORD    172
	.WORD    164
	.WORD    188
	.WORD    180
	.WORD    140
	.WORD    132
	.WORD    156
	.WORD    148
	.WORD    236
	.WORD    228
	.WORD    252
	.WORD    244
	.WORD    204
	.WORD    196
	.WORD    220
	.WORD    212
	.WORD    86
	.WORD    82
	.WORD    94
	.WORD    90
	.WORD    70
	.WORD    66
	.WORD    78
	.WORD    74
	.WORD    118
	.WORD    114
	.WORD    126
	.WORD    122
	.WORD    102
	.WORD    98
	.WORD    110
	.WORD    106


	.sect	"ulaw"

;*********************************************************************
;
;	CCITT mu-law Expansion Table
;
;********************************************************************

	.DEF	UEXPTAB
UEXPTAB	.WORD	0e0a1h
	.WORD	0e1a1h
	.WORD	0e2a1h
	.WORD	0e3a1h
	.WORD	0e4a1h
	.WORD	0e5a1h
	.WORD	0e6a1h
	.WORD	0e7a1h
	.WORD	0e8a1h
	.WORD	0e9a1h
	.WORD	0eaa1h
	.WORD	0eba1h
	.WORD	0eca1h
	.WORD	0eda1h
	.WORD	0eea1h
	.WORD	0efa1h
	.WORD	0f061h
	.WORD	0f0e1h
	.WORD	0f161h
	.WORD	0f1e1h
	.WORD	0f261h
	.WORD	0f2e1h
	.WORD	0f361h
	.WORD	0f3e1h
	.WORD	0f461h
	.WORD	0f4e1h
	.WORD	0f561h
	.WORD	0f5e1h
	.WORD	0f661h
	.WORD	0f6e1h
	.WORD	0f761h
	.WORD	0f7e1h
	.WORD	0f841h
	.WORD	0f881h
	.WORD	0f8c1h
	.WORD	0f901h
	.WORD	0f941h
	.WORD	0f981h
	.WORD	0f9c1h
	.WORD	0fa01h
	.WORD	0fa41h
	.WORD	0fa81h
	.WORD	0fac1h
	.WORD	0fb01h
	.WORD	0fb41h
	.WORD	0fb81h
	.WORD	0fbc1h
	.WORD	0fc01h
	.WORD	0fc31h
	.WORD	0fc51h
	.WORD	0fc71h
	.WORD	0fc91h
	.WORD	0fcb1h
	.WORD	0fcd1h
	.WORD	0fcf1h
	.WORD	0fd11h
	.WORD	0fd31h
	.WORD	0fd51h
	.WORD	0fd71h
	.WORD	0fd91h
	.WORD	0fdb1h
	.WORD	0fdd1h
	.WORD	0fdf1h
	.WORD	0fe11h
	.WORD	0fe29h
	.WORD	0fe39h
	.WORD	0fe49h
	.WORD	0fe59h
	.WORD	0fe69h
	.WORD	0fe79h
	.WORD	0fe89h
	.WORD	0fe99h
	.WORD	0fea9h
	.WORD	0feb9h
	.WORD	0fec9h
	.WORD	0fed9h
	.WORD	0fee9h
	.WORD	0fef9h
	.WORD	0ff09h
	.WORD	0ff19h
	.WORD	0ff25h
	.WORD	0ff2dh
	.WORD	0ff35h
	.WORD	0ff3dh
	.WORD	0ff45h
	.WORD	0ff4dh
	.WORD	0ff55h
	.WORD	0ff5dh
	.WORD	0ff65h
	.WORD	0ff6dh
	.WORD	0ff75h
	.WORD	0ff7dh
	.WORD	0ff85h
	.WORD	0ff8dh
	.WORD	0ff95h
	.WORD	0ff9dh
	.WORD	0ffa3h
	.WORD	0ffa7h
	.WORD	0ffabh
	.WORD	0ffafh
	.WORD	0ffb3h
	.WORD	0ffb7h
	.WORD	0ffbbh
	.WORD	0ffbfh
	.WORD	0ffc3h
	.WORD	0ffc7h
	.WORD	0ffcbh
	.WORD	0ffcfh
	.WORD	0ffd3h
	.WORD	0ffd7h
	.WORD	0ffdbh
	.WORD	0ffdfh
	.WORD	0ffe2h
	.WORD	0ffe4h
	.WORD	0ffe6h
	.WORD	0ffe8h
	.WORD	0ffeah
	.WORD	0ffech
	.WORD	0ffeeh
	.WORD	0fff0h
	.WORD	0fff2h
	.WORD	0fff4h
	.WORD	0fff6h
	.WORD	0fff8h
	.WORD	0fffah
	.WORD	0fffch
	.WORD	0fffeh
	.WORD	00000h
	.WORD	01f5fh
	.WORD	01e5fh
	.WORD	01d5fh
	.WORD	01c5fh
	.WORD	01b5fh
	.WORD	01a5fh
	.WORD	0195fh
	.WORD	0185fh
	.WORD	0175fh
	.WORD	0165fh
	.WORD	0155fh
	.WORD	0145fh
	.WORD	0135fh
	.WORD	0125fh
	.WORD	0115fh
	.WORD	0105fh
	.WORD	00f9fh
	.WORD	00f1fh
	.WORD	00e9fh
	.WORD	00e1fh
	.WORD	00d9fh
	.WORD	00d1fh
	.WORD	00c9fh
	.WORD	00c1fh
	.WORD	00b9fh
	.WORD	00b1fh
	.WORD	00a9fh
	.WORD	00a1fh
	.WORD	0099fh
	.WORD	0091fh
	.WORD	0089fh
	.WORD	0081fh
	.WORD	007bfh
	.WORD	0077fh
	.WORD	0073fh
	.WORD	006ffh
	.WORD	006bfh
	.WORD	0067fh
	.WORD	0063fh
	.WORD	005ffh
	.WORD	005bfh
	.WORD	0057fh
	.WORD	0053fh
	.WORD	004ffh
	.WORD	004bfh
	.WORD	0047fh
	.WORD	0043fh
	.WORD	003ffh
	.WORD	003cfh
	.WORD	003afh
	.WORD	0038fh
	.WORD	0036fh
	.WORD	0034fh
	.WORD	0032fh
	.WORD	0030fh
	.WORD	002efh
	.WORD	002cfh
	.WORD	002afh
	.WORD	0028fh
	.WORD	0026fh
	.WORD	0024fh
	.WORD	0022fh
	.WORD	0020fh
	.WORD	001efh
	.WORD	001d7h
	.WORD	001c7h
	.WORD	001b7h
	.WORD	001a7h
	.WORD	00197h
	.WORD	00187h
	.WORD	00177h
	.WORD	00167h
	.WORD	00157h
	.WORD	00147h
	.WORD	00137h
	.WORD	00127h
	.WORD	00117h
	.WORD	00107h
	.WORD	000f7h
	.WORD	000e7h
	.WORD	000dbh
	.WORD	000d3h
	.WORD	000cbh
	.WORD	000c3h
	.WORD	000bbh
	.WORD	000b3h
	.WORD	000abh
	.WORD	000a3h
	.WORD	0009bh
	.WORD	00093h
	.WORD	0008bh
	.WORD	00083h
	.WORD	0007bh
	.WORD	00073h
	.WORD	0006bh
	.WORD	00063h
	.WORD	0005dh
	.WORD	00059h
	.WORD	00055h
	.WORD	00051h
	.WORD	0004dh
	.WORD	00049h
	.WORD	00045h
	.WORD	00041h
	.WORD	0003dh
	.WORD	00039h
	.WORD	00035h
	.WORD	00031h
	.WORD	0002dh
	.WORD	00029h
	.WORD	00025h
	.WORD	00021h
	.WORD	0001eh
	.WORD	0001ch
	.WORD	0001ah
	.WORD	00018h
	.WORD	00016h
	.WORD	00014h
	.WORD	00012h
	.WORD	00010h
	.WORD	0000eh
	.WORD	0000ch
	.WORD	0000ah
	.WORD	00008h
	.WORD	00006h
	.WORD	00004h
	.WORD	00002h
	.WORD	00000h
