/**********************************************************************/
/* File Name:     link.cmd                                            */
/* Target System: C24x Evaluation Board                               */
/*                                                                    */
/* Description:   A basic linker command file for the 'F240 device.   */
/*                This file is used by the linker to determine where  */
/*                certain sections of code should reside in memory.   */
/*                                                                    */
/* Revision:      1.00                                                */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/*  LINKER COMMAND FILE - MEMORY SPECIFICATION for the F240           */
/*--------------------------------------------------------------------*/

MEMORY
{
    PAGE 0 :   VECS   : origin =    0h , length =   040h   /* VECTORS */
	         PROG   : origin =   40h , length = 0FFC0h   /* PROGRAM */

    PAGE 1 :   MMRS   : origin =    0h , length =   060h   /* MMRS    */
               B2     : origin = 0060h , length =   020h   /* DARAM   */
               B0     : origin = 0200h , length =  0100h   /* DARAM   */
               B1     : origin = 0300h , length =  0100h   /* DARAM   */
               DATA   : origin = 8000h , length =  8000h   /* XDM     */
}

/*--------------------------------------------------------------------*/
/* SECTIONS ALLOCATION                                                */
/*--------------------------------------------------------------------*/
SECTIONS
{
    .vectors : { } > VECS      PAGE 0   /* Interrupt vector table     */
    .reset   : { } > VECS      PAGE 0   /* Reset code                 */
    .start   : { } > PROG      PAGE 0   /* Code                       */
    .text    : { } > PROG      PAGE 0   /* Code                       */
    .data    : { } > PROG      PAGE 0   /* Initialization data tables */
    .mmrs    : { } > MMRS      PAGE 1   /* Memory mapped registers    */
    .bss     : { } > B2        PAGE 1   /* Block B2                   */
    .blk0    : { } > B0        PAGE 1   /* Block B0                   */
    .blk1    : { } > B1        PAGE 1   /* Block B1                   */
    .blk2    : { } > B2        PAGE 1   /* Block B2                   */
    .blk3    : { } > DATA      PAGE 1   /* External data memory       */
}
