;************************************************************
;* Variable declaration file				   **
;							   **
; TMS320F2XX Flash Utilities.				   **
; Revision: 2.0,  9/10/97				   **
;							   **
; Filename: svar20.asm					   **
; Modified for F2xx: Sam Saba			   7/07/97 **
; Changes: Removed some unused variables. Added FL_ST and  **
;	   FL_END. Tweaked DLOOP constants. Added more	   **
;	   comments.					   **
;							   **
;		 Ruben D. Perez 			   **
;		 DSP Applications			   **
;		 Texas Instruments Inc. 		   **
;							   **
;	   Modified to suit F240 Serial Boot loader	   **
;		 David Figoli - DCS Apps		   **
;				12 Nov 97		   **
;Note:							    *
;DLOOP is a delay loop variable used in flash algorithms.   *
;This is a function of CLKOUT1. If the F206 device runs at  *
;any CLKOUT1 speed other than 20MHz, DLOOP value should be  *
;re-defined as per the equation, explained below. Use of    *
;current DLOOP for flash programming at speeds other than   *
;20Mhz is not recommended!.				    *
;************************************************************

	.ref	data_buf
	.ref	length
	.ref	dest_addr
	.ref	PRG_paddr
	.ref	PRG_length
	.ref	PRG_bufaddr
	.ref	BYTE_MASK
	.ref	B2_0
	.ref	B2_1
	.ref	B2_2
	.ref	B2_3
	.ref	B2_4
	.ref	B2_5
	.ref	B2_6
	.ref	SPAD1
	.ref	SPAD2

	.ref	DUMMY
	.ref	DLY10
	.ref	DLY100
	.ref	DLY3K3
	.ref	SEG_ST
	.ref	SEG_END
	.ref	PROTECT

	.ref	FL_ADRS 	;Flash load address.
	.ref	FL_DATA 	;Flash load data.
	.ref	ERROR		;Error flag register.

;Variables for ERASE and CLEAR
	.ref	RPG_CNT 	;Program pulse count.
	.ref	FL_ST		;Flash start addr/Seg Cntrl Reg.
	.ref	FL_END		;Flash end address.


;CONSTANTS

; Delay variables for CLEAR,ERASE and PROGRAM
D5      .set    0               ;5us delay
D10     .set    1               ;10us delay
D100    .set    21              ;100us delay
D5K     .set    1100            ;5ms delay
D7K     .set    1545            ;7ms delay

DLOOP  .set      86           ;5us delay loop @ 20MIPs

*DLOOP variable for variable CLKOUT1
*Calculate DLOOP in decimal using the equation 
* DLOOP=(5us*CLKOUT1)-14;
*Examples
*a. @15Mhz,  DLOOP= ;           Check these.
*b. @9.8304Mhz,  DLOOP= ;
*c. @16.384Mhz,  DLOOP= ;

* On-chip I/O registers
F24X_ACCS .set    0FF0Fh  ;F240 ACCESS CNTRL REGISTER.

