//---------------------------------------------------------
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <windows.h>
#include <stdlib.h>
#include "beamer3.rh"
#include "exp_anal.h"
#include "dsk.h"
//---------------------------------------------------------
typedef enum GRAPHMODE {DM_BAR,DM_DOT,DM_SPECT,DM_LINE};
typedef enum APPMODE   {AM_OSC,AM_FFT,AM_SCAN         };
//---------------------------------------------------------
#define  PI         3.141592654
#define  PalEntries 256
#define  NMAX       2048
//#define  QUIT       FALSE
#define  NEW_BKGND  TRUE
#define  OLD_BKGND  FALSE
#define  bh         25
#define  bw         64
#define  MaxSamples 512               // Max FFT size
#define  bw2  (bw+bw+5)
#define  bh2  (      5)

int   dY        =        256;
int   maxy      =          0;
int   maxx      =          0;
int   StepSize  =          2;
//---------------------------------------------------------
char   DSK_APP  []    = "   DSKOSC.DSK";
char   szAppName[]    =       "DSK3API";
char   S        [200];
int    PlotY    [NMAX];
int    oldY     [NMAX];
char   AboutStrg[] = "BEAMER3.EXE\n"
                   "(C)1998\n"
                   "Keith Larson\n"
                   "Texas Instruments Inc";
//---------------------------------------------
ulong  LastSamples=         0;
ulong  EDGESEL    =         0;
ulong  THRESHOLD  =         0;
ulong  A_REG      =         0;
ulong  B_REG      =         0;
ulong  C_REG      =         0;
ulong  AICLOAD_BOX=         0;
ulong  MSG_BOX    = 0x809E00L;
ulong  DATABLOCK  = 0x808020L; //Default points to TIM0
ulong  SAMPLES    =         0;
ulong  Samples    =       512; //Default FFT size is 256
ulong  START      =         2;
ulong  Tprd       =         1;
ulong  CREG       =      0x03; // AIC control register bits
int    TA         =        10; // DAC divisors
int    TB         =        14; //
int    RA         =        10; // ADC divisors
int    RB         =        14; //
int    TAP        =         1; // TA' and RA' are not used in this application
int    RAP        =         1; //
int    PulseMode  =         0;
int    AVG        =         1;
int    UpdateAIC  =         1;
int    mag2       =         1;
//- - - - - - - - - - - - - - 
float  Fh         =    25.0E6;  // 1/Thx
float  Fmclk      =    1000.0;
float  Fsclk      =    1000.0;
float  Fadc       =    1000.0;
float  Fadclo     =    1000.0;
float  Fadchi     =    1000.0;
float  Fdac       =    1000.0;
float  Fdaclo     =    1000.0;
float  Fdacscf    =  288000.0;
float  Fadcscf    =  288000.0;
float  ScreenGain =    0.0625; // Used in division... init with non zero
NUM_TYPE InConvType=  NT_AUTO;
int    Osc_Max    =         0;
int    Osc_Min    =         0;
long   Offset     =         0;
long   Threshold  =         0;
ulong  Edge       =         0;
float  Ftyp       =       0.0;
float  V_div      =       0.0;
float  V_lsb      =      1e-6; // Used in division... init with non zero
float  V_dc       =       0.0;
float  V_pp       =       1.0; // Used in division... init with non zero
int    DispSamples=       256;

uint Win_port = 0x378;
//------------------------------------------------------------------------
RECT                     rect             ;
HDC                      hdcMem           ;
HINSTANCE                hIglbl     = NULL;
HACCEL                   haccel     = NULL;
LOGPALETTE              *pPal       = NULL;
HPALETTE                 hLogPal          ;
PAINTSTRUCT              ps               ;
LOCALHANDLE              hLocMem          ;
HBRUSH                   hBrush           ;
int                      BMPLOADED  =    0;
static char             *BitMapBits = NULL;
static char             *bmpbits    = NULL;
static BITMAPINFO       *bmi        = NULL;
static BITMAPINFOHEADER *bmih       = NULL;
static HBITMAP           hBmem            ;
static HGLOBAL           BMP_handle       ; // Handle to BMP data block
//------------------------------------------------------------------------
long FAR PASCAL _export WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpCmdLine,int nCmdShow);
//------------------------------------------------------------------------
void UnloadBMP(void)
{ if(BMPLOADED)   // De-allocate locked BMP data block
  { GlobalUnlock(BMP_handle);
    GlobalFree(BMP_handle);
  }
}
//------------------------------------------------------------------------
void CreateBMP(HDC hdc, HPALETTE hLogPal)
{
  SHORT *pi;
  SHORT i;
  int BMPWidth;
  //----------------------------------------------------------------------
  // A large block of memory is allocated to hold an image of a 'DIB BMP'
  // as if it where a file image.  By then copying the correct number of
  // bits to an output file an FFT spectrogram BMP file can then be
  // viewed in a conventional BMP viewer.
  //----------------------------------------------------------------------
  if(!BMPLOADED)
  { BMP_handle = GlobalAlloc(GPTR,300000L);
    BitMapBits = (char *) GlobalLock(BMP_handle);
  }
  //----------------------------------------------------------------------
  BitMapBits[ 0] = 0x42;    // 'B'
  BitMapBits[ 1] = 0x4D;    // 'M'
  BitMapBits[ 2] = 0x06;    // Size of file in bytes
  BitMapBits[ 3] = 0x48;    //
  BitMapBits[ 4] = 0x01;    //
  BitMapBits[ 5] = 0x00;    //
  BitMapBits[ 6] = 0x00;    // Unknown
  BitMapBits[ 7] = 0x00;
  BitMapBits[ 8] = 0x00;
  BitMapBits[ 9] = 0x00;
  BitMapBits[10] = 0x36;    // File ptr to BMP data, 14+bmiHeader+PalEntries*4
  BitMapBits[11] = 0x01;
  BitMapBits[12] = 0x00;
  BitMapBits[13] = 0x00;
  BMPWidth = 1024;
  bmih  = (BITMAPINFOHEADER *)(BitMapBits+14);   // BITMAPINFOHEADER
  bmi   = (BITMAPINFO       *) bmih          ;   // BITMAPINFO  bmih
  bmi->bmiHeader.biSize          =         40;
  bmi->bmiHeader.biWidth         =   BMPWidth;
  bmi->bmiHeader.biHeight        =          8;
  bmi->bmiHeader.biPlanes        =          1;
  bmi->bmiHeader.biBitCount      =          8;
  bmi->bmiHeader.biCompression   =          0;
  bmi->bmiHeader.biSizeImage     =
           (bmi->bmiHeader.biWidth)*(bmi->bmiHeader.biHeight);
  bmi->bmiHeader.biXPelsPerMeter =          0;
  bmi->bmiHeader.biYPelsPerMeter =          0;
  bmi->bmiHeader.biClrUsed       = PalEntries;
  bmi->bmiHeader.biClrImportant  = PalEntries;
  bmpbits  = (char *)bmih;
  bmpbits += (int  ) bmih->biSize;
  pi       = (SHORT *) bmpbits;
  bmpbits += (int  ) (bmih->biClrUsed)*4;
  //--------------------------------------
  // Use this to simply use the existing palette with no mapping
  for(i=0;i<PalEntries;i++)
  {
    *pi++ = i;
  }
  SelectPalette(hdc,hLogPal,0);   // Select a palette compatible with the
  RealizePalette(hdc);            // destination hDC
  //
  // The bitmap array in memory is copied to a new DIB array and a handle is
  // returned.  The DIB copy cannot be modified by changing the original data.
  // Use SetDIBits() to modify only a few lines, or recall CreateDIBitmap().
  // However, this function swaps to disk which may not be desireable
  //
  hBmem=CreateDIBitmap(hdc,bmih,CBM_INIT,bmpbits,bmi,DIB_PAL_COLORS);
  BMPLOADED = 1;
}
//---------------------------------------------------------------
// Special print routines for engineers
//    eprintf()     prints using engineering prefixes
//    E_printf()    prints engineering style floats
//    Bin_sprintf() prints binary base 2 1's and 0's
//---------------------------------------------------------------
void  eprintf(char *s,float f)
{
  float sign;
  int   Exp = 0;
  if(f <0) sign = -1;
  else     sign =  1;
  f = (float)fabs(f);
  if(f==0.0) { sprintf(s,"0.000"); return; }
  if(f > 1)  { while(f > 1000) { Exp += 3; f *= 0.0010; }; }
  else       { while(f <    1) { Exp -= 3; f *= 1000.0; }; }
  f*=sign;
  switch(Exp)
  {
    case  12: sprintf(s,"%7.3f T",f); break;
    case   9: sprintf(s,"%7.3f G",f); break;
    case   6: sprintf(s,"%7.3f M",f); break;
    case   3: sprintf(s,"%7.3f K",f); break;
    case   0: sprintf(s,"%7.3f " ,f); break;
    case  -3: sprintf(s,"%7.3f m",f); break;
    case  -6: sprintf(s,"%7.3f u",f); break;
    case  -9: sprintf(s,"%7.3f n",f); break;
    case -12: sprintf(s,"%7.3f p",f); break;
    case -15: sprintf(s,"%7.3f f",f); break;
    default: sprintf(s,"%7.3fE%d",f,Exp); break;
  }
}
void  E_printf(char *s,float f)
{
  float sign;
  int   Exp = 0;
  if(f <0) sign = -1;
  else     sign =  1;
  f = (float)fabs(f);
  if(f==0.0) { sprintf(s,"0.000"); return; }
  if(f > 1)  { while(f > 1000) { Exp += 3; f *= 0.0010; }; }
  else       { while(f <    1) { Exp -= 3; f *= 1000.0; }; }
  f*=sign;
  sprintf(s,"%7.3fE%d",f,Exp);
}

void Bin_sprintf(char *c, int x, int digits)
{
  unsigned int i;
  i=1;
  for(;digits>1;digits--) i=i<<1;
  for(;i!=0;i=i>>1)
  {
    if(i&x) *c++='1';
    else    *c++='0';
  }
  *c = 0;
}
//---------------------------------------------------------------
// The following functions are used with the AIC and other
// dialog boxes where user input is required.
//    Displayed data is in engineering style formats
//    Inputs are capable of expression analysis
//---------------------------------------------------------------
int UpdateDlgItem(HWND hDlg,WPARAM param,NUM_TYPE type)
{
   NUM_TYPE RetType;
   float f;
   int i;
   ulong Val;
   GetDlgItemText(hDlg,param,S,25);
   RetType = expressionz(S,&Val,type);
   switch(RetType)
   {
     case NT_INTEGER: i=(int)Val; break;
     case NT_FLOAT  : f = *((float *) & Val);
		              i = (int)f;
					  break;
     default        : break;
   }
   return i;
}
//---------------------------------------------------------------
void Calc_Regs(void)
{
    if(TA>31) TA=31; if(TA< 4)TA= 4;
    if(TB>63) TB=63; if(TB<10)TB=10;
    if(RA>31) RA=31; if(RA< 4)RA= 4;
    if(RB>63) RB=63; if(RB<10)RB=10;
    if(Tprd<1) Tprd = 1;    if(Tprd>16) Tprd = 16;
    Fmclk  = 0.5*Fh / (float)Tprd;
    if(!PulseMode) Fmclk/=2;
    Fsclk  = (float)(Fmclk * 0.25);
    Fadc = Fmclk / (float) (2*(TA * TB));
    Fdac = Fmclk / (float) (2*(RA * RB));
    Fadcscf = Fsclk / RA;
    Fdacscf = Fsclk / TA;
    if(CREG&0x20){ Fadc=Fdac; Fadcscf = Fdacscf;}
    Fadchi = (float)(3000.0 * Fadcscf/288000.0);
    Fadclo = (float)( 300.0 * Fadcscf/288000.0);
    Fdaclo = (float)(3000.0 * Fdacscf/288000.0);
}
void Show_AIC_Regs(HWND hDlg)
{
    //--- Calculate the various values needed for display ---
    Calc_Regs();
    //--- Print them to each dialog box string --------------
    sprintf(S,    "%d",(int)  TA); SetDlgItemText(hDlg, IDC_TA    ,S);
    sprintf(S,    "%d",(int)  TB); SetDlgItemText(hDlg, IDC_TB    ,S);
    sprintf(S,    "%d",(int) TAP); SetDlgItemText(hDlg, IDC_TAP   ,S);
    sprintf(S,    "%d",(int)  RA); SetDlgItemText(hDlg, IDC_RA    ,S);
    sprintf(S,    "%d",(int)  RB); SetDlgItemText(hDlg, IDC_RB    ,S);
    sprintf(S,    "%d",(int) RAP); SetDlgItemText(hDlg, IDC_RAP   ,S);
    sprintf(S,"0x%04x",(int)CREG); SetDlgItemText(hDlg, IDC_CTRL  ,S);
    sprintf(S,    "%d",(int)Tprd); SetDlgItemText(hDlg, IDC_TPRD  ,S);
    E_printf(S,(float)  Fmclk); SetDlgItemText(hDlg, IDC_MCLK  ,S);
    E_printf(S,(float)  Fsclk); SetDlgItemText(hDlg, IDC_SCLK  ,S);
    E_printf(S,(float)   Fadc); SetDlgItemText(hDlg, IDC_FADC  ,S);
    E_printf(S,(float)   Fdac); SetDlgItemText(hDlg, IDC_FDAC  ,S);
    E_printf(S,(float) Fadchi); SetDlgItemText(hDlg, IDC_FADCHI,S);
    E_printf(S,(float) Fadclo); SetDlgItemText(hDlg, IDC_FADCLO,S);
    E_printf(S,(float) Fdaclo); SetDlgItemText(hDlg, IDC_FDACLO,S);
    //--- Update the pusButtons ----------------------------
    CheckDlgButton(hDlg, IDC_TPMODE, (int) PulseMode);
    CheckDlgButton(hDlg, IDC_TSMODE, (int)!PulseMode);
    // IDC_D0 - IDC_D7
    CheckDlgButton(hDlg, IDC_D0, (int)(CREG & 0x01));
    CheckDlgButton(hDlg, IDC_D1, (int)(CREG & 0x02));
    CheckDlgButton(hDlg, IDC_D2, (int)(CREG & 0x04));
    CheckDlgButton(hDlg, IDC_D3, (int)(CREG & 0x08));
    CheckDlgButton(hDlg, IDC_D4, (int)(CREG & 0x10));
    CheckDlgButton(hDlg, IDC_D5, (int)(CREG & 0x20));
    CheckDlgButton(hDlg, IDC_D6, (int)(CREG & 0x40));
    CheckDlgButton(hDlg, IDC_D7, (int)(CREG & 0x80));
}

void Update_AIC_Regs(HWND hDlg)
{
    InConvType = NT_AUTO;
    RA    =(int)UpdateDlgItem(hDlg,IDC_RA  ,NT_INTEGER);
    RB    =(int)UpdateDlgItem(hDlg,IDC_RB  ,NT_INTEGER);
    RAP   =(int)UpdateDlgItem(hDlg,IDC_RAP ,NT_INTEGER);
    TA    =(int)UpdateDlgItem(hDlg,IDC_TA  ,NT_INTEGER);
    TB    =(int)UpdateDlgItem(hDlg,IDC_TB  ,NT_INTEGER);
    TAP   =(int)UpdateDlgItem(hDlg,IDC_TAP ,NT_INTEGER);
    CREG  =(int)UpdateDlgItem(hDlg,IDC_CTRL,NT_INTEGER);
    Tprd  =(int)UpdateDlgItem(hDlg,IDC_TPRD,NT_INTEGER);
    CREG &= 0xFF;
}
BOOL DLLEXTEND_FN AIC_Setup(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  if(lParam==-1) return TRUE;
  switch(message)
  {
    case WM_INITDIALOG: // haccel = LoadAccelerators(hIglbl, "ACCELERATORS");
                        Show_AIC_Regs(hDlg); return TRUE;
    case WM_PAINT     : Show_AIC_Regs(hDlg); break;
    case WM_CLOSE     : EndDialog(hDlg, TRUE); return TRUE;
    default           : break;
    case WM_COMMAND   :
          switch(wParam)
          {
            case IDC_TPMODE: PulseMode=1; Show_AIC_Regs(hDlg); break;
            case IDC_TSMODE: PulseMode=0; Show_AIC_Regs(hDlg); break;
            case IDC_D0    :  CREG|=0x01; Show_AIC_Regs(hDlg); break;
            case IDC_D1    :  CREG|=0x02; Show_AIC_Regs(hDlg); break;
            case IDC_D2    :  CREG^=0x04; Show_AIC_Regs(hDlg); break;
            case IDC_D3    :  CREG^=0x08; Show_AIC_Regs(hDlg); break;
            case IDC_D4    :  CREG^=0x10; Show_AIC_Regs(hDlg); break;
            case IDC_D5    :  CREG^=0x20; Show_AIC_Regs(hDlg); break;
            case IDC_D6    :  CREG^=0x40; Show_AIC_Regs(hDlg); break;
            case IDC_D7    :  CREG^=0x80; Show_AIC_Regs(hDlg); break;
            case ID_OK     : Update_AIC_Regs(hDlg);
                             UpdateAIC = 1;
                             EndDialog(hDlg, TRUE);
                             return TRUE;
            case CM_RETURN : // Return key or CALC button pressed
            case IDC_CALC  : Update_AIC_Regs(hDlg);
                             Show_AIC_Regs(hDlg);
                             break;
            case ID_CANCEL : EndDialog(hDlg, TRUE);

            // wParam==1, lParam==0, Appears to be Enter key
            case          1: if(lParam!=0) return TRUE;
                             Update_AIC_Regs(hDlg);
                             Show_AIC_Regs(hDlg);
                             break;

            default        : return TRUE;

          }
  }
  return FALSE;
}
//----------------------------------------------------------------
// Use this dialog box to modify the printer port settings
// Abort, Retry, LPT1 LPT2 LPT3, Bi-Dir Norm
//----------------------------------------------------------------
void ports2(int port)
{
  Win_port = port;
  ports(port);
}

uint Win_port_mode = 0;
MSGS PP_INIT_MSG = NO_ERR;
BOOL DLLEXTEND_FN PortInit(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  CheckDlgButton(hDlg,PI_LPT1, Win_port==0x378);
  CheckDlgButton(hDlg,PI_LPT2, Win_port==0x278);
  CheckDlgButton(hDlg,PI_LPT3, Win_port==0x3BC);
  CheckDlgButton(hDlg,PI_NORM, Win_port_mode==4);
  CheckDlgButton(hDlg,PI_BIDIR,Win_port_mode==8);
  CheckDlgButton(hDlg,PI_AUTO, Win_port_mode==0);
  switch(message)
  {
    case WM_INITDIALOG: PP_INIT_MSG = NO_ERR;
                        SetDlgItemText(hDlg,PI_MSG,EXTMSGPTR());
                        SetFocus(GetDlgItem(hDlg, PI_OK));
                        if(lParam == NULL) return FALSE;
                        break;
    case WM_COMMAND   : switch(wParam)
                        {
                           case PI_OK   : EndDialog(hDlg, TRUE);
                                          ports2(Win_port);
                                          Set_BW_force(Win_port_mode);
                                          return TRUE;
                           case PI_EXIT : PP_INIT_MSG = QUIT;
                                          EndDialog(hDlg, TRUE);
                                          return TRUE;
                           case PI_LPT1 : ports2(0x378); break;
                           case PI_LPT2 : ports2(0x278); break;
                           case PI_LPT3 : ports2(0x3BC); break;
                           case PI_NORM : Win_port_mode = 4; break;
                           case PI_BIDIR: Win_port_mode = 8; break;
                           case PI_AUTO : Win_port_mode = 0; break;
                        }
                        break;
  }
  return FALSE;
}

void  MBX(HWND hwnd,char *s,ulong x)
{
  sprintf(S,"%08lx",x);
  MessageBox(hwnd,s,S,MB_OK);
}

//======================================================================
// The job of WinMain is to create the 'parant' window within which
// messages are intercepted from the O/S and sub windows are created.
//======================================================================
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine, int cmdShow)
{

  WNDCLASS wndclass;
  HWND hWnd;
  MSG msg;
  if(lpszCmdLine==NULL) return 0; // added to prevent compiler warning
                                  // cmd line address is never NULL
  if (!hPrevInstance)             // if no previous instance, define wndclass
  {
    wndclass.style         =                                   0;
    wndclass.lpfnWndProc   =                             WndProc;
    wndclass.cbClsExtra    =                                   0;
    wndclass.cbWndExtra    =                                   0;
    wndclass.hInstance     =                           hInstance;
    wndclass.hIcon         =      LoadIcon(NULL,IDI_APPLICATION);
    wndclass.hCursor       =          LoadCursor(NULL,IDC_ARROW);
//  wndclass.hbrBackground =                      COLOR_WINDOW+1;
    wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
//  wndclass.lpszMenuName  =                                NULL;
    wndclass.lpszMenuName  =                             "MENU_";
    wndclass.lpszClassName =                           szAppName;
    if(!RegisterClass(&wndclass))
       return FALSE;
  }
  haccel = LoadAccelerators(hInstance,"ACCELERATORS");
  hWnd = CreateWindow
    (
      szAppName,
      __FILE__,                // Window title bar string
      WS_OVERLAPPEDWINDOW,     // Window style
      50,                      // Initial x pos
      50,                      // Initial y pos
      512+220 +(2*bw),         // Initial Width
              (15*bh),         // Initial Height
      0,                       // Parent window handle
      0,                       // Window menu handle
      hInstance,               // Program Instance handle
      NULL                     // Create parameters
    );
  hIglbl = hInstance;
  ShowWindow(hWnd, cmdShow);
  UpdateWindow(hWnd);
  //
  // Get and dispatch messages for this applicaton.
  //
  while (GetMessage(&msg, NULL, 0, 0))
  {
    if(TranslateAccelerator(hWnd,haccel,&msg)==0)
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
  return(msg.wParam);
}
//----------------------------------------------------------------------
// Allows the mouse to be moved via 'hotkey' keytraps
//----------------------------------------------------------------------
void mousemoverel(int x,int y)
{
  POINT pt;
  GetCursorPos(&pt);
  SetCursorPos(pt.x+x,pt.y+y);
}
//----------------------------------------------------------------------
// Graphics and TExt functions that are used to display data coming from
// the DSK need to be mapped to an area determined by the user.
//----------------------------------------------------------------------
inline void MySetRect(RECT FAR *rect,int x1,int y1,int x2,int y2)
{
  SetRect(rect,bw2+x1,bh2+y1,bw2+x2,bh2+y2);
}
inline void MyMoveToEx(HDC hdc,int x,int y,POINT FAR *p)
{
  MoveToEx(hdc,bw2+x,bh2+y,p);
}
inline void MySetPixel(HDC hdc,int x,int y,COLORREF PCOLOR)
{
  SetPixel(hdc,bw2+x,bh2+y,PCOLOR);
}

inline void MyLineTo(HDC hdc,int x,int y)
{
  LineTo(hdc,bw2+x,bh2+y);
}
inline void Line(HDC hdc,int x1,int y1,int x2,int y2)
{
  MoveToEx(hdc,bw2+x1,bh2+y1,NULL); LineTo(hdc,bw2+x2,bh2+y2);
}

void inline MyText(HDC hdc,int x,int y,char *t)
{
  TextOut(hdc,bw2+x,bh2+y,t,strlen(t));
}
//---------------------------------------------------------
inline void LineC(HDC hdc,int x1,int y1,int x2,int y2,int color)
{
  HPEN  hpen, hpenOld;
  hpen=CreatePen(PS_SOLID,1,PALETTEINDEX(color));
  hpenOld = SelectObject(hdc, hpen);        // Select new color pen
  Line(hdc,x1,y1,x2,y2);
  SelectObject(hdc, hpenOld);
  DeleteObject(hpen);
}
//---------------------------------------------------------
inline void DispBox(HDC hdc,int x,int y,int color)
{
  HPEN  hpen, hpenOld;
  hpen=CreatePen(PS_SOLID,1,PALETTEINDEX(color));
  hpenOld = SelectObject(hdc, hpen);        // Select new color pen
  Line(hdc,x-1,y+1,x-1,y+1);
  Line(hdc,x+1,y+1,x-1,y+1);
  Line(hdc,x+1,y+1,x+1,y+1);
  Line(hdc,x-1,y+1,x+1,y+1);
  SelectObject(hdc, hpenOld);
  DeleteObject(hpen);
}
//---------------------------------------------------------
void TextXY(HDC hdc,char *t, int x,int y,HPALETTE pal,int bc,int tc)
{
  HPALETTE  hOldPalette;
  if(pal==NULL) // use current pallette
  {
    MyText(hdc,x,y,t);
    return;
  }
  hOldPalette = SelectPalette(hdc,pal,0);
  RealizePalette(hdc);
  SetBkColor  (hdc,PALETTEINDEX(bc));
  SetTextColor(hdc,PALETTEINDEX(tc));
  MyText(hdc,x,y,t);
  SelectPalette(hdc,hOldPalette,0);
}
//--------------------------------------------------------
// draw_vect_peak() draws the vertical display bars for
// each frequency bin.  To speed up the line draws, only
// the part which changes is drawn using an XOR function
//--------------------------------------------------------
MSGS FFT_info(HDC hdc,int last)
{
  MSGS err; //=NO_ERR;
  int x, i, L2;
  float sum,f1,f2,dB;
  float f[10];
  // After finding the peak, go back and get the full precision data
  maxy = PlotY[3];
  maxx = 0;
  for(x=3;x<last-3;x++)
  {
    if(PlotY[x]<maxy) { maxy=PlotY[x]; maxx=x; }
  }
  x = maxx;
  #define  CENT  7 // Number of samples to use in centroid
  L2 = CENT>>1;
  if((err=fgetmem(DATABLOCK+MaxSamples+x-L2,CENT,f))!=NO_ERR) return err;
  sum = f[0]; for(i=1;i<CENT;i++) sum += f[i];
  if(sum==0) f1 = 0;
  else
  {
    f2 = x-L2;
    for(i=0;i<CENT;i++) { f1 +=f[i]*f2; f2+=1; }
    f1/= sum;
    f1 = ((f1*Fadc)/(float)(Samples))*1e-3;
  }
  Ftyp = (Ftyp*(AVG-1) + f1)/AVG;
  if(sum<1) dB = -200;
  else      dB = (10*log(sum)/log(10))-134.5; //134.5 derived by measurement
  sprintf(S,"Fpeak=%7.6f khz  %7.2f dB  ",(float) Ftyp,dB);
  MyText(hdc,10    ,dY+ 1,S);
  sprintf(S,"F/div=%7.2f hz    ",(float) Fadc/16);
  MyText(hdc,10    ,dY+20,S);
  sprintf(S,"F/bin=%7.2f hz    ",(float) Fadc/Samples);
  MyText(hdc,10+220,dY+20,S);
  return NO_ERR;
}

void OSC_info(HDC hdc)
{
  int  y,x;
  float dif, G2, Offs,Trgr;
  char buf[128];
  #define VREF 3.15 // TLC32040 voltage reference at pin 8
  G2 = 1.0;
  if((CREG&0x80)&&((CREG&0x40)==0)) G2 = 4;  //+12dB
  if((CREG&0x40)&&((CREG&0x80)==0)) G2 = 2;  // +6dB
  if(Osc_Max==Osc_Min) Osc_Max++;
  dif = (float)Osc_Max-(float)Osc_Min;
  V_lsb = VREF/(G2*16384.0);
  V_div = 32*V_lsb/ScreenGain;
  V_pp = (dif                        )*V_lsb,
  V_dc = ((long)Osc_Max+(long)Osc_Min)*V_lsb,
  //Offs=(100.0*((float)Offset-(float)Osc_Min)/dif)-50;
  Offs=Offset * V_lsb;
  //Trgr= 100.0*((float)Threshold-(float)Osc_Min)/dif; // As percentage
  Trgr= Threshold * V_lsb;                           // As volts
  if(Edge) sprintf(S,"-Edge");
  else     sprintf(S,"+Edge");                 MyText(hdc,x=   0,y=dY+ 1,S);
  eprintf(buf,Trgr);sprintf(S,"Trgr=%sV ",buf);MyText(hdc,x+=140,y      ,S);
  eprintf(buf,Offs);sprintf(S,"Offs=%sV ",buf);MyText(hdc,x+=140,y      ,S);
//sprintf(S,"Offs=%d\%  ",(int)Offs);          MyText(hdc,x+=140,y      ,S);
  eprintf(buf,V_pp );sprintf(S,"%sVpp ",  buf);MyText(hdc,x+=140,y      ,S);
  eprintf(buf,V_dc );sprintf(S,"%sVdc ",  buf);MyText(hdc,x     ,y+=25  ,S);
  eprintf(buf,V_div);sprintf(S,"%sV/div ",buf);MyText(hdc,x=   0,y=dY+25,S);
  eprintf(buf,V_lsb);sprintf(S,"%sV/lsb ",buf);MyText(hdc,x+=140,y      ,S);
}
void AIC_info(HDC hdc, int DispMode, int last)
{
  char buf[80];
  int cx, y;
  if(DispMode!=DM_SPECT) cx = mag2*last+35;
  else                   cx =      last+35;
  y = 0;
  Calc_Regs();
  sprintf(S,"Size=%d(disp x%d)",(int)Samples,mag2); MyText(hdc,cx,y+=10,S);
  sprintf(S,"Avg =%d",(int)                   AVG); MyText(hdc,cx,y+=20,S);
  Bin_sprintf(buf,(int)CREG,8);
  sprintf(S,"CTL =%s",      buf); MyText(hdc,cx,y+=30,S);
  sprintf(S,"TA  =%d",(int)  TA); MyText(hdc,cx,y+=20,S);
  sprintf(S,"TB  =%d",(int)  TB); MyText(hdc,cx,y+=20,S);
  sprintf(S,"RA  =%d",(int)  RA); MyText(hdc,cx,y+=20,S);
  sprintf(S,"RB  =%d",(int)  RB); MyText(hdc,cx,y+=20,S);
  sprintf(S,"Tprd=%d",(int)Tprd); MyText(hdc,cx,y+=20,S);
  eprintf(buf,Fmclk);
  if(PulseMode)      sprintf(S,"Tclk=%sHz(pls)",buf);
  else               sprintf(S,"Tclk=%sHz(sqr)",buf); MyText(hdc,cx,y+=20,S);
  eprintf(buf,Fdac); sprintf(S,"Fdac=%sHz"     ,buf); MyText(hdc,cx,y+=30,S);
  eprintf(buf,Fadc); sprintf(S,"Fadc=%sHz"     ,buf); MyText(hdc,cx,y+=20,S);
//sprintf(S,"DataPtr=0x%08lx",DATABLOCK); MyText(hdc,cx,y+=20,S);
}
void Draw_Osc_Grid(HDC hdc,int last)
{
  int i, y, cx, xx,div,DIVS;
  int n=128;
  dY   = 256;
  DIVS = 8;
  #define ticks 4
  y = last /(DIVS*ticks);
  i = 0;
  for(div=0;div<DIVS;div++)
  {
    Line(hdc,i*mag2,0,i*mag2,dY);
    for(xx=0;xx<ticks;xx++)
    {
      Line(hdc,i*mag2,n+3,i*mag2,n-3);
      i+=y;
    }
    Line(hdc,i*mag2,0,i*mag2,dY);
  }
  // Vt marker divisions
  y = dY / (DIVS*ticks);
  cx = last*mag2;
  i = 0;
  for(div=0;div<DIVS;div++)
  {
    Line(hdc,0,i,cx,i);
    n=cx>>1;
    for(xx=0;xx<ticks;xx++)
    {
      Line(hdc,n-3,i,n+3,i);
      i+=y;
    }
    Line(hdc,0,i,cx,i);
  }
}
void Draw_FFT_Grid(HDC hdc,int last)
{
  int i, y, cx,DIVS;
  DIVS=8;
  dY=260;
  y = last / DIVS;
  for(i=0;i<=last;i+=y) Line(hdc,i*mag2,0,i*mag2,dY);
  DIVS=10;
  y = dY/DIVS;
  for(i=0;i<=dY  ;i+=y) Line(hdc,0,i,mag2*last,i);
  cx = mag2*last + 2;
  for(i=0;i<dY;i+=y)
  {
    sprintf(S,"%+2d",-10*i/y);
    MyText(hdc,cx+2,i+15,S);
  }
}
void disp_grid_info(HDC hdc, int DispMode, int AppMode)
{
  COLORREF LINECOLOR;
  HPEN  hpen, hpenOld;
  SetBkColor  (hdc,PALETTEINDEX(  0));
  SetTextColor(hdc,PALETTEINDEX(150));
  if(DispMode!=DM_SPECT)
  {
    LINECOLOR = PALETTEINDEX(150);
    hpen=CreatePen(PS_SOLID,1, LINECOLOR);
    hpenOld = SelectObject(hdc, hpen);
    switch(AppMode)
    {
       case AM_OSC: Draw_Osc_Grid(hdc,DispSamples); break;
       case AM_FFT: Draw_FFT_Grid(hdc,DispSamples); break;
       default:     break;
    }
    SelectObject(hdc, hpenOld);
    DeleteObject(hpen);
  }
  AIC_info(hdc,DispMode,DispSamples);
  switch(AppMode)
  {
    default:
    case AM_FFT: FFT_info(hdc,DispSamples); break;
    case AM_OSC: OSC_info(hdc     ); break;
  }
}
//--------------------------------------------
// Draw the display
//--------------------------------------------
MSGS DrawData(HDC hdc, int AppMode,int DispMode)
{
//HPALETTE  hOldPalette;
  static int line_ypos;
  COLORREF LINECOLOR;
  MSGS err=NO_ERR;
  HPEN  hpen, hpenOld;
  int blitW, blitH, copied, i, y, cx,z;
  int ROPmode;
//hOldPalette = SelectPalette(hdc,hLogPal,0);
//RealizePalette(hdc);
  //--------------------------------------------
//if(disp_ all)
//  disp_grid_info(hdc,DispMode,AppMode);
  //--------------------------------------------
  // Select a new color for the data
  //--------------------------------------------
  LINECOLOR = PALETTEINDEX(220);
  hpen=CreatePen(PS_SOLID,1, LINECOLOR);
  hpenOld = SelectObject(hdc, hpen);
  //--------------------------------------------
  ROPmode = GetROP2(hdc); // Keep the original mode
  SetROP2(hdc,R2_XORPEN);
  switch(DispMode)
  {
    default:
    case DM_BAR:  cx = 0;
                  for(i=0;i<DispSamples;i++)
                  {
                    y = PlotY[i];
                    for(z=0;z<mag2;z++)
                    {
                      if(y > oldY[i]) Line(hdc,cx,oldY[i]  ,cx,y  ); // erase
                      if(y < oldY[i]) Line(hdc,cx,oldY[i]-1,cx,y-1); // draw
                      cx++;
                    }

                  }
                  break;
    case DM_LINE: MyMoveToEx(hdc,0,dY/2,NULL);
                  for(i=0;i<DispSamples;i++)
                  {
                    cx = i*mag2;
                    MyLineTo(hdc,cx,oldY[i]);
                    if(AppMode==AM_FFT) MySetPixel(hdc,cx,oldY[i],LINECOLOR);
                  }
                  MyMoveToEx(hdc,0,dY/2,NULL);
                  for(i=0;i<DispSamples;i++)
                  {
                    cx = i*mag2;
                    MyLineTo(hdc,cx,PlotY[i]);
                    if(AppMode==AM_FFT) MySetPixel(hdc,cx,PlotY[i],LINECOLOR);
                  }
                  break;

    case DM_DOT:  for(i=0;i < DispSamples;i++)
                  {
                    y = oldY[i];
                    cx = i*mag2;
                    Line(hdc,cx-1,y,cx+1,y); // undraw old
                  }
                  for(i=0;i < DispSamples;i++)
                  {
                    y = PlotY[i];
                    cx = i*mag2;
                    Line(hdc,cx-1,y,cx+1,y); // Draw New
                  }
                  break;

   case DM_SPECT: blitW=(int)bmih->biWidth;
                  blitH=(int)bmih->biHeight; //blitH-k
                  y = 0;
                  #define ystep 1  // Number of times to copy line
                  for(cx=0;cx<ystep;cx++)
                  {
                    for(i=0;i<DispSamples;i++)
                      bmpbits[i+y] = 64+((256-PlotY[i])*.75);
                    y+=blitW;
                  }
                  copied=SetDIBits(hdc,hBmem,blitH-ystep,ystep,bmpbits,bmi,DIB_PAL_COLORS);
                  if(copied==0) return SYS_ERR;
                  hdcMem = CreateCompatibleDC(hdc);
                  SelectObject(hdcMem,hBmem);
                  blitW = DispSamples;
                  BitBlt(hdc,10+bw2,line_ypos ,blitW,ystep,hdcMem,0,0,SRCCOPY);
                  line_ypos+=ystep;
                  if(line_ypos>256  ) line_ypos =0;
                  DeleteDC(hdcMem);   //ReleaseDC(hwnd,hdc);
                  break;
  }
  for(i=0;i<DispSamples;i++)
    oldY[i] = PlotY[i];
  //- Turn off XOR draw mode
  SetROP2(hdc,ROPmode);
  SelectObject(hdc, hpenOld);
  DeleteObject(hpen);
//SelectPalette(hdc,hOldPalette,0);
  return err;
}
//-----------------------------------------------------------------------
MSGS ComCheck(void)
{
  MSGS err;
  ulong ltemp;
  ltemp=0x320C31L;
  if((err=putmem(MSG_BOX,1,&ltemp))!=NO_ERR) return err;
  if((err=getmem(MSG_BOX,1,&ltemp))!=NO_ERR) return err;
  if(ltemp!=0x320C31L) return COM_ERR;
  return NO_ERR;
}
MSGS getdata(int AppMode)
{
  float K1, K2;
  MSGS err;
  MSG msg;
  SHORT dat;
  int  i, y;
  SHORT *ip;
  char *cp;
  long l;
  ulong ltemp;
  ulong  ldata    [NMAX];
  int    adata    [NMAX];
//  MAX_WAIT = 10*Samples / (2e-6*Fdac); // Adjust for slow buffer fill rates
  //---------------------------------------------------------
  // Drive HPSTB (INT2) low and wait...
  //   Process any new Windows messages that might occur
  //---------------------------------------------------------
  HPI_STRB(0);
  for(;;)
  {
    if(HPI_ACK()) break;
    if(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)) return WIN_MSG;
  }
  //-----------------------------------------------------------------
  // Determine the number of samples that need to be downloaded
  // from the DSK by the application and Sample size.  For example
  // in an FFT, the positive and negative frequency domain data
  // is identical, and this is converted to log2 magnitudes, packed
  // as bytes.  The number of 32 bit words to download is therefor
  // Samples/8.  Oscilliscope is packed 16 bit values
  //-----------------------------------------------------------------
  if(Samples>1024) Samples = 1024;
  switch(AppMode)
  {
    default    : DispSamples = (int)Samples/2; l = Samples/8; break;
    case AM_OSC: DispSamples = (int)Samples  ; l = Samples/2; break;
  }
  LastSamples = l;

  if((err=getmem(DATABLOCK,l,ldata))!=NO_ERR) return err;
  //-----------------------------------------------------------------
  // With the data downloaded, the DSK can get started on the next
  // data frame while the host works on the display.
  //-----------------------------------------------------------------
  if(UpdateAIC)
  {
    ulong AREG, BREG;
    UpdateAIC = 0;
    if(PulseMode) AREG = 0x2C1;
    else          AREG = 0x3C1;
    if((err=putmem(0x00808020L,1,&AREG))!=NO_ERR) return err;
    if((err=putmem(0x00808028L,1,&Tprd))!=NO_ERR) return err;
    AREG = 1;
    if((err=putmem(0x00808024L,1,&AREG))!=NO_ERR) return err;
    AREG = (TA<<9)+(RA<<2)+0;
    BREG = (TB<<9)+(RB<<2)+2;
    if((err=putmem(A_REG      ,1,&AREG ))!=NO_ERR) return err;
    if((err=putmem(B_REG      ,1,&BREG ))!=NO_ERR) return err;
    if((err=putmem(C_REG      ,1,&CREG ))!=NO_ERR) return err;
    if((err=putmem(AICLOAD_BOX,1,&START))!=NO_ERR) return err;
 // if((err=putmem(MSG_BOX ,1,&START))!=NO_ERR) return err;
  }
  if(AppMode==AM_OSC)
  {
    if((err=putmem(THRESHOLD,1,(ulong *)&Threshold))!=NO_ERR) return err;
    if((err=getmem(THRESHOLD,1,&ltemp))!=NO_ERR) return err;
    if((err=putmem(EDGESEL  ,1,&Edge ))!=NO_ERR) return err;
  }

  if((err=putmem(SAMPLES ,1,&Samples))!=NO_ERR) return err;
  if((err=ComCheck())!=NO_ERR) return err;
  /*
  ltemp=0x320C31L;
  if((err=putmem(MSG_BOX,1,&ltemp))!=NO_ERR) return err;
  if((err=getmem(MSG_BOX,1,&ltemp))!=NO_ERR) return err;
  if(ltemp!=0x320C31L) return COM_ERR;
  */
  if((err=putmem(MSG_BOX,1,&START))!=NO_ERR) return err;
  //-----------------------------------------------------------------
  // With the DSP now working on the next data frame, start working
  // displaying the results that were just downloaded.  The first
  // step is to convert the raw data into plotable x,y points
  //-----------------------------------------------------------------
  K1 = AVG - 1;
  K2 = 1.0/AVG;
  cp = (char *) ldata;
  ip = (SHORT *) ldata;
  //
  // Generate plot data
  //
  Osc_Max = -32000;
  Osc_Min =  32000;
  for(i=0;i<DispSamples;i++)
  {
    switch(AppMode)
    {
      default:
      case AM_FFT: dat = *cp++; break;
      case AM_OSC: dat = *ip++;
                 //dat = (dat<<16)>>16;
                   if(dat>Osc_Max) Osc_Max = dat;
                   if(dat<Osc_Min) Osc_Min = dat;
                   dat = (dat + Offset)* ScreenGain;
                   break;
    }
    y = (dat + (K1*adata[i]))*K2;
    adata[i] = y;
    y = dY - 128 - y;
    if(y<  0) y =  0;
    if(y> dY) y = dY;
    PlotY[i] = y;
  }
  return err;
}
//---------------------------------------------------------
/*
MSGS DSK_WinInitCom(HWND hwnd, int loops)
{
  FARPROC FarProc;
  MSGS err;
  for(;;)
  {
    err = Init_Communication(loops);
    if(err==NO_ERR)
    {
      return err;
    }
    FarProc = MakeProcInstance((FARPROC)PortInit,hIglbl);
    DialogBox(hIglbl,"PP_INIT",hwnd,FarProc);
    FreeProcInstance(FarProc);
    if(PP_INIT_MSG == QUIT)
    {
      PostQuitMessage( 0 );
      return NO_ERR;
    }
  }
}
*/
//------------------------------------------------------------------
#define Quit PostQuitMessage
MSGS InitApp(HWND hwnd, char *appname,int AppMode)
{
  FARPROC FarProc;
  MSGS err;
  int x;
//int k;
  ulong l;
  Set_BW_force(0); // Default is Auto detect mode
  for(x=4;x>0;x--)
  {
    err = Init_Communication(2);
    if(err==NO_ERR) break;
    FarProc = MakeProcInstance((FARPROC)PortInit,hIglbl);
    DialogBox(hIglbl,"PP_INIT",hwnd,FarProc);
    FreeProcInstance(FarProc);
    if(PP_INIT_MSG == QUIT)
    {
      PostQuitMessage( 0 );
      return NO_ERR;
    }

    /*
    switch(err)
    { case EXT_MSG_ERR:
      case EXT_MSG_OK:
               MessageBeep(-1); // Audable alert for user
               k = MessageBox(NULL,EXTMSGPTR(),"Init Com", MB_RETRYCANCEL);
               if(k==IDRETRY) break;
               else
               {
                 PostQuitMessage( 0 );
                 return NO_ERR;
               }
      default: break;
    }
    */
  }
  if(x<=0)
  { PostQuitMessage( 0 );
    return err;
  }
  if((err=HALT_CPU())!=NO_ERR) return err; // Stop DSK.  Now in spin0 loop
  if((err=HALT_CPU())!=NO_ERR) return err; // Stop again sets context to spin0 loop

//CTXT[SP] = 0x809F00L; putmem(CTXT_PTR+SP,1,&CTXT[SP]);
  ulong DLLEXTEND_EX  CTXTPTR(void);
  ulong DLLEXTEND_EX  SPDFLT (void);
  l=SPDFLT()-6; WriteCTXT(SP,l); putmem(CTXTPTR()+SP,1,&l);
  l=0x000080L; WriteCTXT(DP,l); putmem(CTXTPTR()+DP,1,&l);
  l=0x000000L; WriteCTXT(IF,l); putmem(CTXTPTR()+IF,1,&l);
  l=0x0000C4L; WriteCTXT(IE,l); putmem(CTXTPTR()+IE,1,&l);
  if((err=RUN_CPU ())!=NO_ERR) return err; // Run kernel loop spin0
  if((err=HALT_CPU())!=NO_ERR) return err; // stop spin0 loop, update context
  if((err=Load_File(appname,LOAD))!=NO_ERR)
  {
    sprintf(S,"%s %s",appname,Error_Strg(err));
    MessageBox(hwnd,S,"Application Load",MB_OK);
    Quit(0);
    return err;
  }
  else
    Load_File(appname,SLOAD);
  x =ref_value("A_REG"     , (long *)&A_REG);
  x+=ref_value("B_REG"     , (long *)&B_REG);
  x+=ref_value("C_REG"     , (long *)&C_REG);
  x+=ref_value("MSG_BOX"   , (long *)&MSG_BOX);  //**
  x+=ref_value("AICLOAD"   , (long *)&AICLOAD_BOX);
  x+=ref_value("DATA_ARRAY", (long *)&DATABLOCK);
  x+=ref_value("SIZE"      , (long *)&SAMPLES  );
  if(x!=7) return SYM_LOAD;   // err if 7 symbols not loaded
  if(AppMode == AM_OSC)
  {
    ref_value("TLVL"      , (long *)&THRESHOLD);
    ref_value("EDGESEL"   , (long *)&EDGESEL  );
  }
  if((err=getmem(SAMPLES,1,&Samples))!=NO_ERR) return err;
  if((err=ComCheck())!=NO_ERR) return err;
  return (RUN_CPU());
}
void Reset_Data_Pts(void)
{
  int i;
  for(i=0;i<NMAX;i++)
    oldY[i] = dY;
  PlotY[i] = dY;
//  Inva lidateRect(hwnd,NULL,NEW_BKGND);
}

#define  WS  WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON
#define  CW  CreateWindow
#define  SW  ShowWindow

void MB(HWND hWnd,HINSTANCE higlbl,char *c,int x,int y,int w,int h,int CMD)
{
  CreateWindow("BUTTON",c,WS,x,y,w,h,hWnd,(HMENU)CMD,higlbl,NULL);
}

//--------------------------------------------------------------------
void MakeButtons(HWND hwnd,HINSTANCE higlbl)
{
  int x,y;
  static int ButtonsMade = 0;
  if(ButtonsMade) return;
  ButtonsMade = 1;
  y = -bh;
  MB(hwnd,higlbl,   "AIC SETUP",x=0  ,y+=bh,bw*2,bh,CM_AICSET );
  MB(hwnd,higlbl,        "Scan",x=0  ,y+=bh,bw  ,bh,CM_SPECT  );
  MB(hwnd,higlbl,         "Bar",x+=bw,y    ,bw  ,bh,CM_BAR    );
  MB(hwnd,higlbl,        "Line",x=0  ,y+=bh,bw  ,bh,CM_LINE   );
  MB(hwnd,higlbl,        "Dots",x+=bw,y    ,bw  ,bh,CM_DOT    );
  MB(hwnd,higlbl,       "+ pts",x=0  ,y+=bh,bw  ,bh,__F10     );
  MB(hwnd,higlbl,       "- pts",x+=bw,y    ,bw  ,bh,__F9      );
  MB(hwnd,higlbl,      "+ xmag",x =0 ,y+=bh,bw  ,bh,CM_MAGUP  );
  MB(hwnd,higlbl,      "- xmag",x+=bw,y    ,bw  ,bh,CM_MAGDN  );
  MB(hwnd,higlbl,"Fourier Txfm",x=0  ,y+=bh,bw*2,bh,CM_FFT    );
  MB(hwnd,higlbl,"Oscilliscope",x=0  ,y+=bh,bw*2,bh,CM_OSC    );
  MB(hwnd,higlbl,"Auto Setting",x=0  ,y+=bh,bw*2,bh,CM_AUTOSET);

  MB(hwnd,higlbl,           "+",x=0    ,y+=bh,bw/2,bh,CM_PTRGR  );
  MB(hwnd,higlbl,           "-",x+=bw/2,y    ,bw/2,bh,CM_NTRGR  );
  MB(hwnd,higlbl,        "edge",x+=bw/2,y    ,bw  ,bh,CM_NTRGR  );

  MB(hwnd,higlbl,           "+",x=0    ,y+=bh,bw/2,bh,CM_TUP    );
  MB(hwnd,higlbl,           "-",x+=bw/2,y    ,bw/2,bh,CM_TDN    );
  MB(hwnd,higlbl,        "trgr",x+=bw/2,y    ,bw  ,bh,CM_TDN    );

  MB(hwnd,higlbl,           "+",x=0    ,y+=bh,bw/2,bh,CM_UPGAIN );
  MB(hwnd,higlbl,           "-",x+=bw/2,y    ,bw/2,bh,CM_DNGAIN );
  MB(hwnd,higlbl,        "gain",x+=bw/2,y    ,bw  ,bh,CM_1_GAIN );

  MB(hwnd,higlbl,           "+",x=0    ,y+=bh,bw/2,bh,CM_UPOFFS);
  MB(hwnd,higlbl,           "-",x+=bw/2,y    ,bw/2,bh,CM_DNOFFS);
  MB(hwnd,higlbl,      "offs=0",x+=bw/2,y    ,bw  ,bh,CM_0_OFFS);
  MB(hwnd,higlbl,      "HELP"  ,x=0  ,y+=bh,2*bw,bh,CM_HELP);
}
//------------------------------------------------------------------
// Windows message loop processor
//------------------------------------------------------------------
long FAR PASCAL _export WndProc(HWND hWnd, UINT message,WPARAM wParam, LPARAM lParam)
{
  HPALETTE  hOldPalette;
  FARPROC FarProc;
  MSG  msg;
  MSGS err;
  static HBITMAP hBmemy;
  static HINSTANCE hig;
  HDC hDC1,memDC;
  int   i;
  int maxX, maxY;
  static int AppMode  = AM_FFT;
  static int DispMode = DM_LINE;
  static int InitComplete = 0;
  static int disp_all = 1; 
  err = NO_ERR;
  switch(message)
  {
  	 case WM_CREATE:
         hig    = ((LPCREATESTRUCT) lParam)->hInstance;
         maxX   = GetSystemMetrics(SM_CXSCREEN);
         maxY   = GetSystemMetrics(SM_CYSCREEN);
         hDC1   = GetDC(hWnd);
         memDC  = CreateCompatibleDC(hDC1);
         hBrush = GetStockObject(WHITE_BRUSH);
         SelectObject(memDC,hBrush);
         PatBlt(memDC,0,0,maxX,maxY,PATCOPY);
         DeleteDC(memDC);
         //------------------------------------------------------------------
         // Create a grayscale palette
         //-------------------------------------------------------------------
         hLocMem = LocalAlloc(LPTR,sizeof(LOGPALETTE)+2*(PalEntries-1)*sizeof(PALETTEENTRY));
         pPal = (LOGPALETTE *) LocalLock(hLocMem);
         pPal -> palVersion = 0x300;
         pPal -> palNumEntries = PalEntries;
         for(i=0;i<PalEntries;i++)
         { pPal->palPalEntry[i].peRed   = (char)i;
           pPal->palPalEntry[i].peGreen = (char)i;
           pPal->palPalEntry[i].peBlue  = (char)i;
         }
         hLogPal = CreatePalette(pPal);
         ReleaseDC(hWnd,hDC1);
         CreateBMP(hDC1,hLogPal);            //Default BMP for spectrogram
         //-------------------------------------------------------
         PostMessage(hWnd,WM_COMMAND,CM_FFT,0); // INIT board and app first
         break;
    case WM_DESTROY:
         DeleteObject(hBmemy);
         DeleteObject(hLogPal);
         LocalUnlock (hLocMem);
         LocalFree   (hLocMem);
         UnloadBMP();
         PostQuitMessage(0);
         break;
         //------------------------------------------------------------
         // If the window moves or resizes, redraw everything
         //------------------------------------------------------------
//  case WM_MOUSEMOVE: return 0;
    case WM_MOVE     :
    case WM_SETFOCUS :
    case WM_KILLFOCUS:
    case WM_SIZE     : Reset_Data_Pts();
                       InvalidateRect(hWnd,NULL,NEW_BKGND);
                       disp_all = 1;
                       return 0;
         //------------------------------------------------------------
    case WM_PAINT    :
         MakeButtons(hWnd,hig);
         hDC1 = BeginPaint(hWnd,&ps);
         hOldPalette = SelectPalette(hDC1,hLogPal,0);
         RealizePalette(hDC1);
         if(disp_all)
           disp_grid_info(hDC1,DispMode,AppMode);
         DrawData(hDC1,AppMode,DispMode);
         SelectPalette(hDC1,hOldPalette,0);
         EndPaint(hWnd,&ps);
         break;
	 case WM_COMMAND:
			switch(wParam&0xFFFFL)
			{
           case CM_CRASH: Pulse_Init(); break;

           case __1    : CREG^=0x80; Calc_Regs();  break;
           case __2    : CREG^=0x40; Calc_Regs();  break;
           case __3    : CREG^=0x20; Calc_Regs();  break;
           case __4    : CREG^=0x10; Calc_Regs();  break;
           case __5    : CREG^=0x08; Calc_Regs();  break;
           case __6    : CREG^=0x04; Calc_Regs();  break;
           case __7    : CREG^=0x02; Calc_Regs();  break;
           case __8    : CREG^=0x01; Calc_Regs();  break;
           case __F1   : TA--;       Calc_Regs();  break;
           case __F2   : TA++;       Calc_Regs();  break;
           case __F3   : TB--;       Calc_Regs();  break;
           case __F4   : TB++;       Calc_Regs();  break;
           case __F5   : RA--;       Calc_Regs();  break;
           case __F6   : RA++;       Calc_Regs();  break;
           case __F7   : RB--;       Calc_Regs();  break;
           case __F8   : RB++;       Calc_Regs();  break;
           case __Ins  : Tprd++;     Calc_Regs();  break;
           case __Del  : Tprd--;     Calc_Regs();  break;

           case CM_UPOFFS: Offset += (V_div/2)/V_lsb;
                           if(Offset> 32767L) Offset= 32767L; break;
           case CM_DNOFFS: Offset -= (V_div/2)/V_lsb;
                           if(Offset<-32768L) Offset=-32768L; break;
           case CM_0_OFFS: Offset  = 0;                       break;
           case CM_TDN   : Threshold -= (V_div/2)/V_lsb;
                           if(Threshold<-32768L) Threshold=-32768L; break;
           case CM_TUP   : Threshold += (V_div/2)/V_lsb;
                           if(Threshold> 32767L) Threshold= 32767L; break;
           case CM_AUTOSET:Threshold = (V_dc / V_lsb)/2;
                           Offset = -Threshold;
                           ScreenGain = 0.5*dY/(V_pp/V_lsb); break;
           case CM_UPGAIN: ScreenGain*=2.0;
                           if(ScreenGain>256  )ScreenGain=256  ;break;
           case CM_DNGAIN: ScreenGain*=0.5;
                           if(ScreenGain<1/256)ScreenGain=1/256;break;
           case CM_1_GAIN: ScreenGain = 1;                      break;

           case CM_PTRGR: Edge= 0; break;
           case CM_NTRGR: Edge= 1; break;
           case CM_OSC : AppMode=AM_OSC; dY=256;
                         err=InitApp(hWnd," DSKOSC.DSK" ,AM_OSC);
                         if(err==NO_ERR) PostMessage(hWnd,WM_COMMAND,CM_COMPUTE,0);
                         break;
           case CM_FFT : AppMode=AM_FFT; dY=260;
                         err=InitApp(hWnd," FFT_RR2.DSK",AM_FFT);
                         if(err==NO_ERR) PostMessage(hWnd,WM_COMMAND,CM_COMPUTE,0);
                   //    getdata(AppMode);
                         break;
           case __F9 : Samples/=2; if(Samples<  16) Samples=  16; break;
           case __F10: Samples*=2; if(Samples>1024) Samples=1024; break;
           case __F11: AVG++; if(AVG>8) AVG = 8; break;
           case __F12: AVG--; if(AVG<1) AVG = 1; break;
           //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
           // At the end of CM_COMPUTE, a call back message is posted causing
           // Windows to loop back.  The message que is then checked and
           // processed if needed for other applications and messages.  If
           // not, Windows would only process this one message and lock up.
           //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
           case CM_COMPUTE:
                  // Check to see if any Windows messages need to be processed
                  while(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
                  { if(!GetMessage(&msg,NULL,0,0))
                    { PostQuitMessage(0);
                      return 0;
                    }
                    if(TranslateAccelerator(hWnd,haccel,&msg)==0)
                    { TranslateMessage(&msg);
                      DispatchMessage(&msg);
                    }
                  }
                  // get the data that will later be displayed
                  err = getdata(AppMode);
                  if(err==WIN_MSG)
                  {
                    PostMessage(hWnd,WM_COMMAND,CM_COMPUTE,0); // post callback
                   // err = NO_ERR;
                    return 0;
                  }
                  if(err!=NO_ERR)
                  {
                    if(AppMode==AM_FFT) PostMessage(hWnd,WM_COMMAND,CM_FFT,0);
                    else                PostMessage(hWnd,WM_COMMAND,CM_OSC,0);
                    break;
                  }
                  PostMessage(hWnd,WM_COMMAND,CM_COMPUTE,0);  // Post callback
                  // To prevent flickering, only the rectangular region that
                  // needs an update is invalidated.  Except, during the
                  // initial startup when the screen is painted before the
                  // data and mode are actualy set.
                  switch(AppMode)
                  { default    : i = (int)Samples/2; break;
                    case AM_OSC: i = (int)Samples  ; break;
                  }
                  switch(DispMode)
                  { case DM_SPECT:   i +=10; break;
                    default:         i *= mag2; break;
                  }
                  MySetRect(&rect,0,0,i+210,dY+100);
                  if(InitComplete)
                    InvalidateRect(hWnd,&rect,OLD_BKGND);
                  else
                  {
                    disp_all=1;
                    Reset_Data_Pts();
                    InvalidateRect(hWnd,NULL,NEW_BKGND);
                  }
                  InitComplete = 1;
                  return 0;
           case __UP      : mousemoverel( 0,-1); return 0; //break;
           case __DOWN    : mousemoverel( 0, 1); return 0; //break;
           case __RIGHT   : mousemoverel( 1, 0); return 0; //break;
           case __LEFT    : mousemoverel(-1, 0); return 0; //break;
           case CM_MAGUP  : mag2*=2; if(mag2>8) mag2=8; break;
           case CM_MAGDN  : mag2/=2; if(mag2<1) mag2=1; break;
           case CM_BAR    : DispMode =  DM_BAR; break;
           case CM_SPECT  : DispMode =DM_SPECT; break;
           case CM_DOT    : DispMode =  DM_DOT; break;
           case CM_LINE   :DispMode = DM_LINE; break;
           case CM_AICSET :// Open the AIC setup dialog box to modify the
                            // TA, TB and Control registers.  Poke the new
                            // values into DSP memory and restart the app
                          FarProc = MakeProcInstance((FARPROC)AIC_Setup,hIglbl);
                          DialogBox(hIglbl,"AICSETUP",hWnd,FarProc);
                          FreeProcInstance(FarProc);
                          Calc_Regs();
                          break;
           //---------------------------------------------------
           case __SF1:
           case CM_HELP:  WinHelp(hWnd, "myhelp.hlp", HELP_CONTENTS, 0L);
                          return 0L;
           case CM_ABOUT: MessageBox(hWnd,AboutStrg,"About",MB_OK);
                          break;
           //---------------------------------------------------
           case CM_EXIT   :
             PostQuitMessage(0); break;
           default: break;
         }
         if(err==NO_ERR)
         {
           UpdateAIC=1;
           InitComplete=0;
           disp_all = 1;
         }
         break;
    default:
      return(DefWindowProc(hWnd, message, wParam, lParam));
  }
  return(0L);
}



