;**************************************************************
;  
;                 init2.asp
;  
;                 James M. Patterson
;  
;                 12-22-89
;  
;           (C) Texas Instruments Inc., 1992 
;  
;           Refer to the file 'license.txt' included with this 
;           this package for usage and license information. 
;  
;**************************************************************
;
;   TMS320C2x XDS/22 INITIALIZATION SCRIPT
;
;      James M. Patterson
;      Texas Instruments
;      370 South North Lake Boulevard
;      Altamonte Springs, Florida 32701
;
CLEAR					;CLEAR SCREEN
BOX  0 0 5 79 2 		  ;DRAW A GREEN BOX
ATSAY  2 31 9  "SET XDS PARAMETERS"	;WHAT WE'RE DOING

;
;	CHECK FOR PARAMETER FILE
;

ISFILE	"XDS2INIT.PRM"

IF	SUCCESS
	GOTO	READ_INIT	;IF FILE IS THERE, READ IT
ENDIF				;IF NOT, FALL THROUGH TO NO_FILE

NO_FILE:

BOX 0 0 23 79 2 		;DRAW ANOTHER BOX

    CLOCK_SOURCE:

    ATSAY  4 2 11  "SELECT EMULATOR CLOCK SOURCE:                      "
    ATSAY  5 7 11  "0 - XDS EMULATOR BOARD CRYSTAL  ( 20 MHz )"
    ATSAY  6 7 11  "1 - OSCILLATOR ON YOUR TARGET BOARD"
    ATSAY  7 7 11  "2 - XDS EMULATOR BOARD OSCILLATOR ( 40 MHz )"

    ATGET  4 33 10 1 S9      ;READ VALUE

    SWITCH    S9

	 CASE "0"            ;CHECK FOR ZERO
	      ASSIGN	S9   "INTERNAL"
	      ENDCASE

	 CASE "1"            ;IS IT 1
	      ASSIGN	S9   "TARGET"
	      ENDCASE

	 CASE "2"
	      ASSIGN	S9   "OSC"
	      ENDCASE

	 DEFAULT
	      ASSIGN	S9   "INVALID SELECTION"
	      ATSAY	4 33 4 S9
	      PAUSE	2    ;WAIT A WHILE
	      GOTO CLOCK_SOURCE
	 ENDCASE

    ENDSWITCH

    ATSAY     4 33 10 "                                           "
    ATSAY     4 33 10 S9     ;PRINT GOOD SELECTION ON SCREEN

    SCROLL    0 5 1 7 78     ;CLEAR PART OF SCREEN

    DELETE_SBP:

    ATSAY     6 2 11 "DELETE SOFTWARE BREAKPOINTS WHEN REACHED?              "
    ATSAY     7 7 11 "0 - NO"
    ATSAY     8 7 11 "1 - YES"
    ATGET     6 45 10 1 S8

    SWITCH    S8

	 CASE "0"
	      ASSIGN	S8   "NO"
	 ENDCASE

	 CASE "1"
	      ASSIGN	S8   "YES"
	 ENDCASE

	 DEFAULT
	      ASSIGN	S8   "MUST BE 0 OR 1"
	      ATSAY	6 45 4 S8
	      PAUSE	2
	      GOTO DELETE_SBP
	 ENDCASE

    ENDSWITCH

    ATSAY     6 2 11 "DELETE SOFTWARE BREAKPOINTS WHEN REACHED?              "
    ATSAY     6 45 10 S8     ;DISPLAY VALUE

    SCROLL    0 7 1 8 78 15  ;CLEAR SCREEN

	HEX:

	ATSAY 8 2 11 "HEX NOTATION?                    "
	ATSAY 9 7 11 "0 - NONE:  ALL NUMBERS ARE HEXADECIMAL"
	ATSAY 10 7 11 "1 - TI:  HEXADECIMAL INPUT VALUES DESIGNATED AS:"
	ATSAY 11 16 11 ">xxxx, 0Xxxxx, Xxxxx, Hxxxx, OR  xxxxH"
	ATSAY 12 16 11 "HEXADECIMAL NUMBERS DISPLAYED AS >xxxx"
	ATSAY 13 7 11 "2 - X:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYED AS Xxxxx"
	ATSAY 14 7 11 "3 - HS:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYE AS xxxxH"
	ATSAY 15 7 11 "4 - HP:  SAME AS TI, EXCEPT HEXADECIMAL NUMBERS DISPLAYED AS Hxxxx"

	ATGET 8 17 10 1 S1

	SWITCH	S1

		CASE	0
			ASSIGN	S1	"NONE"
		ENDCASE

		CASE	1
			ASSIGN	S1	"TI"
		ENDCASE

		CASE	2
			ASSIGN	S1	"X"
		ENDCASE

		CASE	3
			ASSIGN	S1	"HS"
		ENDCASE

		CASE	4
			ASSIGN	S1	"HP"
		ENDCASE

		DEFAULT
			ASSIGN	S1	"INVALID SELECTION"
			ATSAY 8 17 4 S1
			PAUSE 2
			GOTO HEX
		ENDCASE
	ENDSWITCH

	ATSAY 8 2 11 "HEX NOTATION?                    "
	ATSAY 8 17 10 S1
	SCROLL 0 9 2 15 78 15		;CLEAN UP SCREEN

    EXT_ADDRESS:

    ATSAY	10 2 11 "HOW MANY EXTENDED ADDRESS BITS?                     "
    ATSAY	11 7 11 "MIN = 0; MAX = 8"
    ATGET	10 45 10 1 S7

	SWITCH	S7
		CASE	"0"		;THESE ARE ALL VALID
		ENDCASE
		CASE	"1"
		ENDCASE
		CASE	"2"
		ENDCASE
		CASE	"3"
		ENDCASE
		CASE	"4"
		ENDCASE
		CASE	"5"
		ENDCASE
		CASE	"6"
		ENDCASE
		CASE	"7"
		ENDCASE
		CASE	"8"		;LAST VALID INPUT
		ENDCASE

		DEFAULT
			ASSIGN	S7	"VALUE MUST BE BETWEEN 0 AND 8"
			ATSAY	10 2 11 "HOW MANY EXTENDED ADDRESS BITS?                     "
			ATSAY	10 45 4 S7	 ;PRINT ERROR MESSAGE
			PAUSE	2
			GOTO EXT_ADDRESS
		ENDCASE
	ENDSWITCH

	ATSAY	10 2 11 "HOW MANY EXTENDED ADDRESS BITS?                     "
	ATSAY	10 45 10 S7
	SCROLL	0 11 2 11 78 7	  ;PARTIAL SCREEN CLEAR

	MAP_MODE:

	ATSAY	12 2 11 "MAP OVERLAP MODE?                               "
	ATSAY	13 7 11 "0 - PROGRAM AND DATA MEMORY ADDRESSES MUST NOT OVERLAP"
	ATSAY	14 7 11 "1 - PROGRAM AND DATA MAY OVERLAP"
	ATSAY	15 11 11 "MAPPED ADDRESSES MUST BE BETWEEN 0000H AND 7FFFH OR 8000H AND FFFFH"
	ATGET	12 21 10 1 S6

	SWITCH	  S6

		CASE "0"
			ASSIGN	  S6   "HIGH/LOW"
		ENDCASE

		CASE "1"
			ASSIGN	  S6   "PROGRAM"
		ENDCASE

		DEFAULT
			ASSIGN	  S6   "MUST BE 0 OR 1"
			ATSAY	  12 21 4 S6
			PAUSE	  2
			GOTO	MAP_MODE
		ENDCASE
	ENDSWITCH

	ATSAY	12 2 11 "MAP OVERLAP MODE?                               "
	ATSAY	12 21 10 S6
	SCROLL	0 13 2 15 78 7		;CLEAN UP SCREEN

	TARGET_READY:

	ATSAY	14 2 11 "WAIT FOR TARGET READY?                           "
	ATSAY	15 7 11 "0 - NO"
	ATSAY	16 7 11 "1 - YES"
	ATGET	14 26 10 1 S5

	SWITCH	  S5

		CASE "0"
			ASSIGN	  S5   "NO"
		ENDCASE

		CASE "1"
			ASSIGN	  S5   "YES"
		ENDCASE

		DEFAULT
			ASSIGN	  S5   "MUST BE 0 OR 1"
			ATSAY	  14 26 S5
			PAUSE	  2
			GOTO TARGET_READY
		ENDCASE
	ENDSWITCH

	ATSAY	14 2 11 "WAIT FOR TARGET READY?                           "
	ATSAY	14 26 10 S5	;DISPLAY VALUE
	SCROLL	0 15 2 16 78  7 ;CLEAN UP SCREEN

	BUS_REQUEST:

	ATSAY	16 2 11 "ENABLE BUS REQUEST MODE?                         "
	ATSAY	17 7 11 "0 - NO"
	ATSAY	18 7 11 "1 - YES"
	ATGET	16 28 10 1 S4

	SWITCH	  S4

		CASE "0"
			ASSIGN	  S4   " NO^M"
		ENDCASE

		CASE "1"
			ASSIGN	  S4   " YES^M"
		ENDCASE

		DEFAULT
			ASSIGN	  S4   "MUST BE 0 OR 1"
			ATSAY	  16 28 4 S4
			PAUSE	  2
			GOTO BUS_REQUEST
		ENDCASE
	ENDSWITCH

	ATSAY	16 2 11 "ENABLE BUS REQUEST MODE?                         "
	ATSAY	16 28 10 S4
	SCROLL	0 17 2 18 78 7	;CLEAN UP SCREEN

	TARGET_PROG:

	ATSAY	18 2 11 "ENABLE ON-BOARD PROGRAM RAM?                      "
	ATSAY	19 7 11 "0 - OFF"
	ATSAY	20 7 11 "1 - ON"
	ATGET	18 32 10 1 S3

	SWITCH	  S3

		CASE "0"
			ASSIGN	  S3   "OFF"
		ENDCASE

		CASE "1"
			ASSIGN	  S3   "ON"
		ENDCASE

		DEFAULT
			ASSIGN	  S3   "MUST BE 0 OR 1"
			ATSAY	  18 32 4 S3
			PAUSE	  2
			GOTO TARGET_PROG
		ENDCASE
	ENDSWITCH

	ATSAY	18 2 11 "ENABLE ON-BOARD PROGRAM RAM?                      "
	ATSAY	18 32 10 S3
	SCROLL	0 19 2 20 78 7	;CLEAN UP SCREEN

	TARGET_DATA:

	ATSAY	20 2 11 "ENABLE ON-BOARD DATA RAM?                      "
	ATSAY	21 7 11 "0 - OFF"
	ATSAY	22 7 11 "1 - ON"
	ATGET	20 32 10 1 S2

	SWITCH	  S2

		CASE "0"
			ASSIGN	  S2   "OFF"
		ENDCASE

		CASE "1"
			ASSIGN	  S2   "ON"
		ENDCASE

		DEFAULT
			ASSIGN	  S2   "MUST BE 0 OR 1"
			ATSAY	  20 32 4 S2
			PAUSE	  2
			GOTO TARGET_DATA
		ENDCASE
	ENDSWITCH

	ATSAY	20 2 11 "ENABLE ON-BOARD DATA RAM?                      "
	ATSAY	20 32 10 S2
	SCROLL	0 21 2 22 78 7	;CLEAN UP SCREEN

	ATSAY	22 2 11 "CHANGE INITIALIZATION PARAMETERS? (DEFAULT = NO)      "
	ATGET	22 52 10 3 S0
	STRCMP	S0 "YES"
	IF SUCCESS
		GOTO	NO_FILE
	ELSE
		ASSIGN	S0  "NO            "
		ATSAY	22 52 10 S0
	ENDIF

	FOPENO	XDS2INIT.PRM	BINARY	  ;OPEN PARM FILE

	IF NOT SUCCESS
		ATSAY	22 2 4 "CAN'T OPEN XDS2INIT.PRM FOR OUTPUT!"
		TERMINAL
	ENDIF

	SCROLL	0 22 2 22 78 7	;CLEAR LINE ON SCREEN
	ATSAY	22 2 14 "UPDATING XDS2INIT.PRM"

	FPUTS	S9		;UPDATE PARAMETER FILE
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S8
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S1
	FPUTC	"^J"
	FPUTS	S7
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S6
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S5
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S4
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S3
	FPUTC	"^J"	      ;LINE FEED
	FPUTS	S2
	FPUTC	"^J"	      ;LINE FEED

	FCLOSEO 		;CLOSE FILE

	GOTO	DO_INIT:

READ_INIT:
;
;	READ INIT FILE
;

ATSAY	4 2 11 "USE VALUES FROM XDS2INIT.ASP? (DEFAULT IS YES)         "
ATGET	4 50 10 3 S2  ;READ RESPONSE
STRCMP	S2	"NO"
IF	SUCCESS
	GOTO	NO_FILE 	;GO READ NEW STUFF FROM KEYBOARD
ELSE
	ASSIGN	S2 "YES"
	ATSAY	4 50 10 S2
ENDIF				;OTHERWISE, READ OLD STUFF FROM FILE
;
;	DEBUGGING
;

DO_INIT:

SET DISPLAY OFF

BOX 0 0 5 79 2			;DRAW A GREEN BOX
ATSAY  2 31 9  "SET XDS PARAMETERS"	;WHAT WE'RE DOING

SCROLL	0   6 0 23 79 7 	 ;CLEAR SCREEN BELOW

ATSAY	6 2 14 "INITIALIZING XDS"
LOCATE 8 2
;TRACE ON
TRANSMIT "^["
WAITFOR  "^M?"

FOPENI	 "XDS2INIT.PRM" BINARY	   ;TRY TO OPEN INIT FILE
IF SUCCESS

    ;READ FIRST PARAMETER (EMU CLOCK SOURCE)

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE

    SET DISPLAY ON
    PAUSE 1
    TRANSMIT "INIT^M"		       ;SEND INIT COMMAND
    WAITFOR " = "                      ;CLOCK SOURCE IS FIRST

    PAUSE 1
    TRANSMIT S9 		       ;SEND CLOCK SOURCE FROM FILE
    WAITFOR " = "                      ;SOFTWARE BREAKPOINT MODE

    ;READ MODE VALUE

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE
    PAUSE 1
    TRANSMIT  S9		       ;SEND TO XDS
    WAITFOR " = "                      ;WAIT FOR NEXT PROMPT

    ;READ HEX NOTATION

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE
    PAUSE 1
    TRANSMIT  S9		       ;SEND VALUE TO XDS
    WAITFOR " = "                      ;WAIT FOR PROMPT

    ;READ NUMBER OF EXTENDED ADDRESS BITS

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE

    PAUSE 1
    TRANSMIT  S9		       ;SEND TO XDS
    WAITFOR " = " 1			;WAIT AGAIN
    IF NOT  WAITFOR
	TRANSMIT    "^M"    ;THIS IS A KLUGE
    ENDIF

    ;READ MAP OVERLAP MODE

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE

    PAUSE 1
    TRANSMIT  S9		       ;SEND TO XDS
    WAITFOR " = "                      ;WAIT

    ;WAIT FOR TARGET READY

    ASSIGN  S9	"                    "	;CLEAR STRING
    FGETS   S9				;READ NEW VALUE

    PAUSE 1

    TRANSMIT  S9		       ;SEND TO XDS
    WAITFOR " = "                      ;WAIT

    ;ENABLE BUS REQUEST?

    ASSIGN  S9	"                              "  ;CLEAR STRING
    FGETS   S9				;READ NEW VALUE
    PAUSE 1
    TRANSMIT  S9		       ;SEND LAST VALUE TO XDS
    PAUSE 1
    TRANSMIT "^M"
    WAITFOR   "?" 1

;   SET EMULATOR "TARGET" MEMORY
;
    ATSAY   16 2 14 "SETTING XDS TARGET RAM CONFIGURATION"
    LOCATE  18 2

    TRANSMIT	"ITR^M"     ;SEND ITR COMMAND
    WAITFOR " = "	    ;WAIT FOR RESPONSE
    FGETS   S9		    ;READ VALUE
    PAUSE   1		    ;KILL TIME
    TRANSMIT	S9	    ;SEND IT
    WAITFOR " = "	    ;WAIT FOR RESPONSE
    FGETS   S9		    ;READ VALUE
    PAUSE   1		    ;KILL TIME


    PAUSE   1		    ;WAIT
    TRANSMIT	S9	    ;SEND VALUE
    PAUSE   1
    TRANSMIT	"^M"
    WAITFOR "^M?" 1


    FCLOSEI			       ;CLOSE INPUT FILE

    SET DISPLAY ON
