*================================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	40 BIT SUBTRACT
*
*	Revision Date:  04/29/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		long sub40(long a, long b)
*
*		a --- first 40 bit value 
*               b --- second 40 bit value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		long sub40(long a,long b)
*		{
*			return(a - b);
*		}
*
*
*	DESCRIPTION
*
*		This routine takes two 40 bit values and calculates their
*               difference.  The inputs are 40-bit numbers, and the result is 
*       	a 40-bit number.
*	
*	ASSUMPTIONS
*
*         	1. Only one difference is computed with a pair of 40-bit values.
*		2. Multiple 40-bit subs can yield 1/2 cycle per 40-bit subtract
*		   on average.
*
*	CYCLES
*
*		3
*
*================================================================================
	.global _sub40
	.text
_sub40:
*** BEGIN Benchmark Timing
B_START:
		SUBU	.L1X	A4,	B4,	A5:A4	; c_tmp = a_tmp - b_tmp
||		SUB	.L2X	A5,	B5,	B5	; c_tmp = a_tmp - b_tmp

		ADD	.L1X	B5,	A5,	A5	; c_tmp = a_tmp - b_tmp
		EXTU	.S1	A5,	24, 24, A5	; extract bottom for store
B_END:
*** END Benchmark Timing
STOP:		B	.S2	B3
		NOP	5
