*================================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	32 Bit Unsigned multiply With 40 Bit Result
*
*	Revision Date:  07/14/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		Ulong40 mpyu3240(unsigned int a, unsigned int b)
*
*		a --- first 32 bit input unsigned value
*               b --- second 32 bit input unsigned value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		Ulong40 mpy3240(unsigned int a, unsigned int b)
*		{
*		        Ulong40 c;
*		        c = (Ulong40) a * (Ulong40) b;
*		        return (c);
*		}
*		
*	DESCRIPTION
*
*		This routine takes two 32 bit unsigned integer values and
*               calculates their product.  The inputs are 32-bit unsigned
*		integer, and the result is a 40-bit unsigned integer.
*	
*	ASSUMPTIONS
*
*               1. Only one sum is computed with a pair of 32-bit values.
*               2. The assembly code can be rewritten to give an average of
*                  1 32-bit unsigned multiply with 40 bit result every two
*                  cycles when executing multiple multiplies.
*
*	CYCLES
*
*		7
*
*===============================================================================
	.global _mpyu3240
	.text

_mpyu3240:
*** BEGIN Benchmark Timing
B_START:

	MPYHLU	.M1x	A4,	B4,	A4	; c  = (a>>16)*b
||	MPYHLU	.M2x	B4,	A4,	B4	; c1 = (b>>16)*a

	MPYHU	.M1x	A4,	B4,	A6	; c3 = (a>>16)*(b>>16)
||	MPYU	.M2x	B4,	A4,	B4	; c2 = a*b

	ADD	.L1x	B4,	A4,	A4	; c  += c1

	SHL	.S1	A4, 	16,	A5:A4	; c <<= 16

	ADDU	.L1x	B4,	A5:A4,	A5:A4	; c  += c2

	ADD	.L1	A5,	A6,	A5	; c(H) += c3

        EXTU    .S1     A5,24,24,A5    		; extract bottom for store

B_END:
*** END Benchmark Timing
STOP:	B	.S2	B3			; return to calling function
	NOP	5
