*================================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	32 Bit Multiply
*
*	Revision Date:  07/14/97
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		int mpy32(int a, int b)
*
*		a --- first 32 bit input value
*               b --- second 32 bit input value
*
*		If routine is not to be used as a C callable function then
*		you need to initialize values for all of the values passed
*		as these are assumed to be in registers as defined by the 
*		calling convention of the compiler, (refer to the C compiler
*		reference guide).
*
*	C CODE
*		This is the C equivalent of the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		int mpy32(int a, int b)
*		{
*			return (a * b);
*		}
*		
*	DESCRIPTION
*
*		This routine takes two 32 bit integer values and calculates
*               their product.  The inputs are 32-bit integer, and the result
*		is a 32-bit integer.
*	
*	ASSUMPTIONS
*
*         	Only one product is computed with a pair of 32-bit values.  The
*		code can be reorganized to compute an average of two 32-bit
*		product in three cycles.
*
*	CYCLES
*
*		5
*
*===============================================================================
	.global _mpy32
	.text

_mpy32:
*** BEGIN Benchmark Timing
B_START:

	MPYHSLU	.M1x	A4,	B4,	A4	; c  = (a>>16)*(unsigned)b
||	MPYHSLU	.M2x	B4,	A4,	B4	; c1 = (b>>16)*(unsigned)a

	MPYU	.M2x	B4,	A4,	B4	; c2 = (unsigned)a*(unsigned)b

	ADD	.L1x	B4,	A4,	A4	; c  += c1

	SHL	.S1	A4, 	16,	A4	; c <<= 16

	ADD	.L1x	B4,	A4,	A4	; c  += c2

B_END:
*** END Benchmark Timing
STOP:	B	.S2	B3			; return to calling function
	NOP	5
