*=============================================================================
*
*	TEXAS INSTRUMENTS, INC.		
*
*	
*	Revision Date:	06/24/98
*	
*	USAGE	This routine is C Callable and can be called as:
*		
*		a = isqrdp(b);
*
*		If the routine is not to be used as a C callable function,
*		then you need to initialize values for all of the parameters
*		passed to the function since these are assumed to be in
*		registers as defined by the calling convention of the
*		compiler, (refer to the TMS320C6x Optimizing C Compiler
*		User's Guide).
*
*	C CODE
*		This is the C equivalent for the assembly code.  Note that
*		the assembly code is hand optimized and restrictions may
*		apply.
*
*		double isqrdp(double x)
*		{
*		  int i;
*		  double y;
*
*		  y = _rsqrdp(x);
*
*		  for (i=0; i<3; i++)
*		  {
*		     y = y * (1.5f - (x * 0.5f * y * y);
*		  }
*
*		  return y;
*		}
*
*	DESCRIPTION
*
*		This routine calculates the double precision square root
*		reciprocal.
*
*	TECHNIQUES
*
*		1.  RSQRDP is used to get the reciprocal square root of the
*		    single precision value held in the register A4.  However,
*		    to increase the precision of the mantissa to the full
*		    52 bits, three iterations of the Newton-Rhapson algorithm
*		    are required.
*
*			y(n+1) = y(n)[1.5f - 0.5f * x * y(n) * y(n)]
*
*		    where,
*
*		    y(0) = seed value from the _rsqrdp intrinsic
*		    x = the input whose reciprocal sq.root is to be calculated										    *
*
*		    Due to the high number of dependencies and the long delay
*		    slots required in mpydp and subdp, several nops are
*		    required in the loop.
*
*       ARGUMENTS PASSED
*
*		x	 ->  A5:A4
*
*	CYCLES
*
*		113 Cycles
*
*===============================================================================*

	.def	_isqrdp
	.sect	".text"

_isqrdp:

	ZERO	.D2	B4		    ; const = 0.5f (d.p.)
||	ZERO	.L2	B5		    ; const = 0.5f (d.p.)
||	ZERO	.D1	A7		    ; const = 1.5f (d.p.)
||	MV	.L1	A4,A8		    ; A8 = A4
||	RSQRDP	.S1	A5:A4,A5:A4	    ; Double Precision Square root

	MVKH	.S2	0x3fe00000,B5	    ; const = 0.5f (d.p.)
||	ADD	.L2	B4,2,B0 	    ; Loop counter B0 = 2
||	MV	.D1	A5,A9		    ; A9 = A5
||	ZERO	.L1	A6		    ; const = 1.5f (d.p.)

Loop:
	MPYDP	.M1	A5:A4,A5:A4,A3:A2   ; y * y
||	MPYDP	.M2X	A9:A8,B5:B4,B7:B6   ; x * 0.5f = z
||	MVKH	.S1	0x3ff80000,A7	    ; const = 1.5f (d.p.)
	NOP		9

	MPYDP	.M1X	B7:B6,A3:A2,A3:A2   ; z * y * y
	NOP		9

	SUBDP	.L1	A7:A6,A3:A2,A3:A2   ; 1.5f - z * y * y
	NOP		6

	MPYDP	.M1	A5:A4,A3:A2,A5:A4   ; y * (1.5f - z * y * y)
	NOP		3

  [!B0] B	.S2	B3		    ; Return to calling program
|| [B0] B	.S1	Loop
|| [B0] SUB	.D2	B0,1,B0 	    ; Decrement loop counter

	NOP		5
