*************************************************************************
* Application:	C54x LEC						*
* File name:	echoequ.inc						*
* Description:	Constants declaration					*
*									*
* Author:	Jelena Nikolic, Associate Technical Staff		*
* Date:		January 97						*
*************************************************************************		

NLMS    .set    1               ; symbols for conditional assembly
BLOCK   .set    2

	.if mode=NLMS
		.asg    AR2, n_ref_ptr
	.elseif mode=BLOCK
		.asg    AR2, n_error_ptr
	.endif          
		.asg    AR3, filter_ptr
		.asg    AR4, ref_ptr
		.asg    AR5, s0_ptr

TAPS            .set    48		; Note: maximum = 512
	.if mode=NLMS
BLOCKSIZE       .set    0		; has to be zero.
	.elseif mode=BLOCK
BLOCKSIZE       .set    16              ; Note: TAPS/BLOCKSIZE must be integer.
	.endif

GAIN            .set    -10		; beta gain = 2^(GAIN)

LTAU            .set    9               ; LPF LONG TAU = 16 MSECS
					; = 125 USECS *2**(16-LTAU)
STAU            .set    11              ; LPF SHORT TAU = 4 MSECS
					; = 125 USECS *2**(16-STAU)
HTAU            .set    13              ; HPF TAU = 1MSEC=1/2*P1*170HZ
					; =125 USECS*2**(16-HTAU)
THRES0          .set    800h            ; SUPPRESS THRES =1/16 (-24DB)
					; = 2*THRES0 (-6DB*THRES0)
HANGT0          .set    600             ; HANG OVER TIME = 75 MSECS
					; = -6DB *NER
NER             .set    1               ; NEAR END SPEECH THRES = -6DB
					; = -6DB * NER
CUTOF0          .set    21h             ; UPDATE CUTOFF = -48DB
					; = -6DB * (13 -LN(CUTOF0))
no_nesp_level   .set    021h            ; max_m set to this
					;  level to prevent near-end speech
					;  from being declared on startup.
*************************************************************************
*       ECHO CANCELLER CONTROL FLAG REGISTER  BIT EQUATES       *
*************************************************************************

NONESP          .set    4               ;1 = no near-end speech detected
					;0 = near-end speech detected 

ESUP            .set    1               ;1 = enable residual echo suppressor
					;0 = disable residual echo suppressor

UNFREEZE        .set    2               ;1 = enable tap update
					;0 = freezef tap update

ECAN            .set    0               ;1 = enable echo cancellation
					;0 = disable echo cancellation (but
					; a(k) coefficients still adapt)

