/******************************************************************/
/* regs.h V0.00                                                   */
/* Copyright (c) Texas Instruments , Incorporated  1997           */
/******************************************************************/
 
/******************************************************************/
/* DEFINE ALL PERIPHERAL MEMORY MAPPED REGISTER ADRESSES          */
/******************************************************************/
 
/******************************************************************/
/* Check to see if mmregs.h has been previously included by       */
/* another header, if so, skip this and go on                     */
/******************************************************************/
#if !defined(__MMREGS)
#include <limits.h>
 
/******************************************************************/
/* Target specific data and macros                                */
/*                                                                */
/* MASK_TARGET_WORD - bit pattern to mask all bits in a target    */
/*                    word                                        */
/* WORD_SIZE        - size in bits of target word                 */
/* BASE_ADDR        - base address of memory-mapped peripheral    */
/*                    control registers                           */
/******************************************************************/
 
#define MASK_TARGET_WORD        0xffff
#define TARGET_WRD_SZ   CHAR_BIT
#define BYTES_PER_WORD  TARGET_WRD_SZ/8
#define WORD_SIZE       (CHAR_BIT * sizeof(unsigned int))
 
#define SP_ADDR(port)           (0x22 + (0x10 * port))
#define DRR_ADDR(port)          (0x20 + (0x10 * port))
#define DXR_ADDR(port)          (0x21 + (0x10 * port))
#define BSP_ADDR(port)          (0x22 + (0x20 * port))
#define BDRR_ADDR(port)         (0x20 + (0x20 * port))
#define BDXR_ADDR(port)         (0x21 + (0x20 * port))
#define BSPCE_ADDR(port)        (0x23 + (0x20 * port))
#define AXR_ADDR(port)          (0x38 + (0x04 * port))
#define ARR_ADDR(port)          (0x3a + (0x04 * port))
#define TDM_ADDR                TSPC
#define TIMER_ADDR              TCR_ADDR
 
#define BASE_VEC_ADR            0x0
#define RESET_VEC               0x0
#define NMI_VEC                 4
#define SINT17_VEC              8
#define SINT18_VEC              12
#define SINT19_VEC              16
#define SINT20_VEC              20
#define SINT21_VEC              24
#define SINT22_VEC              28
#define SINT23_VEC              32
#define SINT24_VEC              36
#define SINT25_VEC              40
#define SINT26_VEC              44
#define SINT27_VEC              48
#define SINT28_VEC              52
#define SINT29_VEC              56
#define SINT30_VEC              60
#define INT0_VEC                64
#define INT1_VEC                68
#define INT2_VEC                72
#define TINT_VEC                76
#define RINT0_VEC               80
#define BRINT0_VEC              84
#define XINT0_VEC               88
#define BXINT0_VEC              92
#define RINT1_VEC               96
#define TRINT_VEC               100
#define XINT1_VEC               104
#define TXINT_VEC               108
#define INT3_VEC                112
#define HPI_VEC                 116
#define BRINT1_VEC              120
#define BXINT1_VEC              124
 
/*----------------------------------------------------------------------------*/
/* MACRO FUNCTIONS                                                            */
/*----------------------------------------------------------------------------*/
 
#define CONTENTS_OF(addr) \
        (*((volatile unsigned int *)(addr)))
 
#define LENGTH_TO_BITS(length) \
        (~(0xffffffff << (length)))
 
/* MACROS to SET, CLEAR and RETURN bits and bitfields in Memory Mapped        */
/* locations using the address of the specified register.                     */
 
#define REG_READ(addr) \
        (CONTENTS_OF(addr))
 
#define REG_WRITE(addr,val) \
        (CONTENTS_OF(addr) = (val))
 
 
#define MASK_BIT(bit) \
        (1 << (bit))
 
#define RESET_BIT(addr,bit) \
        (CONTENTS_OF(addr) &= (~MASK_BIT(bit)))
 
#define GET_BIT(addr,bit) \
        (CONTENTS_OF(addr) & (MASK_BIT(bit)) ? 1 : 0)
 
#define SET_BIT(addr,bit) \
        (CONTENTS_OF(addr) = (CONTENTS_OF(addr)) | (MASK_BIT(bit)))
 
#define ASSIGN_BIT_VAL(addr,bit,val) \
        ( (val) ? SET_BIT(addr,bit) : RESET_BIT(addr,bit) )
 
#define CREATE_FIELD(bit,length) \
        (LENGTH_TO_BITS(length) << (bit))
 
#define RESET_FIELD(addr,bit,length) \
        ( CONTENTS_OF(addr) &= (~CREATE_FIELD(bit,length)))
 
#define TRUNCATE(val,bit,length) \
        (((unsigned int)(val) << (bit)) & (CREATE_FIELD(bit, length)))
 
#define MASK_FIELD(bit,val,length)\
        TRUNCATE(val, bit, length)
 
#define GET_FIELD(addr,bit,length) \
       ((CONTENTS_OF(addr) & CREATE_FIELD(bit,length)) >> bit)
 
#define LOAD_FIELD(addr,val,bit,length) \
        (CONTENTS_OF(addr) &= (~CREATE_FIELD(bit,length))\
                               | TRUNCATE(val, bit, length))
 
/* MACROS to SET, CLEAR and RETURN bits and bitfields in Memory Mapped        */
/* and Non-Memory Mapped using register names.                                */
 
#define GET_REG(reg) \
        (reg)
 
#define SET_REG(reg,val) \
        ((reg)= (val))
 
#define GET_REG_BIT(reg,bit) \
        ((reg) & MASK_BIT(bit) ? 1 : 0)
 
#define SET_REG_BIT(reg,bit) \
        ((reg) |= MASK_BIT(bit))
 
#define RESET_REG_BIT(reg,bit) \
        ((reg) &= (~MASK_BIT(bit)))
 
#define GET_REG_FIELD(reg,bit,length) \
        (reg & CREATE_FIELD(bit,length)) >> bit)
 
#define LOAD_REG_FIELD(reg,val,bit,length) \
        (reg &= (~CREATE_FIELD(bit,length)) | (val<<bit))
 
/******************************************************************/
/* Define data structures for all memory mapped registers         */
/******************************************************************/
/*----------------------------------------------------------------*/
/* Define bit fields for Serial Port Control Registers            */
/*----------------------------------------------------------------*/
 
#define RSRFULL         13
#define RSRFULL_SZ       1
 
#define XSREMPTY        12
#define XSREMPTY_SZ      1
 
#define XRDY            11
#define XRDY_SZ          1
 
#define RRDY            10
#define RRDY_SZ          1
 
#define IN1              9
#define IN1_SZ           1
 
#define IN0              8
#define IN0_SZ           1
 
#define RRST             7
#define RRST_SZ          1
 
#define XRST             6
#define XRST_SZ          1
 
#define TXM              5
#define TXM_SZ           1
 
#define MCM              4
#define MCM_SZ           1
 
#define FSM              3
#define FSM_SZ           1
 
#define FO               2
#define FO_SZ            1
 
#define DLB              1
#define DLB_SZ           1
 
#define TDM              0
#define TDM_SZ           1
 
#define CLKDV            0
#define CLKDV_SZ         5
 
#define FSP              5
#define FSP_SZ           1
 
#define CLKP             6
#define CLKP_SZ          1
 
#define FE               7
#define FE_SZ            1
 
#define FIG              8
#define FIG_SZ           1
 
#define PCM              9
#define PCM_SZ           1
 
#define BXE             10
#define BXE_SZ           1
 
#define XH              11
#define XH_SZ            1
 
#define HALTX           12
#define HALTX_SZ         1
 
#define BRE             13
#define BRE_SZ           1
 
#define RH              14
#define RH_SZ            1
 
#define HALTR           15
#define HALTR_SZ         1
 
/******************************************************************/
/* Define Timer Period, and Control Registers with all related    */
/* data structures, macros, and functions                         */
/*----------------------------------------------------------------*/
#define PSC              6
#define PSC_SZ           4
 
#define TRB              5
#define TRB_SZ           1
 
#define TSS              4
#define TSS_SZ           1
 
#define TDDR             0
#define TDDR_SZ          4
 
/*---------------------------------------------------------------*/
/* Data structures, macros for Clock Mode Register               */
/*---------------------------------------------------------------*/
 
#define PLLMUL          12
#define PLLMUL_SZ        4
 
#define PLLDIV          11
#define PLLDIV_SZ        1
 
#define PLLCOUNT         3
#define PLLCOUNT_SZ      8
 
#define PLLON_OFF        2
#define PLLON_OFF_SZ     1
 
#define PLLNDIV          1
#define PLLNDIV_SZ       1
 
#define PLLSTATUS        0
#define PLLSTATUS_SZ     1
 
 
/******************************************************************/
/* Define bit fields for Software Wait State Register             */
/******************************************************************/
#define IO              12
#define IO_SZ            3
 
#define DATA_HI          9
#define DATA_HI_SZ       3
 
#define DATA_LO          6
#define DATA_LO_SZ       3
 
#define PROGRAM_HI       3
#define PROGRAM_HI_SZ    3
 
#define PROGRAM_LO       0
#define PROGRAM_LO_SZ    3
 
/*-------------------------------------------------------------------*/
/* Define structure for Bank Switch Control Register                 */
/*-------------------------------------------------------------------*/
#define BNKCMP          12
#define BNKCMP_SZ        4
 
#define PSDS            11
#define PSDS_SZ          1
 
#define BH               1
#define BH_SZ            1
 
#define EXIO             0
#define EXIO_SZ          1
 
#define INT0             0
#define INT1             1
#define INT2             2
#define TINT             3
 
#define RINT0            4
#define XINT0            5
 
#define BRINT0           4
#define BXINT0           5
 
#define RINT1            6
#define XINT1            7
 
#define TRINT            6
#define TXINT            7
 
#define INT3             8
#define HPINT            9
#define BRINT1          10
#define BXINT1          11
 
/***************************************************************/
/* DEFINE DATA STRUCTURE FOR HOST PORT INTERFACE CONTROL REG   */
/***************************************************************/
#define BOB              0
#define SMOD             1
#define DSPINT           2
#define HINT             3
 
/******************************************************************/
/* Define Interrupt Flag and Interrupt Mask Registers             */
/******************************************************************/
#define IMR     *(volatile unsigned int *)0x00
#define IMR_ADDR                0x0
 
#define IFR     *(volatile unsigned int *)0x01
#define IFR_ADDR                0x1
 
 
/******************************************************************/
/* Serial Port 0 defined for C541 only                            */
/******************************************************************/
#define DRR0    *(volatile unsigned int *)0x20
#define DRR0_ADDR       0x20
 
#define DXR0    *(volatile unsigned int *)0x21
#define DXR0_ADDR       0x21
 
#define SPC0    *(volatile unsigned int *)0x22
#define SPC0_ADDR       0x22
 
/******************************************************************/
/* Buffered Serial Port 0 defined for all devices except C541     */
/******************************************************************/
#define BSPC0   *(volatile unsigned int *)0x22
#define BSPC0_ADDR      0x22
 
#define BSPCE0  *(volatile unsigned int *)0x23
#define BSPCE0_ADDR     0x23
 
#define BDRR0   *(volatile unsigned int *)0x20
#define BDRR0_ADDR      0x20
 
#define BDXR0   *(volatile unsigned int *)0x21
#define BDXR0_ADDR      0x21
 
 
/*******************************************************************/
/* TIMER REGISTER ADDRESSES                                        */
/* Defined for all devices                                         */
/*******************************************************************/
#define TIM     *(volatile unsigned int *)0x24
#define TIM_ADDR                0x24
 
#define PRD     *(volatile unsigned int *)0x25
#define PRD_ADDR                0x25
 
#define TCR     *(volatile unsigned int *)0x26
#define TCR_ADDR                0x26
 
/*********************************************************************/
/* EXTERNAL BUS CONTROL REGISTERS                                    */
/*********************************************************************/
#define BSCR    *(volatile unsigned int *)0x29
#define BSCR_ADDR       0x29
 
#define SWWSR   *(volatile unsigned int *)0x28
#define SWWSR_ADDR      0x28
 
 
/*********************************************************************/
/* HOST PORT INTERFACE REGISTER ADDRESS                              */
/* Defined for C542, C545(LP) & C548 only                            */
/*********************************************************************/
#define HPIC    *(volatile unsigned int *)0x2C
#define HPIC_ADDR       0x2c
#define HPI_ADDR        0x1000
 
/*********************************************************************/
/* Defined flags for use in setting control for HPI host interface   */
/* control pins                                                      */
/* The value of these constants is their relative bit position in    */
/* the control structure for the host side of the HPI interface      */
/*********************************************************************/
#define HAS_PIN         0
#define HBIL_PIN        1
#define HCNTL0_PIN      2
#define HCNTL1_PIN      3
#define HCS_PIN         4
#define HD0_PIN         5
#define HDS1_PIN        6
#define HDS2_PIN        7
#define HINT_PIN        8
#define HRDY_PIN        9
#define HRW_PIN         10
 
/*********************************************************************/
/* Serial Port 1 defined for C541(LP),C545(LP),C546(LP)              */
/*********************************************************************/
#define SPC1    *(volatile unsigned int *)0x32
#define SPC1_ADDR       0x32
 
#define DXR1    *(volatile unsigned int *)0x31
#define DXR1_ADDR       0x31
 
#define DRR1    *(volatile unsigned int *)0x30
#define DRR1_ADDR       0x30
 
/**********************************************************************/
/* TDM PORT ADDRESSES                                                 */
/* Defined for C542, C543 & C548 only                                 */
/**********************************************************************/
#define TSPC    *(volatile unsigned int *)0x32
#define TSPC_ADDR       0x32
 
#define TRCV    *(volatile unsigned int *)0x30
#define TRCV_ADDR       0x30
 
#define TDXR    *(volatile unsigned int *)0x31
#define TDXR_ADDR       0x31
 
#define TCSR    *(volatile unsigned int *)0x33
#define TCSR_ADDR       0x33
 
#define TRTA    *(volatile unsigned int *)0x34
#define TRTA_ADDR       0x34
 
#define TRAD    *(volatile unsigned int *)0x35
#define TRAD_ADDR       0x35
 
 
/*********************************************************************/
/* AUTOBUFFERING UNIT (Buffered Serial Port 0)                       */
/* Defined for all except C541                                       */
/*********************************************************************/
#define AXR0    *(volatile unsigned int *)0x38
#define AXR0_ADDR       0x38
 
#define BKX0    *(volatile unsigned int *)0x39
#define BKX0_ADDR       0x39
 
#define ARR0    *(volatile unsigned int *)0x3a
#define ARR0_ADDR       0x3a
 
#define BKR0    *(volatile unsigned int *)0x3b
#define BKR0_ADDR       0x3b
 
/*********************************************************************/
/* AUTOBUFFERING UNIT (Buffered Serial Port 1)                       */
/* Defined for C548 Only!!!!!!                                       */
/*********************************************************************/
#define AXR1    *(volatile unsigned int *)0x3c
#define AXR1_ADDR       0x3c
 
#define BKX1    *(volatile unsigned int *)0x3d
#define BKX1_ADDR       0x3d
 
#define ARR1    *(volatile unsigned int *)0x3e
#define ARR1_ADDR       0x3e
 
#define BKR1    *(volatile unsigned int *)0x3f
#define BKR1_ADDR       0x3f
 
/*********************************************************************/
/* Buffered Serial Port 1 defined only for C548                      */
/*********************************************************************/
#define BSPC1   *(volatile unsigned int *)0x42
#define BSPC1_ADDR      0x42
 
#define BSPCE1  *(volatile unsigned int *)0x43
#define BSPCE1_ADDR     0x43
 
#define BDRR1   *(volatile unsigned int *)0x40
#define BDDR1_ADDR      0x40
 
#define BDXR1   *(volatile unsigned int *)0x41
#define BDXR1_ADDR      0x41
 
/*********************************************************************/
/* CLOCK MODE REGISTER ADDRESS                                       */
/* Defined for C548 and LP devices only                              */
/*********************************************************************/
#define CLKMD   *(volatile unsigned int *)0x58
#define CLKMD_ADDR      0x58
 
/*********************************************************************/
/* Extended Program Counter -XPC register                            */
/*********************************************************************/
extern volatile unsigned int XPC;
#define XPC     *(volatile unsigned int *)0x1e
#define XPC_ADDR                0x1e
 
/*********************************************************************/
/* Program Control and Status Registers (PMST, ST0, ST1)             */
/*********************************************************************/
#define PMST    *(volatile unsigned int *)0x1d
#define PMST_ADDR       0x1d
 
#define ST0     *(volatile unsigned int *)0x06
#define ST0_ADDR        0x06
 
#define ST1     *(volatile unsigned int *)0x07
#define ST1_ADDR        0x07
 
#define __MMREGS
#endif
