; ***************************************************************************
; File: VECTORS.ASM -> Vector Table for the 'C54x DSKplus           10.Jul.96
;
; ***************************************************************************
; The vectors in this table can be configured for processing external and
; internal software interrupts. The DSKplus debugger uses four interrupt
; vectors. These are RESET, TRAP2, INT2, and HPIINT.
;   *  DO NOT MODIFY THESE FOUR VECTORS IF YOU PLAN TO USE THE DEBUGGER  *
;
; All other vector locations are free to use. When programming always be sure
; the HPIINT bit is unmasked (IMR=200h) to allow the communications kernel and
; host PC interact. INT2 should normally be masked (IMR(bit 2) = 0) so that the
; DSP will not interrupt itself during a HINT. HINT is tied to INT2 externally.
;
;
;
         .width   80
         .length  55
	 .title "Vector Table"
         .mmregs

reset	 goto #80h	  ;00; RESET  * DO NOT MODIFY IF USING DEBUGGER *
	 nop
	 nop
nmi	 return_enable	  ;04; non-maskable external interrupt
         nop
         nop
         nop
trap2	 goto #88h	  ;08; trap2  * DO NOT MODIFY IF USING DEBUGGER *
	 nop
	 nop
	 .space 52*16	  ;0C-3F: vectors for software interrupts 18-30
int0	 return_enable	  ;40; external interrupt int0
         nop
         nop
         nop
int1	 return_enable	  ;44; external interrupt int1
         nop
         nop
         nop
int2	 return_enable	  ;48; external interrupt int2
         nop
         nop
         nop
tint	 return_enable	  ;4C; internal timer interrupt
         nop
         nop
         nop
brint	 return_enable	  ;50; BSP receive interrupt
         nop
         nop
         nop
bxint	 return_enable	  ;54; BSP transmit interrupt
         nop
         nop
         nop
trint	 goto RECEIVE     ;58; TDM receive interrupt
	 nop
	 nop
txint	 goto TRANSMIT	  ;5C; TDM transmit interrupt
         nop
	 nop
int3	 return_enable	  ;60; external interrupt int3
         nop
         nop
         nop
hpiint	 dgoto #0e4h	  ;64; HPIint  * DO NOT MODIFY IF USING DEBUGGER *
	 nop
	 nop
	 .space  24*16	  ;68-7F; reserved area

