;***************************************************************************
;									   *
; File: AC01INIT.ASM -> AC01 Initialization Routine		 10.Jul.96 *
;									   *
;***************************************************************************

         .width   80
         .length  55
	 .title "AC01 Initialization Program"
         .mmregs

***************************************************************************
* Certain AC01 registers can be initialized using a conditional assembly
* constant. By setting the constant REGISTER to the appropriate value, the
* assembler will either include initialization for certain registers or
* ignore register initialization.
*
* The constant REGISTER should be set to include the following AC01 register:
*
* REGISTER (binary) =
*
*     0000 0000 0000 0001  -> initialize Register 1  (A Register)
*     0000 0000 0000 0010  -> initialize Register 2  (B Register)
*     0000 0000 0000 0100  -> initialize Register 3  (A' Register)
*     0000 0000 0000 1000  -> initialize Register 4  (Amplifier Gain-Select)
*     0000 0000 0001 0000  -> initialize Register 5  (Analog Configuration)
*     0000 0000 0010 0000  -> initialize Register 6  (Digital Configuration)
*     0000 0000 0100 0000  -> initialize Register 7  (Frame-Sync Delay)
*     0000 0000 1000 0000  -> initialize Register 8  (Fram-Sync number)
*
* Any combination of registers can be initialized by adding the binary
* number to the REGISTER  constant. For example to initalize Registers 4
* and 5, REGISTER = 18h. Upon assembly, only code for register 4 & 5
* initialization is included in the AC01INIT module. When called the
* module will load the REG4 and REG5 values into internal AC01 registers.
*
*
* Register 4 is always loaded to get a 6db input gain. This sets full-scale
* to 3v(p-p input) due to the single-ended AC01 configuration.
*
*
REGISTER .set	03h		; Powerup default values:
REG1	.set   112h		;*		       112h
REG2	.set   212h		;*		       212h
REG3	.set   300h		;		       300h
REG4	.set   40dh		;		       405h
REG5	.set   501h		;		       501h
REG6	.set   600h		;		       600h
REG7	.set   700h		;		       700h
REG8	.set   801h		;		       801h



AC01INIT:
	xf = 0				; reset ac01
	intm = 1			; disable all int service routines
	tcr = #10h                      ; stop timer
	imr = #280h			; wakeup from idle when TDM Xmt int
	tspc = #0008h			; stop TDM serial port
	tdxr = #0h			; send 0 as first xmit word
	tspc = #00c8h			; reset and start TDM serial port
	xf = 1				; release ac01 from reset

;	--------------- Register init's ------------------------------

	.eval	REGISTER & 1h, SELECT	; if REG1 then include this source
	.if SELECT = 1h 		;
	a = #REG1			; load Acc A with REG1 value
	call REQ2			; Call REQ2 subroutine
	.endif

	.eval	REGISTER & 2h, SELECT	; if REG2 then include this source
	.if SELECT = 2h
	a = #REG2
	call REQ2

	.endif

	.eval	REGISTER & 4h, SELECT	; if REG3 then include this source
	.if SELECT = 4h
	a = #REG3
	call REQ2
	.endif

	.eval	REGISTER & 8h, SELECT	; if REG4 then include this source
	.if SELECT = 8h
	a = #REG4
	call REQ2
	.endif

	.eval	REGISTER & 10h, SELECT	; if REG5 then include this source
	.if SELECT = 10h
	a = #REG5
	call REQ2
	.endif

	.eval	REGISTER & 20h, SELECT	; if REG6 then include this source
	.if SELECT = 20h
	a = #REG6
	call REQ2
	.endif

	.eval	REGISTER & 40h, SELECT	; if REG7 then include this source
	.if SELECT = 40h
	a = #REG7
	call REQ2
	.endif

	.eval	REGISTER & 80h, SELECT	; if REG8 then include this source
	.if SELECT = 80h
	a = #REG8
	call REQ2
	.endif
	return


REQ2
	ifr = #080h		      ; clear flag from IFR
	tdxr = #03h                   ; request secondary when AC01 starts

	idle(1) 		      ; wait for primary to xmit
	tdxr = a		      ; send register value to serial port
	ifr = #080h		      ; clear flag from IFR

	idle(1) 		      ; wait for secondary to xmit
	tdxr = #0h		      ; send neutral state in case last init
	ifr = #080h		      ; clear flag from IFR
	idle(1) 		      ; wait for neutral state to xmit
	return			      ; return from subroutine
	.end


