;**************************************************************************
;**        DUAL-TONE MODULATED FREQUENCY GENERATOR FOR THE 'C542         **
;**                        (DTMF GENERATOR ONLY)                         **
;**************************************************************************
;**                          Texas Instruments, Inc.	 	         **
;**                          App. by: Gerald Capwell                     **
;**                          Date: Feb 20, 1997                          **
;**************************************************************************
;
;The code below was written using the 'C54x DSKplus board Debugger.
;Code is loaded into the DSK using the 'C54x debugger interface or the DSK
;LoadApp. Upon execution, the DSK output will generate a 2-tone (DTMF)
;frequency corresponding to the telephone keypad digits found at the label
;'NUMBR'. Digits 1-9 are generated using 1-9. Digits *,0,# are generated
;using '0ah', '0bh' and '0ch' repectively. See the keypad below:
;
;                                Column
;                           1       2       3
;
;                       +-----------------------+
;                 1     |   1   |   2   |   3   |
;                       |       |       |       |
;                       +-------+-------+-------+
;                 2     |   4   |   5   |   6   |
;              R        |       |       |       |
;              O        +-------+-------+-------+
;              W  3     |   7   |   8   |   9   |
;                       |       |       |       |
;                       +-------+-------+-------+
;                 4     |   *  _|   0  _|   #  _|
;                       |     |a|     |b|     |c|
;                       +-----------------------+
;
;Each number to be dialed must be followed by a comma. The phone number must
;end with a '-1'. One second delays can be inserted between digits for a
;pausing effect. Here is an example phone number:
;
; NUMBR  .word  1,7,1,3,2,7,4,2,3,2,3,0,0,1,0bh,2,3,-1
;               \___________________/ \ / \_______/ \/
;                         |            |      |      Stop word
;                   Phone number      Two     |
;                 (1-713-274-2323)   second   |
;                                    pause    |
;                                           password,
;                                             etc.
;                                           (1023)
;
;

         .setsect ".data",0x1500.1  ; all data will be stored in HPI RAM
	 .setsect ".text",0x500,0   ; program will be at 0x500
         .setsect "vectors",0x180,0 ; vector table is at 0x180

; Note: 1. Master clock = 10.000 MHz
;       2. The transmit and receive sections are in synchronous mode.
;          Tone generation is synced on the receive interrupt.
;
;
;  **  These words must be on a boundary. Do not insert anything before these

	 .data
ROWS     .word    00000h          ; Offset     cos(x) (Coefficient)
         .word    00000h          ;            sin(x)
         .word    00000h          ;            Y(n-1)
row1
         .word    07ae1h          ; row 1      cos(x) (Coefficient)
         .word    011ebh          ;            sin(x)
         .word    00000h          ;            Y(n-1)
row2
         .word    079c2h          ; row 2      cos(x) (Coefficient)
         .word    013bch          ;            sin(x)
         .word    00000h          ;            Y(n-1)
row3
         .word    07860h          ; row 3      cos(x) (Coefficient)
         .word    015c2h          ;            sin(x)
         .word    00000h          ;            Y(n-1)
row4
         .word    076b8h          ; row 4      cos(x) (Coefficient)
         .word    017ech          ;            sin(x)
         .word    00000h          ;            Y(n-1)


COLS     .word    00000h          ; Offset
         .word    00000h
         .word    00000h
col3
         .word    0698bh          ;            cos(x) (Coefficient)
         .word    02435h          ; column 3   sin(x)
         .word    00000h          ;            Y(n-1)
col2
         .word    06d86h          ;            cos(x) (Coefficient)
         .word    0211fh          ; column 2   sin(x)
         .word    00000h          ;            Y(n-1)
col1
         .word    070cdh          ;            cos(x) (Coefficient)
         .word    01e3fh          ; column 1   sin(x)
         .word    00000h          ;            Y(n-1)


;---------------------------------------------------------

TIME     .word    0d60h           ; pulse duration
TIMER    .word    00000h
DIGIT    .word    00000h
TEMPACC  .long    0h
	 .align   4
NUMBR    .word    0ah,0ah,0ah,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1


;***************************************************************
;   Set up the ISR vectors                                      *
;***************************************************************
         .sect "vectors"
         .copy "dtmfvecs.asm"
;
;*****************************************************************
; TMS32C05X INITIALIZATION                                       *
;                                                                *
;*****************************************************************
         .text
start:   intm  = 1
	 pmst  = #01a0h
	 sp    = #07FFh           ; sp is before HPIRAM 
         CALL    AC01INIT         ; initialize AIC and enable interrupts
	 OVM  =  #0               ; OVM = 0 normal accumulator overflow
         ar1  =  #NUMBR           ; Phone number pointer
NEXTNUM
         dp   =  #DIGIT
         imr  =  #200h            ; disable receive interrupt
         ar2  =  #ROWS            ; init  column pointer
         ar3  =  #COLS            ; init  row pointer
	 CALL    UNPACK           ; decipher row and column for each digit
         CALL    PAUSESH          ; pause between digits
	 imr  =  #280h		  ; set receive interrupt
         intm =  #0               ; enable interrupts
WAIT     a    =  @TIMER           ; check timer
         if(AEQ) goto  NEXTNUM    ; If timer is zero get another digit
         goto    WAIT
END      imr  =  #200h            ; disable interrupts
	 hpic =  #0ah             ; This line will cause errors if using debugger.
RPT      a    =  hpic
	 a   &=  #08h   
	 if(AEQ) goto NEXTNUM-2   ;
	 goto    RPT           

;------- end of main program ----------;

;
;--------------------------  RECIEVER ISR  ----------------------------------
;
TRANSMIT:

         dp   =  #TIMER
	 b    =  #0h		  ; AR2 is current AR register (ROWS)
         a    =  AR2              ; Load address in AR2 (COSx)
         CALL    GENR8R
    	 dbl(TEMPACC) = b	
	 b    =  #0h	       
         a    =  AR3              ; Load address in AR3 (COSx)
	 CALL    GENR8R
 	 a    += dbl(TEMPACC)     ; Add the ACCB (value of second tone)
         a    =  a >>15
	 a    =  a >> 2	
	 a   &=  #0FFFCh          ; bit 0 & 1 have to be 0 for AIC
         tdxr =  a                ; send it to AIC thru serial port
         a    =  @TIMER           ; Load timer value
	 nop
         a   -=  #01h             ; Decrement timer
         @TIMER =  a              ; Save the timer.
         return_enable
;-------------------------  Tone Generator  --------------------------------
GENR8R:
;	 dp   =  #0h
	 a   +=  #02h		  ; Increment pointer. Points to Y(n-1))
	 ar4  =  a
	 nop
	 nop
         b   -= *AR4- <<15        ; load ACChi with Y(n-1)
         ltd(*AR4-)               ; save address of COSX to T
         a    = #0h               ; clear 
         a    = *AR4+ * T         ; coeff*sinx=P and ACC= -y(n-1)
         a   += a
         b  += a                  ; 2(coeff*sinx)- y1
	 *AR4- = hi(b) << #1h     ; shift one & store ACC_hi ->new sinx value
         return

;---------------------------- end of ISR ------------------------

UNPACK:
         dp   =  #DIGIT
         @TIMER =#0h              ; reset timer value = 0
         a    =  *AR1+            ; get digit 
         @DIGIT = a               ; save digit
         if (AEQ) goto PAUSELG    ; Zero then pause
         if(ALT) goto END         ; Negative then end
	 dp  =   #0h		  ;
NEXTR:   a   -=  #0003h           ; subtract three from digit
         @ar2 += #3h              ; increment row pointer by three
         if(AGT) goto NEXTR       ; subtract again
         a    =  AR2              ; load ACC with the address in AR2
         a   &=  #000Fh           ; get last digit only
	 dp   =  #DIGIT
         a   -=  @DIGIT           ; sub digit from col.3 value (3,6,9,or c)
         a   +=  #01h             ; add one (offset of one for loop)
NEXTC:   
         dp    =  #0
	 @ar3 +=  #03h            ; increment column pointer
         a   -=  #01h             ; sub 1
         if(AGT) goto NEXTC       ; increment column pointer until ACC=0
	 dp   =  #TIMER
         a    =  @TIME            ; Load time value
         @TIMER = a               ; Reset timer for pulse duration
         return
;----------------------------- Pause generator ----------------------
PAUSESH  a    =  #08h <<15        ; pause between numbers
         goto    LOOP
PAUSELG  a    =  #0cah <<15       ; load ACC with value to decrement
         a   +=  #0b9ah <<4       ; Long pause for ","
LOOP     a   -=  #01h             ;  
         if(AGT) goto LOOP        ; 
         return                   ;
;--------------------------------------------------------------------


;--------------------------  Transmit ISR  --------------------------
;
;transmit interrupt is disabled
;
RECEIVE:
      	 return_enable
;---------------------------- end of ISR ------------------------


	 .copy "dtmf_aic.asm"
	 .end