/*----------------------------------------------------------------------------*/
/*  LINKER COMMAND FILE - MEMORY SPECIFICATION for C240 		    		*/
/*  Last update 24 Sep 99									*/
/*----------------------------------------------------------------------------*/

MEMORY
{
    PAGE 0 : VECS	: origin =     0h , length =   040h	  /* PROGRAM */
			 PROG	: origin =    40h , length =  1000h	  /* Ext mem */
			 B0		: origin = 0FF00h , length =  0100h	  /* CNF=1   */

    PAGE 1 : MMRS	: origin =    0h  , length =   05Fh	 /* MMRS    */
	       	 B2		: origin = 0060h  , length =   020h	 /* DARAM   */
			 B0P0	: origin = 0200h  , length =  0080h
			 B0P1	: origin = 0280h  , length =  0080h 
			 B1P0	: origin = 0300h  , length =  0080h 
			 B1P1	: origin = 0380h  , length =  0080h
	       	 DATA	: origin = 4000h  , length =  4000h	 /* EMIF    */
}

/*--------------------------------------------------------------------------*/
/* SECTIONS ALLOCATION                                                      */
/*--------------------------------------------------------------------------*/
SECTIONS
{
    vectors   : { } > VECS	PAGE 0	    /* INTERRUPT VECTOR TABLE	    */
    mon_main  : { } > PROG	PAGE 0	    /* Main Monitor program	    	*/
    .text     : { } > PROG	PAGE 0	    /* User's code                	*/
    .data     : { } > PROG	PAGE 0	    /* INITIALIZATION DATA TABLES 	*/

    .bss      : { } > B0P0	PAGE 1	    /* User RAM - page 4    */
    stack	  :	{ } > B0P0	PAGE 1    	    
    vhz_prof  : { } > B0P0	PAGE 1 
    spimcomp  : { } > B0P1  PAGE 1
    bc		  : { } > B0P1  PAGE 1
    rmp_cntl  : { } > B0P1	PAGE 1   
    sincos    : { } > B1P0	PAGE 1 
    speedprd  : { } > B1P0	PAGE 1 
    d_pid     : { } > B1P1  PAGE 1   
    comp      : { } > B0P1	PAGE 1  
    pwmodrv	  : { } > B0P0	PAGE 1 
    data_log  : { } > B1P1  PAGE 1
 	adc4udrv  : { } > B1P1  PAGE 1   
    
    mon_pge0  : { } > B2	PAGE 1	    /* Used by RT monitor	    	*/
    mon_rgst  : { } > B2	PAGE 1	    /* Used by RT monitor	    	*/
    far_mem   : { } > B0P1  PAGE 1
}
