;====================================================================================
; Module Name: 	DATA_LOG					      
;
; File Name:	Data_log.asm
;
; Description:	
;
;				|~~~~~~~~~~~~~~~~~~~~~~~|	  
;	dlog_iptr1	o------>|		  	|
;   	dlog_iptr2    	o------>|    DATA_LOG/ Data RAM |
;   	 		o------>|		     	|
;				|_______________________|	   
;
;
; Target dependency:	C2xx core only
;
;
; History:
;
; Last Update: 7-7-2000	
;===========================================================================
;(To use this Module, copy this section to main system file)
;		.ref		DATA_LOG, DATA_LOG_INIT		;function call
;		.ref		dlog_iptr1, dlog_iptr2		;Inputs
;		.ref		trig_value						;Inputs
;===========================================================================
;Module definitions for external reference.
		.def		DATA_LOG, DATA_LOG_INIT		;function call
		.def		dlog_iptr1, dlog_iptr2		;Inputs
		.def		trig_value						;Inputs
;===========================================================================
		.include	x24x_app.h


DLOG_PRESCALE	.set	1			;1 gives 50uS log rate
DL_BUFFER1_ADR	.set	08000h
DL_BUFFER2_ADR	.set	08400h
DLOG_CNTR_MAX	.set	400

dlog_iptr1	.usect "data_log",1
dlog_iptr2	.usect "data_log",1
dlog_skip_cntr	.usect "data_log",1
dlog_cntr	.usect "data_log",1
task_ptr	.usect "data_log",1
graph_ptr1	.usect "data_log",1
graph_ptr2	.usect "data_log",1
trig_value	.usect "data_log",1



;-----------------------------------------------------------------------------
DATA_LOG_INIT:
;-----------------------------------------------------------------------------
		LDP	#task_ptr
		SPLK	#POS_TRIG_S1, task_ptr
		SPLK	#DL_BUFFER1_ADR, graph_ptr1
		SPLK	#DL_BUFFER2_ADR, graph_ptr2
		SPLK	#301h, dlog_iptr1
		SPLK	#302h, dlog_iptr2

		SPLK	#0h, trig_value		;Set trig point to 0h

		SPLK	#0h, dlog_skip_cntr	;clear Data log skip counter
		SPLK	#0h, dlog_cntr		;clear Data log counter

		RET

;---------------------------------------------------------------------------------
DATA_LOG:
;---------------------------------------------------------------------------------
		LDP	#task_ptr
		MAR	*, AR5
		SETC	SXM
		LACC	task_ptr
		BACC

POS_TRIG_S1:	;(Positive trigger, detect Negative signal)
		LAR	AR5, dlog_iptr1
		LACC	*,1
		SUB	trig_value,1
		BCND	DL_EXIT, GEQ			;If not Neg return
		SPLK	#POS_TRIG_S2, task_ptr
		B	DL_EXIT

POS_TRIG_S2:	;(Positive trigger, detect Positive signal)
		LAR	AR5, dlog_iptr1
		LACC	*,1
		SUB	trig_value,1
		BCND	PTS2_1, LT			;If Neg, return to S1
		SPLK	#DL_TRIGGERED, task_ptr

		B	DL_EXIT

PTS2_1:		SPLK	#POS_TRIG_S1, task_ptr
		B	DL_EXIT


DL_TRIGGERED:

		LACC	dlog_skip_cntr		;Check if time to Log
		ADD	#1
		SACL	dlog_skip_cntr
		SUB	#DLOG_PRESCALE
		BCND	DL_EXIT, NEQ

	;Data is logged here
		LAR	AR5, dlog_iptr1
		LACC	*
		LAR	AR5, graph_ptr1
		SACL	*+
		SAR	AR5, graph_ptr1

		LAR	AR5, dlog_iptr2
		LACC	*
		LAR	AR5, graph_ptr2
		SACL	*+
		SAR	AR5, graph_ptr2

		SPLK	#0, dlog_skip_cntr

		LACC	dlog_cntr			;Check if Data buffer full
		ADD	#1
		SACL	dlog_cntr
		SUB	#DLOG_CNTR_MAX
		BCND	DL_EXIT, NEQ

		SPLK	#0, dlog_cntr
		SPLK	#POS_TRIG_S1, task_ptr
		SPLK	#DL_BUFFER1_ADR, graph_ptr1
		SPLK	#DL_BUFFER2_ADR, graph_ptr2

DL_EXIT
		CLRC	SXM
		RET

