;==============================================================================
; File Name:	SPIM_CC.ASM 
; Project:		Single pahse AC induction motor control
; Originator/s:	Digital control systems Group - Texas Instruments
;
; Target dependency:	x240/1/2/3/07
; To Select the target device see x24x_app.h file.
;
; Description:	
;		
; Status:		
; Last Update:	20 July 2000
; ____________________________________________________________________________
; Date of Mod | 		    DESCRIPTION
; ------------|---------------------------------------------------------------
;	        |
;	        |
;==============================================================================

;******************************************************************************
;					  SYSTEM OPTIONS
;******************************************************************************
real_time	        .set	1      ; 1 for real time mode, otherwise set 0 
;******************************************************************************
phase1_commissioning	.set	1 	;




;-----------------------------------------------------------------------------
; External references
;-----------------------------------------------------------------------------
		.include	"x24x_app.h"
		.global MON_RT_CNFG

		.ref	SYS_INIT

		.ref	RAMP_CNTL, RAMP_CNTL_INIT				;function call
		.ref	target_value 							;Inputs
		.ref	setpt_value, s_eq_t_flg					;Outputs

	
		.ref	V_Hz_PROFILE, V_Hz_PROFILE_INIT			;function call
		.ref	vhz_freq								;Inputs
		.ref	v_out									;Outputs


		.ref	SINCOSPH, SINCOSPH_INIT				;function call
		.ref	gain_cs, freq, phase				;Inputs 
		.ref	Vcomp1, Vcomp2						;Inputs (modified by COMPEN.asm)
		.ref	sine_a1, sine_a2,					;Outputs

		.ref	DATA_LOG, DATA_LOG_INIT				;function call
		.ref	dlog_iptr1, dlog_iptr2				;Inputs
		.ref	trig_value							;Inputs 
		
		.ref	FC_PWM_O_DRV
		.ref	FC_PWM_O_DRV_INIT			;function call
		.ref	Mfunc_c1, Mfunc_c2, Mfunc_c3, Mfunc_p	;Inputs
		.ref	limit					;Input
  
;-----------------------------------------------------------------------------
; Local Variable Declarations
;-----------------------------------------------------------------------------
		.def	GPR0			;General purpose registers.
		.def	GPR1
		.def	GPR2
		.def	GPR3
		.def	GPR4
		.def	v_timer
        .def    rpm_scaler    
        
        .def	COMCON

		.bss	GPR0,1		;General purpose registers.
		.bss	GPR1,1
		.bss	GPR2,1
		.bss	GPR3,1
		.bss	GPR4,1

 		.bss	D,1  
 		.bss	mode,1   
 		.bss	count,1
 
        
		.bss	v_timer,1
		.bss	freq_in,1
		.bss	speed_setpt,1
        .bss    rpm_scaler,1

       	
		
		.bss	phase_in,1
		.def	phase_in 
		
		.bss	direction,1
		
;==============================================================================
; V E C T O R    T A B L E    ( including RT monitor traps )
;==============================================================================
          	.include "c200mnrt.i" 	; Include conditional assembly options.

		.sect "vectors"  
		.def 	_c_int0

RESET	    B	  _c_int0 	 		; 00
INT1	    B	  PHANTOM	 		; 02
INT2	    B	  T1_PERIOD_ISR		; 04
INT3	    B	  PHANTOM	 		; 06
INT4	    B	  PHANTOM			; 08
INT5	    B	  PHANTOM	 		; 0A
INT6	    B	  PHANTOM	 		; 0C

		.include	"rtvecs.h"

; Note : The above include line must be AFTER the user configurable 
;        vectors. Do not change the place where this line is included.

;==============================================================================
; M A I N   C O D E  - starts here
;==============================================================================
		.text
_c_int0:
		CALL	SYS_INIT
		CALL	RAMP_CNTL_INIT
		CALL	V_Hz_PROFILE_INIT 
		CALL	SINCOSPH_INIT
		CALL	DATA_LOG_INIT    
		CALL	FC_PWM_O_DRV_INIT


;------------------------------------------------------
;System time-base init - Timer1
;------------------------------------------------------
SYSTEM_INT_PERIOD	.set	1000		;set for 50uS period @50nS CPU clock

		
;----------------------------------------------------------
; Initialise the Real time monitor
;----------------------------------------------------------
;---Real Time option---------------
	.if (real_time)
		CALL	MON_RT_CNFG		;For Real-Time
	.endif
;----------------------------------

;----------------------------------------------------------
; System Interrupt Init.
;----------------------------------------------------------
	;Event Manager
		POINT_EV
		SPLK	#0000001000000000b,IMRA ;Enable T1 Underflow Int (i.e. Period)
			    ;||||!!!!||||!!!!		
			    ;5432109876543210

		SPLK	#0FFFFh,IFRA	; Clear all Group A interrupt flags
		SPLK	#0FFFFh,IFRB	; Clear all Group B interrupt flags
		SPLK	#0FFFFh,IFRC	; Clear all Group C interrupt flags

	;C2xx Core
		POINT_PG0

;---Real Time option --------------------------------------------------
	.if (real_time)
		SPLK	#0000000001000010b,IMR	;En Int lvl 2,7 (T1 ISR) 
		        ;|||||||||!||||!|
			    ;5432109876543210
	.endif


	.if (real_time != 1)
		SPLK	#0000000000000010b,IMR	;En Int lvl 2 (T1 ISR)
			    ;||||!!!!||||!!!!		
			    ;5432109876543210
	.endif

		SPLK	#0FFFFh, IFR		;Clear any pending Ints
		EINT					;Enable global Ints
		POINT_B0
;-----------------------------------------------------------------------



;---------------------------------------------------------
;SYSTEM COMMISSIONING OPTIONS - Initialisation
;---------------------------------------------------------
	.if (phase1_commissioning)    
	
RPM_SCALER	.set	5510h			;13.1 (Q11) x 3048/32767 (Q15) = 7FFFh (Q15)	
        
		SPLK	#1000h, freq_in
        SPLK  	#RPM_SCALER,rpm_scaler
 
		SPLK	#0500h, GPR0
 		SPLK	#1200, speed_setpt
 		SPLK	#90, phase_in 
 		SPLK	#0, limit

	.endif


;======================================================
MAIN:		;Main system background loop
;======================================================	
M_1		B	MAIN
;======================================================


;===========================================================================
; Routine Name: T1_PERIOD_ISR				     Routine Type: ISR
;
; Description:
;
;
; Originator: Digital control systems Group - Texas Instruments
;
; History:
;
;
; Last Update:	20-July  00
;===========================================================================
T1_PERIOD_ISR:
;Context save regs
		MAR		*,AR1	;AR1 is stack pointer
		MAR		*+      ;skip one position
		SST		#1, *+  ;save ST1
		SST   		#0, *+  ;save ST0
		SACH		*+      ;save acc high
		SACL		*	;save acc low

;NOTE: should use "read-modify-write" to clear Int flags & not SPLK!
		POINT_EV
		SPLK	#0FFFFh,IFRA  	; Clear all Group A interrupt flags (T1 ISR)

;=========================================================
;Start main section of ISR
;=========================================================
		POINT_B0

;---------------------------------------------------------
;SYSTEM COMMISSIONING OPTIONS - Main code
;---------------------------------------------------------
	.if (phase1_commissioning)   
	
	LDP		#target_value				
	BLDD		#speed_setpt, target_value	
	
	CALL		RAMP_CNTL
	LDP		#target_value					
	lt		setpt_value      
	
	POINT_B0											
	mpy		rpm_scaler
	pac
	sach		freq_in,5	

	
	LDP	#vhz_freq				
	BLDD	#freq_in, vhz_freq		
	 				
	CALL	V_Hz_PROFILE  
		
	 
	LDP	#gain_cs				   
	BLDD	#v_out, gain_cs			
	BLDD	#vhz_freq, freq			  
	BLDD	#phase_in, phase
    
 	LDP	#gain_cs				 	
    
    	CALL	SINCOSPH
    
	.endif




;House keeping & debug prior to ISR exit.
;-----------------------------------------
;Allow variable viewing via DAC o/ps
		CALL	DATA_LOG 

;Update Virtual Timer
		POINT_B0
		LACC	v_timer		;Inc virtual timer
		ADD	#1			;
		AND	#07FFFh		;Force 15 bit wrap around
		SACL	v_timer		;Save it



;=========================================================
;End main section of ISR
;=========================================================
;Context restore regs
END_ISR:
		POINT_PG0

		MAR	*, AR1    	;make stack pointer active
		LACL	*-		;Restore Acc low
		ADDH	*-		;Restore Acc high
		LST	#0, *-      ;load ST0
		LST     #1, *-  ;load ST1
		EINT
		RET

;==============================================================================
; I S R  -  PHANTOM
;
; Description:	Dummy ISR, used to trap spurious interrupts.
;
; Modifies:
;
; Last Update:	16-06-95
;==============================================================================
PHANTOM 	B	PHANTOM
PHANTOM1 	B	PHANTOM1
PHANTOM2 	B	PHANTOM2
PHANTOM3 	B	PHANTOM3
PHANTOM4 	B	PHANTOM4
PHANTOM5 	B	PHANTOM5
PHANTOM6 	B	PHANTOM6


