////////////////////////////////////////////////////////////////////
//     File:   ddpci2040.H
//
//     Purpose: This is the Public include file for the C54x EVM 
//              device drivers and client DLL.
//
//     Copyright (c) 1999, DNA Enterprises, Inc.
////////////////////////////////////////////////////////////////////
#ifndef _DDPCI2040_H
#define _DDPCI2040_H

        // Define IOCTL codes for driver access
#define PCI2040_DEVICE_TYPE    0x8001
#define PCI2040_FUNCTION_BASE  0x0800

#define PCI2040_MAKEIOCTL(n)\
    CTL_CODE((ULONG)PCI2040_DEVICE_TYPE, PCI2040_FUNCTION_BASE+(n), METHOD_BUFFERED, FILE_ANY_ACCESS)

        // Reset Driver and EVM Board
        // Input:  none
        // Output: none
#define IOCTL_PCI2040_DRIVER_RESET\
            PCI2040_MAKEIOCTL(0)

        // Dump PCI Configuration Registers
        // Input:  none
        // Output: PPCI2040_CONFIGURATION - pointer to structure containing
        //         the PCI configuration information
        // Notes:  this call reads the PCI configuration to the caller supplied buffer.
#define IOCTL_PCI2040_DUMP_CONFIGURATION\
            PCI2040_MAKEIOCTL(1)

        // Store PCI Configuration Registers
        // Input: PPCI2040_CONFIGURATION - pointer to structure containing
        //         the PCI configuration information
        // Output:  none
        // Notes:  this call writes the PCI configuration in the caller supplied buffer.
#define IOCTL_PCI2040_STORE_CONFIGURATION\
            PCI2040_MAKEIOCTL(2)

        // Read PCI Configuration Register
        // Input:  
        // Output:
#define IOCTL_PCI2040_READ_PCI_REG\
            PCI2040_MAKEIOCTL(3)

        // Write PCI Configuration Register
        // Input:
        // Output: none
#define IOCTL_PCI2040_WRITE_PCI_REG\
            PCI2040_MAKEIOCTL(4)

        // Map HPI CSR registers into user memory space
        // Input:  none
        // Output: PPCI2040_HPI_CSR_ADDRESSES - structure containing user-mapped 
        //         pointer to the mapped HPI CSR registers and number of bytes
        //         of mapped memory.
        // Notes:  the memory must be unmapped using
        //         IOCTL_PCI2040_UNMAP_HPI_CSR_SPACES,
        //         pointer is vaild only in the caller's address space.
        //         Only one active mapping of the HPI regs is allowed.
#define IOCTL_PCI2040_MAP_HPI_CSR_SPACES\
            PCI2040_MAKEIOCTL(5)

        // Unmap HPI CSR Registers from User's Memory Space
        // Input:  PPCI2040_HPI_CSR_ADDRESSES - pointer to the structure returned
        //         from IOCTL_PCI2040_MAP_HPI_CSR_SPACES
        // Output: none
        // Notes:  the structure must be the structure
        //         that was output by IOCTL_PCI2040_MAP_HPI_CSR_SPACES
#define IOCTL_PCI2040_UNMAP_HPI_CSR_SPACES\
            PCI2040_MAKEIOCTL(6)

        // Map DSP HPI Registers into User's Memory Space
        // Input:  none
        // Output: PPCI2040_DSP_HPI_ADDRESSES - structure containing user-mapped 
        //         pointer to the mapped DSP HPI mwmory and number of bytes
        //         of mapped memory.
        // Notes:  the memory must be unmapped using
        //         IOCTL_PCI2040_UNMAP_DSP_HPI_SPACES,
        //         pointer is vaild only in the caller's address space.
        //         Only one active mapping of the DSP HPI space is allowed.
#define IOCTL_PCI2040_MAP_DSP_HPI_SPACES\
            PCI2040_MAKEIOCTL(7)

        // Unmap DSP HPI Registers from User's Memory Space
        // Input:  PPCI2040_DSP_HPI_ADDRESSES - pointer to the structure returned
        //         from IOCTL_PCI2040_MAP_DSP_HPI_SPACES
        // Output: none
        // Notes:  the structure must be the structure
        //         that was output by IOCTL_PCI2040_MAP_DSP_HPI_SPACES
#define IOCTL_PCI2040_UNMAP_DSP_HPI_SPACES\
            PCI2040_MAKEIOCTL(8)

        // Map GP Bus (TBC) into User's Memory Space
        // Input:  
        // Output: 
        // Notes:  
#define IOCTL_PCI2040_MAP_GPB_TBC_SPACES\
            PCI2040_MAKEIOCTL(9)
    
        // Unmap GP Bus (TBC) from User's Memory Space
        // Input:  
        // Output: 
        // Notes:  
#define IOCTL_PCI2040_UNMAP_GPB_TBC_SPACES\
            PCI2040_MAKEIOCTL(10)

        // The following is used for the DSP reset IOCTLs
typedef enum {
    Select_DSP0 = 0,        // Selects DSP 0 as target
    Select_DSP1,            // "
    Select_DSP2,
    Select_DSP3
} DSPSelectEnum, *PDSPSelectEnum;

        // Hold DSP in Reset State
        // Input:  PDSPSelectEnum containing the number of the DSP to reset
        // Output: none
#define IOCTL_PCI2040_DSP_RESET_HOLD\
            PCI2040_MAKEIOCTL(11)

        // Release DSP from Reset State
        // Input:  PDSPSelectEnum containing the number of the DSP to reset
        // Output: none
#define IOCTL_PCI2040_DSP_RESET_RELEASE\
            PCI2040_MAKEIOCTL(12)

        // Reset Install RING3 interrupt event handle
        // Input:  Kernel32 mapped event handle
        // Output: none
        // Note:
#define IOCTL_PCI2040_INSTALL_INTERRUPT_EVENT\
            PCI2040_MAKEIOCTL(13)

        // Reset Clear RING3 interrupt event handle
        // Input:  none
        // Output: none
        // Note:
#define IOCTL_PCI2040_CLEAR_INTERRUPT_EVENT\
            PCI2040_MAKEIOCTL(14)

        // Get event information
        // Input:  none
        // Output: Event status
        // Note:  The returned status uses values defined for the HPI CSR
        //        control register and HPI ERROR detail that has been shifted
        //        16 bits to the left (see defines below).
#define IOCTL_PCI2040_GET_INTERRUPT_INFORMATION\
            PCI2040_MAKEIOCTL(15)

        // Wait in driver for interrupt signal (NT only)
        // Input:  none
        // Output: none
        // Note:   WinNT only
#define IOCTL_PCI2040_WAITFOR_PROCESSOR_SIGNAL\
            PCI2040_MAKEIOCTL(16)

        // Maximum number of unhandled interrupts the driver will
        // queue without the application servicing them.  Should
        // more than this number of interrupts occur, the driver
        // will discard the oldest interrupts as new ones come in.
#define MAX_UNHANDLED_INTERRUPTS    64

#define PCI2040_VENDOR_ID   0x104C
#define PCI2040_DEVICE_ID   0XAC60
#define MAX_PCI2040_BOARDS  8

#define HPICSR_SIZE         4096        // Size of HPICSR segment to map
#define HPI_MAPPED_DSP_SZ   1024        // Size of segment for each DSP
#define CSpace_SIZE         32768       // Size of Control Space segment to map
#define GPB_SIZE            256         // Size of General Purpose segment to map

#pragma pack(push)
#pragma pack(1)
        // Structure used to access the PCI configuration
typedef struct _PCI2040_CONFIGURATION {
    USHORT  VendorID;       // Vendor ID
    USHORT  DeviceID;       // Device ID
    USHORT  Command;        // Command
    USHORT  Status;         // Status
    UCHAR   RevisionID;     // Revision ID
    UCHAR   ProgIf;         // Prog
    UCHAR   SubClass;       // Sub-class
    UCHAR   BaseClass;      // Base-class
    UCHAR   CacheLineSize;  // Cache Line Size
    UCHAR   LatencyTimer;   // Latency Timer
    UCHAR   HeaderType;     // Header Type
    UCHAR   BIST;           // BIST
    ULONG   HPICSRBar;      // HPI CSR Memory Base Addrress
    ULONG   CSpaceBar;      // Control Space Base Address
    ULONG   GPBBar;         // GPBus Base Address
    ULONG   Reserve0[4];    // Reserved
    USHORT  SubVendorID;    // Subsystem Vendor ID
    USHORT  SubSysID;       // Subsystem ID
    ULONG   Reserve1;       // Reserved
    UCHAR   CapPointer;     // Capability Pointer
    UCHAR   Reserve2[3];    // Reserved
    ULONG   Reserve3;       // Reserved
    UCHAR   IRQLine;        // Interrupt Line
    UCHAR   IRQPin;         // Interrupt Pin
    UCHAR   MinGnt;         // Min Grant
    UCHAR   MaxLat;         // Max latency
    USHORT  Reserve4[2];    // Reserved
    UCHAR   GPBSelect;      // GPIO Select
    UCHAR   GPBInData;      // GPIO Input Data
    UCHAR   GPBDataDir;     // GPIO Direction Control
    UCHAR   GPBOutData;     // GPIO Output Data
    UCHAR   GPBIntType;     // GPIO Interrupt Type
    UCHAR   Reserve5[3];    // Reserved
    USHORT  MiscControl;    // Misc Control
    UCHAR   Reserve14;      // Reserved
    UCHAR   Diag;           // Diagnostic
    UCHAR   PMCapID;        // PM Capability ID
    UCHAR   PMNext;         // PM Next-Item Pointer
    USHORT  PMCap;          // Power Management Capabilities
    USHORT  PMCntlStat;     // PM Control / Status
    USHORT  Reserve6;       // Reserved
    ULONG   HPICSRIOBar;    // HPI CSR I/O Base Address
    UCHAR   HSCapID;        // HS Capability ID
    UCHAR   HSNext;         // HS Next-Item Pointer
    UCHAR   HSCSR;          // HS_CSR
    UCHAR   Reserve7[5];    // Reserved
} PCI2040_DUMP_CONFIG_REGS, *PPCI2040_DUMP_CONFIG_REGS;
#pragma pack(pop)

        // Defines for register numbers
#define VENDORID_OFFSET     0       // Vendor ID
#define DEVICEID_OFFSET     2       // Device ID
#define COMMAND_OFFSET      4       // Command
#define STATUS_OFFSET       6       // Status
#define REVISIONID_OFFSET   8       // Revision ID
#define PROGIF_OFFSET       9       // Prog
#define SUBCLASS_OFFSET     10      // Sub-class
#define BASECLASS_OFFSET    11      // Base-class
#define CACHELINESIZE_OFFSET 12     // Cache Line Size
#define LATENCYTIMER_OFFSET 13      // Latency Timer
#define HEADERTYPE_OFFSET   14      // Header Type
#define BIST_OFFSET         15      // BIST
#define HPICSRBAR_OFFSET    16      // HPI CSR Memory Base Addrress
#define CSPACEBAR_OFFSET    20      // Control Space Base Address
#define GPBBAR_OFFSET       24      // GPBus Base Address
#define SUBVENDORID_OFFSET  44      // Subsystem Vendor ID
#define SUBSYSID_OFFSET     46      // Subsystem ID
#define CAPPOINTER_OFFSET   52      // Capability Pointer
#define IRQLINE_OFFSET      60      // Interrupt Line
#define IRQPIN_OFFSET       61      // Interrupt Pin
#define MINGNT_OFFSET       62      // Min Grant
#define MAXLAT_OFFSET       63      // Max latency
#define GPBSELECT_OFFSET    68      // GPIO Select
#define GPBINDATA_OFFSET    69      // GPIO Input Data
#define GPBDATADIR_OFFSET   70      // GPIO Direction Control
#define GPBOUTDATA_OFFSET   71      // GPIO Output Data
#define GPBINTTYPE_OFFSET   72      // GPIO Interrupt Type
#define MISCCONTROL_OFFSET  76      // Misc Control
#define DIAG_OFFSET         79      // Diagnostic
#define PMCAPID_OFFSET      80      // PM Capability ID
#define PMNEXT_OFFSET       81      // PM Next-Item Pointer
#define PMCAP_OFFSET        82      // Power Management Capabilities
#define PMCNTLSTAT_OFFSET   84      // PM Control / Status
#define HPICSRIOBAR_OFFSET  88      // HPI CSR I/O Base Address
#define HSCAPID_OFFSET      92      // HS Capability ID
#define HSNEXT_OFFSET       93      // HS Next-Item Pointer
#define HSCSR_OFFSET        94      // HS_CSR


        // Enum for writing and reading individual registers
typedef enum  {
    ENUM_VENDORID_OFFSET    = VENDORID_OFFSET,
    ENUM_DEVICEID_OFFSET    = DEVICEID_OFFSET,
    ENUM_COMMAND_OFFSET     = COMMAND_OFFSET,
    ENUM_STATUS_OFFSET      = STATUS_OFFSET,
    ENUM_REVISIONID_OFFSET  = REVISIONID_OFFSET,
    ENUM_PROGIF_OFFSET      = PROGIF_OFFSET,
    ENUM_SUBCLASS_OFFSET    = SUBCLASS_OFFSET,
    ENUM_BASECLASS_OFFSET   = BASECLASS_OFFSET,
    ENUM_CACHELINESIZE_OFFSET = CACHELINESIZE_OFFSET,
    ENUM_LATENCYTIMER_OFFSET = LATENCYTIMER_OFFSET,
    ENUM_HEADERTYPE_OFFSET  = HEADERTYPE_OFFSET,
    ENUM_BIST_OFFSET        = BIST_OFFSET,
    ENUM_HPICSRBAR_OFFSET   = HPICSRBAR_OFFSET,
    ENUM_CSPACEBAR_OFFSET   = CSPACEBAR_OFFSET,
    ENUM_GPBBAR_OFFSET      = GPBBAR_OFFSET,
    ENUM_SUBVENDORID_OFFSET = SUBVENDORID_OFFSET,
    ENUM_SUBSYSID_OFFSET    = SUBSYSID_OFFSET,
    ENUM_CAPPOINTER_OFFSET  = CAPPOINTER_OFFSET,
    ENUM_IRQLINE_OFFSET     = IRQLINE_OFFSET,
    ENUM_IRQPIN_OFFSET      = IRQPIN_OFFSET,
    ENUM_MINGNT_OFFSET      = MINGNT_OFFSET,
    ENUM_MAXLAT_OFFSET      = MAXLAT_OFFSET,
    ENUM_GPBSELECT_OFFSET   = GPBSELECT_OFFSET,
    ENUM_GPBINDATA_OFFSET   = GPBINDATA_OFFSET,
    ENUM_GPBDATADIR_OFFSET  = GPBDATADIR_OFFSET,
    ENUM_GPBOUTDATA_OFFSET  = GPBOUTDATA_OFFSET,
    ENUM_GPBINTTYPE_OFFSET  = GPBINTTYPE_OFFSET,
    ENUM_MISCCONTROL_OFFSET = MISCCONTROL_OFFSET,
    ENUM_DIAG_OFFSET        = DIAG_OFFSET,
    ENUM_PMCAPID_OFFSET     = PMCAPID_OFFSET,
    ENUM_PMNEXT_OFFSET      = PMNEXT_OFFSET,
    ENUM_PMCAP_OFFSET       = PMCAP_OFFSET,
    ENUM_PMCNTLSTAT_OFFSET  = PMCNTLSTAT_OFFSET,
    ENUM_HPICSRIOBAR_OFFSET = HPICSRIOBAR_OFFSET,
    ENUM_HSCAPID_OFFSET     = HSCAPID_OFFSET,
    ENUM_HSNEXT_OFFSET      = HSNEXT_OFFSET,
    ENUM_HSCSR_OFFSET       = HSCSR_OFFSET,
    ENUM_INVALID            = -1
} PCI2040_REG_OFFSETS, *PPCI2040_REG_OFFSETS;

#pragma pack(push)
#pragma pack(1)
        // Structure used for HPI CSR Space
typedef struct _PCI2040_HPI_CSR {
    ULONG   IntEventSet;
    ULONG   IntEventClear;
    ULONG   IntMaskSet;
    ULONG   IntMaskClear;
    USHORT  HPIErrorReport;
    USHORT  Reserved1;
    USHORT  HPIResetRegister;
    USHORT  HPIImplementation;
    USHORT  HPIDataWidth;
    USHORT  Reserved2;
} PCI2040_HPI_CSR, *PPCI2040_HPI_CSR;
#pragma pack(pop)

        // Definitions for IntEventSet and IntEventClear
#define INTDSP0  (1<<0)     // Bit set if an interrupt has been generated by a device connected
                            // to the HPI[0] interface. Software can set this bit for diagnostics.
#define INTDSP1  (1<<1)     // Bit set if an interrupt has been generated by a device connected
                            // to the HPI[1] interface. Software can set this bit for diagnostics.
#define INTDSP2  (1<<2)     // Bit set if an interrupt has been generated by a device connected
                            // to the HPI[2] interface. Software can set this bit for diagnostics.
#define INTDSP3  (1<<3)     // Bit set if an interrupt has been generated by a device connected
                            // to the HPI[3] interface. Software can set this bit for diagnostics.
#define GPINT    (1<<26)    // Bit set if an interrupt has been generated by a device connected
                            // to the GPINT# interface. Software can set this bit for diagnostics.
#define INTGPIO2 (1<<27)    // Set when GPIO2Pin selects GPIO2 as an interrupt event input, and the
                            // event type selected by the GPIO Interrupt Event Type Register occurs.
#define INTGPIO3 (1<<28)    // Set when GPIO3Pin selects GPIO3 as an interrupt event input, and the
                            // event type selected by the GPIO Interrupt Event Type Register occurs.
#define GPERROR  (1<<29)    // Bit set upon serious error conditions on the GP interface, and
                            // allows software to gracefully terminate communication with a GP device.
#define HPIERROR (1<<30)    // Bit set upon serious error conditions on the HPI interface, and allows
                            // software to gracefully terminate communication with an HPI device.
                            // This bit is the OR combination of the HPI errors in the HPI Error Report
                            // Register.

        // This macro is provided for retrieving HPI error detail
        // using the IOCTL_PCI2040_GET_INTERRUPT_INFORMATION.  The
        // HPI error detail is returned starting at bit location 16
        // and follows the order defined for the HPI Error fields.
#define GetHPIErrorDetail(a)    ((a>>16)&0xF)

// Definitions for IntMaskSet and IntMaskClear
// 28:0 --- When set, interrupt will be generated when the corresponding interrupt
//          event bit (See ABOVE) is set.
#define GPERRORMASK (1<<29) // When set, an interrupt will be generated when the IntEvent.GPError
                            // event bit is set. When set, the GP state machine will never cause target
                            // aborts on PCI and will return the PCI slave zeros on such errors. When
                            // set, errors on posted writes will not cause SERR# signal assertions
                            // enabled by SERR_EN. When this bit is cleared, target aborts may occur and
                            // SERR# may be signaled as a result of a posted write error.
#define HPIERRORMASK (1<<30) // When set, an interrupt will be generated when the IntEvent.HPIError event
                            // bit is set (See Table 34). When set, the HPI state machine will never cause
                            // target aborts on PCI and will return the PCI slave zeros on such errors.
                            // When set, errors on posted writes will not cause SERR# signal assertions
                            // enabled by SERR_EN. When this bit is cleared, target aborts may occur and
                            // SERR# may be signaled as a result of a posted write error.
#define MASTERINTENABLE (1<<31) // When set, external interrupts will be generated in accordance with the
                            // IntMask register. If clear, no external interrupts will be generated.

// Definitions for HPIErrorReport
#define HPIERR0 (1<<0)      // Bit set if a serious error occurs on the HPI[0] interface.
#define HPIERR1 (1<<1)      // Bit set if a serious error occurs on the HPI[1] interface.
#define HPIERR2 (1<<2)      // Bit set if a serious error occurs on the HPI[2] interface.
#define HPIERR3 (1<<3)      // Bit set if a serious error occurs on the HPI[3] interface.

// Definitions for HPIResetRegister
#define HPI0_RST (1<<0)     // HPI Reset 0. When set, HRST0# is asserted.
#define HPI1_RST (1<<1)     // HPI Reset 1. When set, HRST1# is asserted.
#define HPI2_RST (1<<2)     // HPI Reset 2. When set, HRST2# is asserted.
#define HPI3_RST (1<<3)     // HPI Reset 3. When set, HRST3# is asserted.

// Definitions for HPIImplementation
#define DSP_PRSNT0 (1<<0)   // DSP0 Present. These bits indicate if the DSP0 is present on the HPI I/F.
#define DSP_PRSNT1 (1<<1)   // DSP1 Present. These bits indicate if the DSP1 is present on the HPI I/F.
#define DSP_PRSNT2 (1<<2)   // DSP2 Present. These bits indicate if the DSP2 is present on the HPI I/F.
#define DSP_PRSNT3 (1<<3)   // DSP3 Present. These bits indicate if the DSP3 is present on the HPI I/F.

// Definitions for HPIDataWidth
#define DWIDTH0 (1<<0)      // When set, the HPI[0] data bus is 16-bits (C6x). When zero, it is 8-bits (C54x).
#define DWIDTH1 (1<<1)      // When set, the HPI[1] data bus is 16-bits (C6x). When zero, it is 8-bits (C54x).
#define DWIDTH2 (1<<2)      // When set, the HPI[2] data bus is 16-bits (C6x). When zero, it is 8-bits (C54x).
#define DWIDTH3 (1<<3)      // When set, the HPI[3] data bus is 16-bits (C6x). When zero, it is 8-bits (C54x).

        // Structure used to write PCI register
typedef struct _PCI2040_WRITE_REG
{
    PCI2040_REG_OFFSETS Regoff;     // Register to read/write
    ULONG               DataVal;    // Data to read/write
} PCI2040_WRITE_REG, *PPCI2040_WRITE_REG;

        // Useful PCI Register value definitions
        // PCI Control Register
#define PCIREG_CTL_FBBEN    (1<<9)  // Fast Back-to-Back Enable. This bit 
                                    // controls whether or not the device
                                    // is allowed to perform back to back
                                    // capability for bus master transaction.
                                    // This bit is hardwired to 0 and indicates
                                    // that FBB transfers are not supported
#define PCIREG_CTL_SERREN   (1<<8)  // System Error (SERR#) Enable. This bit
                                    // is an enable for the output driver on
                                    // the SERR# pin. If this bit is cleared,
                                    // and a system error condition is set,
                                    // the error signal will not appear on the
                                    // external SERR# pin
#define PCIREG_CTL_STEPEN   (1<<7)  // Address/Data Stepping Control. This bit
                                    // indicates whether or not the device
                                    // performs address stepping. This bit is 
                                    // hard wired to "0"
#define PCIREG_CTL_PERREN   (1<<6)  // Parity Error Response Enable. This bit
                                    // controls whether or not the device
                                    // responds to detected parity errors. 
                                    // If this bit is set, the device will
                                    // respond normally to parity errors. 
                                    // Otherwise, the device will ignore detected
                                    // parity errors
#define PCIREG_CTL_VGAEN    (1<<5)  // VGA Palette Snoop. This bit is not applicable
                                    // and is hardwired to a "0"
#define PCIREG_CTL_MWIEN    (1<<4)  // Memory Write and Invalidate Enable. This bit
                                    // enables the device to use the Memory Write and
                                    // Invalidate command. This device does not support
                                    // MWI and uses MW instead. This bit is hardwired
                                    // to "0"
#define PCIREG_CTL_Special  (1<<3)  // Special Cycle. This bit controls the devices
                                    // response to special cycle commands. This device
                                    // does not monitor any special commands, this bit
                                    // is set to "0"
#define PCIREG_CTL_MASTEN   (1<<2)  // Bus Master Control. This bit allows a PCI device
                                    // to function as a bus master. This bit is hardwired
                                    // to "0"
#define PCIREG_CTL_MEMEN    (1<<1)  // Memory Space Enable. This bit enables the device
                                    // to respond to memory accesses to any of the 
                                    // defined base address memory regions. If this bit
                                    // is cleared, the device will not respond to memory
                                    // mapped accesses.
#define PCIREG_CTL_IOEN     (1<<0)  // I/O Space Control. This bit enables the device
                                    // to respond to I/O accesses within its defined
                                    // base address register I/O regions

    // HPI Control Register (HPIC) CSpaceaddr+0
    // *** NOTE ***
    // The following definitions are defined for the C54X DSP.
    // If a version of this software is created for the C6X, then the definitions and use
    // in the drivers need to be changed.
    //
#define HPIC_BOB    (1<<0|1<<8)     // The byte-order-bit. This bit determines the placement
                                    // for the two bytes of a transfer. If BOB=1, the
                                    // first byte of a transfer is least significant. If 
                                    // BOB=0, the first byte is most significant. This bit
                                    // can only be accessed (written or read) by the host,
                                    // and it must be initialized before the first data or
                                    // address register access.
#define HPIC_DSPINT (1<<2|1<<10)    // The host-to-54xx interrupt. When the host writes a
                                    // 1 to this bit, a 54xx interrupt is generated. The
                                    // bit can only be written by the host, and it is always
                                    // read as 0 by both the host and the 54xx. When
                                    // the host writes to HPIC, both bytes must write the
                                    // same value. 
#define HPIC_HINT   (1<<3|1<<11)    // The 54xx-to-host interrupt. This bit determines the
                                    // state of the 54xx HINT output, which can be
                                    // used to interrupt the host. When the HINT bit is set
                                    // to 1, the HINT output is driven low, and when the
                                    // bit is cleared to 0, the output is driven high. The
                                    // HINT bit can only be set by the 54xx, and it can
                                    // only be cleared by the host. The host clears the bit
                                    // by writing a 1 to it. 
#define HPIC_XHPIA  (1<<4|1<<12)    // The extended HPI address bit. This bit determines 
                                    // which address bits the HPIA register sets. When
                                    // the XHPIA bit is cleared to zero, the HPIA register
                                    // reflects the state of the lower 16 HPI-8 address
                                    // bits A[0:15]. When the bit is set to one, the seven
                                    // LSBs of the HPIA register reflect the state of the
                                    // HPI-8 extended address bits. Only the host has access                                    // to this bit, and it is not initialized after reset.
#endif
