************************************************************************
*  - Target (Assembly version) Read Test (ta_read.asm)                 *
*  - Reads 100 integers, one at a time.                                *
*  - Uses one input channel.                                           *
*                                                                      *
*  - Tests Data transmission from host to target at the User layer.    *
************************************************************************
        .mmregs
FP      .set      AR7
        .title    "Target Read Test for C54x"

************************ RTDX User layer *******************************
      .include "rtdx.i"                 ; include RTDX macro library
************************************************************************

        .sect   ".const"
SL1:    .string 13,"Test Completed",0
MAX_ITERATIONS  .set     100
        RTDX_input_channel     ichan    ; Declare input channel
        .sect   ".text"
        .global _main
        .ref    _puts
        .def    i
        .bss    i,1,0,0
************************************************************************
*  FUNCTION DEF: _main                                                 *
************************************************************************
_main:
        PSHM    AR1                     ; holds data read from host
        RTDX_Enable_Data_Input ichan    ; Enable the input channel
        ST      #0,*(i)                 ; Initialize our counter to 0

READ_DATA:   
        RTDX_Data_Read ichan,AR1,#1     ; Read data from host
        LD      *(i),A                  ; store current count into
                                        ;     accumulator
        ADD     #1,A                    ; Increment counter
        STLM    A,AR2                   ; place counter into register
                                        ;     AR2 for testing
	nop
        STM     #MAX_ITERATIONS,AR0     ; store maximum iterations in
                                        ;     register AR0 for testing
        CMPR    LT,AR2                  ; test to see if the contents
                                        ;     of register AR0 are less
                                        ;     than the contents of
                                        ;     register AR2
        BCD     READ_DATA,TC            ; delayed branch to read data if
                                        ;     true
        MVMD    AR2,*(i)                ; update counter with new value
         
        RTDX_Disable_Data_Input ichan   ; Disable input channel
        LD      #SL1,A                  ; load test completion message
        CALL    #_puts                  ; print message
        POPM    AR1 
        RET