/*************************************************************************/
/* string.h  C16 V2.04                                                   */
/* Copyright (c) 1992,1997 Texas Instruments Incorporated                */
/*************************************************************************/
#ifndef _STRING
#define _STRING
 
#if _INLINE
#define __INLINE static inline
#else
#define __INLINE
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

__INLINE size_t  strlen(const char *_string);
__INLINE char   *strcpy(char *_dest, const char *_src);
         char   *strncpy(char *_to, const char *_from, size_t _n);
         char   *strcat(char *_string1, const char *_string2);
         char   *strncat(char *_to, const char *_from, size_t _n);
         char   *strchr(const char *_string, int _c);
         char   *strrchr(const char *_string, int _c);
         int     strcmp(const char *_string1, const char *_string2);
         int     strncmp(const char *_string1, const char *_string2, size_t _n);
        
         int     strcoll(const char *_string1, const char *_string2);
         size_t  strxfrm(char *_to, const char *_from, size_t _n);
         char   *strpbrk(const char *_string, const char *_chs);
         size_t  strspn(const char *_string, const char *_chs);
         size_t  strcspn(const char *_string, const char *_chs);
         char   *strstr(const char *_string1, const char *_string2);
         char   *strtok(char *_str1, const char *_str2);
         char   *strerror(int _errno);
        
         void   *memmove(void *_s1, const void *_s2, size_t _n);
__INLINE void   *memcpy(void *_s1, const void *_s2, size_t _n);
         int     memcmp(const void *_cs, const void *_ct, size_t _n);
         void   *memchr(const void *_cs, int _c, size_t _n);
__INLINE void   *memset(void *_mem, int _ch, size_t _n);

#if _INLINE

/****************************************************************************/
/*  strcpy v0.00                                                            */
/****************************************************************************/
__INLINE char *strcpy(register char *dest, register const char *src)
{
     register char *result = dest;     

     while (*dest++ = *src++);
     return result;
}

/****************************************************************************/
/*  strlen v0.00                                                            */
/****************************************************************************/
__INLINE size_t strlen(const char *string)
{
   register size_t n = -1;

   do n++; while (*string++);
   return n;
}

/****************************************************************************/
/*  memcpy v0.00							    */
/****************************************************************************/
__INLINE void *memcpy(void *s1, const void *s2, register size_t n)
{
    if (n)
    {
      register char *src  = s2;
      register char *dest = s1;

      do
	*dest++ = *src++;
      while (--n);
    }

    return s1;
}

/****************************************************************************/
/*  memset v0.00                                                            */
/****************************************************************************/
__INLINE void *memset(void *mem, register int ch, register size_t n)
{
    if (n)
    {
      register char *str = mem;

      do
	*str++ = ch;
      while (--n);
    }

    return mem;
}

#endif

#undef __INLINE

#endif
